package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.Disclaimer;
import org.symphonyoss.symphony.pod.model.UserIdList;
import org.symphonyoss.symphony.pod.model.DisclaimerList;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-08-11T19:01:54.668-04:00")
public class DisclaimerApi {
  private ApiClient apiClient;

  public DisclaimerApi() {
    this(Configuration.getDefaultApiClient());
  }

  public DisclaimerApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * PROVISIONAL Create a new disclaimer. The id and timestamps should not be set, they will be assigned in the response.
   * 
   * @param sessionToken Session authentication token. (required)
   * @param payload  (required)
   * @return Disclaimer
   * @throws ApiException if fails to make API call
   */
  public Disclaimer v1AdminDisclaimerCreatePost(String sessionToken, Disclaimer payload) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminDisclaimerCreatePost");
    }
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v1AdminDisclaimerCreatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/disclaimer/create".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Disclaimer> localVarReturnType = new GenericType<Disclaimer>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a disclaimer by disclaimer id
   * 
   * @param sessionToken Session authentication token. (required)
   * @param did The ID of the entity (required)
   * @return Disclaimer
   * @throws ApiException if fails to make API call
   */
  public Disclaimer v1AdminDisclaimerDidGet(String sessionToken, String did) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminDisclaimerDidGet");
    }
    
    // verify the required parameter 'did' is set
    if (did == null) {
      throw new ApiException(400, "Missing the required parameter 'did' when calling v1AdminDisclaimerDidGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/disclaimer/{did}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "did" + "\\}", apiClient.escapeString(did.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Disclaimer> localVarReturnType = new GenericType<Disclaimer>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * PROVISIONAL Modify a disclaimer
   * 
   * @param sessionToken Session authentication token. (required)
   * @param did The ID of the entity (required)
   * @param payload  (required)
   * @return Disclaimer
   * @throws ApiException if fails to make API call
   */
  public Disclaimer v1AdminDisclaimerDidUpdatePost(String sessionToken, String did, Disclaimer payload) throws ApiException {
    Object localVarPostBody = payload;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminDisclaimerDidUpdatePost");
    }
    
    // verify the required parameter 'did' is set
    if (did == null) {
      throw new ApiException(400, "Missing the required parameter 'did' when calling v1AdminDisclaimerDidUpdatePost");
    }
    
    // verify the required parameter 'payload' is set
    if (payload == null) {
      throw new ApiException(400, "Missing the required parameter 'payload' when calling v1AdminDisclaimerDidUpdatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/disclaimer/{did}/update".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "did" + "\\}", apiClient.escapeString(did.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Disclaimer> localVarReturnType = new GenericType<Disclaimer>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * List all users assigned to this disclaimer
   * 
   * @param sessionToken Session authentication token. (required)
   * @param did The ID of the entity (required)
   * @return UserIdList
   * @throws ApiException if fails to make API call
   */
  public UserIdList v1AdminDisclaimerDidUsersGet(String sessionToken, String did) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminDisclaimerDidUsersGet");
    }
    
    // verify the required parameter 'did' is set
    if (did == null) {
      throw new ApiException(400, "Missing the required parameter 'did' when calling v1AdminDisclaimerDidUsersGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/disclaimer/{did}/users".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "did" + "\\}", apiClient.escapeString(did.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<UserIdList> localVarReturnType = new GenericType<UserIdList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * List all disclaimers for the company (pod)
   * 
   * @param sessionToken Session authentication token. (required)
   * @return DisclaimerList
   * @throws ApiException if fails to make API call
   */
  public DisclaimerList v1AdminDisclaimerListGet(String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AdminDisclaimerListGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/admin/disclaimer/list".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<DisclaimerList> localVarReturnType = new GenericType<DisclaimerList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
