package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.ConfigurationInstanceSubmissionCreate;
import org.symphonyoss.symphony.pod.model.ConfigurationInstance;
import org.symphonyoss.symphony.pod.model.ConfigurationInstanceSubmissionUpdate;
import org.symphonyoss.symphony.pod.model.ConfigurationInstanceList;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-08-11T19:01:54.668-04:00")
public class ConfigurationInstanceApi {
  private ApiClient apiClient;

  public ConfigurationInstanceApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ConfigurationInstanceApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Create a Configuration Instance object.
   * A caller can create a Configuration Instance object.  If the {configurationId} is invalid, a client error results. 
   * @param configurationId Configuration ID (required)
   * @param sessionToken Session authentication token. (required)
   * @param configurationInstance  (required)
   * @return ConfigurationInstance
   * @throws ApiException if fails to make API call
   */
  public ConfigurationInstance v1ConfigurationConfigurationIdInstanceCreatePost(String configurationId, String sessionToken, ConfigurationInstanceSubmissionCreate configurationInstance) throws ApiException {
    Object localVarPostBody = configurationInstance;
    
    // verify the required parameter 'configurationId' is set
    if (configurationId == null) {
      throw new ApiException(400, "Missing the required parameter 'configurationId' when calling v1ConfigurationConfigurationIdInstanceCreatePost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConfigurationConfigurationIdInstanceCreatePost");
    }
    
    // verify the required parameter 'configurationInstance' is set
    if (configurationInstance == null) {
      throw new ApiException(400, "Missing the required parameter 'configurationInstance' when calling v1ConfigurationConfigurationIdInstanceCreatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/configuration/{configurationId}/instance/create".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "configurationId" + "\\}", apiClient.escapeString(configurationId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ConfigurationInstance> localVarReturnType = new GenericType<ConfigurationInstance>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a configuration Instance from a Configuration.
   * A caller can get a configuration Instance object for a given Configuration and Instance ID.  If the {configurationId} is invalid, a client error results.  If the {instanceId} is invalid, a client error results.  If the ID is correct, then 200 is returned along with the configuration Instance. 
   * @param configurationId Configuration ID (required)
   * @param instanceId Configuration Instance ID (required)
   * @param sessionToken Session authentication token. (required)
   * @return ConfigurationInstance
   * @throws ApiException if fails to make API call
   */
  public ConfigurationInstance v1ConfigurationConfigurationIdInstanceInstanceIdGetGet(String configurationId, String instanceId, String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'configurationId' is set
    if (configurationId == null) {
      throw new ApiException(400, "Missing the required parameter 'configurationId' when calling v1ConfigurationConfigurationIdInstanceInstanceIdGetGet");
    }
    
    // verify the required parameter 'instanceId' is set
    if (instanceId == null) {
      throw new ApiException(400, "Missing the required parameter 'instanceId' when calling v1ConfigurationConfigurationIdInstanceInstanceIdGetGet");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConfigurationConfigurationIdInstanceInstanceIdGetGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/configuration/{configurationId}/instance/{instanceId}/get".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "configurationId" + "\\}", apiClient.escapeString(configurationId.toString()))
      .replaceAll("\\{" + "instanceId" + "\\}", apiClient.escapeString(instanceId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ConfigurationInstance> localVarReturnType = new GenericType<ConfigurationInstance>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update a configuration Instance object.
   * A caller can update a configuration Instance object.  If the {configurationId} is invalid, a client error results.  If the {instanceId} is invalid, a client error results. 
   * @param configurationId Configuration ID (required)
   * @param instanceId Configuration Instance ID (required)
   * @param sessionToken Session authentication token. (required)
   * @param configurationInstance  (required)
   * @return ConfigurationInstance
   * @throws ApiException if fails to make API call
   */
  public ConfigurationInstance v1ConfigurationConfigurationIdInstanceInstanceIdUpdatePut(String configurationId, String instanceId, String sessionToken, ConfigurationInstanceSubmissionUpdate configurationInstance) throws ApiException {
    Object localVarPostBody = configurationInstance;
    
    // verify the required parameter 'configurationId' is set
    if (configurationId == null) {
      throw new ApiException(400, "Missing the required parameter 'configurationId' when calling v1ConfigurationConfigurationIdInstanceInstanceIdUpdatePut");
    }
    
    // verify the required parameter 'instanceId' is set
    if (instanceId == null) {
      throw new ApiException(400, "Missing the required parameter 'instanceId' when calling v1ConfigurationConfigurationIdInstanceInstanceIdUpdatePut");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConfigurationConfigurationIdInstanceInstanceIdUpdatePut");
    }
    
    // verify the required parameter 'configurationInstance' is set
    if (configurationInstance == null) {
      throw new ApiException(400, "Missing the required parameter 'configurationInstance' when calling v1ConfigurationConfigurationIdInstanceInstanceIdUpdatePut");
    }
    
    // create path and map variables
    String localVarPath = "/v1/configuration/{configurationId}/instance/{instanceId}/update".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "configurationId" + "\\}", apiClient.escapeString(configurationId.toString()))
      .replaceAll("\\{" + "instanceId" + "\\}", apiClient.escapeString(instanceId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ConfigurationInstance> localVarReturnType = new GenericType<ConfigurationInstance>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of configuration Instances from an Integration.
   * A caller can get all configuration Instances objects for a given Configuration ID.  If the {configurationId} is invalid, a client error results.  If there are no configuration Instances to return, a 204 response will be returned. 
   * @param configurationId Configuration ID (required)
   * @param sessionToken Session authentication token. (required)
   * @param offset No. of configuration Instances to skip.  (optional)
   * @param limit Max No. of configuration Instances to return. If no value is provided, 50 is the default.  (optional)
   * @return ConfigurationInstanceList
   * @throws ApiException if fails to make API call
   */
  public ConfigurationInstanceList v1ConfigurationConfigurationIdInstanceListGet(String configurationId, String sessionToken, Integer offset, Integer limit) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'configurationId' is set
    if (configurationId == null) {
      throw new ApiException(400, "Missing the required parameter 'configurationId' when calling v1ConfigurationConfigurationIdInstanceListGet");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConfigurationConfigurationIdInstanceListGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/configuration/{configurationId}/instance/list".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "configurationId" + "\\}", apiClient.escapeString(configurationId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ConfigurationInstanceList> localVarReturnType = new GenericType<ConfigurationInstanceList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
