package org.symphonyoss.symphony.pod.api;

import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.pod.model.V1Configuration;
import org.symphonyoss.symphony.pod.model.Error;
import org.symphonyoss.symphony.pod.model.V1ConfigurationSubmissionCreate;
import org.symphonyoss.symphony.pod.model.ConfigurationList;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-08-11T19:01:54.668-04:00")
public class ConfigurationApi {
  private ApiClient apiClient;

  public ConfigurationApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ConfigurationApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Gets a Configuration object.
   * A caller can get a Configuration object for a given ID.  If the {configurationId} is invalid, a client error results.  If the ID is correct, then 200 is returned along with the Configuration. 
   * @param configurationId Configuration ID (required)
   * @param sessionToken Session authentication token. (required)
   * @return V1Configuration
   * @throws ApiException if fails to make API call
   */
  public V1Configuration v1ConfigurationConfigurationIdGetGet(String configurationId, String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'configurationId' is set
    if (configurationId == null) {
      throw new ApiException(400, "Missing the required parameter 'configurationId' when calling v1ConfigurationConfigurationIdGetGet");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConfigurationConfigurationIdGetGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/configuration/{configurationId}/get".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "configurationId" + "\\}", apiClient.escapeString(configurationId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<V1Configuration> localVarReturnType = new GenericType<V1Configuration>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update a Configuration object.
   * A caller can update a Configuration object.  If the {configurationId} is invalid, a client error results. 
   * @param configurationId Configuration ID (required)
   * @param sessionToken Session authentication token. (required)
   * @param _configuration  (required)
   * @return V1Configuration
   * @throws ApiException if fails to make API call
   */
  public V1Configuration v1ConfigurationConfigurationIdUpdatePut(String configurationId, String sessionToken, V1Configuration _configuration) throws ApiException {
    Object localVarPostBody = _configuration;
    
    // verify the required parameter 'configurationId' is set
    if (configurationId == null) {
      throw new ApiException(400, "Missing the required parameter 'configurationId' when calling v1ConfigurationConfigurationIdUpdatePut");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConfigurationConfigurationIdUpdatePut");
    }
    
    // verify the required parameter '_configuration' is set
    if (_configuration == null) {
      throw new ApiException(400, "Missing the required parameter '_configuration' when calling v1ConfigurationConfigurationIdUpdatePut");
    }
    
    // create path and map variables
    String localVarPath = "/v1/configuration/{configurationId}/update".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "configurationId" + "\\}", apiClient.escapeString(configurationId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<V1Configuration> localVarReturnType = new GenericType<V1Configuration>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Create a Configuration object.
   * A caller can create a Configuration object. 
   * @param sessionToken Session authentication token. (required)
   * @param _configuration  (required)
   * @return V1Configuration
   * @throws ApiException if fails to make API call
   */
  public V1Configuration v1ConfigurationCreatePost(String sessionToken, V1ConfigurationSubmissionCreate _configuration) throws ApiException {
    Object localVarPostBody = _configuration;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConfigurationCreatePost");
    }
    
    // verify the required parameter '_configuration' is set
    if (_configuration == null) {
      throw new ApiException(400, "Missing the required parameter '_configuration' when calling v1ConfigurationCreatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/configuration/create".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<V1Configuration> localVarReturnType = new GenericType<V1Configuration>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Gets a list of Configurations.
   * A caller can get all Configuration objects.  If there are no Configurations to return, a 204 response will be returned. 
   * @param sessionToken Session authentication token. (required)
   * @param offset No. of Configurations to skip.  (optional)
   * @param limit Max No. of Configurations to return. If no value is provided, 50 is the default.  (optional)
   * @return ConfigurationList
   * @throws ApiException if fails to make API call
   */
  public ConfigurationList v1ConfigurationListGet(String sessionToken, Integer offset, Integer limit) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1ConfigurationListGet");
    }
    
    // create path and map variables
    String localVarPath = "/v1/configuration/list".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ConfigurationList> localVarReturnType = new GenericType<ConfigurationList>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
