# UsersApi

All URIs are relative to *https://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1UserGet**](UsersApi.md#v1UserGet) | **GET** /v1/user | Get user information by email address.
[**v1UserNameUserNameGetGet**](UsersApi.md#v1UserNameUserNameGetGet) | **GET** /v1/user/name/{userName}/get | Get user information by user (login) name.


<a name="v1UserGet"></a>
# **v1UserGet**
> User v1UserGet(email, sessionToken, local)

Get user information by email address.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UsersApi;


UsersApi apiInstance = new UsersApi();
String email = "email_example"; // String | Email address
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Boolean local = true; // Boolean | If true then a local DB search will be performed and only local pod users will be returned. If absent or false then a directory search will be performed and users from other pods who are visible to the calling user will also be returned. 
try {
    User result = apiInstance.v1UserGet(email, sessionToken, local);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UsersApi#v1UserGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **email** | **String**| Email address |
 **sessionToken** | **String**| Session authentication token. |
 **local** | **Boolean**| If true then a local DB search will be performed and only local pod users will be returned. If absent or false then a directory search will be performed and users from other pods who are visible to the calling user will also be returned.  | [optional]

### Return type

[**User**](User.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v1UserNameUserNameGetGet"></a>
# **v1UserNameUserNameGetGet**
> User v1UserNameUserNameGetGet(userName, sessionToken)

Get user information by user (login) name.

Searches for a user in the local pod with the given user name. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UsersApi;


UsersApi apiInstance = new UsersApi();
String userName = "userName_example"; // String | User login name
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    User result = apiInstance.v1UserNameUserNameGetGet(userName, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UsersApi#v1UserNameUserNameGetGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userName** | **String**| User login name |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**User**](User.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

