# UserApi

All URIs are relative to *https://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1AdminUserCreatePost**](UserApi.md#v1AdminUserCreatePost) | **POST** /v1/admin/user/create | Create a new user
[**v1AdminUserFindPost**](UserApi.md#v1AdminUserFindPost) | **POST** /v1/admin/user/find | PROVISIONAL Find a user based on attributes
[**v1AdminUserListGet**](UserApi.md#v1AdminUserListGet) | **GET** /v1/admin/user/list | Retreive a list of all users in the company (pod)
[**v1AdminUserUidActionPasswordResetPost**](UserApi.md#v1AdminUserUidActionPasswordResetPost) | **POST** /v1/admin/user/{uid}/action/password_reset | PROVISIONAL Send a password reset email to the email address of a particular user
[**v1AdminUserUidAvatarGet**](UserApi.md#v1AdminUserUidAvatarGet) | **GET** /v1/admin/user/{uid}/avatar | Get the URL of the avatar of a particular user
[**v1AdminUserUidAvatarUpdatePost**](UserApi.md#v1AdminUserUidAvatarUpdatePost) | **POST** /v1/admin/user/{uid}/avatar/update | Update the avatar of a particular user
[**v1AdminUserUidDelegatesGet**](UserApi.md#v1AdminUserUidDelegatesGet) | **GET** /v1/admin/user/{uid}/delegates | Get the delegates assigned to a user
[**v1AdminUserUidDelegatesUpdatePost**](UserApi.md#v1AdminUserUidDelegatesUpdatePost) | **POST** /v1/admin/user/{uid}/delegates/update | Update the delegates assigned to a user
[**v1AdminUserUidDisclaimerGet**](UserApi.md#v1AdminUserUidDisclaimerGet) | **GET** /v1/admin/user/{uid}/disclaimer | Get the disclaimer assigned to a user
[**v1AdminUserUidDisclaimerUpdatePost**](UserApi.md#v1AdminUserUidDisclaimerUpdatePost) | **POST** /v1/admin/user/{uid}/disclaimer/update | Assign a disclaimer to a user
[**v1AdminUserUidFeaturesGet**](UserApi.md#v1AdminUserUidFeaturesGet) | **GET** /v1/admin/user/{uid}/features | Get the list of Symphony feature entitlements enabled for a particular user
[**v1AdminUserUidFeaturesUpdatePost**](UserApi.md#v1AdminUserUidFeaturesUpdatePost) | **POST** /v1/admin/user/{uid}/features/update | Update the list of Symphony feature entitlements for a particular user
[**v1AdminUserUidGet**](UserApi.md#v1AdminUserUidGet) | **GET** /v1/admin/user/{uid} | Retreive user details for a particular user
[**v1AdminUserUidRolesGet**](UserApi.md#v1AdminUserUidRolesGet) | **GET** /v1/admin/user/{uid}/roles | PROVISIONAL Get the list of roles assigned to a user
[**v1AdminUserUidRolesUpdatePost**](UserApi.md#v1AdminUserUidRolesUpdatePost) | **POST** /v1/admin/user/{uid}/roles/update | PROVISIONAL Update the list of roles assigned to a user
[**v1AdminUserUidStatusGet**](UserApi.md#v1AdminUserUidStatusGet) | **GET** /v1/admin/user/{uid}/status | Get the status, active or inactive, for a particular user
[**v1AdminUserUidStatusUpdatePost**](UserApi.md#v1AdminUserUidStatusUpdatePost) | **POST** /v1/admin/user/{uid}/status/update | Update the status of a particular user
[**v1AdminUserUidUpdatePost**](UserApi.md#v1AdminUserUidUpdatePost) | **POST** /v1/admin/user/{uid}/update | Update an existing user


<a name="v1AdminUserCreatePost"></a>
# **v1AdminUserCreatePost**
> UserDetail v1AdminUserCreatePost(sessionToken, payload)

Create a new user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
UserCreate payload = new UserCreate(); // UserCreate | 
try {
    UserDetail result = apiInstance.v1AdminUserCreatePost(sessionToken, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserCreatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **payload** | [**UserCreate**](UserCreate.md)|  |

### Return type

[**UserDetail**](UserDetail.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserFindPost"></a>
# **v1AdminUserFindPost**
> UserList v1AdminUserFindPost(sessionToken, payload)

PROVISIONAL Find a user based on attributes

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
UserFilter payload = new UserFilter(); // UserFilter | 
try {
    UserList result = apiInstance.v1AdminUserFindPost(sessionToken, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserFindPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **payload** | [**UserFilter**](UserFilter.md)|  |

### Return type

[**UserList**](UserList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserListGet"></a>
# **v1AdminUserListGet**
> UserIdList v1AdminUserListGet(sessionToken)

Retreive a list of all users in the company (pod)

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    UserIdList result = apiInstance.v1AdminUserListGet(sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**UserIdList**](UserIdList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidActionPasswordResetPost"></a>
# **v1AdminUserUidActionPasswordResetPost**
> SuccessResponse v1AdminUserUidActionPasswordResetPost(sessionToken, uid, payload)

PROVISIONAL Send a password reset email to the email address of a particular user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
PasswordReset payload = new PasswordReset(); // PasswordReset | 
try {
    SuccessResponse result = apiInstance.v1AdminUserUidActionPasswordResetPost(sessionToken, uid, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidActionPasswordResetPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |
 **payload** | [**PasswordReset**](PasswordReset.md)|  |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidAvatarGet"></a>
# **v1AdminUserUidAvatarGet**
> AvatarList v1AdminUserUidAvatarGet(sessionToken, uid)

Get the URL of the avatar of a particular user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
try {
    AvatarList result = apiInstance.v1AdminUserUidAvatarGet(sessionToken, uid);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidAvatarGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |

### Return type

[**AvatarList**](AvatarList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidAvatarUpdatePost"></a>
# **v1AdminUserUidAvatarUpdatePost**
> SuccessResponse v1AdminUserUidAvatarUpdatePost(sessionToken, uid, payload)

Update the avatar of a particular user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
AvatarUpdate payload = new AvatarUpdate(); // AvatarUpdate | 
try {
    SuccessResponse result = apiInstance.v1AdminUserUidAvatarUpdatePost(sessionToken, uid, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidAvatarUpdatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |
 **payload** | [**AvatarUpdate**](AvatarUpdate.md)|  |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidDelegatesGet"></a>
# **v1AdminUserUidDelegatesGet**
> IntegerList v1AdminUserUidDelegatesGet(sessionToken, uid)

Get the delegates assigned to a user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
try {
    IntegerList result = apiInstance.v1AdminUserUidDelegatesGet(sessionToken, uid);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidDelegatesGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |

### Return type

[**IntegerList**](IntegerList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidDelegatesUpdatePost"></a>
# **v1AdminUserUidDelegatesUpdatePost**
> SuccessResponse v1AdminUserUidDelegatesUpdatePost(sessionToken, uid, payload)

Update the delegates assigned to a user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
DelegateAction payload = new DelegateAction(); // DelegateAction | 
try {
    SuccessResponse result = apiInstance.v1AdminUserUidDelegatesUpdatePost(sessionToken, uid, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidDelegatesUpdatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |
 **payload** | [**DelegateAction**](DelegateAction.md)|  |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidDisclaimerGet"></a>
# **v1AdminUserUidDisclaimerGet**
> Disclaimer v1AdminUserUidDisclaimerGet(sessionToken, uid)

Get the disclaimer assigned to a user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
try {
    Disclaimer result = apiInstance.v1AdminUserUidDisclaimerGet(sessionToken, uid);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidDisclaimerGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |

### Return type

[**Disclaimer**](Disclaimer.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidDisclaimerUpdatePost"></a>
# **v1AdminUserUidDisclaimerUpdatePost**
> SuccessResponse v1AdminUserUidDisclaimerUpdatePost(sessionToken, uid, payload)

Assign a disclaimer to a user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
StringId payload = new StringId(); // StringId | 
try {
    SuccessResponse result = apiInstance.v1AdminUserUidDisclaimerUpdatePost(sessionToken, uid, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidDisclaimerUpdatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |
 **payload** | [**StringId**](StringId.md)|  |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidFeaturesGet"></a>
# **v1AdminUserUidFeaturesGet**
> FeatureList v1AdminUserUidFeaturesGet(sessionToken, uid)

Get the list of Symphony feature entitlements enabled for a particular user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
try {
    FeatureList result = apiInstance.v1AdminUserUidFeaturesGet(sessionToken, uid);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidFeaturesGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |

### Return type

[**FeatureList**](FeatureList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidFeaturesUpdatePost"></a>
# **v1AdminUserUidFeaturesUpdatePost**
> SuccessResponse v1AdminUserUidFeaturesUpdatePost(sessionToken, uid, payload)

Update the list of Symphony feature entitlements for a particular user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
FeatureList payload = new FeatureList(); // FeatureList | 
try {
    SuccessResponse result = apiInstance.v1AdminUserUidFeaturesUpdatePost(sessionToken, uid, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidFeaturesUpdatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |
 **payload** | [**FeatureList**](FeatureList.md)|  |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidGet"></a>
# **v1AdminUserUidGet**
> UserDetail v1AdminUserUidGet(sessionToken, uid)

Retreive user details for a particular user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
try {
    UserDetail result = apiInstance.v1AdminUserUidGet(sessionToken, uid);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |

### Return type

[**UserDetail**](UserDetail.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidRolesGet"></a>
# **v1AdminUserUidRolesGet**
> RoleList v1AdminUserUidRolesGet(sessionToken, uid)

PROVISIONAL Get the list of roles assigned to a user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
try {
    RoleList result = apiInstance.v1AdminUserUidRolesGet(sessionToken, uid);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidRolesGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |

### Return type

[**RoleList**](RoleList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidRolesUpdatePost"></a>
# **v1AdminUserUidRolesUpdatePost**
> SuccessResponse v1AdminUserUidRolesUpdatePost(sessionToken, uid, payload)

PROVISIONAL Update the list of roles assigned to a user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
StringList payload = new StringList(); // StringList | 
try {
    SuccessResponse result = apiInstance.v1AdminUserUidRolesUpdatePost(sessionToken, uid, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidRolesUpdatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |
 **payload** | [**StringList**](StringList.md)|  |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidStatusGet"></a>
# **v1AdminUserUidStatusGet**
> UserStatus v1AdminUserUidStatusGet(sessionToken, uid)

Get the status, active or inactive, for a particular user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
try {
    UserStatus result = apiInstance.v1AdminUserUidStatusGet(sessionToken, uid);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidStatusGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |

### Return type

[**UserStatus**](UserStatus.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidStatusUpdatePost"></a>
# **v1AdminUserUidStatusUpdatePost**
> SuccessResponse v1AdminUserUidStatusUpdatePost(sessionToken, uid, payload)

Update the status of a particular user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
UserStatus payload = new UserStatus(); // UserStatus | 
try {
    SuccessResponse result = apiInstance.v1AdminUserUidStatusUpdatePost(sessionToken, uid, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidStatusUpdatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |
 **payload** | [**UserStatus**](UserStatus.md)|  |

### Return type

[**SuccessResponse**](SuccessResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminUserUidUpdatePost"></a>
# **v1AdminUserUidUpdatePost**
> UserDetail v1AdminUserUidUpdatePost(sessionToken, uid, payload)

Update an existing user

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.UserApi;


UserApi apiInstance = new UserApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Long uid = 789L; // Long | User ID as a decimal integer 
UserAttributes payload = new UserAttributes(); // UserAttributes | 
try {
    UserDetail result = apiInstance.v1AdminUserUidUpdatePost(sessionToken, uid, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling UserApi#v1AdminUserUidUpdatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **uid** | **Long**| User ID as a decimal integer  |
 **payload** | [**UserAttributes**](UserAttributes.md)|  |

### Return type

[**UserDetail**](UserDetail.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

