# InfoBarriersApi

All URIs are relative to *https://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1AdminGroupGidMembershipAddPost**](InfoBarriersApi.md#v1AdminGroupGidMembershipAddPost) | **POST** /v1/admin/group/{gid}/membership/add | Add members to an Information Barrier group.
[**v1AdminGroupGidMembershipListGet**](InfoBarriersApi.md#v1AdminGroupGidMembershipListGet) | **GET** /v1/admin/group/{gid}/membership/list | Get the list of userids in this Information Barrier Group
[**v1AdminGroupGidMembershipRemovePost**](InfoBarriersApi.md#v1AdminGroupGidMembershipRemovePost) | **POST** /v1/admin/group/{gid}/membership/remove | Remove members from an Information Barrier group
[**v1AdminGroupListGet**](InfoBarriersApi.md#v1AdminGroupListGet) | **GET** /v1/admin/group/list | Get a list of all Information Barrier Groups
[**v1AdminPolicyListGet**](InfoBarriersApi.md#v1AdminPolicyListGet) | **GET** /v1/admin/policy/list | Get all Information Policies


<a name="v1AdminGroupGidMembershipAddPost"></a>
# **v1AdminGroupGidMembershipAddPost**
> BulkActionResult v1AdminGroupGidMembershipAddPost(gid, sessionToken, users)

Add members to an Information Barrier group.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.InfoBarriersApi;


InfoBarriersApi apiInstance = new InfoBarriersApi();
String gid = "gid_example"; // String | URL-Safe encoded Group ID
String sessionToken = "sessionToken_example"; // String | Session authentication token.
IntegerList users = new IntegerList(); // IntegerList | 
try {
    BulkActionResult result = apiInstance.v1AdminGroupGidMembershipAddPost(gid, sessionToken, users);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling InfoBarriersApi#v1AdminGroupGidMembershipAddPost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **gid** | **String**| URL-Safe encoded Group ID |
 **sessionToken** | **String**| Session authentication token. |
 **users** | [**IntegerList**](IntegerList.md)|  |

### Return type

[**BulkActionResult**](BulkActionResult.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminGroupGidMembershipListGet"></a>
# **v1AdminGroupGidMembershipListGet**
> IntegerList v1AdminGroupGidMembershipListGet(gid, sessionToken)

Get the list of userids in this Information Barrier Group

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.InfoBarriersApi;


InfoBarriersApi apiInstance = new InfoBarriersApi();
String gid = "gid_example"; // String | URL-Safe encoded Group ID
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    IntegerList result = apiInstance.v1AdminGroupGidMembershipListGet(gid, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling InfoBarriersApi#v1AdminGroupGidMembershipListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **gid** | **String**| URL-Safe encoded Group ID |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**IntegerList**](IntegerList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminGroupGidMembershipRemovePost"></a>
# **v1AdminGroupGidMembershipRemovePost**
> BulkActionResult v1AdminGroupGidMembershipRemovePost(gid, sessionToken, users)

Remove members from an Information Barrier group

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.InfoBarriersApi;


InfoBarriersApi apiInstance = new InfoBarriersApi();
String gid = "gid_example"; // String | URL-Safe encoded Group ID
String sessionToken = "sessionToken_example"; // String | Session authentication token.
IntegerList users = new IntegerList(); // IntegerList | 
try {
    BulkActionResult result = apiInstance.v1AdminGroupGidMembershipRemovePost(gid, sessionToken, users);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling InfoBarriersApi#v1AdminGroupGidMembershipRemovePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **gid** | **String**| URL-Safe encoded Group ID |
 **sessionToken** | **String**| Session authentication token. |
 **users** | [**IntegerList**](IntegerList.md)|  |

### Return type

[**BulkActionResult**](BulkActionResult.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminGroupListGet"></a>
# **v1AdminGroupListGet**
> GroupList v1AdminGroupListGet(sessionToken)

Get a list of all Information Barrier Groups

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.InfoBarriersApi;


InfoBarriersApi apiInstance = new InfoBarriersApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    GroupList result = apiInstance.v1AdminGroupListGet(sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling InfoBarriersApi#v1AdminGroupListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**GroupList**](GroupList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminPolicyListGet"></a>
# **v1AdminPolicyListGet**
> PolicyList v1AdminPolicyListGet(sessionToken)

Get all Information Policies

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.InfoBarriersApi;


InfoBarriersApi apiInstance = new InfoBarriersApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    PolicyList result = apiInstance.v1AdminPolicyListGet(sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling InfoBarriersApi#v1AdminPolicyListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**PolicyList**](PolicyList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

