# DisclaimerApi

All URIs are relative to *https://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1AdminDisclaimerCreatePost**](DisclaimerApi.md#v1AdminDisclaimerCreatePost) | **POST** /v1/admin/disclaimer/create | PROVISIONAL Create a new disclaimer. The id and timestamps should not be set, they will be assigned in the response.
[**v1AdminDisclaimerDidGet**](DisclaimerApi.md#v1AdminDisclaimerDidGet) | **GET** /v1/admin/disclaimer/{did} | Get a disclaimer by disclaimer id
[**v1AdminDisclaimerDidUpdatePost**](DisclaimerApi.md#v1AdminDisclaimerDidUpdatePost) | **POST** /v1/admin/disclaimer/{did}/update | PROVISIONAL Modify a disclaimer
[**v1AdminDisclaimerDidUsersGet**](DisclaimerApi.md#v1AdminDisclaimerDidUsersGet) | **GET** /v1/admin/disclaimer/{did}/users | List all users assigned to this disclaimer
[**v1AdminDisclaimerListGet**](DisclaimerApi.md#v1AdminDisclaimerListGet) | **GET** /v1/admin/disclaimer/list | List all disclaimers for the company (pod)


<a name="v1AdminDisclaimerCreatePost"></a>
# **v1AdminDisclaimerCreatePost**
> Disclaimer v1AdminDisclaimerCreatePost(sessionToken, payload)

PROVISIONAL Create a new disclaimer. The id and timestamps should not be set, they will be assigned in the response.

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.DisclaimerApi;


DisclaimerApi apiInstance = new DisclaimerApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Disclaimer payload = new Disclaimer(); // Disclaimer | 
try {
    Disclaimer result = apiInstance.v1AdminDisclaimerCreatePost(sessionToken, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling DisclaimerApi#v1AdminDisclaimerCreatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **payload** | [**Disclaimer**](Disclaimer.md)|  |

### Return type

[**Disclaimer**](Disclaimer.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminDisclaimerDidGet"></a>
# **v1AdminDisclaimerDidGet**
> Disclaimer v1AdminDisclaimerDidGet(sessionToken, did)

Get a disclaimer by disclaimer id

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.DisclaimerApi;


DisclaimerApi apiInstance = new DisclaimerApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
String did = "did_example"; // String | The ID of the entity
try {
    Disclaimer result = apiInstance.v1AdminDisclaimerDidGet(sessionToken, did);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling DisclaimerApi#v1AdminDisclaimerDidGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **did** | **String**| The ID of the entity |

### Return type

[**Disclaimer**](Disclaimer.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminDisclaimerDidUpdatePost"></a>
# **v1AdminDisclaimerDidUpdatePost**
> Disclaimer v1AdminDisclaimerDidUpdatePost(sessionToken, did, payload)

PROVISIONAL Modify a disclaimer

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.DisclaimerApi;


DisclaimerApi apiInstance = new DisclaimerApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
String did = "did_example"; // String | The ID of the entity
Disclaimer payload = new Disclaimer(); // Disclaimer | 
try {
    Disclaimer result = apiInstance.v1AdminDisclaimerDidUpdatePost(sessionToken, did, payload);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling DisclaimerApi#v1AdminDisclaimerDidUpdatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **did** | **String**| The ID of the entity |
 **payload** | [**Disclaimer**](Disclaimer.md)|  |

### Return type

[**Disclaimer**](Disclaimer.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminDisclaimerDidUsersGet"></a>
# **v1AdminDisclaimerDidUsersGet**
> UserIdList v1AdminDisclaimerDidUsersGet(sessionToken, did)

List all users assigned to this disclaimer

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.DisclaimerApi;


DisclaimerApi apiInstance = new DisclaimerApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
String did = "did_example"; // String | The ID of the entity
try {
    UserIdList result = apiInstance.v1AdminDisclaimerDidUsersGet(sessionToken, did);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling DisclaimerApi#v1AdminDisclaimerDidUsersGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **did** | **String**| The ID of the entity |

### Return type

[**UserIdList**](UserIdList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1AdminDisclaimerListGet"></a>
# **v1AdminDisclaimerListGet**
> DisclaimerList v1AdminDisclaimerListGet(sessionToken)

List all disclaimers for the company (pod)

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.DisclaimerApi;


DisclaimerApi apiInstance = new DisclaimerApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    DisclaimerList result = apiInstance.v1AdminDisclaimerListGet(sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling DisclaimerApi#v1AdminDisclaimerListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**DisclaimerList**](DisclaimerList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

