# ConfigurationInstanceApi

All URIs are relative to *https://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1ConfigurationConfigurationIdInstanceCreatePost**](ConfigurationInstanceApi.md#v1ConfigurationConfigurationIdInstanceCreatePost) | **POST** /v1/configuration/{configurationId}/instance/create | Create a Configuration Instance object.
[**v1ConfigurationConfigurationIdInstanceInstanceIdGetGet**](ConfigurationInstanceApi.md#v1ConfigurationConfigurationIdInstanceInstanceIdGetGet) | **GET** /v1/configuration/{configurationId}/instance/{instanceId}/get | Get a configuration Instance from a Configuration.
[**v1ConfigurationConfigurationIdInstanceInstanceIdUpdatePut**](ConfigurationInstanceApi.md#v1ConfigurationConfigurationIdInstanceInstanceIdUpdatePut) | **PUT** /v1/configuration/{configurationId}/instance/{instanceId}/update | Update a configuration Instance object.
[**v1ConfigurationConfigurationIdInstanceListGet**](ConfigurationInstanceApi.md#v1ConfigurationConfigurationIdInstanceListGet) | **GET** /v1/configuration/{configurationId}/instance/list | Get a list of configuration Instances from an Integration.


<a name="v1ConfigurationConfigurationIdInstanceCreatePost"></a>
# **v1ConfigurationConfigurationIdInstanceCreatePost**
> ConfigurationInstance v1ConfigurationConfigurationIdInstanceCreatePost(configurationId, sessionToken, configurationInstance)

Create a Configuration Instance object.

A caller can create a Configuration Instance object.  If the {configurationId} is invalid, a client error results. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.ConfigurationInstanceApi;


ConfigurationInstanceApi apiInstance = new ConfigurationInstanceApi();
String configurationId = "configurationId_example"; // String | Configuration ID
String sessionToken = "sessionToken_example"; // String | Session authentication token.
ConfigurationInstanceSubmissionCreate configurationInstance = new ConfigurationInstanceSubmissionCreate(); // ConfigurationInstanceSubmissionCreate | 
try {
    ConfigurationInstance result = apiInstance.v1ConfigurationConfigurationIdInstanceCreatePost(configurationId, sessionToken, configurationInstance);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling ConfigurationInstanceApi#v1ConfigurationConfigurationIdInstanceCreatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configurationId** | **String**| Configuration ID |
 **sessionToken** | **String**| Session authentication token. |
 **configurationInstance** | [**ConfigurationInstanceSubmissionCreate**](ConfigurationInstanceSubmissionCreate.md)|  |

### Return type

[**ConfigurationInstance**](ConfigurationInstance.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1ConfigurationConfigurationIdInstanceInstanceIdGetGet"></a>
# **v1ConfigurationConfigurationIdInstanceInstanceIdGetGet**
> ConfigurationInstance v1ConfigurationConfigurationIdInstanceInstanceIdGetGet(configurationId, instanceId, sessionToken)

Get a configuration Instance from a Configuration.

A caller can get a configuration Instance object for a given Configuration and Instance ID.  If the {configurationId} is invalid, a client error results.  If the {instanceId} is invalid, a client error results.  If the ID is correct, then 200 is returned along with the configuration Instance. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.ConfigurationInstanceApi;


ConfigurationInstanceApi apiInstance = new ConfigurationInstanceApi();
String configurationId = "configurationId_example"; // String | Configuration ID
String instanceId = "instanceId_example"; // String | Configuration Instance ID
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    ConfigurationInstance result = apiInstance.v1ConfigurationConfigurationIdInstanceInstanceIdGetGet(configurationId, instanceId, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling ConfigurationInstanceApi#v1ConfigurationConfigurationIdInstanceInstanceIdGetGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configurationId** | **String**| Configuration ID |
 **instanceId** | **String**| Configuration Instance ID |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**ConfigurationInstance**](ConfigurationInstance.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v1ConfigurationConfigurationIdInstanceInstanceIdUpdatePut"></a>
# **v1ConfigurationConfigurationIdInstanceInstanceIdUpdatePut**
> ConfigurationInstance v1ConfigurationConfigurationIdInstanceInstanceIdUpdatePut(configurationId, instanceId, sessionToken, configurationInstance)

Update a configuration Instance object.

A caller can update a configuration Instance object.  If the {configurationId} is invalid, a client error results.  If the {instanceId} is invalid, a client error results. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.ConfigurationInstanceApi;


ConfigurationInstanceApi apiInstance = new ConfigurationInstanceApi();
String configurationId = "configurationId_example"; // String | Configuration ID
String instanceId = "instanceId_example"; // String | Configuration Instance ID
String sessionToken = "sessionToken_example"; // String | Session authentication token.
ConfigurationInstanceSubmissionUpdate configurationInstance = new ConfigurationInstanceSubmissionUpdate(); // ConfigurationInstanceSubmissionUpdate | 
try {
    ConfigurationInstance result = apiInstance.v1ConfigurationConfigurationIdInstanceInstanceIdUpdatePut(configurationId, instanceId, sessionToken, configurationInstance);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling ConfigurationInstanceApi#v1ConfigurationConfigurationIdInstanceInstanceIdUpdatePut");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configurationId** | **String**| Configuration ID |
 **instanceId** | **String**| Configuration Instance ID |
 **sessionToken** | **String**| Session authentication token. |
 **configurationInstance** | [**ConfigurationInstanceSubmissionUpdate**](ConfigurationInstanceSubmissionUpdate.md)|  |

### Return type

[**ConfigurationInstance**](ConfigurationInstance.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1ConfigurationConfigurationIdInstanceListGet"></a>
# **v1ConfigurationConfigurationIdInstanceListGet**
> ConfigurationInstanceList v1ConfigurationConfigurationIdInstanceListGet(configurationId, sessionToken, offset, limit)

Get a list of configuration Instances from an Integration.

A caller can get all configuration Instances objects for a given Configuration ID.  If the {configurationId} is invalid, a client error results.  If there are no configuration Instances to return, a 204 response will be returned. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.ConfigurationInstanceApi;


ConfigurationInstanceApi apiInstance = new ConfigurationInstanceApi();
String configurationId = "configurationId_example"; // String | Configuration ID
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Integer offset = 56; // Integer | No. of configuration Instances to skip. 
Integer limit = 56; // Integer | Max No. of configuration Instances to return. If no value is provided, 50 is the default. 
try {
    ConfigurationInstanceList result = apiInstance.v1ConfigurationConfigurationIdInstanceListGet(configurationId, sessionToken, offset, limit);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling ConfigurationInstanceApi#v1ConfigurationConfigurationIdInstanceListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configurationId** | **String**| Configuration ID |
 **sessionToken** | **String**| Session authentication token. |
 **offset** | **Integer**| No. of configuration Instances to skip.  | [optional]
 **limit** | **Integer**| Max No. of configuration Instances to return. If no value is provided, 50 is the default.  | [optional]

### Return type

[**ConfigurationInstanceList**](ConfigurationInstanceList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

