# ConfigurationApi

All URIs are relative to *https://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1ConfigurationConfigurationIdGetGet**](ConfigurationApi.md#v1ConfigurationConfigurationIdGetGet) | **GET** /v1/configuration/{configurationId}/get | Gets a Configuration object.
[**v1ConfigurationConfigurationIdUpdatePut**](ConfigurationApi.md#v1ConfigurationConfigurationIdUpdatePut) | **PUT** /v1/configuration/{configurationId}/update | Update a Configuration object.
[**v1ConfigurationCreatePost**](ConfigurationApi.md#v1ConfigurationCreatePost) | **POST** /v1/configuration/create | Create a Configuration object.
[**v1ConfigurationListGet**](ConfigurationApi.md#v1ConfigurationListGet) | **GET** /v1/configuration/list | Gets a list of Configurations.


<a name="v1ConfigurationConfigurationIdGetGet"></a>
# **v1ConfigurationConfigurationIdGetGet**
> V1Configuration v1ConfigurationConfigurationIdGetGet(configurationId, sessionToken)

Gets a Configuration object.

A caller can get a Configuration object for a given ID.  If the {configurationId} is invalid, a client error results.  If the ID is correct, then 200 is returned along with the Configuration. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.ConfigurationApi;


ConfigurationApi apiInstance = new ConfigurationApi();
String configurationId = "configurationId_example"; // String | Configuration ID
String sessionToken = "sessionToken_example"; // String | Session authentication token.
try {
    V1Configuration result = apiInstance.v1ConfigurationConfigurationIdGetGet(configurationId, sessionToken);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling ConfigurationApi#v1ConfigurationConfigurationIdGetGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configurationId** | **String**| Configuration ID |
 **sessionToken** | **String**| Session authentication token. |

### Return type

[**V1Configuration**](V1Configuration.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

<a name="v1ConfigurationConfigurationIdUpdatePut"></a>
# **v1ConfigurationConfigurationIdUpdatePut**
> V1Configuration v1ConfigurationConfigurationIdUpdatePut(configurationId, sessionToken, _configuration)

Update a Configuration object.

A caller can update a Configuration object.  If the {configurationId} is invalid, a client error results. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.ConfigurationApi;


ConfigurationApi apiInstance = new ConfigurationApi();
String configurationId = "configurationId_example"; // String | Configuration ID
String sessionToken = "sessionToken_example"; // String | Session authentication token.
V1Configuration _configuration = new V1Configuration(); // V1Configuration | 
try {
    V1Configuration result = apiInstance.v1ConfigurationConfigurationIdUpdatePut(configurationId, sessionToken, _configuration);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling ConfigurationApi#v1ConfigurationConfigurationIdUpdatePut");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configurationId** | **String**| Configuration ID |
 **sessionToken** | **String**| Session authentication token. |
 **_configuration** | [**V1Configuration**](V1Configuration.md)|  |

### Return type

[**V1Configuration**](V1Configuration.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1ConfigurationCreatePost"></a>
# **v1ConfigurationCreatePost**
> V1Configuration v1ConfigurationCreatePost(sessionToken, _configuration)

Create a Configuration object.

A caller can create a Configuration object. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.ConfigurationApi;


ConfigurationApi apiInstance = new ConfigurationApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
V1ConfigurationSubmissionCreate _configuration = new V1ConfigurationSubmissionCreate(); // V1ConfigurationSubmissionCreate | 
try {
    V1Configuration result = apiInstance.v1ConfigurationCreatePost(sessionToken, _configuration);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling ConfigurationApi#v1ConfigurationCreatePost");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **_configuration** | [**V1ConfigurationSubmissionCreate**](V1ConfigurationSubmissionCreate.md)|  |

### Return type

[**V1Configuration**](V1Configuration.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

<a name="v1ConfigurationListGet"></a>
# **v1ConfigurationListGet**
> ConfigurationList v1ConfigurationListGet(sessionToken, offset, limit)

Gets a list of Configurations.

A caller can get all Configuration objects.  If there are no Configurations to return, a 204 response will be returned. 

### Example
```java
// Import classes:
//import org.symphonyoss.symphony.pod.invoker.ApiException;
//import org.symphonyoss.symphony.pod.api.ConfigurationApi;


ConfigurationApi apiInstance = new ConfigurationApi();
String sessionToken = "sessionToken_example"; // String | Session authentication token.
Integer offset = 56; // Integer | No. of Configurations to skip. 
Integer limit = 56; // Integer | Max No. of Configurations to return. If no value is provided, 50 is the default. 
try {
    ConfigurationList result = apiInstance.v1ConfigurationListGet(sessionToken, offset, limit);
    System.out.println(result);
} catch (ApiException e) {
    System.err.println("Exception when calling ConfigurationApi#v1ConfigurationListGet");
    e.printStackTrace();
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionToken** | **String**| Session authentication token. |
 **offset** | **Integer**| No. of Configurations to skip.  | [optional]
 **limit** | **Integer**| Max No. of Configurations to return. If no value is provided, 50 is the default.  | [optional]

### Return type

[**ConfigurationList**](ConfigurationList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

