/*
 * Authenticator API
 * For bots and other on-premise processes to authenticate. Once authenticated, the bot will be able to use the methods described in serviceAPI.yaml and agentAPI.yaml.  Connections to the servers will be over client authenticated TLS, the servers for this API will perform the authentication by inspecting the certificate presented by the SSLSocketClient.  There will be two implementations of this API, one on your Pod and one on the Key Manager. In order to fully authenticate, an API client will have to call both of these implementations and pass both of the session tokens returned as headers in all subsequent requests to the Symphony API. 
 *
 * OpenAPI spec version: 1.50.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.symphonyoss.symphony.authenticator.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ExtensionAppTokens
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-01-28T11:18:01.884-05:00")
public class ExtensionAppTokens {
  @JsonProperty("appId")
  private String appId = null;

  @JsonProperty("appToken")
  private String appToken = null;

  @JsonProperty("symphonyToken")
  private String symphonyToken = null;

  @JsonProperty("expireAt")
  private Long expireAt = null;

  public ExtensionAppTokens appId(String appId) {
    this.appId = appId;
    return this;
  }

   /**
   * Application ID
   * @return appId
  **/
  @ApiModelProperty(value = "Application ID")
  public String getAppId() {
    return appId;
  }

  public void setAppId(String appId) {
    this.appId = appId;
  }

  public ExtensionAppTokens appToken(String appToken) {
    this.appToken = appToken;
    return this;
  }

   /**
   * This token generated by the application when calling authentication endpoint 
   * @return appToken
  **/
  @ApiModelProperty(value = "This token generated by the application when calling authentication endpoint ")
  public String getAppToken() {
    return appToken;
  }

  public void setAppToken(String appToken) {
    this.appToken = appToken;
  }

  public ExtensionAppTokens symphonyToken(String symphonyToken) {
    this.symphonyToken = symphonyToken;
    return this;
  }

   /**
   * This token generated by Symphony and should be used by the application to verify that it&#39;s talking to Symphony. 
   * @return symphonyToken
  **/
  @ApiModelProperty(value = "This token generated by Symphony and should be used by the application to verify that it's talking to Symphony. ")
  public String getSymphonyToken() {
    return symphonyToken;
  }

  public void setSymphonyToken(String symphonyToken) {
    this.symphonyToken = symphonyToken;
  }

  public ExtensionAppTokens expireAt(Long expireAt) {
    this.expireAt = expireAt;
    return this;
  }

   /**
   * unix timestamp when the token expired
   * @return expireAt
  **/
  @ApiModelProperty(value = "unix timestamp when the token expired")
  public Long getExpireAt() {
    return expireAt;
  }

  public void setExpireAt(Long expireAt) {
    this.expireAt = expireAt;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExtensionAppTokens extensionAppTokens = (ExtensionAppTokens) o;
    return Objects.equals(this.appId, extensionAppTokens.appId) &&
        Objects.equals(this.appToken, extensionAppTokens.appToken) &&
        Objects.equals(this.symphonyToken, extensionAppTokens.symphonyToken) &&
        Objects.equals(this.expireAt, extensionAppTokens.expireAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appId, appToken, symphonyToken, expireAt);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExtensionAppTokens {\n");
    
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    appToken: ").append(toIndentedString(appToken)).append("\n");
    sb.append("    symphonyToken: ").append(toIndentedString(symphonyToken)).append("\n");
    sb.append("    expireAt: ").append(toIndentedString(expireAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

