package org.symphonyoss.symphony.authenticator.api;

import org.symphonyoss.symphony.authenticator.invoker.ApiException;
import org.symphonyoss.symphony.authenticator.invoker.ApiClient;
import org.symphonyoss.symphony.authenticator.invoker.Configuration;
import org.symphonyoss.symphony.authenticator.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.symphonyoss.symphony.authenticator.model.AuthenticateRequest;
import org.symphonyoss.symphony.authenticator.model.Error;
import org.symphonyoss.symphony.authenticator.model.ExtensionAppTokens;
import org.symphonyoss.symphony.authenticator.model.OboAuthResponse;
import org.symphonyoss.symphony.authenticator.model.Token;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-08-25T07:03:16.361-04:00")
public class AuthenticationApi {
  private ApiClient apiClient;

  public AuthenticationApi() {
    this(Configuration.getDefaultApiClient());
  }

  public AuthenticationApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * PROVISIONAL - Authenticate an application in a delegated context.
   * Based on the SSL client certificate presented by the TLS layer, authenticate the API caller and return an application session. 
   * @return Token
   * @throws ApiException if fails to make API call
   */
  public Token v1AppAuthenticatePost() throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/v1/app/authenticate".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Token> localVarReturnType = new GenericType<Token>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * PROVISIONAL - Authenicate an application in a delegated context to act on behalf of a user
   * 
   * @param uid user id (required)
   * @param sessionToken Authorization token obtains from app/authenicate API (required)
   * @return OboAuthResponse
   * @throws ApiException if fails to make API call
   */
  public OboAuthResponse v1AppUserUidAuthenticatePost(Long uid, String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'uid' is set
    if (uid == null) {
      throw new ApiException(400, "Missing the required parameter 'uid' when calling v1AppUserUidAuthenticatePost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AppUserUidAuthenticatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/app/user/{uid}/authenticate".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "uid" + "\\}", apiClient.escapeString(uid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<OboAuthResponse> localVarReturnType = new GenericType<OboAuthResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * PROVISIONAL - Authenicate an application in a delegated context to act on behalf of a user
   * 
   * @param username username (required)
   * @param sessionToken Authorization token obtains from app/authenicate API (required)
   * @return OboAuthResponse
   * @throws ApiException if fails to make API call
   */
  public OboAuthResponse v1AppUsernameUsernameAuthenticatePost(String username, String sessionToken) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'username' is set
    if (username == null) {
      throw new ApiException(400, "Missing the required parameter 'username' when calling v1AppUsernameUsernameAuthenticatePost");
    }
    
    // verify the required parameter 'sessionToken' is set
    if (sessionToken == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v1AppUsernameUsernameAuthenticatePost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/app/username/{username}/authenticate".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "username" + "\\}", apiClient.escapeString(username.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (sessionToken != null)
      localVarHeaderParams.put("sessionToken", apiClient.parameterToString(sessionToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<OboAuthResponse> localVarReturnType = new GenericType<OboAuthResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Authenticate a client-extension application
   * Based on the application&#39;s SSL client certificate presented by the TLS layer, it authenticates the client-extension application and return a symphony verification token. 
   * @param authRequest application generated token (required)
   * @return ExtensionAppTokens
   * @throws ApiException if fails to make API call
   */
  public ExtensionAppTokens v1AuthenticateExtensionAppPost(AuthenticateRequest authRequest) throws ApiException {
    Object localVarPostBody = authRequest;
    
    // verify the required parameter 'authRequest' is set
    if (authRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'authRequest' when calling v1AuthenticateExtensionAppPost");
    }
    
    // create path and map variables
    String localVarPath = "/v1/authenticate/extensionApp".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ExtensionAppTokens> localVarReturnType = new GenericType<ExtensionAppTokens>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Authenticate.
   * Based on the SSL client certificate presented by the TLS layer, authenticate the API caller and return a session token. 
   * @return Token
   * @throws ApiException if fails to make API call
   */
  public Token v1AuthenticatePost() throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/v1/authenticate".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Token> localVarReturnType = new GenericType<Token>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
