/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.util;

import java.io.IOException;
import java.io.OutputStream;

public class CountedOutputStream
extends OutputStream {
    private final OutputStream out;
    private long offset = 0L;
    private int counted = 0;

    public CountedOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.counted == 0) {
            ++this.offset;
        }
        ++this.counted;
        this.out.write(b);
        --this.counted;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.counted == 0) {
            this.offset += (long)len;
        }
        ++this.counted;
        this.out.write(b, off, len);
        --this.counted;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.counted == 0) {
            this.offset += (long)b.length;
        }
        ++this.counted;
        this.out.write(b);
        --this.counted;
    }

    public long getOffset() {
        return this.offset;
    }

    public void beginUncounted() {
        ++this.counted;
    }

    public void endUncounted() {
        --this.counted;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

