/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.TableCellNode;

public class TableCell
extends Element {
    public static final String MESSAGEML_TAG = "td";
    private static final String ATTR_ROWSPAN = "rowspan";
    private static final String ATTR_COLSPAN = "colspan";

    public TableCell(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "rowspan": {
                this.setAttribute(ATTR_ROWSPAN, this.getLongAttribute(item).toString());
                break;
            }
            case "colspan": {
                this.setAttribute(ATTR_COLSPAN, this.getLongAttribute(item).toString());
                break;
            }
            default: {
                super.buildAttribute(parser, item);
            }
        }
    }

    @Override
    public Node asMarkdown() {
        return new TableCellNode();
    }

    public String toString() {
        return "Cell";
    }

    @Override
    void updateBiContext(BiContext context) {
        super.updateBiContext(context);
        if (this.getAttribute(ATTR_ROWSPAN) != null) {
            context.updateItemCount(BiFields.TABLE_CELL_ROW_SPAN.getValue());
        }
        if (this.getAttribute(ATTR_COLSPAN) != null) {
            context.updateItemCount(BiFields.TABLE_CELL_COL_SPAN.getValue());
        }
    }
}

