/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.List;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;

public interface MinMaxLengthElement {
    public static final String MINLENGTH_ATTR = "minlength";
    public static final String MAXLENGTH_ATTR = "maxlength";
    public static final List<String> ALL_MIN_MAX_ATTRS = Arrays.asList("minlength", "maxlength");

    default public void validateMinAndMaxLengths() throws InvalidInputException {
        Integer maxLength = this.getAttributeAsInteger(MAXLENGTH_ATTR);
        if (this.isLengthOutOfRange(maxLength)) {
            throw new InvalidInputException(this.getLengthErrorMessage(MAXLENGTH_ATTR));
        }
        Integer minLength = this.getAttributeAsInteger(MINLENGTH_ATTR);
        if (this.isLengthOutOfRange(minLength)) {
            throw new InvalidInputException(this.getLengthErrorMessage(MINLENGTH_ATTR));
        }
        if (this.isMinAndMaxLengthCombinationValid(minLength = this.getDefaultValueIfCurrentIsNull(minLength, this.getMinValueAllowed()), maxLength = this.getDefaultValueIfCurrentIsNull(maxLength, this.getMaxValueAllowed()))) {
            throw new InvalidInputException("The attribute \"minlength\" must be lower than the \"maxlength\" attribute");
        }
        this.validateInitialValueIfFound(minLength, maxLength);
    }

    default public void validateInitialValueIfFound(Integer minLength, Integer maxLength) throws InvalidInputException {
        String initialValue;
        if (this.hasElementInitialValue() && (this.isTextSmallerThanMinLength(minLength, initialValue = this.getElementInitialValue()) || this.isTextBiggerThanMaxLength(maxLength, initialValue))) {
            throw new InvalidInputException(String.format("The length of this %s's initial value must be between %s and %s", this.getElementType(), minLength, maxLength));
        }
    }

    default public Integer getDefaultValueIfCurrentIsNull(Integer currentValue, Integer defaultValue) {
        return currentValue == null ? defaultValue : currentValue;
    }

    default public boolean isMinAndMaxLengthCombinationValid(Integer minLength, Integer maxLength) {
        return minLength != null && maxLength != null && minLength > maxLength;
    }

    default public boolean isTextBiggerThanMaxLength(Integer maxLength, String text) {
        return text != null && maxLength != null && text.length() > maxLength;
    }

    default public boolean isTextSmallerThanMinLength(Integer minLength, String text) {
        return text != null && minLength != null && text.length() < minLength;
    }

    default public Integer getAttributeAsInteger(String attributeName) throws InvalidInputException {
        Integer length = null;
        if (this.getAttributeValue(attributeName) != null) {
            try {
                length = Integer.parseInt(this.getAttributeValue(attributeName));
            }
            catch (NumberFormatException e) {
                throw new InvalidInputException(String.format("The attribute \"%s\" must be a valid number.", attributeName));
            }
        }
        return length;
    }

    default public boolean isLengthOutOfRange(Integer length) {
        return length != null && (length < this.getMinValueAllowed() || length > this.getMaxValueAllowed());
    }

    default public String getLengthErrorMessage(String attributeName) {
        return String.format("The attribute \"%s\" must be between %s and %s", attributeName, this.getMinValueAllowed(), this.getMaxValueAllowed());
    }

    public String getElementType();

    public boolean hasElementInitialValue();

    public String getElementInitialValue();

    public String getAttributeValue(String var1);

    public Integer getMinValueAllowed();

    public Integer getMaxValueAllowed();
}

