/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.Entity;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.Node;

abstract class Keyword
extends Entity {
    private static final String ATTR_TAG = "tag";
    private static final String ENTITY_ID_PREFIX = "keyword";
    private static final String MSG_INVALID_TAG_PATTERN = "Values of the attribute 'tag' for the element '%s' must match the pattern %s.";
    protected String tag;

    Keyword(Element parent, String messageMLTag, String presentationMlTag, FormatEnum format) {
        super(parent, messageMLTag, presentationMlTag, format);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "tag": {
                this.tag = item.getTextContent();
                break;
            }
            default: {
                super.buildAttribute(parser, item);
            }
        }
    }

    @Override
    public void validate() throws InvalidInputException {
        if (this.tag == null) {
            throw new InvalidInputException("The attribute \"tag\" is required");
        }
        String pattern = this.getTagPattern();
        if (!this.tag.matches(pattern)) {
            throw new InvalidInputException(String.format(MSG_INVALID_TAG_PATTERN, this.getMessageMLTag(), pattern));
        }
        super.validate();
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    protected String getEntityIdPrefix() {
        return ENTITY_ID_PREFIX;
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        out.printElement(this.presentationMLTag, this.asText(), "class", "entity", "data-entity-id", this.entityId);
    }

    @Override
    protected String getEntityValue() {
        return this.getTag();
    }

    public String toString() {
        return "Keyword(" + this.getTag() + ")";
    }

    public abstract String getTagPattern();
}

