/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.w3c.dom.Node;

public class Image
extends Element {
    public static final String MESSAGEML_TAG = "img";
    private static final String ATTR_SRC = "src";

    public Image(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "src": {
                this.setAttribute(ATTR_SRC, this.getStringAttribute(item));
                break;
            }
            default: {
                super.buildAttribute(parser, item);
            }
        }
    }

    @Override
    public void validate() throws InvalidInputException {
        this.assertNoContent();
        if (!this.getAttributes().containsKey(ATTR_SRC)) {
            throw new InvalidInputException("The attribute \"src\" is required");
        }
    }

    @Override
    public boolean areNestedElementsAllowed() {
        return false;
    }

    @Override
    void updateBiContext(BiContext context) {
        super.updateBiContext(context);
        context.updateItemCount(BiFields.IMAGE.getValue());
        String srcValue = this.getAttribute(ATTR_SRC);
        if (srcValue != null) {
            if (srcValue.startsWith("data:image")) {
                context.updateItemCount(BiFields.IMAGE_DATA.getValue());
            }
            if (srcValue.startsWith("http")) {
                context.updateItemCount(BiFields.IMAGE_URL.getValue());
            }
        }
    }
}

