/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;

public class Div
extends Element {
    public static final String MESSAGEML_TAG = "div";
    private static final String ATTR_ENTITY_ID = "data-entity-id";
    private static final String ATTR_ICON_SRC = "data-icon-src";
    private static final String ATTR_ACCENT_COLOR = "data-accent-color";
    private static final String ATTR_DATA_STATE = "data-state";
    private static final String ATTR_DATA_VARIANT = "data-variant";

    public Div(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "data-entity-id": 
            case "data-icon-src": 
            case "data-accent-color": 
            case "data-state": 
            case "data-variant": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            default: {
                super.buildAttribute(parser, item);
            }
        }
    }

    @Override
    public Node asMarkdown() {
        return new Paragraph();
    }

    @Override
    public ObjectNode asEntityJson(ObjectNode parent) {
        String entityId = this.getAttribute(ATTR_ENTITY_ID);
        if (entityId != null) {
            return (ObjectNode)parent.path(entityId);
        }
        return null;
    }

    @Override
    public void validate() throws InvalidInputException {
        String classAttr = this.getAttribute("class");
        if (this.getAttribute(ATTR_ENTITY_ID) != null && !"entity".equals(classAttr)) {
            throw new InvalidInputException("The attribute \"data-entity-id\" is only allowed if the element class is \"entity\".");
        }
        if ("entity".equals(classAttr) && this.getAttribute(ATTR_ENTITY_ID) == null) {
            throw new InvalidInputException("The attribute \"data-entity-id\" is required if the element class is \"entity\".");
        }
        String[] classes = classAttr != null ? classAttr.split(" ") : null;
        for (String attr : new String[]{ATTR_ICON_SRC, ATTR_ACCENT_COLOR}) {
            this.verifyClassSpecificAttribute(attr, classes, "card");
        }
        this.verifyClassSpecificAttribute(ATTR_DATA_STATE, classes, "expandable-card");
        this.verifyClassSpecificAttribute(ATTR_DATA_VARIANT, classes, "expandableCardBody");
    }

    private void verifyClassSpecificAttribute(String attr, String[] classes, String element) throws InvalidInputException {
        if (!(this.getAttribute(attr) == null || classes != null && classes.length != 0 && element.equals(classes[0]))) {
            throw new InvalidInputException(String.format("The attribute \"" + attr + "\" is only allowed if the element class is \"%s\".", element));
        }
    }

    @Override
    void updateBiContext(BiContext context) {
        super.updateBiContext(context);
        context.updateItemCount(BiFields.DIV.getValue());
    }
}

