/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Collections;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.bi.BiItem;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.Keyword;
import org.symphonyoss.symphony.messageml.markdown.nodes.KeywordNode;

public class CashTag
extends Keyword {
    public static final String MESSAGEML_TAG = "cash";
    public static final String PREFIX = "$";
    public static final String ENTITY_TYPE = "org.symphonyoss.fin.security";
    public static final String CASHTAG_PATTERN = "^(?!(?:[0-9,.]+$))(?!(?:[0-9,.]+(m|b|t|mm|bn|M|B|T|MM|BN|\\+|\\-|\\)|\\(|\\[|\\]|\\*|\\/)(\\s|$)))[^\\s\\$]*[^\\s!@#$%^&*()+=<>,.\\/?`~:;'\"\\\\|\\-]+[^\\s\\$]*$";
    private static final String ENTITY_SUBTYPE = "org.symphonyoss.fin.security.id.ticker";
    private static final String ENTITY_VERSION = "1.0";

    public CashTag(Element parent, int entityIndex) {
        super(parent, MESSAGEML_TAG, "span", FormatEnum.MESSAGEML);
        this.entityId = this.getEntityId(entityIndex);
    }

    public CashTag(Element parent, int entityIndex, String value) {
        super(parent, MESSAGEML_TAG, "span", FormatEnum.MESSAGEML);
        this.entityId = this.getEntityId(entityIndex);
        this.tag = value;
    }

    public CashTag(Element parent, String presentationMlTag, String value) {
        super(parent, MESSAGEML_TAG, presentationMlTag, FormatEnum.PRESENTATIONML);
        this.tag = value;
    }

    @Override
    public String asText() {
        return PREFIX + this.getTag();
    }

    @Override
    public Node asMarkdown() {
        return new KeywordNode(PREFIX, this.getTag());
    }

    @Override
    public String toString() {
        return "CashTag(" + this.getTag() + ")";
    }

    @Override
    public String getTagPattern() {
        return CASHTAG_PATTERN;
    }

    @Override
    protected String getEntitySubType() {
        return ENTITY_SUBTYPE;
    }

    @Override
    protected String getEntityVersion() {
        return ENTITY_VERSION;
    }

    @Override
    protected String getEntityType() {
        return ENTITY_TYPE;
    }

    @Override
    public void updateBiContext(BiContext context) {
        super.updateBiContext(context);
        context.updateItemCount(BiFields.CASHTAGS.getValue());
        context.addItem(new BiItem(BiFields.ENTITY.getValue(), Collections.singletonMap(BiFields.ENTITY_TYPE.getValue(), this.getEntitySubType())));
    }
}

