/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.LinkedHashMap;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.Node;

public class Card
extends Element {
    public static final String MESSAGEML_TAG = "card";
    public static final String PRESENTATIONML_CLASS = "card";
    private static final String PRESENTATIONML_TAG = "div";
    private static final String ATTR_ICON = "iconSrc";
    private static final String ATTR_ACCENT = "accent";
    private static final String PRESENTATIONML_ICON = "data-icon-src";
    private static final String PRESENTATIONML_ACCENT = "data-accent-color";

    public Card(Element parent, FormatEnum format) {
        super(parent, "card", format);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "data-icon-src": 
            case "iconSrc": {
                this.setAttribute(ATTR_ICON, this.getStringAttribute(item));
                break;
            }
            case "data-accent-color": 
            case "accent": {
                this.setAttribute(ATTR_ACCENT, this.getStringAttribute(item));
                break;
            }
            default: {
                super.buildAttribute(parser, item);
            }
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        if (this.getAttribute("class") != null) {
            presentationAttrs.put("class", String.format("%s %s", "card", this.getAttribute("class")));
        } else {
            presentationAttrs.put("class", "card");
        }
        if (this.getAttribute(ATTR_ICON) != null) {
            presentationAttrs.put(PRESENTATIONML_ICON, this.getAttribute(ATTR_ICON));
        }
        if (this.getAttribute(ATTR_ACCENT) != null) {
            presentationAttrs.put(PRESENTATIONML_ACCENT, this.getAttribute(ATTR_ACCENT));
        }
        out.openElement(PRESENTATIONML_TAG, presentationAttrs);
        for (Element child : this.getChildren()) {
            child.asPresentationML(out, context);
        }
        out.closeElement();
    }

    @Override
    public String getPresentationMLTag() {
        return PRESENTATIONML_TAG;
    }

    @Override
    void updateBiContext(BiContext context) {
        super.updateBiContext(context);
        context.updateItemCount(BiFields.CARD.getValue());
    }
}

