/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.entityjson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.symphonyoss.symphony.entityjson.EntityJsonParser;
import org.symphonyoss.symphony.entityjson.IEntityJsonInstanceContext;
import org.symphonyoss.symphony.entityjson.IEntityJsonSchemaContext;
import org.symphonyoss.symphony.entityjson.InvalidSchemaException;
import org.symphonyoss.symphony.entityjson.NoSchemaException;
import org.symphonyoss.symphony.entityjson.SchemaValidationException;
import org.symphonyoss.symphony.entityjson.StructuredObjectId;

public class StructuredObject {
    private final IEntityJsonInstanceContext context_;
    private final Object instanceSource_;
    private final ObjectNode jsonNode_;
    private final String toString_;
    private final String type_;
    private final String version_;
    private final int majorVersion_;
    private final int minorVersion_;
    private final List<StructuredObjectId> idList_;

    StructuredObject(IEntityJsonInstanceContext context) {
        this(context, context.getInstanceSource(), context.getInstanceJsonNode());
    }

    StructuredObject(IEntityJsonInstanceContext context, Object instanceSource, ObjectNode jsonNode) {
        this.context_ = context;
        this.instanceSource_ = instanceSource;
        this.jsonNode_ = jsonNode;
        this.type_ = jsonNode.get("type").asText();
        this.version_ = jsonNode.get("version").asText();
        String[] parts = this.version_.split("\\.");
        this.majorVersion_ = Integer.parseInt(parts[0]);
        this.minorVersion_ = Integer.parseInt(parts[1]);
        StringBuffer s = new StringBuffer("StructuredObject(\"");
        s.append(this.type_);
        s.append(" v");
        s.append(this.version_);
        s.append("\"");
        boolean first = true;
        JsonNode idNode = jsonNode.get("id");
        ArrayList<StructuredObjectId> idList = new ArrayList<StructuredObjectId>();
        if (idNode instanceof ArrayNode) {
            for (JsonNode node : idNode) {
                StructuredObjectId id = new StructuredObjectId(node);
                if (first) {
                    first = false;
                    s.append(", \"");
                    s.append(id.toString());
                    s.append("\"");
                }
                idList.add(id);
            }
        }
        this.idList_ = Collections.unmodifiableList(idList);
        s.append(")");
        this.toString_ = s.toString();
    }

    public IEntityJsonInstanceContext getContext() {
        return this.context_;
    }

    public IEntityJsonSchemaContext validate(EntityJsonParser parser) throws SchemaValidationException, NoSchemaException, InvalidSchemaException {
        StringBuffer ubuf = new StringBuffer("https://schemas.oss.symphony.com/proposed");
        for (String part : this.type_.split("\\.")) {
            ubuf.append("/");
            ubuf.append(part);
        }
        ubuf.append("-v");
        ubuf.append(this.majorVersion_);
        ubuf.append("_");
        ubuf.append(this.minorVersion_);
        ubuf.append(".json");
        try {
            return parser.validate(new URL(ubuf.toString()), this.instanceSource_, this.jsonNode_);
        }
        catch (MalformedURLException e) {
            throw new InvalidSchemaException(null, (Throwable)e);
        }
    }

    public String getType() {
        return this.type_;
    }

    public String getVersion() {
        return this.version_;
    }

    public int getMajorVersion() {
        return this.majorVersion_;
    }

    public int getMinorVersion() {
        return this.minorVersion_;
    }

    public List<StructuredObjectId> getIdList() {
        return this.idList_;
    }

    public String toString() {
        return this.toString_;
    }
}

