/*
 * Copyright 2016-2017 MessageML - Symphony LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.symphonyoss.symphony.messageml.util;

import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

import java.io.StringReader;

/**
 * An entity resolver which returns an empty string for any input, making {@link javax.xml.parsers.DocumentBuilder}
 * ignore DTD references.
 * @author lukasz
 * @since 3/24/17
 */
public class NoOpEntityResolver implements EntityResolver {

  @Override
  public InputSource resolveEntity(String publicId, String systemId) {
    return new InputSource(new StringReader(""));
  }
}
