/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.bi.BiItem;
import org.symphonyoss.symphony.messageml.elements.Button;
import org.symphonyoss.symphony.messageml.elements.Checkbox;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.Radio;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.FormNode;

public class Form
extends Element {
    public static final String MESSAGEML_TAG = "form";
    private static final String ID_ATTR = "id";
    private static final int MAX_COUNT_PER_CHILD_TYPE = 50;
    private static final String ERR_MSG_MISSING_ACTION_BTN = "The form with id '%s' should have at least one action button";

    public Form(Element parent, FormatEnum format) {
        super(parent, MESSAGEML_TAG, format);
    }

    @Override
    public Boolean hasIdAttribute() {
        return true;
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        this.assertNotParentAtAnyLevel(Collections.singletonList(this.getClass()));
        this.assertChildrenNotExceedingMaxCount(Arrays.asList(Checkbox.class, Radio.class), 50);
        if (this.getAttribute(ID_ATTR) == null) {
            throw new InvalidInputException("The attribute \"id\" is required");
        }
        this.assertAttributeNotBlank(ID_ATTR);
        this.assertAtLeastOneActionButton();
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        if (ID_ATTR.equals(item.getNodeName())) {
            this.setAttribute(ID_ATTR, this.getStringAttribute(item));
        } else {
            this.throwInvalidInputException(item);
        }
    }

    @Override
    public Node asMarkdown() {
        return new FormNode();
    }

    private void assertAtLeastOneActionButton() throws InvalidInputException {
        boolean hasActionButton = this.findElements(Button.class).stream().anyMatch(element -> "action".equals(element.getAttribute("type")));
        if (!hasActionButton) {
            throw new InvalidInputException(String.format(ERR_MSG_MISSING_ACTION_BTN, this.getAttribute(ID_ATTR)));
        }
    }

    @Override
    void updateBiContext(BiContext context) {
        context.addItem(new BiItem(BiFields.FORM.getValue(), new HashMap<String, Object>()));
    }
}

