/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.bi;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.symphony.messageml.bi.BiItem;

public class BiContext {
    private static final Logger logger = LoggerFactory.getLogger(BiContext.class);
    private final String libraryVersion = BiContext.extractVersion();
    private final List<BiItem> items = new ArrayList<BiItem>();

    public String getLibraryVersion() {
        return this.libraryVersion;
    }

    public List<BiItem> getItems() {
        return this.items;
    }

    public void addItem(BiItem item) {
        this.items.add(item);
    }

    public void updateItem(String itemName, String attributeName) {
        Optional<BiItem> optionalBiItem = this.getItemWithName(itemName);
        if (optionalBiItem.isPresent()) {
            optionalBiItem.get().increaseAttributeCount(attributeName);
        } else {
            this.addItem(new BiItem(itemName, attributeName));
        }
    }

    private Optional<BiItem> getItemWithName(String itemName) {
        return this.getItems().stream().filter(item -> item.getName().equals(itemName)).findFirst();
    }

    private static String extractVersion() {
        String version = BiContext.class.getPackage().getImplementationVersion();
        if (version == null || version.isEmpty()) {
            logger.warn("Failed to extract the messageML library version.");
            version = "Unknown";
        }
        return "MessageML " + version;
    }
}

