/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.Node;

public class ExpandableCard
extends Element {
    public static final String MESSAGEML_TAG = "expandable-card";
    public static final String PRESENTATIONML_CLASS = "expandable-card";
    private static final String PRESENTATIONML_TAG = "div";
    private static final String ATTR_STATE = "state";
    private static final String PRESENTATIONML_STATE = "data-state";
    private static final List<String> allowedStates = Arrays.asList("collapsed", "cropped", "expanded");

    public ExpandableCard(Element parent, FormatEnum format) {
        super(parent, "expandable-card", format);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "data-state": 
            case "state": {
                this.setAttribute(ATTR_STATE, this.getStringAttribute(item));
                break;
            }
            default: {
                super.buildAttribute(parser, item);
            }
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        if (this.getAttribute("class") != null) {
            presentationAttrs.put("class", String.format("%s %s", "expandable-card", this.getAttribute("class")));
        } else {
            presentationAttrs.put("class", "expandable-card");
        }
        if (this.getAttribute(ATTR_STATE) != null) {
            presentationAttrs.put(PRESENTATIONML_STATE, this.getAttribute(ATTR_STATE));
        }
        out.openElement(PRESENTATIONML_TAG, presentationAttrs);
        for (Element child : this.getChildren()) {
            child.asPresentationML(out, context);
        }
        out.closeElement();
    }

    @Override
    public String getPresentationMLTag() {
        return PRESENTATIONML_TAG;
    }

    @Override
    void validate() throws InvalidInputException {
        super.validate();
        this.assertAttributeNotBlank(ATTR_STATE);
        this.assertAttributeValue(ATTR_STATE, allowedStates);
    }
}

