/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.LabelableElement;
import org.symphonyoss.symphony.messageml.elements.TooltipableElement;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class GroupedElement
extends FormElement {
    private static final String PRESENTATIONML_DIV_TAG = "div";
    private static final String PRESENTATIONML_CLASS_ATTR = "class";
    private static final int PRESENTATIONML_DIV_NUMBER_OF_CHILDREN = 2;
    private static final String PRESENTATIONML_DEFAULT_VALUE = "on";
    protected static final String PRESENTATIONML_LABEL_TAG = "label";
    protected static final String VALUE_ATTR = "value";
    protected static final String CHECKED_ATTR = "checked";
    protected static final String FOR_ATTR = "for";

    public GroupedElement(Element parent, String messageMLTag, FormatEnum format) {
        super(parent, messageMLTag, format);
    }

    @Override
    public void buildAll(MessageMLParser parser, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        switch (this.getFormat()) {
            case MESSAGEML: {
                super.buildAll(parser, element);
                break;
            }
            case PRESENTATIONML: {
                if ("input".equals(element.getNodeName())) {
                    this.buildElementAttrFromInputTag(parser, element);
                } else {
                    this.buildElementFromGroupDiv(parser, element);
                }
                this.validate();
                break;
            }
            default: {
                throw new InvalidInputException(String.format("Invalid message format for \"%s\" element", this.getMessageMLTag()));
            }
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        String id = String.format("%s-%s", this.getPresentationMLInputType(), context.generateShortId());
        Map<String, String> presentationInputAttrs = this.buildGroupedElementInputAttributes(id);
        LinkedHashMap<String, String> presentationLabelForAttr = new LinkedHashMap<String, String>();
        if (this.getChildren().isEmpty()) {
            out.printElement("input", presentationInputAttrs);
        } else {
            out.openElement(PRESENTATIONML_DIV_TAG, PRESENTATIONML_CLASS_ATTR, this.getPresentationMLDivClass());
            presentationInputAttrs.put("id", id);
            out.printElement("input", presentationInputAttrs);
            presentationLabelForAttr.put(FOR_ATTR, id);
            out.openElement(PRESENTATIONML_LABEL_TAG, presentationLabelForAttr);
            for (Element child : this.getChildren()) {
                child.asPresentationML(out, context);
            }
            out.closeElement();
            out.closeElement();
        }
    }

    protected void buildElementFromGroupDiv(MessageMLParser parser, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        NodeList children = element.getChildNodes();
        Integer numberOfNonTextChildrenNodes = this.countNonTextNodesInNodeList(children);
        if (numberOfNonTextChildrenNodes != 2) {
            throw new InvalidInputException(String.format("Invalid PresentationML for the \"%s\" element", this.getMessageMLTag()));
        }
        String firstNodeName = "";
        block10: for (int i = 0; i < children.getLength(); ++i) {
            if (firstNodeName.equals(children.item(i).getNodeName())) {
                throw new InvalidInputException(String.format("Invalid PresentationML for the \"%s\" element", this.getMessageMLTag()));
            }
            switch (children.item(i).getNodeName()) {
                case "input": {
                    this.buildElementAttrFromInputTag(parser, children.item(i));
                    firstNodeName = "input";
                    continue block10;
                }
                case "label": {
                    this.buildTextFromLabelTag(parser, children.item(i));
                    firstNodeName = PRESENTATIONML_LABEL_TAG;
                    continue block10;
                }
                case "#text": {
                    continue block10;
                }
                default: {
                    throw new InvalidInputException(String.format("Invalid PresentationML for the \"%s\" element", this.getMessageMLTag()));
                }
            }
        }
    }

    private void buildTextFromLabelTag(MessageMLParser context, Node labelElement) throws InvalidInputException, ProcessingException {
        NodeList childNodes = labelElement.getChildNodes();
        if (childNodes == null || childNodes.getLength() <= 0) {
            throw new InvalidInputException(String.format("Invalid PresentationML for the \"%s\" element", this.getMessageMLTag()));
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            this.buildNode(context, childNodes.item(i));
        }
    }

    protected void buildElementAttrFromInputTag(MessageMLParser parser, Node inputElement) throws InvalidInputException {
        org.w3c.dom.Element sibling;
        NamedNodeMap inputAttributes = inputElement.getAttributes();
        inputAttributes.removeNamedItem("type");
        for (int i = 0; i < inputAttributes.getLength(); ++i) {
            this.buildAttribute(parser, inputAttributes.item(i));
        }
        if (this instanceof LabelableElement && (sibling = this.findSibling(inputElement, PRESENTATIONML_LABEL_TAG, null)) != null) {
            this.getAttributes().put(PRESENTATIONML_LABEL_TAG, sibling.getTextContent());
        }
        if (this instanceof TooltipableElement && (sibling = this.findSibling(inputElement, "span", "info-hint")) != null) {
            this.getAttributes().put("data-title", sibling.getAttribute("data-title"));
        }
    }

    private org.w3c.dom.Element findSibling(Node inputElement, String tagName, String clazz) throws InvalidInputException {
        ArrayList result = new ArrayList();
        Arrays.asList(true, false).stream().forEach(ascending -> {
            Node sibling;
            Node node = sibling = ascending != false ? inputElement.getNextSibling() : inputElement.getPreviousSibling();
            while (sibling != null) {
                org.w3c.dom.Element element;
                if (sibling instanceof org.w3c.dom.Element && tagName.equals((element = (org.w3c.dom.Element)sibling).getTagName()) && (clazz == null || clazz.equals(element.getAttribute(PRESENTATIONML_CLASS_ATTR)))) {
                    result.add(element);
                }
                sibling = ascending != false ? sibling.getNextSibling() : sibling.getPreviousSibling();
            }
        });
        switch (result.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (org.w3c.dom.Element)result.get(0);
            }
        }
        throw new InvalidInputException(String.format("Multiple tag %s found for element %s but only one is expected", tagName, inputElement.getNodeName()));
    }

    protected Map<String, String> buildGroupedElementInputAttributes(String id) {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        presentationAttrs.put("type", this.getPresentationMLInputType());
        presentationAttrs.put("name", this.getAttribute("name"));
        if (this.getAttribute(CHECKED_ATTR) != null) {
            presentationAttrs.put(CHECKED_ATTR, this.getAttribute(CHECKED_ATTR));
        }
        if (this.getAttribute(VALUE_ATTR) != null) {
            presentationAttrs.put(VALUE_ATTR, this.getAttribute(VALUE_ATTR));
        } else {
            presentationAttrs.put(VALUE_ATTR, PRESENTATIONML_DEFAULT_VALUE);
        }
        return presentationAttrs;
    }

    protected abstract String getPresentationMLInputType();

    protected abstract String getPresentationMLDivClass();
}

