/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.LabelableElement;
import org.symphonyoss.symphony.messageml.elements.RegexElement;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.elements.TooltipableElement;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.TextFieldNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class TextField
extends FormElement
implements RegexElement,
LabelableElement,
TooltipableElement {
    public static final String MESSAGEML_TAG = "text-field";
    public static final String ELEMENT_ID = "textfield";
    public static final String PRESENTATIONML_INPUT_TYPE = "text";
    private static final String MINLENGTH_ATTR = "minlength";
    private static final String MAXLENGTH_ATTR = "maxlength";
    private static final String REQUIRED_ATTR = "required";
    private static final String MASKED_ATTR = "masked";
    private static final String PLACEHOLDER_ATTR = "placeholder";
    private static final String VALUE_ATTR = "value";
    private static final String PRESENTATIONML_MASKED_ATTR = "data-masked";
    private static final Set<String> VALID_BOOLEAN_VALUES = new HashSet<String>(Arrays.asList("true", "false"));
    private static final Integer MIN_ALLOWED_LENGTH = 1;
    private static final Integer MAX_ALLOWED_LENGTH = 128;
    private static final String MARKDOWN = "Text Field";

    public TextField(Element parent, FormatEnum messageFormat) {
        super(parent, MESSAGEML_TAG, messageFormat);
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, VALID_BOOLEAN_VALUES);
        }
        if (this.getAttribute(MASKED_ATTR) != null) {
            this.assertAttributeValue(MASKED_ATTR, VALID_BOOLEAN_VALUES);
        }
        this.assertAttributeNotBlank("name");
        this.assertContentModel(Collections.singleton(TextNode.class));
        this.validateMinAndMaxLengths();
    }

    @Override
    public void buildAll(MessageMLParser parser, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        switch (this.getFormat()) {
            case MESSAGEML: {
                super.buildAll(parser, element);
                break;
            }
            case PRESENTATIONML: {
                this.buildAllFromPresentationML(parser, element);
            }
        }
    }

    @Override
    public Node asMarkdown() {
        return new TextFieldNode(this.getAttribute(PLACEHOLDER_ATTR), this.hasExactNumberOfChildren(1) ? this.getChild(0).asText() : null);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "required": 
            case "placeholder": 
            case "minlength": 
            case "maxlength": 
            case "masked": 
            case "pattern": 
            case "pattern-error-message": 
            case "label": 
            case "title": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "id": {
                if (this.format != FormatEnum.PRESENTATIONML) {
                    this.throwInvalidInputException(item);
                }
                this.fillAttributes(parser, item);
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    private void buildAllFromPresentationML(MessageMLParser parser, org.w3c.dom.Element element) throws InvalidInputException {
        NamedNodeMap attr = element.getAttributes();
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            throw new InvalidInputException("Element \"" + this.getMessageMLTag() + "\" may not have child elements or text content");
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            this.buildAttributeFromPresentationML(parser, attr.item(i));
        }
    }

    private void buildAttributeFromPresentationML(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "required": 
            case "placeholder": 
            case "minlength": 
            case "maxlength": 
            case "label": 
            case "pattern": 
            case "data-pattern-error-message": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "value": {
                this.addChild(new TextNode((Element)this, this.getStringAttribute(item)));
                break;
            }
            case "data-masked": {
                this.setAttribute(MASKED_ATTR, this.getStringAttribute(item));
                break;
            }
            case "id": {
                this.fillAttributes(parser, item);
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public Map<String, String> getOtherAttributes() {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        presentationAttrs.put("type", PRESENTATIONML_INPUT_TYPE);
        presentationAttrs.put("name", this.getAttribute("name"));
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            presentationAttrs.put(PLACEHOLDER_ATTR, this.getAttribute(PLACEHOLDER_ATTR));
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            presentationAttrs.put(REQUIRED_ATTR, this.getAttribute(REQUIRED_ATTR));
        }
        if (this.getAttribute(MASKED_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_MASKED_ATTR, this.getAttribute(MASKED_ATTR));
        }
        if (this.getAttribute(MINLENGTH_ATTR) != null) {
            presentationAttrs.put(MINLENGTH_ATTR, this.getAttribute(MINLENGTH_ATTR));
        }
        if (this.getAttribute(MAXLENGTH_ATTR) != null) {
            presentationAttrs.put(MAXLENGTH_ATTR, this.getAttribute(MAXLENGTH_ATTR));
        }
        if (this.getChildren() != null && this.getChildren().size() == 1) {
            presentationAttrs.put(VALUE_ATTR, this.getChildren().get(0).asText());
        }
        return presentationAttrs;
    }

    @Override
    public String getPresentationMLTag() {
        return "input";
    }

    @Override
    public boolean areNestedElementsAllowed() {
        return false;
    }

    @Override
    public String getElementId() {
        return ELEMENT_ID;
    }

    private void validateMinAndMaxLengths() throws InvalidInputException {
        String initialValue;
        Integer maxLength = this.getAttributeAsInteger(MAXLENGTH_ATTR);
        if (this.isLengthOutOfRange(maxLength)) {
            throw new InvalidInputException(this.getLengthErrorMessage(MAXLENGTH_ATTR));
        }
        Integer minLength = this.getAttributeAsInteger(MINLENGTH_ATTR);
        if (this.isLengthOutOfRange(minLength)) {
            throw new InvalidInputException(this.getLengthErrorMessage(MINLENGTH_ATTR));
        }
        minLength = this.getDefaultValueIfCurrentIsNull(minLength, MIN_ALLOWED_LENGTH);
        if (this.isMinAndMaxLengthCombinationValid(maxLength = this.getDefaultValueIfCurrentIsNull(maxLength, MAX_ALLOWED_LENGTH), minLength)) {
            throw new InvalidInputException("The attribute \"minlength\" must be lower than the \"maxlength\" attribute");
        }
        if (this.textFieldHasInitialValue() && (this.isTextSmallerThanMinLength(minLength, initialValue = this.getTextFieldInitialValue()) || this.isTextBiggerThanMaxLength(maxLength, initialValue))) {
            throw new InvalidInputException(String.format("The length of this text-field's initial value must be between %s and %s", minLength, maxLength));
        }
    }

    private Integer getDefaultValueIfCurrentIsNull(Integer currentValue, Integer defaultValue) {
        return currentValue == null ? defaultValue : currentValue;
    }

    private String getTextFieldInitialValue() {
        return ((TextNode)this.getChild(0)).getText();
    }

    private boolean isMinAndMaxLengthCombinationValid(Integer maxLength, Integer minLength) {
        return minLength != null && maxLength != null && minLength > maxLength;
    }

    private boolean isTextBiggerThanMaxLength(Integer maxLength, String text) {
        return text != null && maxLength != null && text.length() > maxLength;
    }

    private boolean isTextSmallerThanMinLength(Integer minLength, String text) {
        return text != null && minLength != null && text.length() < minLength;
    }

    private boolean textFieldHasInitialValue() {
        return this.getChildren() != null && this.getChildren().size() == 1 && this.getChild(0) instanceof TextNode;
    }

    private Integer getAttributeAsInteger(String attributeName) throws InvalidInputException {
        Integer length = null;
        if (this.getAttribute(attributeName) != null) {
            try {
                length = Integer.parseInt(this.getAttribute(attributeName));
            }
            catch (NumberFormatException e) {
                throw new InvalidInputException(String.format("The attribute \"%s\" must be a valid number.", attributeName));
            }
        }
        return length;
    }

    private boolean isLengthOutOfRange(Integer length) {
        return length != null && (length < MIN_ALLOWED_LENGTH || length > MAX_ALLOWED_LENGTH);
    }

    private String getLengthErrorMessage(String attributeName) {
        return String.format("The attribute \"%s\" must be between %s and %s", attributeName, MIN_ALLOWED_LENGTH, MAX_ALLOWED_LENGTH);
    }
}

