/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.LabelableElement;
import org.symphonyoss.symphony.messageml.elements.RegexElement;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.TextAreaNode;

public class TextArea
extends FormElement
implements RegexElement,
LabelableElement {
    public static final String MESSAGEML_TAG = "textarea";
    private static final String PLACEHOLDER_ATTR = "placeholder";
    private static final String REQUIRED_ATTR = "required";
    private static final List<String> VALID_VALUES_FOR_REQUIRED_ATTR = Arrays.asList("true", "false");
    private static final String MARKDOWN = "Text Area";

    public TextArea(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, VALID_VALUES_FOR_REQUIRED_ATTR);
        }
        this.assertAttributeNotBlank("name");
        this.assertContentModel(Collections.singleton(TextNode.class));
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "required": 
            case "placeholder": 
            case "pattern": 
            case "pattern-error-message": 
            case "label": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "id": {
                Optional<String> labelValue;
                if (this.format != FormatEnum.PRESENTATIONML) {
                    this.throwInvalidInputException(item);
                }
                if (!(labelValue = parser.getLabel(this.getStringAttribute(item))).isPresent()) break;
                this.setAttribute("label", labelValue.get());
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public Node asMarkdown() {
        return new TextAreaNode(this.getAttribute(PLACEHOLDER_ATTR), this.hasExactNumberOfChildren(1) ? this.getChild(0).asText() : null);
    }

    @Override
    public String getElementId() {
        return MESSAGEML_TAG;
    }
}

