/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Bold;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.GroupedElement;
import org.symphonyoss.symphony.messageml.elements.Italic;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.RadioNode;

public class Radio
extends GroupedElement {
    public static final String MESSAGEML_TAG = "radio";
    public static final String PRESENTATIONML_INPUT_TYPE = "radio";
    public static final String PRESENTATIONML_DIV_CLASS = "radio-group";
    private static final String NAME_ATTR = "name";
    private static final String MARKDOWN = "Radio Button";

    public Radio(Element parent, FormatEnum messageFormat) {
        super(parent, "radio", messageFormat);
    }

    @Override
    public Node asMarkdown() {
        if (this.hasExactNumberOfChildren(1)) {
            return new RadioNode(this.getChildren().get(0).asText());
        }
        return new RadioNode();
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        this.assertAttributeNotBlank(NAME_ATTR);
        if (this.getAttribute("checked") != null) {
            this.assertAttributeValue("checked", Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        if (!this.getChildren().isEmpty()) {
            this.assertContentModel(Arrays.asList(TextNode.class, Bold.class, Italic.class));
        }
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "checked": 
            case "name": 
            case "value": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    protected String getPresentationMLInputType() {
        return "radio";
    }

    @Override
    protected String getPresentationMLDivClass() {
        return PRESENTATIONML_DIV_CLASS;
    }
}

