/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.Option;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.SelectNode;

public class Select
extends FormElement {
    public static final String MESSAGEML_TAG = "select";
    private static final String REQUIRED_ATTR = "required";
    private static final String OPTION_SELECTED_ATTR = "selected";
    private static final String DATA_PLACEHOLDER_ATTR = "data-placeholder";

    public Select(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    public Node asMarkdown() {
        return new SelectNode(this.getAttribute(DATA_PLACEHOLDER_ATTR));
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        this.assertContentModel(Collections.singleton(Option.class));
        this.assertContainsChildOfType(Collections.singleton(Option.class));
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
        }
        this.assertOnlyOneOptionSelected();
        this.assertAttributeNotBlank("name");
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": {
                this.setAttribute("name", this.getStringAttribute(item));
                break;
            }
            case "required": {
                this.setAttribute(REQUIRED_ATTR, this.getStringAttribute(item));
                break;
            }
            case "data-placeholder": {
                this.setAttribute(DATA_PLACEHOLDER_ATTR, this.getStringAttribute(item));
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    private void assertOnlyOneOptionSelected() throws InvalidInputException {
        long numberOfSelectedOptions = this.getChildren().stream().map(child -> child.getAttribute(OPTION_SELECTED_ATTR)).filter(selectedAttr -> selectedAttr != null && selectedAttr.equalsIgnoreCase(Boolean.TRUE.toString())).count();
        if (numberOfSelectedOptions > 1L) {
            throw new InvalidInputException("Element \"select\" can only have one selected \"option\"");
        }
    }
}

