/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.commonmark.node.Text;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;

public class HorizontalRule
extends Element {
    public static final String MESSAGEML_TAG = "hr";
    private static final String MARKDOWN = "---";

    public HorizontalRule(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
    }

    @Override
    public String asText() {
        return "\n";
    }

    @Override
    public Node asMarkdown() {
        Paragraph node = new Paragraph();
        node.appendChild((Node)new Text(MARKDOWN));
        return node;
    }

    @Override
    public void validate() throws InvalidInputException {
        this.assertNoContent();
        this.assertNoAttributes();
    }

    @Override
    public boolean areNestedElementsAllowed() {
        return false;
    }

    public String toString() {
        return "\n";
    }
}

