/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.entityjson;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.symphonyoss.symphony.entityjson.IEntityJsonContext;
import org.symphonyoss.symphony.entityjson.IEntityJsonInstanceContext;
import org.symphonyoss.symphony.entityjson.InvalidInstanceException;
import org.symphonyoss.symphony.entityjson.StructuredObject;

public class EntityJson
implements Iterable<StructuredObject> {
    private final IEntityJsonInstanceContext context_;
    private final List<StructuredObject> children_;
    private final Map<String, StructuredObject> childMap_;

    public EntityJson(IEntityJsonInstanceContext context) throws InvalidInstanceException {
        this.context_ = context;
        ObjectNode jsonNode = this.context_.getInstanceJsonNode();
        ArrayList<StructuredObject> children = new ArrayList<StructuredObject>();
        HashMap childMap = new HashMap();
        Iterator it = jsonNode.fields();
        while (it.hasNext()) {
            ObjectNode objectInstance;
            Map.Entry entry = (Map.Entry)it.next();
            try {
                objectInstance = (ObjectNode)entry.getValue();
            }
            catch (ClassCastException e) {
                throw new InvalidInstanceException((IEntityJsonContext)context, (Throwable)e);
            }
            StructuredObject obj = new StructuredObject(this.context_, this.context_.getInstanceSource(), objectInstance);
            children.add(obj);
            childMap.put(entry.getKey(), obj);
        }
        this.children_ = Collections.unmodifiableList(children);
        this.childMap_ = Collections.unmodifiableMap(childMap);
    }

    public IEntityJsonInstanceContext getContext() {
        return this.context_;
    }

    public List<StructuredObject> getChildren() {
        return this.children_;
    }

    @Override
    public Iterator<StructuredObject> iterator() {
        return this.children_.iterator();
    }

    @Nullable
    public StructuredObject get(String name) {
        return this.childMap_.get(name);
    }

    public int size() {
        return this.children_.size();
    }

    public boolean isEmpty() {
        return this.children_.isEmpty();
    }

    public boolean contains(StructuredObject o) {
        return this.children_.contains(o);
    }

    public StructuredObject get(int index) {
        return this.children_.get(index);
    }

    public String toString() {
        return "EntityJson" + this.childMap_;
    }
}

