/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.FormElementNode;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class TextField
extends FormElement {
    public static final String MESSAGEML_TAG = "text-field";
    public static final String PRESENTATIONML_INPUT_TYPE = "text";
    private static final String MINLENGTH_ATTR = "minlength";
    private static final String MAXLENGTH_ATTR = "maxlength";
    private static final String REQUIRED_ATTR = "required";
    private static final String MASKED_ATTR = "masked";
    private static final String PLACEHOLDER_ATTR = "placeholder";
    private static final String VALUE_ATTR = "value";
    private static final String PRESENTATIONML_MASKED_ATTR = "data-masked";
    private static final Set<String> VALID_BOOLEAN_VALUES = new HashSet<String>(Arrays.asList("true", "false"));
    private static final Integer MIN_ALLOWED_LENGTH = 1;
    private static final Integer MAX_ALLOWED_LENGTH = 128;
    private static final String MARKDOWN = "Text Field";

    public TextField(Element parent, FormatEnum messageFormat) {
        super(parent, MESSAGEML_TAG, messageFormat);
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, VALID_BOOLEAN_VALUES);
        }
        if (this.getAttribute(MASKED_ATTR) != null) {
            this.assertAttributeValue(MASKED_ATTR, VALID_BOOLEAN_VALUES);
        }
        this.validateMinAndMaxLengths();
        this.assertContentModel(Collections.singleton(TextNode.class));
    }

    @Override
    public void buildAll(MessageMLParser context, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        switch (this.getFormat()) {
            case MESSAGEML: {
                super.buildAll(context, element);
                break;
            }
            case PRESENTATIONML: {
                this.buildAllFromPresentationML(element);
            }
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out) {
        out.printElement("input", this.buildTextFieldInputAttributes());
    }

    @Override
    public Node asMarkdown() {
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            return new FormElementNode(MARKDOWN, ":" + this.getAttribute(PLACEHOLDER_ATTR));
        }
        return new FormElementNode(MARKDOWN);
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": {
                this.setAttribute("name", this.getStringAttribute(item));
                break;
            }
            case "required": {
                this.setAttribute(REQUIRED_ATTR, this.getStringAttribute(item));
                break;
            }
            case "placeholder": {
                this.setAttribute(PLACEHOLDER_ATTR, this.getStringAttribute(item));
                break;
            }
            case "minlength": {
                this.setAttribute(MINLENGTH_ATTR, this.getStringAttribute(item));
                break;
            }
            case "maxlength": {
                this.setAttribute(MAXLENGTH_ATTR, this.getStringAttribute(item));
                break;
            }
            case "masked": {
                this.setAttribute(MASKED_ATTR, this.getStringAttribute(item));
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    private void buildAllFromPresentationML(org.w3c.dom.Element element) throws InvalidInputException {
        NamedNodeMap attr = element.getAttributes();
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            throw new InvalidInputException("Element \"" + this.getMessageMLTag() + "\" may not have child elements or text content");
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            this.buildAttributeFromPresentationML(attr.item(i));
        }
    }

    private void buildAttributeFromPresentationML(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": {
                this.setAttribute("name", this.getStringAttribute(item));
                break;
            }
            case "value": {
                this.addChild(new TextNode((Element)this, this.getStringAttribute(item)));
                break;
            }
            case "required": {
                this.setAttribute(REQUIRED_ATTR, this.getStringAttribute(item));
                break;
            }
            case "placeholder": {
                this.setAttribute(PLACEHOLDER_ATTR, this.getStringAttribute(item));
                break;
            }
            case "minlength": {
                this.setAttribute(MINLENGTH_ATTR, this.getStringAttribute(item));
                break;
            }
            case "maxlength": {
                this.setAttribute(MAXLENGTH_ATTR, this.getStringAttribute(item));
                break;
            }
            case "data-masked": {
                this.setAttribute(MASKED_ATTR, this.getStringAttribute(item));
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    private Map<String, String> buildTextFieldInputAttributes() {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        presentationAttrs.put("type", PRESENTATIONML_INPUT_TYPE);
        presentationAttrs.put("name", this.getAttribute("name"));
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            presentationAttrs.put(PLACEHOLDER_ATTR, this.getAttribute(PLACEHOLDER_ATTR));
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            presentationAttrs.put(REQUIRED_ATTR, this.getAttribute(REQUIRED_ATTR));
        }
        if (this.getAttribute(MASKED_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_MASKED_ATTR, this.getAttribute(MASKED_ATTR));
        }
        if (this.getAttribute(MINLENGTH_ATTR) != null) {
            presentationAttrs.put(MINLENGTH_ATTR, this.getAttribute(MINLENGTH_ATTR));
        }
        if (this.getAttribute(MAXLENGTH_ATTR) != null) {
            presentationAttrs.put(MAXLENGTH_ATTR, this.getAttribute(MAXLENGTH_ATTR));
        }
        if (this.getChildren() != null && this.getChildren().size() == 1) {
            presentationAttrs.put(VALUE_ATTR, this.getChildren().get(0).asText());
        }
        return presentationAttrs;
    }

    private void validateMinAndMaxLengths() throws InvalidInputException {
        Integer maxLength = this.getAttributeAsInteger(MAXLENGTH_ATTR);
        if (this.isLengthIsOutOfRange(maxLength)) {
            throw new InvalidInputException(this.getLengthErrorMessage(MAXLENGTH_ATTR));
        }
        Integer minLength = this.getAttributeAsInteger(MINLENGTH_ATTR);
        if (this.isLengthIsOutOfRange(minLength)) {
            throw new InvalidInputException(this.getLengthErrorMessage(MINLENGTH_ATTR));
        }
        if (minLength != null && maxLength != null && minLength > maxLength) {
            throw new InvalidInputException("The attribute \"minlength\" must be lower than the \"maxlength\" attribute");
        }
    }

    private Integer getAttributeAsInteger(String attributeName) throws InvalidInputException {
        Integer length = null;
        if (this.getAttribute(attributeName) != null) {
            try {
                length = Integer.parseInt(this.getAttribute(attributeName));
            }
            catch (NumberFormatException e) {
                throw new InvalidInputException(String.format("The attribute \"%s\" must be a valid number.", attributeName));
            }
        }
        return length;
    }

    private boolean isLengthIsOutOfRange(Integer length) {
        return length != null && (length < MIN_ALLOWED_LENGTH || length > MAX_ALLOWED_LENGTH);
    }

    private String getLengthErrorMessage(String attributeName) {
        return String.format("The attribute \"%s\" must be between %s and %s", attributeName, MIN_ALLOWED_LENGTH, MAX_ALLOWED_LENGTH);
    }
}

