/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.symphonyoss.symphony.messageml.elements.Bold;
import org.symphonyoss.symphony.messageml.elements.BulletList;
import org.symphonyoss.symphony.messageml.elements.Button;
import org.symphonyoss.symphony.messageml.elements.Card;
import org.symphonyoss.symphony.messageml.elements.CardBody;
import org.symphonyoss.symphony.messageml.elements.CardHeader;
import org.symphonyoss.symphony.messageml.elements.CashTag;
import org.symphonyoss.symphony.messageml.elements.Checkbox;
import org.symphonyoss.symphony.messageml.elements.Chime;
import org.symphonyoss.symphony.messageml.elements.Code;
import org.symphonyoss.symphony.messageml.elements.DateSelector;
import org.symphonyoss.symphony.messageml.elements.Div;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.Emoji;
import org.symphonyoss.symphony.messageml.elements.Form;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.HashTag;
import org.symphonyoss.symphony.messageml.elements.Header;
import org.symphonyoss.symphony.messageml.elements.HorizontalRule;
import org.symphonyoss.symphony.messageml.elements.Image;
import org.symphonyoss.symphony.messageml.elements.Italic;
import org.symphonyoss.symphony.messageml.elements.LineBreak;
import org.symphonyoss.symphony.messageml.elements.Link;
import org.symphonyoss.symphony.messageml.elements.ListItem;
import org.symphonyoss.symphony.messageml.elements.Mention;
import org.symphonyoss.symphony.messageml.elements.MessageML;
import org.symphonyoss.symphony.messageml.elements.Option;
import org.symphonyoss.symphony.messageml.elements.OrderedList;
import org.symphonyoss.symphony.messageml.elements.Paragraph;
import org.symphonyoss.symphony.messageml.elements.Password;
import org.symphonyoss.symphony.messageml.elements.PersonSelector;
import org.symphonyoss.symphony.messageml.elements.Preformatted;
import org.symphonyoss.symphony.messageml.elements.Radio;
import org.symphonyoss.symphony.messageml.elements.Select;
import org.symphonyoss.symphony.messageml.elements.Span;
import org.symphonyoss.symphony.messageml.elements.Table;
import org.symphonyoss.symphony.messageml.elements.TableBody;
import org.symphonyoss.symphony.messageml.elements.TableCell;
import org.symphonyoss.symphony.messageml.elements.TableFooter;
import org.symphonyoss.symphony.messageml.elements.TableHeader;
import org.symphonyoss.symphony.messageml.elements.TableHeaderCell;
import org.symphonyoss.symphony.messageml.elements.TableRow;
import org.symphonyoss.symphony.messageml.elements.TextArea;
import org.symphonyoss.symphony.messageml.elements.TextField;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.util.IDataProvider;
import org.symphonyoss.symphony.messageml.util.NoOpEntityResolver;
import org.symphonyoss.symphony.messageml.util.NullErrorHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MessageMLParser {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Configuration FREEMARKER = new Configuration(Configuration.getVersion());
    private final IDataProvider dataProvider;
    private FormatEnum messageFormat;
    private MessageML messageML;
    private ObjectNode entityJson;
    private int index;

    MessageMLParser(IDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    MessageML parse(String message, String entityJson, String version) throws InvalidInputException, ProcessingException, IOException {
        String expandedMessage;
        this.index = 0;
        if (StringUtils.isBlank((CharSequence)message)) {
            throw new InvalidInputException("Error parsing message: the message cannot be null or empty");
        }
        if (StringUtils.isNotBlank((CharSequence)entityJson)) {
            try {
                this.entityJson = (ObjectNode)MAPPER.readTree(entityJson);
            }
            catch (JsonProcessingException e) {
                throw new InvalidInputException("Error parsing EntityJSON: " + e.getMessage());
            }
        } else {
            this.entityJson = new ObjectNode(JsonNodeFactory.instance);
        }
        try {
            expandedMessage = this.expandTemplates(message, (JsonNode)this.entityJson);
        }
        catch (IOException e) {
            throw new InvalidInputException("Error parsing EntityJSON: " + e.getMessage());
        }
        catch (TemplateException e) {
            throw new InvalidInputException(String.format("Error parsing Freemarker template: invalid input at line %s, column %s", e.getLineNumber(), e.getColumnNumber()));
        }
        this.messageML = this.parseMessageML(expandedMessage, version);
        if (this.messageML != null) {
            this.entityJson = this.messageML.asEntityJson(this.entityJson);
            return this.messageML;
        }
        throw new ProcessingException("Internal error. Generated null MessageML from valid input");
    }

    ObjectNode getEntityJson() {
        return this.entityJson;
    }

    private static void validateMessageText(String messageML) throws InvalidInputException {
        if (messageML == null) {
            throw new InvalidInputException("Message input is NULL");
        }
        for (char ch : messageML.toCharArray()) {
            if (ch == '\n' || ch == '\r' || ch == '\t' || ch >= ' ') continue;
            throw new InvalidInputException("Invalid control characters in message");
        }
    }

    private static void validateEntities(org.w3c.dom.Element document, JsonNode entityJson) throws InvalidInputException, ProcessingException {
        NodeList nodes;
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        try {
            XPathExpression expr = xpath.compile("//@data-entity-id");
            nodes = (NodeList)expr.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ProcessingException("Internal error processing document tree: " + e.getMessage());
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String entityId = ((Attr)node).getValue();
            JsonNode entityNode = entityJson.findPath(entityId);
            if (entityNode.isMissingNode()) {
                throw new InvalidInputException("Error processing EntityJSON: no entity data provided for \"data-entity-id\"=\"" + entityId + "\"");
            }
            if (entityNode.isObject()) continue;
            throw new InvalidInputException("Error processing EntityJSON: the node \"" + entityId + "\" has to be an object");
        }
    }

    private void validateFormat(String tag) throws InvalidInputException {
        if (this.messageFormat == FormatEnum.PRESENTATIONML) {
            throw new InvalidInputException("Shorthand tag \"" + tag + "\" is not allowed in PresentationML");
        }
    }

    private String expandTemplates(String message, JsonNode entityJson) throws IOException, TemplateException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", MAPPER.convertValue((Object)entityJson, Map.class));
        data.put("entity", MAPPER.convertValue((Object)entityJson, Map.class));
        StringWriter sw = new StringWriter();
        Template template = new Template("messageML", message, FREEMARKER);
        template.process(data, (Writer)sw);
        return sw.toString();
    }

    private MessageML parseMessageML(String messageML, String version) throws InvalidInputException, ProcessingException {
        MessageMLParser.validateMessageText(messageML);
        org.w3c.dom.Element docElement = this.parseDocument(messageML);
        MessageMLParser.validateEntities(docElement, (JsonNode)this.entityJson);
        switch (docElement.getTagName()) {
            case "messageML": {
                this.messageFormat = FormatEnum.MESSAGEML;
                if (!StringUtils.isBlank((CharSequence)version)) break;
                version = "2.0";
                break;
            }
            case "div": {
                this.messageFormat = FormatEnum.PRESENTATIONML;
                break;
            }
            default: {
                throw new InvalidInputException("Root tag must be <messageML> or <div>");
            }
        }
        MessageML result = new MessageML(this.messageFormat, version);
        result.buildAll(this, docElement);
        result.validate();
        return result;
    }

    org.w3c.dom.Element parseDocument(String messageML) throws InvalidInputException, ProcessingException {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setXIncludeAware(false);
            dbFactory.setExpandEntityReferences(false);
            dbFactory.setIgnoringElementContentWhitespace(true);
            dbFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setErrorHandler(new NullErrorHandler());
            dBuilder.setEntityResolver(new NoOpEntityResolver());
            StringReader sr = new StringReader(messageML);
            ReaderInputStream ris = new ReaderInputStream((Reader)sr);
            Document doc = dBuilder.parse((InputStream)ris);
            doc.getDocumentElement().normalize();
            return doc.getDocumentElement();
        }
        catch (SAXException e) {
            throw new InvalidInputException("Invalid messageML: " + e.getMessage(), e);
        }
        catch (IOException | ParserConfigurationException e) {
            throw new ProcessingException("Failed to parse messageML", e);
        }
    }

    private boolean containsAttribute(String input, String attribute) {
        String[] splitInput = input.split("\\s+");
        return Arrays.asList(splitInput).contains(attribute);
    }

    private void removeAttribute(org.w3c.dom.Element element, String input, String attribute) {
        if (element.hasAttribute(input)) {
            String newAttribute = Arrays.stream(element.getAttribute(input).split("\\s+")).filter(it -> !it.equalsIgnoreCase(attribute)).collect(Collectors.joining(" "));
            if (StringUtils.isNotBlank((CharSequence)newAttribute)) {
                element.setAttribute(input, newAttribute);
            } else {
                element.removeAttribute(input);
            }
        }
    }

    public Element createElement(org.w3c.dom.Element element, Element parent) throws InvalidInputException {
        String tag = element.getNodeName();
        if (Header.isHeaderElement(tag)) {
            return new Header(parent, tag);
        }
        String elementClass = element.getAttribute("class");
        switch (tag) {
            case "chime": {
                this.validateFormat(tag);
                return new Chime(parent, FormatEnum.MESSAGEML);
            }
            case "audio": {
                return new Chime(parent, FormatEnum.PRESENTATIONML);
            }
            case "p": {
                return new Paragraph(parent);
            }
            case "br": {
                return new LineBreak(parent);
            }
            case "hr": {
                return new HorizontalRule(parent);
            }
            case "span": {
                if (this.containsAttribute(elementClass, "entity")) {
                    return this.createEntity(element, parent);
                }
                return new Span(parent);
            }
            case "div": {
                return this.createElementFromDiv(element, parent);
            }
            case "input": {
                return this.createElementFromInput(element, parent);
            }
            case "b": {
                return new Bold(parent);
            }
            case "i": {
                return new Italic(parent);
            }
            case "pre": {
                return new Preformatted(parent);
            }
            case "hash": {
                this.validateFormat(tag);
                return new HashTag(parent, ++this.index);
            }
            case "cash": {
                this.validateFormat(tag);
                return new CashTag(parent, ++this.index);
            }
            case "mention": {
                this.validateFormat(tag);
                return new Mention(parent, ++this.index, this.dataProvider);
            }
            case "a": {
                return new Link(parent, this.dataProvider);
            }
            case "img": {
                return new Image(parent);
            }
            case "ul": {
                return new BulletList(parent);
            }
            case "ol": {
                return new OrderedList(parent);
            }
            case "li": {
                return new ListItem(parent);
            }
            case "table": {
                return new Table(parent);
            }
            case "thead": {
                return new TableHeader(parent);
            }
            case "tbody": {
                return new TableBody(parent);
            }
            case "tfoot": {
                return new TableFooter(parent);
            }
            case "tr": {
                return new TableRow(parent);
            }
            case "th": {
                return new TableHeaderCell(parent);
            }
            case "td": {
                return new TableCell(parent);
            }
            case "card": {
                this.validateFormat(tag);
                return new Card(parent, FormatEnum.MESSAGEML);
            }
            case "code": {
                return new Code(parent);
            }
            case "header": {
                this.validateFormat(tag);
                return new CardHeader(parent, FormatEnum.MESSAGEML);
            }
            case "body": {
                this.validateFormat(tag);
                return new CardBody(parent, FormatEnum.MESSAGEML);
            }
            case "emoji": {
                return new Emoji(parent, ++this.index);
            }
            case "form": {
                return new Form(parent);
            }
            case "select": {
                return new Select(parent);
            }
            case "option": {
                return new Option(parent);
            }
            case "button": {
                return new Button(parent);
            }
            case "text-field": {
                return new TextField(parent);
            }
            case "checkbox": {
                return new Checkbox(parent, FormatEnum.MESSAGEML);
            }
            case "radio": {
                return new Radio(parent, FormatEnum.MESSAGEML);
            }
            case "person-selector": {
                return new PersonSelector(parent);
            }
            case "date-selector": {
                return new DateSelector(parent);
            }
            case "textarea": {
                return new TextArea(parent);
            }
            case "password": {
                return new Password(parent);
            }
        }
        throw new InvalidInputException("Invalid MessageML content at element \"" + tag + "\"");
    }

    private Element createElementFromInput(org.w3c.dom.Element element, Element parent) throws InvalidInputException {
        String elementType = element.getAttribute("type");
        if (this.containsAttribute(elementType, "text")) {
            this.removeAttribute(element, "type", "text");
            return new TextField(parent);
        }
        if (this.containsAttribute(elementType, "password")) {
            this.removeAttribute(element, "type", "password");
            return new Password(parent);
        }
        throw new InvalidInputException(String.format("The input type \"%s\" is not allowed on PresentationML", elementType));
    }

    private Element createElementFromDiv(org.w3c.dom.Element element, Element parent) throws InvalidInputException {
        String elementClass = element.getAttribute("class");
        if (this.containsAttribute(elementClass, "entity")) {
            return this.createEntity(element, parent);
        }
        if (this.containsAttribute(elementClass, "card")) {
            this.removeAttribute(element, "class", "card");
            return new Card(parent, FormatEnum.PRESENTATIONML);
        }
        if (this.containsAttribute(elementClass, "cardBody")) {
            this.removeAttribute(element, "class", "cardBody");
            return new CardBody(parent, FormatEnum.PRESENTATIONML);
        }
        if (this.containsAttribute(elementClass, "cardHeader")) {
            this.removeAttribute(element, "class", "cardHeader");
            return new CardHeader(parent, FormatEnum.PRESENTATIONML);
        }
        if (this.containsAttribute(elementClass, "person-selector")) {
            this.removeAttribute(element, "class", "person-selector");
            return new PersonSelector(parent);
        }
        if (this.containsAttribute(elementClass, "date-selector")) {
            this.removeAttribute(element, "class", "date-selector");
            return new DateSelector(parent);
        }
        if (this.containsAttribute(elementClass, "checkbox-group")) {
            this.removeAttribute(element, "class", "checkbox-group");
            return new Checkbox(parent, FormatEnum.PRESENTATIONML);
        }
        if (this.containsAttribute(elementClass, "radio-group")) {
            this.removeAttribute(element, "class", "radio-group");
            return new Radio(parent, FormatEnum.PRESENTATIONML);
        }
        return new Div(parent);
    }

    private Element createEntity(org.w3c.dom.Element element, Element parent) throws InvalidInputException {
        String entityId = element.getAttribute("data-entity-id");
        String tag = element.getNodeName();
        List entityList = this.entityJson.findValues(entityId);
        if (entityList.isEmpty()) {
            throw new InvalidInputException("The attribute \"data-entity-id\" is required");
        }
        if (entityList.size() > 1) {
            throw new InvalidInputException("Duplicate \"data-entity-id\"=\"" + entityId + "\" in entityJSON");
        }
        JsonNode entity = (JsonNode)entityList.get(0);
        JsonNode type = entity.path("type");
        JsonNode value = entity.path("id").path(0).path("value");
        if (!type.isMissingNode() && !value.isMissingNode()) {
            switch (type.textValue()) {
                case "org.symphonyoss.fin.security": {
                    return new CashTag(parent, tag, value.asText());
                }
                case "org.symphonyoss.taxonomy": {
                    return new HashTag(parent, tag, value.asText());
                }
                case "com.symphony.user.mention": {
                    return new Mention(parent, tag, (Long)value.asLong(), this.dataProvider);
                }
            }
        }
        if ("div".equals(tag)) {
            return new Div(parent);
        }
        if ("span".equals(tag)) {
            return new Span(parent);
        }
        throw new InvalidInputException("The element '" + tag + "\" cannot be an entity");
    }

    static {
        FREEMARKER.setDefaultEncoding("UTF-8");
        FREEMARKER.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        FREEMARKER.setLogTemplateExceptions(false);
        FREEMARKER.setNewBuiltinClassResolver(TemplateClassResolver.ALLOWS_NOTHING_RESOLVER);
    }
}

