/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;

public class Div
extends Element {
    public static final String MESSAGEML_TAG = "div";
    private static final String ATTR_ENTITY_ID = "data-entity-id";
    private static final String ATTR_ICON_SRC = "data-icon-src";
    private static final String ATTR_ACCENT_COLOR = "data-accent-color";

    public Div(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "data-entity-id": {
                this.setAttribute(ATTR_ENTITY_ID, this.getStringAttribute(item));
                break;
            }
            case "data-icon-src": {
                this.setAttribute(ATTR_ICON_SRC, this.getStringAttribute(item));
                break;
            }
            case "data-accent-color": {
                this.setAttribute(ATTR_ACCENT_COLOR, this.getStringAttribute(item));
                break;
            }
            default: {
                super.buildAttribute(item);
            }
        }
    }

    @Override
    public Node asMarkdown() {
        return new Paragraph();
    }

    @Override
    public ObjectNode asEntityJson(ObjectNode parent) {
        String entityId = this.getAttribute(ATTR_ENTITY_ID);
        if (entityId != null) {
            return (ObjectNode)parent.path(entityId);
        }
        return null;
    }

    @Override
    public void validate() throws InvalidInputException {
        String classAttr = this.getAttribute("class");
        if (this.getAttribute(ATTR_ENTITY_ID) != null && !"entity".equals(classAttr)) {
            throw new InvalidInputException("The attribute \"data-entity-id\" is only allowed if the element class is \"entity\".");
        }
        if ("entity".equals(classAttr) && this.getAttribute(ATTR_ENTITY_ID) == null) {
            throw new InvalidInputException("The attribute \"data-entity-id\" is required if the element class is \"entity\".");
        }
        String[] classes = classAttr != null ? classAttr.split(" ") : null;
        for (String attr : new String[]{ATTR_ICON_SRC, ATTR_ACCENT_COLOR}) {
            if (this.getAttribute(attr) == null || classes != null && classes.length != 0 && "card".equals(classes[0])) continue;
            throw new InvalidInputException("The attribute \"" + attr + "\" is only allowed if the element class is \"card\".");
        }
    }
}

