package org.symphonyoss.symphony.messageml.util;

import java.util.HashMap;
import java.util.Map;

/**
 * Class that contains HashMap which has conversion shortcode -> unicode for all supported Emojis.
 * @author cristiadu
 * @since 10/10/17
 */
public class EmojiShortcodeToUnicode {

  private static final Map<String, String> emojiShortcodeToUnicode = new HashMap<>();

  public static String getUnicode(String shortcode) {
    return emojiShortcodeToUnicode.get(shortcode);
  }

  public static Boolean hasUnicodeRepresentation(String shortcode) {
    return (emojiShortcodeToUnicode.get(shortcode) != null);
  }

  private static String emojiToUnicodeString(int... unicodes) {
    return new String(unicodes, 0, unicodes.length);
  }

  static {

    emojiShortcodeToUnicode.put("+1", emojiToUnicodeString(0x001F44D));
    emojiShortcodeToUnicode.put("-1", emojiToUnicodeString(0x001F44E));
    emojiShortcodeToUnicode.put("100", emojiToUnicodeString(0x001F4AF));
    emojiShortcodeToUnicode.put("1234", emojiToUnicodeString(0x001F522));
    emojiShortcodeToUnicode.put("8ball", emojiToUnicodeString(0x001F3B1));
    emojiShortcodeToUnicode.put("a", emojiToUnicodeString(0x001F170));
    emojiShortcodeToUnicode.put("ab", emojiToUnicodeString(0x001F18E));
    emojiShortcodeToUnicode.put("abc", emojiToUnicodeString(0x001F524));
    emojiShortcodeToUnicode.put("abcd", emojiToUnicodeString(0x001F521));
    emojiShortcodeToUnicode.put("accept", emojiToUnicodeString(0x001F251));
    emojiShortcodeToUnicode.put("aerial_tramway", emojiToUnicodeString(0x001F6A1));
    emojiShortcodeToUnicode.put("airplane", emojiToUnicodeString(0x0002708));
    emojiShortcodeToUnicode.put("alarm_clock", emojiToUnicodeString(0x00023F0));
    emojiShortcodeToUnicode.put("alien", emojiToUnicodeString(0x001F47D));
    emojiShortcodeToUnicode.put("ambulance", emojiToUnicodeString(0x001F691));
    emojiShortcodeToUnicode.put("anchor", emojiToUnicodeString(0x0002693));
    emojiShortcodeToUnicode.put("angel", emojiToUnicodeString(0x001F47C));
    emojiShortcodeToUnicode.put("anger", emojiToUnicodeString(0x001F4A2));
    emojiShortcodeToUnicode.put("angry", emojiToUnicodeString(0x001F620));
    emojiShortcodeToUnicode.put("anguished", emojiToUnicodeString(0x001F627));
    emojiShortcodeToUnicode.put("ant", emojiToUnicodeString(0x001F41C));
    emojiShortcodeToUnicode.put("apple", emojiToUnicodeString(0x001F34E));
    emojiShortcodeToUnicode.put("aquarius", emojiToUnicodeString(0x0002652));
    emojiShortcodeToUnicode.put("aries", emojiToUnicodeString(0x0002648));
    emojiShortcodeToUnicode.put("arrow_backward", emojiToUnicodeString(0x00025C0));
    emojiShortcodeToUnicode.put("arrow_double_down", emojiToUnicodeString(0x00023EC));
    emojiShortcodeToUnicode.put("arrow_double_up", emojiToUnicodeString(0x00023EB));
    emojiShortcodeToUnicode.put("arrow_down", emojiToUnicodeString(0x0002B07));
    emojiShortcodeToUnicode.put("arrow_down_small", emojiToUnicodeString(0x001F53D));
    emojiShortcodeToUnicode.put("arrow_forward", emojiToUnicodeString(0x00025B6));
    emojiShortcodeToUnicode.put("arrow_heading_down", emojiToUnicodeString(0x0002935));
    emojiShortcodeToUnicode.put("arrow_heading_up", emojiToUnicodeString(0x0002934));
    emojiShortcodeToUnicode.put("arrow_left", emojiToUnicodeString(0x0002B05));
    emojiShortcodeToUnicode.put("arrow_lower_left", emojiToUnicodeString(0x0002199));
    emojiShortcodeToUnicode.put("arrow_lower_right", emojiToUnicodeString(0x0002198));
    emojiShortcodeToUnicode.put("arrow_right", emojiToUnicodeString(0x00027A1));
    emojiShortcodeToUnicode.put("arrow_right_hook", emojiToUnicodeString(0x00021AA));
    emojiShortcodeToUnicode.put("arrow_up", emojiToUnicodeString(0x0002B06));
    emojiShortcodeToUnicode.put("arrow_up_down", emojiToUnicodeString(0x0002195));
    emojiShortcodeToUnicode.put("arrow_up_small", emojiToUnicodeString(0x001F53C));
    emojiShortcodeToUnicode.put("arrow_upper_left", emojiToUnicodeString(0x0002196));
    emojiShortcodeToUnicode.put("arrow_upper_right", emojiToUnicodeString(0x0002197));
    emojiShortcodeToUnicode.put("arrows_clockwise", emojiToUnicodeString(0x001F503));
    emojiShortcodeToUnicode.put("arrows_counterclockwise", emojiToUnicodeString(0x001F504));
    emojiShortcodeToUnicode.put("art", emojiToUnicodeString(0x001F3A8));
    emojiShortcodeToUnicode.put("articulated_lorry", emojiToUnicodeString(0x001F69B));
    emojiShortcodeToUnicode.put("astonished", emojiToUnicodeString(0x001F632));
    emojiShortcodeToUnicode.put("athletic_shoe", emojiToUnicodeString(0x001F45F));
    emojiShortcodeToUnicode.put("atm", emojiToUnicodeString(0x001F3E7));
    emojiShortcodeToUnicode.put("b", emojiToUnicodeString(0x001F171));
    emojiShortcodeToUnicode.put("baby", emojiToUnicodeString(0x001F476));
    emojiShortcodeToUnicode.put("baby_bottle", emojiToUnicodeString(0x001F37C));
    emojiShortcodeToUnicode.put("baby_chick", emojiToUnicodeString(0x001F424));
    emojiShortcodeToUnicode.put("baby_symbol", emojiToUnicodeString(0x001F6BC));
    emojiShortcodeToUnicode.put("back", emojiToUnicodeString(0x001F519));
    emojiShortcodeToUnicode.put("baggage_claim", emojiToUnicodeString(0x001F6C4));
    emojiShortcodeToUnicode.put("balloon", emojiToUnicodeString(0x001F388));
    emojiShortcodeToUnicode.put("ballot_box_with_check", emojiToUnicodeString(0x0002611));
    emojiShortcodeToUnicode.put("bamboo", emojiToUnicodeString(0x001F38D));
    emojiShortcodeToUnicode.put("banana", emojiToUnicodeString(0x001F34C));
    emojiShortcodeToUnicode.put("bangbang", emojiToUnicodeString(0x000203C));
    emojiShortcodeToUnicode.put("bank", emojiToUnicodeString(0x001F3E6));
    emojiShortcodeToUnicode.put("bar_chart", emojiToUnicodeString(0x001F4CA));
    emojiShortcodeToUnicode.put("barber", emojiToUnicodeString(0x001F488));
    emojiShortcodeToUnicode.put("baseball", emojiToUnicodeString(0x00026BE));
    emojiShortcodeToUnicode.put("basketball", emojiToUnicodeString(0x001F3C0));
    emojiShortcodeToUnicode.put("bath", emojiToUnicodeString(0x001F6C0));
    emojiShortcodeToUnicode.put("bathtub", emojiToUnicodeString(0x001F6C1));
    emojiShortcodeToUnicode.put("battery", emojiToUnicodeString(0x001F50B));
    emojiShortcodeToUnicode.put("bear", emojiToUnicodeString(0x001F43B));
    emojiShortcodeToUnicode.put("bee", emojiToUnicodeString(0x001F41D));
    emojiShortcodeToUnicode.put("beer", emojiToUnicodeString(0x001F37A));
    emojiShortcodeToUnicode.put("beers", emojiToUnicodeString(0x001F37B));
    emojiShortcodeToUnicode.put("beetle", emojiToUnicodeString(0x001F41E));
    emojiShortcodeToUnicode.put("beginner", emojiToUnicodeString(0x001F530));
    emojiShortcodeToUnicode.put("bell", emojiToUnicodeString(0x001F514));
    emojiShortcodeToUnicode.put("bento", emojiToUnicodeString(0x001F371));
    emojiShortcodeToUnicode.put("bicyclist", emojiToUnicodeString(0x001F6B4));
    emojiShortcodeToUnicode.put("bike", emojiToUnicodeString(0x001F6B2));
    emojiShortcodeToUnicode.put("bikini", emojiToUnicodeString(0x001F459));
    emojiShortcodeToUnicode.put("bird", emojiToUnicodeString(0x001F426));
    emojiShortcodeToUnicode.put("birthday", emojiToUnicodeString(0x001F382));
    emojiShortcodeToUnicode.put("black_circle", emojiToUnicodeString(0x00026AB));
    emojiShortcodeToUnicode.put("black_joker", emojiToUnicodeString(0x001F0CF));
    emojiShortcodeToUnicode.put("black_large_square", emojiToUnicodeString(0x0002B1B));
    emojiShortcodeToUnicode.put("black_medium_small_square", emojiToUnicodeString(0x00025FE));
    emojiShortcodeToUnicode.put("black_medium_square", emojiToUnicodeString(0x00025FC));
    emojiShortcodeToUnicode.put("black_nib", emojiToUnicodeString(0x0002712));
    emojiShortcodeToUnicode.put("black_small_square", emojiToUnicodeString(0x00025AA));
    emojiShortcodeToUnicode.put("black_square_button", emojiToUnicodeString(0x001F532));
    emojiShortcodeToUnicode.put("blossom", emojiToUnicodeString(0x001F33C));
    emojiShortcodeToUnicode.put("blowfish", emojiToUnicodeString(0x001F421));
    emojiShortcodeToUnicode.put("blue_book", emojiToUnicodeString(0x001F4D8));
    emojiShortcodeToUnicode.put("blue_car", emojiToUnicodeString(0x001F699));
    emojiShortcodeToUnicode.put("blue_heart", emojiToUnicodeString(0x001F499));
    emojiShortcodeToUnicode.put("blush", emojiToUnicodeString(0x001F60A));
    emojiShortcodeToUnicode.put("boar", emojiToUnicodeString(0x001F417));
    emojiShortcodeToUnicode.put("boat", emojiToUnicodeString(0x00026F5));
    emojiShortcodeToUnicode.put("bomb", emojiToUnicodeString(0x001F4A3));
    emojiShortcodeToUnicode.put("book", emojiToUnicodeString(0x001F4D6));
    emojiShortcodeToUnicode.put("bookmark", emojiToUnicodeString(0x001F516));
    emojiShortcodeToUnicode.put("bookmark_tabs", emojiToUnicodeString(0x001F4D1));
    emojiShortcodeToUnicode.put("books", emojiToUnicodeString(0x001F4DA));
    emojiShortcodeToUnicode.put("boom", emojiToUnicodeString(0x001F4A5));
    emojiShortcodeToUnicode.put("boot", emojiToUnicodeString(0x001F462));
    emojiShortcodeToUnicode.put("bouquet", emojiToUnicodeString(0x001F490));
    emojiShortcodeToUnicode.put("bow", emojiToUnicodeString(0x001F647));
    emojiShortcodeToUnicode.put("bowling", emojiToUnicodeString(0x001F3B3));
    emojiShortcodeToUnicode.put("boy", emojiToUnicodeString(0x001F466));
    emojiShortcodeToUnicode.put("bread", emojiToUnicodeString(0x001F35E));
    emojiShortcodeToUnicode.put("bride_with_veil", emojiToUnicodeString(0x001F470));
    emojiShortcodeToUnicode.put("bridge_at_night", emojiToUnicodeString(0x001F309));
    emojiShortcodeToUnicode.put("briefcase", emojiToUnicodeString(0x001F4BC));
    emojiShortcodeToUnicode.put("broken_heart", emojiToUnicodeString(0x001F494));
    emojiShortcodeToUnicode.put("bug", emojiToUnicodeString(0x001F41B));
    emojiShortcodeToUnicode.put("bulb", emojiToUnicodeString(0x001F4A1));
    emojiShortcodeToUnicode.put("bullettrain_front", emojiToUnicodeString(0x001F685));
    emojiShortcodeToUnicode.put("bullettrain_side", emojiToUnicodeString(0x001F684));
    emojiShortcodeToUnicode.put("bus", emojiToUnicodeString(0x001F68C));
    emojiShortcodeToUnicode.put("busstop", emojiToUnicodeString(0x001F68F));
    emojiShortcodeToUnicode.put("bust_in_silhouette", emojiToUnicodeString(0x001F464));
    emojiShortcodeToUnicode.put("busts_in_silhouette", emojiToUnicodeString(0x001F465));
    emojiShortcodeToUnicode.put("cactus", emojiToUnicodeString(0x001F335));
    emojiShortcodeToUnicode.put("cake", emojiToUnicodeString(0x001F370));
    emojiShortcodeToUnicode.put("calendar", emojiToUnicodeString(0x001F4C6));
    emojiShortcodeToUnicode.put("calling", emojiToUnicodeString(0x001F4F2));
    emojiShortcodeToUnicode.put("camel", emojiToUnicodeString(0x001F42B));
    emojiShortcodeToUnicode.put("camera", emojiToUnicodeString(0x001F4F7));
    emojiShortcodeToUnicode.put("cancer", emojiToUnicodeString(0x000264B));
    emojiShortcodeToUnicode.put("candy", emojiToUnicodeString(0x001F36C));
    emojiShortcodeToUnicode.put("capital_abcd", emojiToUnicodeString(0x001F520));
    emojiShortcodeToUnicode.put("capricorn", emojiToUnicodeString(0x0002651));
    emojiShortcodeToUnicode.put("car", emojiToUnicodeString(0x001F697));
    emojiShortcodeToUnicode.put("card_index", emojiToUnicodeString(0x001F4C7));
    emojiShortcodeToUnicode.put("carousel_horse", emojiToUnicodeString(0x001F3A0));
    emojiShortcodeToUnicode.put("cat", emojiToUnicodeString(0x001F431));
    emojiShortcodeToUnicode.put("cat2", emojiToUnicodeString(0x001F408));
    emojiShortcodeToUnicode.put("cd", emojiToUnicodeString(0x001F4BF));
    emojiShortcodeToUnicode.put("chart", emojiToUnicodeString(0x001F4B9));
    emojiShortcodeToUnicode.put("chart_with_downwards_trend", emojiToUnicodeString(0x001F4C9));
    emojiShortcodeToUnicode.put("chart_with_upwards_trend", emojiToUnicodeString(0x001F4C8));
    emojiShortcodeToUnicode.put("checkered_flag", emojiToUnicodeString(0x001F3C1));
    emojiShortcodeToUnicode.put("cherries", emojiToUnicodeString(0x001F352));
    emojiShortcodeToUnicode.put("cherry_blossom", emojiToUnicodeString(0x001F338));
    emojiShortcodeToUnicode.put("chestnut", emojiToUnicodeString(0x001F330));
    emojiShortcodeToUnicode.put("chicken", emojiToUnicodeString(0x001F414));
    emojiShortcodeToUnicode.put("children_crossing", emojiToUnicodeString(0x001F6B8));
    emojiShortcodeToUnicode.put("chocolate_bar", emojiToUnicodeString(0x001F36B));
    emojiShortcodeToUnicode.put("christmas_tree", emojiToUnicodeString(0x001F384));
    emojiShortcodeToUnicode.put("church", emojiToUnicodeString(0x00026EA));
    emojiShortcodeToUnicode.put("cinema", emojiToUnicodeString(0x001F3A6));
    emojiShortcodeToUnicode.put("circus_tent", emojiToUnicodeString(0x001F3AA));
    emojiShortcodeToUnicode.put("city_sunrise", emojiToUnicodeString(0x001F307));
    emojiShortcodeToUnicode.put("city_sunset", emojiToUnicodeString(0x001F306));
    emojiShortcodeToUnicode.put("cl", emojiToUnicodeString(0x001F191));
    emojiShortcodeToUnicode.put("clap", emojiToUnicodeString(0x001F44F));
    emojiShortcodeToUnicode.put("clapper", emojiToUnicodeString(0x001F3AC));
    emojiShortcodeToUnicode.put("clipboard", emojiToUnicodeString(0x001F4CB));
    emojiShortcodeToUnicode.put("clock1", emojiToUnicodeString(0x001F550));
    emojiShortcodeToUnicode.put("clock10", emojiToUnicodeString(0x001F559));
    emojiShortcodeToUnicode.put("clock1030", emojiToUnicodeString(0x001F565));
    emojiShortcodeToUnicode.put("clock11", emojiToUnicodeString(0x001F55A));
    emojiShortcodeToUnicode.put("clock1130", emojiToUnicodeString(0x001F566));
    emojiShortcodeToUnicode.put("clock12", emojiToUnicodeString(0x001F55B));
    emojiShortcodeToUnicode.put("clock1230", emojiToUnicodeString(0x001F567));
    emojiShortcodeToUnicode.put("clock130", emojiToUnicodeString(0x001F55C));
    emojiShortcodeToUnicode.put("clock2", emojiToUnicodeString(0x001F551));
    emojiShortcodeToUnicode.put("clock230", emojiToUnicodeString(0x001F55D));
    emojiShortcodeToUnicode.put("clock3", emojiToUnicodeString(0x001F552));
    emojiShortcodeToUnicode.put("clock330", emojiToUnicodeString(0x001F55E));
    emojiShortcodeToUnicode.put("clock4", emojiToUnicodeString(0x001F553));
    emojiShortcodeToUnicode.put("clock430", emojiToUnicodeString(0x001F55F));
    emojiShortcodeToUnicode.put("clock5", emojiToUnicodeString(0x001F554));
    emojiShortcodeToUnicode.put("clock530", emojiToUnicodeString(0x001F560));
    emojiShortcodeToUnicode.put("clock6", emojiToUnicodeString(0x001F555));
    emojiShortcodeToUnicode.put("clock630", emojiToUnicodeString(0x001F561));
    emojiShortcodeToUnicode.put("clock7", emojiToUnicodeString(0x001F556));
    emojiShortcodeToUnicode.put("clock730", emojiToUnicodeString(0x001F562));
    emojiShortcodeToUnicode.put("clock8", emojiToUnicodeString(0x001F557));
    emojiShortcodeToUnicode.put("clock830", emojiToUnicodeString(0x001F563));
    emojiShortcodeToUnicode.put("clock9", emojiToUnicodeString(0x001F558));
    emojiShortcodeToUnicode.put("clock930", emojiToUnicodeString(0x001F564));
    emojiShortcodeToUnicode.put("closed_book", emojiToUnicodeString(0x001F4D5));
    emojiShortcodeToUnicode.put("closed_lock_with_key", emojiToUnicodeString(0x001F510));
    emojiShortcodeToUnicode.put("closed_umbrella", emojiToUnicodeString(0x001F302));
    emojiShortcodeToUnicode.put("cloud", emojiToUnicodeString(0x0002601));
    emojiShortcodeToUnicode.put("clubs", emojiToUnicodeString(0x0002663));
    emojiShortcodeToUnicode.put("cocktail", emojiToUnicodeString(0x001F378));
    emojiShortcodeToUnicode.put("coffee", emojiToUnicodeString(0x0002615));
    emojiShortcodeToUnicode.put("cold_sweat", emojiToUnicodeString(0x001F630));
    emojiShortcodeToUnicode.put("collision", emojiToUnicodeString(0x001F4A5));
    emojiShortcodeToUnicode.put("computer", emojiToUnicodeString(0x001F4BB));
    emojiShortcodeToUnicode.put("confetti_ball", emojiToUnicodeString(0x001F38A));
    emojiShortcodeToUnicode.put("confounded", emojiToUnicodeString(0x001F616));
    emojiShortcodeToUnicode.put("confused", emojiToUnicodeString(0x001F615));
    emojiShortcodeToUnicode.put("congratulations", emojiToUnicodeString(0x0003297));
    emojiShortcodeToUnicode.put("construction", emojiToUnicodeString(0x001F6A7));
    emojiShortcodeToUnicode.put("construction_worker", emojiToUnicodeString(0x001F477));
    emojiShortcodeToUnicode.put("convenience_store", emojiToUnicodeString(0x001F3EA));
    emojiShortcodeToUnicode.put("cookie", emojiToUnicodeString(0x001F36A));
    emojiShortcodeToUnicode.put("cool", emojiToUnicodeString(0x001F192));
    emojiShortcodeToUnicode.put("cop", emojiToUnicodeString(0x001F46E));
    emojiShortcodeToUnicode.put("copyright", emojiToUnicodeString(0x00000A9));
    emojiShortcodeToUnicode.put("corn", emojiToUnicodeString(0x001F33D));
    emojiShortcodeToUnicode.put("couple", emojiToUnicodeString(0x001F46B));
    emojiShortcodeToUnicode.put("couple_with_heart", emojiToUnicodeString(0x001F491));
    emojiShortcodeToUnicode.put("couplekiss", emojiToUnicodeString(0x001F48F));
    emojiShortcodeToUnicode.put("cow", emojiToUnicodeString(0x001F42E));
    emojiShortcodeToUnicode.put("cow2", emojiToUnicodeString(0x001F404));
    emojiShortcodeToUnicode.put("credit_card", emojiToUnicodeString(0x001F4B3));
    emojiShortcodeToUnicode.put("crescent_moon", emojiToUnicodeString(0x001F319));
    emojiShortcodeToUnicode.put("crocodile", emojiToUnicodeString(0x001F40A));
    emojiShortcodeToUnicode.put("crossed_flags", emojiToUnicodeString(0x001F38C));
    emojiShortcodeToUnicode.put("crown", emojiToUnicodeString(0x001F451));
    emojiShortcodeToUnicode.put("cry", emojiToUnicodeString(0x001F622));
    emojiShortcodeToUnicode.put("crying_cat_face", emojiToUnicodeString(0x001F63F));
    emojiShortcodeToUnicode.put("crystal_ball", emojiToUnicodeString(0x001F52E));
    emojiShortcodeToUnicode.put("cupid", emojiToUnicodeString(0x001F498));
    emojiShortcodeToUnicode.put("curly_loop", emojiToUnicodeString(0x00027B0));
    emojiShortcodeToUnicode.put("currency_exchange", emojiToUnicodeString(0x001F4B1));
    emojiShortcodeToUnicode.put("curry", emojiToUnicodeString(0x001F35B));
    emojiShortcodeToUnicode.put("custard", emojiToUnicodeString(0x001F36E));
    emojiShortcodeToUnicode.put("customs", emojiToUnicodeString(0x001F6C3));
    emojiShortcodeToUnicode.put("cyclone", emojiToUnicodeString(0x001F300));
    emojiShortcodeToUnicode.put("dancer", emojiToUnicodeString(0x001F483));
    emojiShortcodeToUnicode.put("dancers", emojiToUnicodeString(0x001F46F));
    emojiShortcodeToUnicode.put("dango", emojiToUnicodeString(0x001F361));
    emojiShortcodeToUnicode.put("dart", emojiToUnicodeString(0x001F3AF));
    emojiShortcodeToUnicode.put("dash", emojiToUnicodeString(0x001F4A8));
    emojiShortcodeToUnicode.put("date", emojiToUnicodeString(0x001F4C5));
    emojiShortcodeToUnicode.put("deciduous_tree", emojiToUnicodeString(0x001F333));
    emojiShortcodeToUnicode.put("department_store", emojiToUnicodeString(0x001F3EC));
    emojiShortcodeToUnicode.put("diamond_shape_with_a_dot_inside", emojiToUnicodeString(0x001F4A0));
    emojiShortcodeToUnicode.put("diamonds", emojiToUnicodeString(0x0002666));
    emojiShortcodeToUnicode.put("disappointed", emojiToUnicodeString(0x001F61E));
    emojiShortcodeToUnicode.put("disappointed_relieved", emojiToUnicodeString(0x001F625));
    emojiShortcodeToUnicode.put("dizzy", emojiToUnicodeString(0x001F4AB));
    emojiShortcodeToUnicode.put("dizzy_face", emojiToUnicodeString(0x001F635));
    emojiShortcodeToUnicode.put("do_not_litter", emojiToUnicodeString(0x001F6AF));
    emojiShortcodeToUnicode.put("dog", emojiToUnicodeString(0x001F436));
    emojiShortcodeToUnicode.put("dog2", emojiToUnicodeString(0x001F415));
    emojiShortcodeToUnicode.put("dollar", emojiToUnicodeString(0x001F4B5));
    emojiShortcodeToUnicode.put("dolls", emojiToUnicodeString(0x001F38E));
    emojiShortcodeToUnicode.put("dolphin", emojiToUnicodeString(0x001F42C));
    emojiShortcodeToUnicode.put("door", emojiToUnicodeString(0x001F6AA));
    emojiShortcodeToUnicode.put("doughnut", emojiToUnicodeString(0x001F369));
    emojiShortcodeToUnicode.put("dragon", emojiToUnicodeString(0x001F409));
    emojiShortcodeToUnicode.put("dragon_face", emojiToUnicodeString(0x001F432));
    emojiShortcodeToUnicode.put("dress", emojiToUnicodeString(0x001F457));
    emojiShortcodeToUnicode.put("dromedary_camel", emojiToUnicodeString(0x001F42A));
    emojiShortcodeToUnicode.put("droplet", emojiToUnicodeString(0x001F4A7));
    emojiShortcodeToUnicode.put("dvd", emojiToUnicodeString(0x001F4C0));
    emojiShortcodeToUnicode.put("e-mail", emojiToUnicodeString(0x001F4E7));
    emojiShortcodeToUnicode.put("ear", emojiToUnicodeString(0x001F442));
    emojiShortcodeToUnicode.put("ear_of_rice", emojiToUnicodeString(0x001F33E));
    emojiShortcodeToUnicode.put("earth_africa", emojiToUnicodeString(0x001F30D));
    emojiShortcodeToUnicode.put("earth_americas", emojiToUnicodeString(0x001F30E));
    emojiShortcodeToUnicode.put("earth_asia", emojiToUnicodeString(0x001F30F));
    emojiShortcodeToUnicode.put("egg", emojiToUnicodeString(0x001F373));
    emojiShortcodeToUnicode.put("eggplant", emojiToUnicodeString(0x001F346));
    emojiShortcodeToUnicode.put("eight_pointed_black_star", emojiToUnicodeString(0x0002734));
    emojiShortcodeToUnicode.put("eight_spoked_asterisk", emojiToUnicodeString(0x0002733));
    emojiShortcodeToUnicode.put("electric_plug", emojiToUnicodeString(0x001F50C));
    emojiShortcodeToUnicode.put("elephant", emojiToUnicodeString(0x001F418));
    emojiShortcodeToUnicode.put("email", emojiToUnicodeString(0x0002709));
    emojiShortcodeToUnicode.put("end", emojiToUnicodeString(0x001F51A));
    emojiShortcodeToUnicode.put("envelope", emojiToUnicodeString(0x0002709));
    emojiShortcodeToUnicode.put("envelope_with_arrow", emojiToUnicodeString(0x001F4E9));
    emojiShortcodeToUnicode.put("euro", emojiToUnicodeString(0x001F4B6));
    emojiShortcodeToUnicode.put("european_castle", emojiToUnicodeString(0x001F3F0));
    emojiShortcodeToUnicode.put("european_post_office", emojiToUnicodeString(0x001F3E4));
    emojiShortcodeToUnicode.put("evergreen_tree", emojiToUnicodeString(0x001F332));
    emojiShortcodeToUnicode.put("exclamation", emojiToUnicodeString(0x0002757));
    emojiShortcodeToUnicode.put("expressionless", emojiToUnicodeString(0x001F611));
    emojiShortcodeToUnicode.put("eyeglasses", emojiToUnicodeString(0x001F453));
    emojiShortcodeToUnicode.put("eyes", emojiToUnicodeString(0x001F440));
    emojiShortcodeToUnicode.put("facepunch", emojiToUnicodeString(0x001F44A));
    emojiShortcodeToUnicode.put("factory", emojiToUnicodeString(0x001F3ED));
    emojiShortcodeToUnicode.put("fallen_leaf", emojiToUnicodeString(0x001F342));
    emojiShortcodeToUnicode.put("family", emojiToUnicodeString(0x001F46A));
    emojiShortcodeToUnicode.put("fast_forward", emojiToUnicodeString(0x00023E9));
    emojiShortcodeToUnicode.put("fax", emojiToUnicodeString(0x001F4E0));
    emojiShortcodeToUnicode.put("fearful", emojiToUnicodeString(0x001F628));
    emojiShortcodeToUnicode.put("feet", emojiToUnicodeString(0x001F43E));
    emojiShortcodeToUnicode.put("ferris_wheel", emojiToUnicodeString(0x001F3A1));
    emojiShortcodeToUnicode.put("file_folder", emojiToUnicodeString(0x001F4C1));
    emojiShortcodeToUnicode.put("fire", emojiToUnicodeString(0x001F525));
    emojiShortcodeToUnicode.put("fire_engine", emojiToUnicodeString(0x001F692));
    emojiShortcodeToUnicode.put("fireworks", emojiToUnicodeString(0x001F386));
    emojiShortcodeToUnicode.put("first_quarter_moon", emojiToUnicodeString(0x001F313));
    emojiShortcodeToUnicode.put("first_quarter_moon_with_face", emojiToUnicodeString(0x001F31B));
    emojiShortcodeToUnicode.put("fish", emojiToUnicodeString(0x001F41F));
    emojiShortcodeToUnicode.put("fish_cake", emojiToUnicodeString(0x001F365));
    emojiShortcodeToUnicode.put("fishing_pole_and_fish", emojiToUnicodeString(0x001F3A3));
    emojiShortcodeToUnicode.put("fist", emojiToUnicodeString(0x000270A));
    emojiShortcodeToUnicode.put("flags", emojiToUnicodeString(0x001F38F));
    emojiShortcodeToUnicode.put("flashlight", emojiToUnicodeString(0x001F526));
    emojiShortcodeToUnicode.put("flipper", emojiToUnicodeString(0x001F42C));
    emojiShortcodeToUnicode.put("floppy_disk", emojiToUnicodeString(0x001F4BE));
    emojiShortcodeToUnicode.put("flower_playing_cards", emojiToUnicodeString(0x001F3B4));
    emojiShortcodeToUnicode.put("flushed", emojiToUnicodeString(0x001F633));
    emojiShortcodeToUnicode.put("foggy", emojiToUnicodeString(0x001F301));
    emojiShortcodeToUnicode.put("football", emojiToUnicodeString(0x001F3C8));
    emojiShortcodeToUnicode.put("footprints", emojiToUnicodeString(0x001F463));
    emojiShortcodeToUnicode.put("fork_and_knife", emojiToUnicodeString(0x001F374));
    emojiShortcodeToUnicode.put("fountain", emojiToUnicodeString(0x00026F2));
    emojiShortcodeToUnicode.put("four_leaf_clover", emojiToUnicodeString(0x001F340));
    emojiShortcodeToUnicode.put("free", emojiToUnicodeString(0x001F193));
    emojiShortcodeToUnicode.put("fried_shrimp", emojiToUnicodeString(0x001F364));
    emojiShortcodeToUnicode.put("fries", emojiToUnicodeString(0x001F35F));
    emojiShortcodeToUnicode.put("frog", emojiToUnicodeString(0x001F438));
    emojiShortcodeToUnicode.put("frowning", emojiToUnicodeString(0x001F626));
    emojiShortcodeToUnicode.put("fuelpump", emojiToUnicodeString(0x00026FD));
    emojiShortcodeToUnicode.put("full_moon", emojiToUnicodeString(0x001F315));
    emojiShortcodeToUnicode.put("full_moon_with_face", emojiToUnicodeString(0x001F31D));
    emojiShortcodeToUnicode.put("game_die", emojiToUnicodeString(0x001F3B2));
    emojiShortcodeToUnicode.put("gem", emojiToUnicodeString(0x001F48E));
    emojiShortcodeToUnicode.put("gemini", emojiToUnicodeString(0x000264A));
    emojiShortcodeToUnicode.put("ghost", emojiToUnicodeString(0x001F47B));
    emojiShortcodeToUnicode.put("gift", emojiToUnicodeString(0x001F381));
    emojiShortcodeToUnicode.put("gift_heart", emojiToUnicodeString(0x001F49D));
    emojiShortcodeToUnicode.put("girl", emojiToUnicodeString(0x001F467));
    emojiShortcodeToUnicode.put("globe_with_meridians", emojiToUnicodeString(0x001F310));
    emojiShortcodeToUnicode.put("goat", emojiToUnicodeString(0x001F410));
    emojiShortcodeToUnicode.put("golf", emojiToUnicodeString(0x00026F3));
    emojiShortcodeToUnicode.put("grapes", emojiToUnicodeString(0x001F347));
    emojiShortcodeToUnicode.put("green_apple", emojiToUnicodeString(0x001F34F));
    emojiShortcodeToUnicode.put("green_book", emojiToUnicodeString(0x001F4D7));
    emojiShortcodeToUnicode.put("green_heart", emojiToUnicodeString(0x001F49A));
    emojiShortcodeToUnicode.put("grey_exclamation", emojiToUnicodeString(0x0002755));
    emojiShortcodeToUnicode.put("grey_question", emojiToUnicodeString(0x0002754));
    emojiShortcodeToUnicode.put("grimacing", emojiToUnicodeString(0x001F62C));
    emojiShortcodeToUnicode.put("grin", emojiToUnicodeString(0x001F601));
    emojiShortcodeToUnicode.put("grinning", emojiToUnicodeString(0x001F600));
    emojiShortcodeToUnicode.put("guardsman", emojiToUnicodeString(0x001F482));
    emojiShortcodeToUnicode.put("guitar", emojiToUnicodeString(0x001F3B8));
    emojiShortcodeToUnicode.put("gun", emojiToUnicodeString(0x001F52B));
    emojiShortcodeToUnicode.put("haircut", emojiToUnicodeString(0x001F487));
    emojiShortcodeToUnicode.put("hamburger", emojiToUnicodeString(0x001F354));
    emojiShortcodeToUnicode.put("hammer", emojiToUnicodeString(0x001F528));
    emojiShortcodeToUnicode.put("hamster", emojiToUnicodeString(0x001F439));
    emojiShortcodeToUnicode.put("hand", emojiToUnicodeString(0x000270B));
    emojiShortcodeToUnicode.put("handbag", emojiToUnicodeString(0x001F45C));
    emojiShortcodeToUnicode.put("hankey", emojiToUnicodeString(0x001F4A9));
    emojiShortcodeToUnicode.put("hatched_chick", emojiToUnicodeString(0x001F425));
    emojiShortcodeToUnicode.put("hatching_chick", emojiToUnicodeString(0x001F423));
    emojiShortcodeToUnicode.put("headphones", emojiToUnicodeString(0x001F3A7));
    emojiShortcodeToUnicode.put("hear_no_evil", emojiToUnicodeString(0x001F649));
    emojiShortcodeToUnicode.put("heart", emojiToUnicodeString(0x0002764));
    emojiShortcodeToUnicode.put("heart_decoration", emojiToUnicodeString(0x001F49F));
    emojiShortcodeToUnicode.put("heart_eyes", emojiToUnicodeString(0x001F60D));
    emojiShortcodeToUnicode.put("heart_eyes_cat", emojiToUnicodeString(0x001F63B));
    emojiShortcodeToUnicode.put("heartbeat", emojiToUnicodeString(0x001F493));
    emojiShortcodeToUnicode.put("heartpulse", emojiToUnicodeString(0x001F497));
    emojiShortcodeToUnicode.put("hearts", emojiToUnicodeString(0x0002665));
    emojiShortcodeToUnicode.put("heavy_check_mark", emojiToUnicodeString(0x0002714));
    emojiShortcodeToUnicode.put("heavy_division_sign", emojiToUnicodeString(0x0002797));
    emojiShortcodeToUnicode.put("heavy_dollar_sign", emojiToUnicodeString(0x001F4B2));
    emojiShortcodeToUnicode.put("heavy_exclamation_mark", emojiToUnicodeString(0x0002757));
    emojiShortcodeToUnicode.put("heavy_minus_sign", emojiToUnicodeString(0x0002796));
    emojiShortcodeToUnicode.put("heavy_multiplication_x", emojiToUnicodeString(0x0002716));
    emojiShortcodeToUnicode.put("heavy_plus_sign", emojiToUnicodeString(0x0002795));
    emojiShortcodeToUnicode.put("helicopter", emojiToUnicodeString(0x001F681));
    emojiShortcodeToUnicode.put("herb", emojiToUnicodeString(0x001F33F));
    emojiShortcodeToUnicode.put("hibiscus", emojiToUnicodeString(0x001F33A));
    emojiShortcodeToUnicode.put("high_brightness", emojiToUnicodeString(0x001F506));
    emojiShortcodeToUnicode.put("high_heel", emojiToUnicodeString(0x001F460));
    emojiShortcodeToUnicode.put("hocho", emojiToUnicodeString(0x001F52A));
    emojiShortcodeToUnicode.put("honey_pot", emojiToUnicodeString(0x001F36F));
    emojiShortcodeToUnicode.put("honeybee", emojiToUnicodeString(0x001F41D));
    emojiShortcodeToUnicode.put("horse", emojiToUnicodeString(0x001F434));
    emojiShortcodeToUnicode.put("horse_racing", emojiToUnicodeString(0x001F3C7));
    emojiShortcodeToUnicode.put("hospital", emojiToUnicodeString(0x001F3E5));
    emojiShortcodeToUnicode.put("hotel", emojiToUnicodeString(0x001F3E8));
    emojiShortcodeToUnicode.put("hotsprings", emojiToUnicodeString(0x0002668));
    emojiShortcodeToUnicode.put("hourglass", emojiToUnicodeString(0x000231B));
    emojiShortcodeToUnicode.put("hourglass_flowing_sand", emojiToUnicodeString(0x00023F3));
    emojiShortcodeToUnicode.put("house", emojiToUnicodeString(0x001F3E0));
    emojiShortcodeToUnicode.put("house_with_garden", emojiToUnicodeString(0x001F3E1));
    emojiShortcodeToUnicode.put("hushed", emojiToUnicodeString(0x001F62F));
    emojiShortcodeToUnicode.put("ice_cream", emojiToUnicodeString(0x001F368));
    emojiShortcodeToUnicode.put("icecream", emojiToUnicodeString(0x001F366));
    emojiShortcodeToUnicode.put("id", emojiToUnicodeString(0x001F194));
    emojiShortcodeToUnicode.put("ideograph_advantage", emojiToUnicodeString(0x001F250));
    emojiShortcodeToUnicode.put("imp", emojiToUnicodeString(0x001F47F));
    emojiShortcodeToUnicode.put("inbox_tray", emojiToUnicodeString(0x001F4E5));
    emojiShortcodeToUnicode.put("incoming_envelope", emojiToUnicodeString(0x001F4E8));
    emojiShortcodeToUnicode.put("information_desk_person", emojiToUnicodeString(0x001F481));
    emojiShortcodeToUnicode.put("information_source", emojiToUnicodeString(0x0002139));
    emojiShortcodeToUnicode.put("innocent", emojiToUnicodeString(0x001F607));
    emojiShortcodeToUnicode.put("interrobang", emojiToUnicodeString(0x0002049));
    emojiShortcodeToUnicode.put("iphone", emojiToUnicodeString(0x001F4F1));
    emojiShortcodeToUnicode.put("izakaya_lantern", emojiToUnicodeString(0x001F3EE));
    emojiShortcodeToUnicode.put("jack_o_lantern", emojiToUnicodeString(0x001F383));
    emojiShortcodeToUnicode.put("japan", emojiToUnicodeString(0x001F5FE));
    emojiShortcodeToUnicode.put("japanese_castle", emojiToUnicodeString(0x001F3EF));
    emojiShortcodeToUnicode.put("japanese_goblin", emojiToUnicodeString(0x001F47A));
    emojiShortcodeToUnicode.put("japanese_ogre", emojiToUnicodeString(0x001F479));
    emojiShortcodeToUnicode.put("jeans", emojiToUnicodeString(0x001F456));
    emojiShortcodeToUnicode.put("joy", emojiToUnicodeString(0x001F602));
    emojiShortcodeToUnicode.put("joy_cat", emojiToUnicodeString(0x001F639));
    emojiShortcodeToUnicode.put("key", emojiToUnicodeString(0x001F511));
    emojiShortcodeToUnicode.put("keycap_ten", emojiToUnicodeString(0x001F51F));
    emojiShortcodeToUnicode.put("kimono", emojiToUnicodeString(0x001F458));
    emojiShortcodeToUnicode.put("kiss", emojiToUnicodeString(0x001F48B));
    emojiShortcodeToUnicode.put("kissing", emojiToUnicodeString(0x001F617));
    emojiShortcodeToUnicode.put("kissing_cat", emojiToUnicodeString(0x001F63D));
    emojiShortcodeToUnicode.put("kissing_closed_eyes", emojiToUnicodeString(0x001F61A));
    emojiShortcodeToUnicode.put("kissing_heart", emojiToUnicodeString(0x001F618));
    emojiShortcodeToUnicode.put("kissing_smiling_eyes", emojiToUnicodeString(0x001F619));
    emojiShortcodeToUnicode.put("koala", emojiToUnicodeString(0x001F428));
    emojiShortcodeToUnicode.put("koko", emojiToUnicodeString(0x001F201));
    emojiShortcodeToUnicode.put("lantern", emojiToUnicodeString(0x001F3EE));
    emojiShortcodeToUnicode.put("large_blue_circle", emojiToUnicodeString(0x001F535));
    emojiShortcodeToUnicode.put("large_blue_diamond", emojiToUnicodeString(0x001F537));
    emojiShortcodeToUnicode.put("large_orange_diamond", emojiToUnicodeString(0x001F536));
    emojiShortcodeToUnicode.put("last_quarter_moon", emojiToUnicodeString(0x001F317));
    emojiShortcodeToUnicode.put("last_quarter_moon_with_face", emojiToUnicodeString(0x001F31C));
    emojiShortcodeToUnicode.put("laughing", emojiToUnicodeString(0x001F606));
    emojiShortcodeToUnicode.put("leaves", emojiToUnicodeString(0x001F343));
    emojiShortcodeToUnicode.put("ledger", emojiToUnicodeString(0x001F4D2));
    emojiShortcodeToUnicode.put("left_luggage", emojiToUnicodeString(0x001F6C5));
    emojiShortcodeToUnicode.put("left_right_arrow", emojiToUnicodeString(0x0002194));
    emojiShortcodeToUnicode.put("leftwards_arrow_with_hook", emojiToUnicodeString(0x00021A9));
    emojiShortcodeToUnicode.put("lemon", emojiToUnicodeString(0x001F34B));
    emojiShortcodeToUnicode.put("leo", emojiToUnicodeString(0x000264C));
    emojiShortcodeToUnicode.put("leopard", emojiToUnicodeString(0x001F406));
    emojiShortcodeToUnicode.put("libra", emojiToUnicodeString(0x000264E));
    emojiShortcodeToUnicode.put("light_rail", emojiToUnicodeString(0x001F688));
    emojiShortcodeToUnicode.put("link", emojiToUnicodeString(0x001F517));
    emojiShortcodeToUnicode.put("lips", emojiToUnicodeString(0x001F444));
    emojiShortcodeToUnicode.put("lipstick", emojiToUnicodeString(0x001F484));
    emojiShortcodeToUnicode.put("lock", emojiToUnicodeString(0x001F512));
    emojiShortcodeToUnicode.put("lock_with_ink_pen", emojiToUnicodeString(0x001F50F));
    emojiShortcodeToUnicode.put("lollipop", emojiToUnicodeString(0x001F36D));
    emojiShortcodeToUnicode.put("loop", emojiToUnicodeString(0x00027BF));
    emojiShortcodeToUnicode.put("loudspeaker", emojiToUnicodeString(0x001F4E2));
    emojiShortcodeToUnicode.put("love_hotel", emojiToUnicodeString(0x001F3E9));
    emojiShortcodeToUnicode.put("love_letter", emojiToUnicodeString(0x001F48C));
    emojiShortcodeToUnicode.put("low_brightness", emojiToUnicodeString(0x001F505));
    emojiShortcodeToUnicode.put("m", emojiToUnicodeString(0x00024C2));
    emojiShortcodeToUnicode.put("mag", emojiToUnicodeString(0x001F50D));
    emojiShortcodeToUnicode.put("mag_right", emojiToUnicodeString(0x001F50E));
    emojiShortcodeToUnicode.put("mahjong", emojiToUnicodeString(0x001F004));
    emojiShortcodeToUnicode.put("mailbox", emojiToUnicodeString(0x001F4EB));
    emojiShortcodeToUnicode.put("mailbox_closed", emojiToUnicodeString(0x001F4EA));
    emojiShortcodeToUnicode.put("mailbox_with_mail", emojiToUnicodeString(0x001F4EC));
    emojiShortcodeToUnicode.put("mailbox_with_no_mail", emojiToUnicodeString(0x001F4ED));
    emojiShortcodeToUnicode.put("man", emojiToUnicodeString(0x001F468));
    emojiShortcodeToUnicode.put("man_with_gua_pi_mao", emojiToUnicodeString(0x001F472));
    emojiShortcodeToUnicode.put("man_with_turban", emojiToUnicodeString(0x001F473));
    emojiShortcodeToUnicode.put("mans_shoe", emojiToUnicodeString(0x001F45E));
    emojiShortcodeToUnicode.put("maple_leaf", emojiToUnicodeString(0x001F341));
    emojiShortcodeToUnicode.put("mask", emojiToUnicodeString(0x001F637));
    emojiShortcodeToUnicode.put("massage", emojiToUnicodeString(0x001F486));
    emojiShortcodeToUnicode.put("meat_on_bone", emojiToUnicodeString(0x001F356));
    emojiShortcodeToUnicode.put("mega", emojiToUnicodeString(0x001F4E3));
    emojiShortcodeToUnicode.put("melon", emojiToUnicodeString(0x001F348));
    emojiShortcodeToUnicode.put("memo", emojiToUnicodeString(0x001F4DD));
    emojiShortcodeToUnicode.put("mens", emojiToUnicodeString(0x001F6B9));
    emojiShortcodeToUnicode.put("metro", emojiToUnicodeString(0x001F687));
    emojiShortcodeToUnicode.put("microphone", emojiToUnicodeString(0x001F3A4));
    emojiShortcodeToUnicode.put("microscope", emojiToUnicodeString(0x001F52C));
    emojiShortcodeToUnicode.put("milky_way", emojiToUnicodeString(0x001F30C));
    emojiShortcodeToUnicode.put("minibus", emojiToUnicodeString(0x001F690));
    emojiShortcodeToUnicode.put("minidisc", emojiToUnicodeString(0x001F4BD));
    emojiShortcodeToUnicode.put("mobile_phone_off", emojiToUnicodeString(0x001F4F4));
    emojiShortcodeToUnicode.put("money_with_wings", emojiToUnicodeString(0x001F4B8));
    emojiShortcodeToUnicode.put("moneybag", emojiToUnicodeString(0x001F4B0));
    emojiShortcodeToUnicode.put("monkey", emojiToUnicodeString(0x001F412));
    emojiShortcodeToUnicode.put("monkey_face", emojiToUnicodeString(0x001F435));
    emojiShortcodeToUnicode.put("monorail", emojiToUnicodeString(0x001F69D));
    emojiShortcodeToUnicode.put("moon", emojiToUnicodeString(0x001F314));
    emojiShortcodeToUnicode.put("mortar_board", emojiToUnicodeString(0x001F393));
    emojiShortcodeToUnicode.put("mount_fuji", emojiToUnicodeString(0x001F5FB));
    emojiShortcodeToUnicode.put("mountain_bicyclist", emojiToUnicodeString(0x001F6B5));
    emojiShortcodeToUnicode.put("mountain_cableway", emojiToUnicodeString(0x001F6A0));
    emojiShortcodeToUnicode.put("mountain_railway", emojiToUnicodeString(0x001F69E));
    emojiShortcodeToUnicode.put("mouse", emojiToUnicodeString(0x001F42D));
    emojiShortcodeToUnicode.put("mouse2", emojiToUnicodeString(0x001F401));
    emojiShortcodeToUnicode.put("movie_camera", emojiToUnicodeString(0x001F3A5));
    emojiShortcodeToUnicode.put("moyai", emojiToUnicodeString(0x001F5FF));
    emojiShortcodeToUnicode.put("muscle", emojiToUnicodeString(0x001F4AA));
    emojiShortcodeToUnicode.put("mushroom", emojiToUnicodeString(0x001F344));
    emojiShortcodeToUnicode.put("musical_keyboard", emojiToUnicodeString(0x001F3B9));
    emojiShortcodeToUnicode.put("musical_note", emojiToUnicodeString(0x001F3B5));
    emojiShortcodeToUnicode.put("musical_score", emojiToUnicodeString(0x001F3BC));
    emojiShortcodeToUnicode.put("mute", emojiToUnicodeString(0x001F507));
    emojiShortcodeToUnicode.put("nail_care", emojiToUnicodeString(0x001F485));
    emojiShortcodeToUnicode.put("name_badge", emojiToUnicodeString(0x001F4DB));
    emojiShortcodeToUnicode.put("necktie", emojiToUnicodeString(0x001F454));
    emojiShortcodeToUnicode.put("negative_squared_cross_mark", emojiToUnicodeString(0x000274E));
    emojiShortcodeToUnicode.put("neutral_face", emojiToUnicodeString(0x001F610));
    emojiShortcodeToUnicode.put("new", emojiToUnicodeString(0x001F195));
    emojiShortcodeToUnicode.put("new_moon", emojiToUnicodeString(0x001F311));
    emojiShortcodeToUnicode.put("new_moon_with_face", emojiToUnicodeString(0x001F31A));
    emojiShortcodeToUnicode.put("newspaper", emojiToUnicodeString(0x001F4F0));
    emojiShortcodeToUnicode.put("ng", emojiToUnicodeString(0x001F196));
    emojiShortcodeToUnicode.put("no_bell", emojiToUnicodeString(0x001F515));
    emojiShortcodeToUnicode.put("no_bicycles", emojiToUnicodeString(0x001F6B3));
    emojiShortcodeToUnicode.put("no_entry", emojiToUnicodeString(0x00026D4));
    emojiShortcodeToUnicode.put("no_entry_sign", emojiToUnicodeString(0x001F6AB));
    emojiShortcodeToUnicode.put("no_good", emojiToUnicodeString(0x001F645));
    emojiShortcodeToUnicode.put("no_mobile_phones", emojiToUnicodeString(0x001F4F5));
    emojiShortcodeToUnicode.put("no_mouth", emojiToUnicodeString(0x001F636));
    emojiShortcodeToUnicode.put("no_pedestrians", emojiToUnicodeString(0x001F6B7));
    emojiShortcodeToUnicode.put("no_smoking", emojiToUnicodeString(0x001F6AD));
    emojiShortcodeToUnicode.put("non-potable_water", emojiToUnicodeString(0x001F6B1));
    emojiShortcodeToUnicode.put("nose", emojiToUnicodeString(0x001F443));
    emojiShortcodeToUnicode.put("notebook", emojiToUnicodeString(0x001F4D3));
    emojiShortcodeToUnicode.put("notebook_with_decorative_cover", emojiToUnicodeString(0x001F4D4));
    emojiShortcodeToUnicode.put("notes", emojiToUnicodeString(0x001F3B6));
    emojiShortcodeToUnicode.put("nut_and_bolt", emojiToUnicodeString(0x001F529));
    emojiShortcodeToUnicode.put("o", emojiToUnicodeString(0x0002B55));
    emojiShortcodeToUnicode.put("o2", emojiToUnicodeString(0x001F17E));
    emojiShortcodeToUnicode.put("ocean", emojiToUnicodeString(0x001F30A));
    emojiShortcodeToUnicode.put("octopus", emojiToUnicodeString(0x001F419));
    emojiShortcodeToUnicode.put("oden", emojiToUnicodeString(0x001F362));
    emojiShortcodeToUnicode.put("office", emojiToUnicodeString(0x001F3E2));
    emojiShortcodeToUnicode.put("ok", emojiToUnicodeString(0x001F197));
    emojiShortcodeToUnicode.put("ok_hand", emojiToUnicodeString(0x001F44C));
    emojiShortcodeToUnicode.put("ok_woman", emojiToUnicodeString(0x001F646));
    emojiShortcodeToUnicode.put("older_man", emojiToUnicodeString(0x001F474));
    emojiShortcodeToUnicode.put("older_woman", emojiToUnicodeString(0x001F475));
    emojiShortcodeToUnicode.put("on", emojiToUnicodeString(0x001F51B));
    emojiShortcodeToUnicode.put("oncoming_automobile", emojiToUnicodeString(0x001F698));
    emojiShortcodeToUnicode.put("oncoming_bus", emojiToUnicodeString(0x001F68D));
    emojiShortcodeToUnicode.put("oncoming_police_car", emojiToUnicodeString(0x001F694));
    emojiShortcodeToUnicode.put("oncoming_taxi", emojiToUnicodeString(0x001F696));
    emojiShortcodeToUnicode.put("open_book", emojiToUnicodeString(0x001F4D6));
    emojiShortcodeToUnicode.put("open_file_folder", emojiToUnicodeString(0x001F4C2));
    emojiShortcodeToUnicode.put("open_hands", emojiToUnicodeString(0x001F450));
    emojiShortcodeToUnicode.put("open_mouth", emojiToUnicodeString(0x001F62E));
    emojiShortcodeToUnicode.put("ophiuchus", emojiToUnicodeString(0x00026CE));
    emojiShortcodeToUnicode.put("orange_book", emojiToUnicodeString(0x001F4D9));
    emojiShortcodeToUnicode.put("outbox_tray", emojiToUnicodeString(0x001F4E4));
    emojiShortcodeToUnicode.put("ox", emojiToUnicodeString(0x001F402));
    emojiShortcodeToUnicode.put("package", emojiToUnicodeString(0x001F4E6));
    emojiShortcodeToUnicode.put("page_facing_up", emojiToUnicodeString(0x001F4C4));
    emojiShortcodeToUnicode.put("page_with_curl", emojiToUnicodeString(0x001F4C3));
    emojiShortcodeToUnicode.put("pager", emojiToUnicodeString(0x001F4DF));
    emojiShortcodeToUnicode.put("palm_tree", emojiToUnicodeString(0x001F334));
    emojiShortcodeToUnicode.put("panda_face", emojiToUnicodeString(0x001F43C));
    emojiShortcodeToUnicode.put("paperclip", emojiToUnicodeString(0x001F4CE));
    emojiShortcodeToUnicode.put("parking", emojiToUnicodeString(0x001F17F));
    emojiShortcodeToUnicode.put("part_alternation_mark", emojiToUnicodeString(0x000303D));
    emojiShortcodeToUnicode.put("partly_sunny", emojiToUnicodeString(0x00026C5));
    emojiShortcodeToUnicode.put("passport_control", emojiToUnicodeString(0x001F6C2));
    emojiShortcodeToUnicode.put("paw_prints", emojiToUnicodeString(0x001F43E));
    emojiShortcodeToUnicode.put("peach", emojiToUnicodeString(0x001F351));
    emojiShortcodeToUnicode.put("pear", emojiToUnicodeString(0x001F350));
    emojiShortcodeToUnicode.put("pencil", emojiToUnicodeString(0x001F4DD));
    emojiShortcodeToUnicode.put("pencil2", emojiToUnicodeString(0x000270F));
    emojiShortcodeToUnicode.put("penguin", emojiToUnicodeString(0x001F427));
    emojiShortcodeToUnicode.put("pensive", emojiToUnicodeString(0x001F614));
    emojiShortcodeToUnicode.put("performing_arts", emojiToUnicodeString(0x001F3AD));
    emojiShortcodeToUnicode.put("persevere", emojiToUnicodeString(0x001F623));
    emojiShortcodeToUnicode.put("person_frowning", emojiToUnicodeString(0x001F64D));
    emojiShortcodeToUnicode.put("person_with_blond_hair", emojiToUnicodeString(0x001F471));
    emojiShortcodeToUnicode.put("person_with_pouting_face", emojiToUnicodeString(0x001F64E));
    emojiShortcodeToUnicode.put("phone", emojiToUnicodeString(0x000260E));
    emojiShortcodeToUnicode.put("pig", emojiToUnicodeString(0x001F437));
    emojiShortcodeToUnicode.put("pig2", emojiToUnicodeString(0x001F416));
    emojiShortcodeToUnicode.put("pig_nose", emojiToUnicodeString(0x001F43D));
    emojiShortcodeToUnicode.put("pill", emojiToUnicodeString(0x001F48A));
    emojiShortcodeToUnicode.put("pineapple", emojiToUnicodeString(0x001F34D));
    emojiShortcodeToUnicode.put("pisces", emojiToUnicodeString(0x0002653));
    emojiShortcodeToUnicode.put("pizza", emojiToUnicodeString(0x001F355));
    emojiShortcodeToUnicode.put("point_down", emojiToUnicodeString(0x001F447));
    emojiShortcodeToUnicode.put("point_left", emojiToUnicodeString(0x001F448));
    emojiShortcodeToUnicode.put("point_right", emojiToUnicodeString(0x001F449));
    emojiShortcodeToUnicode.put("point_up", emojiToUnicodeString(0x000261D));
    emojiShortcodeToUnicode.put("point_up_2", emojiToUnicodeString(0x001F446));
    emojiShortcodeToUnicode.put("police_car", emojiToUnicodeString(0x001F693));
    emojiShortcodeToUnicode.put("poodle", emojiToUnicodeString(0x001F429));
    emojiShortcodeToUnicode.put("poop", emojiToUnicodeString(0x001F4A9));
    emojiShortcodeToUnicode.put("post_office", emojiToUnicodeString(0x001F3E3));
    emojiShortcodeToUnicode.put("postal_horn", emojiToUnicodeString(0x001F4EF));
    emojiShortcodeToUnicode.put("postbox", emojiToUnicodeString(0x001F4EE));
    emojiShortcodeToUnicode.put("potable_water", emojiToUnicodeString(0x001F6B0));
    emojiShortcodeToUnicode.put("pouch", emojiToUnicodeString(0x001F45D));
    emojiShortcodeToUnicode.put("poultry_leg", emojiToUnicodeString(0x001F357));
    emojiShortcodeToUnicode.put("pound", emojiToUnicodeString(0x001F4B7));
    emojiShortcodeToUnicode.put("pouting_cat", emojiToUnicodeString(0x001F63E));
    emojiShortcodeToUnicode.put("pray", emojiToUnicodeString(0x001F64F));
    emojiShortcodeToUnicode.put("princess", emojiToUnicodeString(0x001F478));
    emojiShortcodeToUnicode.put("punch", emojiToUnicodeString(0x001F44A));
    emojiShortcodeToUnicode.put("purple_heart", emojiToUnicodeString(0x001F49C));
    emojiShortcodeToUnicode.put("purse", emojiToUnicodeString(0x001F45B));
    emojiShortcodeToUnicode.put("pushpin", emojiToUnicodeString(0x001F4CC));
    emojiShortcodeToUnicode.put("put_litter_in_its_place", emojiToUnicodeString(0x001F6AE));
    emojiShortcodeToUnicode.put("question", emojiToUnicodeString(0x0002753));
    emojiShortcodeToUnicode.put("rabbit", emojiToUnicodeString(0x001F430));
    emojiShortcodeToUnicode.put("rabbit2", emojiToUnicodeString(0x001F407));
    emojiShortcodeToUnicode.put("racehorse", emojiToUnicodeString(0x001F40E));
    emojiShortcodeToUnicode.put("radio", emojiToUnicodeString(0x001F4FB));
    emojiShortcodeToUnicode.put("radio_button", emojiToUnicodeString(0x001F518));
    emojiShortcodeToUnicode.put("rage", emojiToUnicodeString(0x001F621));
    emojiShortcodeToUnicode.put("railway_car", emojiToUnicodeString(0x001F683));
    emojiShortcodeToUnicode.put("rainbow", emojiToUnicodeString(0x001F308));
    emojiShortcodeToUnicode.put("raised_hand", emojiToUnicodeString(0x000270B));
    emojiShortcodeToUnicode.put("raised_hands", emojiToUnicodeString(0x001F64C));
    emojiShortcodeToUnicode.put("raising_hand", emojiToUnicodeString(0x001F64B));
    emojiShortcodeToUnicode.put("ram", emojiToUnicodeString(0x001F40F));
    emojiShortcodeToUnicode.put("ramen", emojiToUnicodeString(0x001F35C));
    emojiShortcodeToUnicode.put("rat", emojiToUnicodeString(0x001F400));
    emojiShortcodeToUnicode.put("recycle", emojiToUnicodeString(0x000267B));
    emojiShortcodeToUnicode.put("red_car", emojiToUnicodeString(0x001F697));
    emojiShortcodeToUnicode.put("red_circle", emojiToUnicodeString(0x001F534));
    emojiShortcodeToUnicode.put("registered", emojiToUnicodeString(0x00000AE));
    emojiShortcodeToUnicode.put("relaxed", emojiToUnicodeString(0x000263A));
    emojiShortcodeToUnicode.put("relieved", emojiToUnicodeString(0x001F60C));
    emojiShortcodeToUnicode.put("repeat", emojiToUnicodeString(0x001F501));
    emojiShortcodeToUnicode.put("repeat_one", emojiToUnicodeString(0x001F502));
    emojiShortcodeToUnicode.put("restroom", emojiToUnicodeString(0x001F6BB));
    emojiShortcodeToUnicode.put("revolving_hearts", emojiToUnicodeString(0x001F49E));
    emojiShortcodeToUnicode.put("rewind", emojiToUnicodeString(0x00023EA));
    emojiShortcodeToUnicode.put("ribbon", emojiToUnicodeString(0x001F380));
    emojiShortcodeToUnicode.put("rice", emojiToUnicodeString(0x001F35A));
    emojiShortcodeToUnicode.put("rice_ball", emojiToUnicodeString(0x001F359));
    emojiShortcodeToUnicode.put("rice_cracker", emojiToUnicodeString(0x001F358));
    emojiShortcodeToUnicode.put("rice_scene", emojiToUnicodeString(0x001F391));
    emojiShortcodeToUnicode.put("ring", emojiToUnicodeString(0x001F48D));
    emojiShortcodeToUnicode.put("rocket", emojiToUnicodeString(0x001F680));
    emojiShortcodeToUnicode.put("roller_coaster", emojiToUnicodeString(0x001F3A2));
    emojiShortcodeToUnicode.put("rooster", emojiToUnicodeString(0x001F413));
    emojiShortcodeToUnicode.put("rose", emojiToUnicodeString(0x001F339));
    emojiShortcodeToUnicode.put("rotating_light", emojiToUnicodeString(0x001F6A8));
    emojiShortcodeToUnicode.put("round_pushpin", emojiToUnicodeString(0x001F4CD));
    emojiShortcodeToUnicode.put("rowboat", emojiToUnicodeString(0x001F6A3));
    emojiShortcodeToUnicode.put("rugby_football", emojiToUnicodeString(0x001F3C9));
    emojiShortcodeToUnicode.put("runner", emojiToUnicodeString(0x001F3C3));
    emojiShortcodeToUnicode.put("running", emojiToUnicodeString(0x001F3C3));
    emojiShortcodeToUnicode.put("running_shirt_with_sash", emojiToUnicodeString(0x001F3BD));
    emojiShortcodeToUnicode.put("sa", emojiToUnicodeString(0x001F202));
    emojiShortcodeToUnicode.put("sagittarius", emojiToUnicodeString(0x0002650));
    emojiShortcodeToUnicode.put("sailboat", emojiToUnicodeString(0x00026F5));
    emojiShortcodeToUnicode.put("sake", emojiToUnicodeString(0x001F376));
    emojiShortcodeToUnicode.put("sandal", emojiToUnicodeString(0x001F461));
    emojiShortcodeToUnicode.put("santa", emojiToUnicodeString(0x001F385));
    emojiShortcodeToUnicode.put("satellite", emojiToUnicodeString(0x001F4E1));
    emojiShortcodeToUnicode.put("satisfied", emojiToUnicodeString(0x001F606));
    emojiShortcodeToUnicode.put("saxophone", emojiToUnicodeString(0x001F3B7));
    emojiShortcodeToUnicode.put("school", emojiToUnicodeString(0x001F3EB));
    emojiShortcodeToUnicode.put("school_satchel", emojiToUnicodeString(0x001F392));
    emojiShortcodeToUnicode.put("scissors", emojiToUnicodeString(0x0002702));
    emojiShortcodeToUnicode.put("scorpius", emojiToUnicodeString(0x000264F));
    emojiShortcodeToUnicode.put("scream", emojiToUnicodeString(0x001F631));
    emojiShortcodeToUnicode.put("scream_cat", emojiToUnicodeString(0x001F640));
    emojiShortcodeToUnicode.put("scroll", emojiToUnicodeString(0x001F4DC));
    emojiShortcodeToUnicode.put("seat", emojiToUnicodeString(0x001F4BA));
    emojiShortcodeToUnicode.put("secret", emojiToUnicodeString(0x0003299));
    emojiShortcodeToUnicode.put("see_no_evil", emojiToUnicodeString(0x001F648));
    emojiShortcodeToUnicode.put("seedling", emojiToUnicodeString(0x001F331));
    emojiShortcodeToUnicode.put("shaved_ice", emojiToUnicodeString(0x001F367));
    emojiShortcodeToUnicode.put("sheep", emojiToUnicodeString(0x001F411));
    emojiShortcodeToUnicode.put("shell", emojiToUnicodeString(0x001F41A));
    emojiShortcodeToUnicode.put("ship", emojiToUnicodeString(0x001F6A2));
    emojiShortcodeToUnicode.put("shirt", emojiToUnicodeString(0x001F455));
    emojiShortcodeToUnicode.put("shit", emojiToUnicodeString(0x001F4A9));
    emojiShortcodeToUnicode.put("shoe", emojiToUnicodeString(0x001F45E));
    emojiShortcodeToUnicode.put("shower", emojiToUnicodeString(0x001F6BF));
    emojiShortcodeToUnicode.put("signal_strength", emojiToUnicodeString(0x001F4F6));
    emojiShortcodeToUnicode.put("six_pointed_star", emojiToUnicodeString(0x001F52F));
    emojiShortcodeToUnicode.put("ski", emojiToUnicodeString(0x001F3BF));
    emojiShortcodeToUnicode.put("skull", emojiToUnicodeString(0x001F480));
    emojiShortcodeToUnicode.put("sleeping", emojiToUnicodeString(0x001F634));
    emojiShortcodeToUnicode.put("sleepy", emojiToUnicodeString(0x001F62A));
    emojiShortcodeToUnicode.put("slot_machine", emojiToUnicodeString(0x001F3B0));
    emojiShortcodeToUnicode.put("small_blue_diamond", emojiToUnicodeString(0x001F539));
    emojiShortcodeToUnicode.put("small_orange_diamond", emojiToUnicodeString(0x001F538));
    emojiShortcodeToUnicode.put("small_red_triangle", emojiToUnicodeString(0x001F53A));
    emojiShortcodeToUnicode.put("small_red_triangle_down", emojiToUnicodeString(0x001F53B));
    emojiShortcodeToUnicode.put("smile", emojiToUnicodeString(0x001F604));
    emojiShortcodeToUnicode.put("smile_cat", emojiToUnicodeString(0x001F638));
    emojiShortcodeToUnicode.put("smiley", emojiToUnicodeString(0x001F603));
    emojiShortcodeToUnicode.put("smiley_cat", emojiToUnicodeString(0x001F63A));
    emojiShortcodeToUnicode.put("smiling_imp", emojiToUnicodeString(0x001F608));
    emojiShortcodeToUnicode.put("smirk", emojiToUnicodeString(0x001F60F));
    emojiShortcodeToUnicode.put("smirk_cat", emojiToUnicodeString(0x001F63C));
    emojiShortcodeToUnicode.put("smoking", emojiToUnicodeString(0x001F6AC));
    emojiShortcodeToUnicode.put("snail", emojiToUnicodeString(0x001F40C));
    emojiShortcodeToUnicode.put("snake", emojiToUnicodeString(0x001F40D));
    emojiShortcodeToUnicode.put("snowboarder", emojiToUnicodeString(0x001F3C2));
    emojiShortcodeToUnicode.put("snowflake", emojiToUnicodeString(0x0002744));
    emojiShortcodeToUnicode.put("snowman", emojiToUnicodeString(0x00026C4));
    emojiShortcodeToUnicode.put("sob", emojiToUnicodeString(0x001F62D));
    emojiShortcodeToUnicode.put("soccer", emojiToUnicodeString(0x00026BD));
    emojiShortcodeToUnicode.put("soon", emojiToUnicodeString(0x001F51C));
    emojiShortcodeToUnicode.put("sos", emojiToUnicodeString(0x001F198));
    emojiShortcodeToUnicode.put("sound", emojiToUnicodeString(0x001F509));
    emojiShortcodeToUnicode.put("space_invader", emojiToUnicodeString(0x001F47E));
    emojiShortcodeToUnicode.put("spades", emojiToUnicodeString(0x0002660));
    emojiShortcodeToUnicode.put("spaghetti", emojiToUnicodeString(0x001F35D));
    emojiShortcodeToUnicode.put("sparkle", emojiToUnicodeString(0x0002747));
    emojiShortcodeToUnicode.put("sparkler", emojiToUnicodeString(0x001F387));
    emojiShortcodeToUnicode.put("sparkles", emojiToUnicodeString(0x0002728));
    emojiShortcodeToUnicode.put("sparkling_heart", emojiToUnicodeString(0x001F496));
    emojiShortcodeToUnicode.put("speak_no_evil", emojiToUnicodeString(0x001F64A));
    emojiShortcodeToUnicode.put("speaker", emojiToUnicodeString(0x001F50A));
    emojiShortcodeToUnicode.put("speech_balloon", emojiToUnicodeString(0x001F4AC));
    emojiShortcodeToUnicode.put("speedboat", emojiToUnicodeString(0x001F6A4));
    emojiShortcodeToUnicode.put("star", emojiToUnicodeString(0x0002B50));
    emojiShortcodeToUnicode.put("star2", emojiToUnicodeString(0x001F31F));
    emojiShortcodeToUnicode.put("stars", emojiToUnicodeString(0x001F303));
    emojiShortcodeToUnicode.put("station", emojiToUnicodeString(0x001F689));
    emojiShortcodeToUnicode.put("statue_of_liberty", emojiToUnicodeString(0x001F5FD));
    emojiShortcodeToUnicode.put("steam_locomotive", emojiToUnicodeString(0x001F682));
    emojiShortcodeToUnicode.put("stew", emojiToUnicodeString(0x001F372));
    emojiShortcodeToUnicode.put("straight_ruler", emojiToUnicodeString(0x001F4CF));
    emojiShortcodeToUnicode.put("strawberry", emojiToUnicodeString(0x001F353));
    emojiShortcodeToUnicode.put("stuck_out_tongue", emojiToUnicodeString(0x001F61B));
    emojiShortcodeToUnicode.put("stuck_out_tongue_closed_eyes", emojiToUnicodeString(0x001F61D));
    emojiShortcodeToUnicode.put("stuck_out_tongue_winking_eye", emojiToUnicodeString(0x001F61C));
    emojiShortcodeToUnicode.put("sun_with_face", emojiToUnicodeString(0x001F31E));
    emojiShortcodeToUnicode.put("sunflower", emojiToUnicodeString(0x001F33B));
    emojiShortcodeToUnicode.put("sunglasses", emojiToUnicodeString(0x001F60E));
    emojiShortcodeToUnicode.put("sunny", emojiToUnicodeString(0x0002600));
    emojiShortcodeToUnicode.put("sunrise", emojiToUnicodeString(0x001F305));
    emojiShortcodeToUnicode.put("sunrise_over_mountains", emojiToUnicodeString(0x001F304));
    emojiShortcodeToUnicode.put("surfer", emojiToUnicodeString(0x001F3C4));
    emojiShortcodeToUnicode.put("sushi", emojiToUnicodeString(0x001F363));
    emojiShortcodeToUnicode.put("suspension_railway", emojiToUnicodeString(0x001F69F));
    emojiShortcodeToUnicode.put("sweat", emojiToUnicodeString(0x001F613));
    emojiShortcodeToUnicode.put("sweat_drops", emojiToUnicodeString(0x001F4A6));
    emojiShortcodeToUnicode.put("sweat_smile", emojiToUnicodeString(0x001F605));
    emojiShortcodeToUnicode.put("sweet_potato", emojiToUnicodeString(0x001F360));
    emojiShortcodeToUnicode.put("swimmer", emojiToUnicodeString(0x001F3CA));
    emojiShortcodeToUnicode.put("symbols", emojiToUnicodeString(0x001F523));
    emojiShortcodeToUnicode.put("syringe", emojiToUnicodeString(0x001F489));
    emojiShortcodeToUnicode.put("tada", emojiToUnicodeString(0x001F389));
    emojiShortcodeToUnicode.put("tanabata_tree", emojiToUnicodeString(0x001F38B));
    emojiShortcodeToUnicode.put("tangerine", emojiToUnicodeString(0x001F34A));
    emojiShortcodeToUnicode.put("taurus", emojiToUnicodeString(0x0002649));
    emojiShortcodeToUnicode.put("taxi", emojiToUnicodeString(0x001F695));
    emojiShortcodeToUnicode.put("tea", emojiToUnicodeString(0x001F375));
    emojiShortcodeToUnicode.put("telephone", emojiToUnicodeString(0x000260E));
    emojiShortcodeToUnicode.put("telephone_receiver", emojiToUnicodeString(0x001F4DE));
    emojiShortcodeToUnicode.put("telescope", emojiToUnicodeString(0x001F52D));
    emojiShortcodeToUnicode.put("tennis", emojiToUnicodeString(0x001F3BE));
    emojiShortcodeToUnicode.put("tent", emojiToUnicodeString(0x00026FA));
    emojiShortcodeToUnicode.put("thought_balloon", emojiToUnicodeString(0x001F4AD));
    emojiShortcodeToUnicode.put("thumbsdown", emojiToUnicodeString(0x001F44E));
    emojiShortcodeToUnicode.put("thumbsup", emojiToUnicodeString(0x001F44D));
    emojiShortcodeToUnicode.put("ticket", emojiToUnicodeString(0x001F3AB));
    emojiShortcodeToUnicode.put("tiger", emojiToUnicodeString(0x001F42F));
    emojiShortcodeToUnicode.put("tiger2", emojiToUnicodeString(0x001F405));
    emojiShortcodeToUnicode.put("tired_face", emojiToUnicodeString(0x001F62B));
    emojiShortcodeToUnicode.put("tm", emojiToUnicodeString(0x0002122));
    emojiShortcodeToUnicode.put("toilet", emojiToUnicodeString(0x001F6BD));
    emojiShortcodeToUnicode.put("tokyo_tower", emojiToUnicodeString(0x001F5FC));
    emojiShortcodeToUnicode.put("tomato", emojiToUnicodeString(0x001F345));
    emojiShortcodeToUnicode.put("tongue", emojiToUnicodeString(0x001F445));
    emojiShortcodeToUnicode.put("top", emojiToUnicodeString(0x001F51D));
    emojiShortcodeToUnicode.put("tophat", emojiToUnicodeString(0x001F3A9));
    emojiShortcodeToUnicode.put("tractor", emojiToUnicodeString(0x001F69C));
    emojiShortcodeToUnicode.put("traffic_light", emojiToUnicodeString(0x001F6A5));
    emojiShortcodeToUnicode.put("train", emojiToUnicodeString(0x001F683));
    emojiShortcodeToUnicode.put("train2", emojiToUnicodeString(0x001F686));
    emojiShortcodeToUnicode.put("tram", emojiToUnicodeString(0x001F68A));
    emojiShortcodeToUnicode.put("triangular_flag_on_post", emojiToUnicodeString(0x001F6A9));
    emojiShortcodeToUnicode.put("triangular_ruler", emojiToUnicodeString(0x001F4D0));
    emojiShortcodeToUnicode.put("trident", emojiToUnicodeString(0x001F531));
    emojiShortcodeToUnicode.put("triumph", emojiToUnicodeString(0x001F624));
    emojiShortcodeToUnicode.put("trolleybus", emojiToUnicodeString(0x001F68E));
    emojiShortcodeToUnicode.put("trophy", emojiToUnicodeString(0x001F3C6));
    emojiShortcodeToUnicode.put("tropical_drink", emojiToUnicodeString(0x001F379));
    emojiShortcodeToUnicode.put("tropical_fish", emojiToUnicodeString(0x001F420));
    emojiShortcodeToUnicode.put("truck", emojiToUnicodeString(0x001F69A));
    emojiShortcodeToUnicode.put("trumpet", emojiToUnicodeString(0x001F3BA));
    emojiShortcodeToUnicode.put("tshirt", emojiToUnicodeString(0x001F455));
    emojiShortcodeToUnicode.put("tulip", emojiToUnicodeString(0x001F337));
    emojiShortcodeToUnicode.put("turtle", emojiToUnicodeString(0x001F422));
    emojiShortcodeToUnicode.put("tv", emojiToUnicodeString(0x001F4FA));
    emojiShortcodeToUnicode.put("twisted_rightwards_arrows", emojiToUnicodeString(0x001F500));
    emojiShortcodeToUnicode.put("two_hearts", emojiToUnicodeString(0x001F495));
    emojiShortcodeToUnicode.put("two_men_holding_hands", emojiToUnicodeString(0x001F46C));
    emojiShortcodeToUnicode.put("two_women_holding_hands", emojiToUnicodeString(0x001F46D));
    emojiShortcodeToUnicode.put("u5272", emojiToUnicodeString(0x001F239));
    emojiShortcodeToUnicode.put("u5408", emojiToUnicodeString(0x001F234));
    emojiShortcodeToUnicode.put("u55b6", emojiToUnicodeString(0x001F23A));
    emojiShortcodeToUnicode.put("u6307", emojiToUnicodeString(0x001F22F));
    emojiShortcodeToUnicode.put("u6708", emojiToUnicodeString(0x001F237));
    emojiShortcodeToUnicode.put("u6709", emojiToUnicodeString(0x001F236));
    emojiShortcodeToUnicode.put("u6e80", emojiToUnicodeString(0x001F235));
    emojiShortcodeToUnicode.put("u7121", emojiToUnicodeString(0x001F21A));
    emojiShortcodeToUnicode.put("u7533", emojiToUnicodeString(0x001F238));
    emojiShortcodeToUnicode.put("u7981", emojiToUnicodeString(0x001F232));
    emojiShortcodeToUnicode.put("u7a7a", emojiToUnicodeString(0x001F233));
    emojiShortcodeToUnicode.put("umbrella", emojiToUnicodeString(0x0002614));
    emojiShortcodeToUnicode.put("unamused", emojiToUnicodeString(0x001F612));
    emojiShortcodeToUnicode.put("underage", emojiToUnicodeString(0x001F51E));
    emojiShortcodeToUnicode.put("unlock", emojiToUnicodeString(0x001F513));
    emojiShortcodeToUnicode.put("up", emojiToUnicodeString(0x001F199));
    emojiShortcodeToUnicode.put("v", emojiToUnicodeString(0x000270C));
    emojiShortcodeToUnicode.put("vertical_traffic_light", emojiToUnicodeString(0x001F6A6));
    emojiShortcodeToUnicode.put("vhs", emojiToUnicodeString(0x001F4FC));
    emojiShortcodeToUnicode.put("vibration_mode", emojiToUnicodeString(0x001F4F3));
    emojiShortcodeToUnicode.put("video_camera", emojiToUnicodeString(0x001F4F9));
    emojiShortcodeToUnicode.put("video_game", emojiToUnicodeString(0x001F3AE));
    emojiShortcodeToUnicode.put("violin", emojiToUnicodeString(0x001F3BB));
    emojiShortcodeToUnicode.put("virgo", emojiToUnicodeString(0x000264D));
    emojiShortcodeToUnicode.put("volcano", emojiToUnicodeString(0x001F30B));
    emojiShortcodeToUnicode.put("vs", emojiToUnicodeString(0x001F19A));
    emojiShortcodeToUnicode.put("walking", emojiToUnicodeString(0x001F6B6));
    emojiShortcodeToUnicode.put("waning_crescent_moon", emojiToUnicodeString(0x001F318));
    emojiShortcodeToUnicode.put("waning_gibbous_moon", emojiToUnicodeString(0x001F316));
    emojiShortcodeToUnicode.put("warning", emojiToUnicodeString(0x00026A0));
    emojiShortcodeToUnicode.put("watch", emojiToUnicodeString(0x000231A));
    emojiShortcodeToUnicode.put("water_buffalo", emojiToUnicodeString(0x001F403));
    emojiShortcodeToUnicode.put("watermelon", emojiToUnicodeString(0x001F349));
    emojiShortcodeToUnicode.put("wave", emojiToUnicodeString(0x001F44B));
    emojiShortcodeToUnicode.put("wavy_dash", emojiToUnicodeString(0x0003030));
    emojiShortcodeToUnicode.put("waxing_crescent_moon", emojiToUnicodeString(0x001F312));
    emojiShortcodeToUnicode.put("waxing_gibbous_moon", emojiToUnicodeString(0x001F314));
    emojiShortcodeToUnicode.put("wc", emojiToUnicodeString(0x001F6BE));
    emojiShortcodeToUnicode.put("weary", emojiToUnicodeString(0x001F629));
    emojiShortcodeToUnicode.put("wedding", emojiToUnicodeString(0x001F492));
    emojiShortcodeToUnicode.put("whale", emojiToUnicodeString(0x001F433));
    emojiShortcodeToUnicode.put("whale2", emojiToUnicodeString(0x001F40B));
    emojiShortcodeToUnicode.put("wheelchair", emojiToUnicodeString(0x000267F));
    emojiShortcodeToUnicode.put("white_check_mark", emojiToUnicodeString(0x0002705));
    emojiShortcodeToUnicode.put("white_circle", emojiToUnicodeString(0x00026AA));
    emojiShortcodeToUnicode.put("white_flower", emojiToUnicodeString(0x001F4AE));
    emojiShortcodeToUnicode.put("white_large_square", emojiToUnicodeString(0x0002B1C));
    emojiShortcodeToUnicode.put("white_medium_small_square", emojiToUnicodeString(0x00025FD));
    emojiShortcodeToUnicode.put("white_medium_square", emojiToUnicodeString(0x00025FB));
    emojiShortcodeToUnicode.put("white_small_square", emojiToUnicodeString(0x00025AB));
    emojiShortcodeToUnicode.put("white_square_button", emojiToUnicodeString(0x001F533));
    emojiShortcodeToUnicode.put("wind_chime", emojiToUnicodeString(0x001F390));
    emojiShortcodeToUnicode.put("wine_glass", emojiToUnicodeString(0x001F377));
    emojiShortcodeToUnicode.put("wink", emojiToUnicodeString(0x001F609));
    emojiShortcodeToUnicode.put("wolf", emojiToUnicodeString(0x001F43A));
    emojiShortcodeToUnicode.put("woman", emojiToUnicodeString(0x001F469));
    emojiShortcodeToUnicode.put("womans_clothes", emojiToUnicodeString(0x001F45A));
    emojiShortcodeToUnicode.put("womans_hat", emojiToUnicodeString(0x001F452));
    emojiShortcodeToUnicode.put("womens", emojiToUnicodeString(0x001F6BA));
    emojiShortcodeToUnicode.put("worried", emojiToUnicodeString(0x001F61F));
    emojiShortcodeToUnicode.put("wrench", emojiToUnicodeString(0x001F527));
    emojiShortcodeToUnicode.put("x", emojiToUnicodeString(0x000274C));
    emojiShortcodeToUnicode.put("yellow_heart", emojiToUnicodeString(0x001F49B));
    emojiShortcodeToUnicode.put("yen", emojiToUnicodeString(0x001F4B4));
    emojiShortcodeToUnicode.put("yum", emojiToUnicodeString(0x001F60B));
    emojiShortcodeToUnicode.put("zap", emojiToUnicodeString(0x00026A1));
    emojiShortcodeToUnicode.put("zzz", emojiToUnicodeString(0x001F4A4));
    emojiShortcodeToUnicode.put("angel_tone1", emojiToUnicodeString(0x001f47c, 0x001f3fb));
    emojiShortcodeToUnicode.put("angel_tone2", emojiToUnicodeString(0x001f47c, 0x001f3fc));
    emojiShortcodeToUnicode.put("angel_tone3", emojiToUnicodeString(0x001f47c, 0x001f3fd));
    emojiShortcodeToUnicode.put("angel_tone4", emojiToUnicodeString(0x001f47c, 0x001f3fe));
    emojiShortcodeToUnicode.put("angel_tone5", emojiToUnicodeString(0x001f47c, 0x001f3ff));
    emojiShortcodeToUnicode.put("asterisk", emojiToUnicodeString(0x00002a, 0x0020e3));
    emojiShortcodeToUnicode.put("baby_tone1", emojiToUnicodeString(0x001f476, 0x001f3fb));
    emojiShortcodeToUnicode.put("baby_tone2", emojiToUnicodeString(0x001f476, 0x001f3fc));
    emojiShortcodeToUnicode.put("baby_tone3", emojiToUnicodeString(0x001f476, 0x001f3fd));
    emojiShortcodeToUnicode.put("baby_tone4", emojiToUnicodeString(0x001f476, 0x001f3fe));
    emojiShortcodeToUnicode.put("baby_tone5", emojiToUnicodeString(0x001f476, 0x001f3ff));
    emojiShortcodeToUnicode.put("basketball_player_tone1", emojiToUnicodeString(0x0026f9, 0x001f3fb));
    emojiShortcodeToUnicode.put("basketball_player_tone2", emojiToUnicodeString(0x0026f9, 0x001f3fc));
    emojiShortcodeToUnicode.put("basketball_player_tone3", emojiToUnicodeString(0x0026f9, 0x001f3fd));
    emojiShortcodeToUnicode.put("basketball_player_tone4", emojiToUnicodeString(0x0026f9, 0x001f3fe));
    emojiShortcodeToUnicode.put("basketball_player_tone5", emojiToUnicodeString(0x0026f9, 0x001f3ff));
    emojiShortcodeToUnicode.put("bath_tone1", emojiToUnicodeString(0x001f6c0, 0x001f3fb));
    emojiShortcodeToUnicode.put("bath_tone2", emojiToUnicodeString(0x001f6c0, 0x001f3fc));
    emojiShortcodeToUnicode.put("bath_tone3", emojiToUnicodeString(0x001f6c0, 0x001f3fd));
    emojiShortcodeToUnicode.put("bath_tone4", emojiToUnicodeString(0x001f6c0, 0x001f3fe));
    emojiShortcodeToUnicode.put("bath_tone5", emojiToUnicodeString(0x001f6c0, 0x001f3ff));
    emojiShortcodeToUnicode.put("bicyclist_tone1", emojiToUnicodeString(0x001f6b4, 0x001f3fb));
    emojiShortcodeToUnicode.put("bicyclist_tone2", emojiToUnicodeString(0x001f6b4, 0x001f3fc));
    emojiShortcodeToUnicode.put("bicyclist_tone3", emojiToUnicodeString(0x001f6b4, 0x001f3fd));
    emojiShortcodeToUnicode.put("bicyclist_tone4", emojiToUnicodeString(0x001f6b4, 0x001f3fe));
    emojiShortcodeToUnicode.put("bicyclist_tone5", emojiToUnicodeString(0x001f6b4, 0x001f3ff));
    emojiShortcodeToUnicode.put("bow_tone1", emojiToUnicodeString(0x001f647, 0x001f3fb));
    emojiShortcodeToUnicode.put("bow_tone2", emojiToUnicodeString(0x001f647, 0x001f3fc));
    emojiShortcodeToUnicode.put("bow_tone3", emojiToUnicodeString(0x001f647, 0x001f3fd));
    emojiShortcodeToUnicode.put("bow_tone4", emojiToUnicodeString(0x001f647, 0x001f3fe));
    emojiShortcodeToUnicode.put("bow_tone5", emojiToUnicodeString(0x001f647, 0x001f3ff));
    emojiShortcodeToUnicode.put("boy_tone1", emojiToUnicodeString(0x001f466, 0x001f3fb));
    emojiShortcodeToUnicode.put("boy_tone2", emojiToUnicodeString(0x001f466, 0x001f3fc));
    emojiShortcodeToUnicode.put("boy_tone3", emojiToUnicodeString(0x001f466, 0x001f3fd));
    emojiShortcodeToUnicode.put("boy_tone4", emojiToUnicodeString(0x001f466, 0x001f3fe));
    emojiShortcodeToUnicode.put("boy_tone5", emojiToUnicodeString(0x001f466, 0x001f3ff));
    emojiShortcodeToUnicode.put("bride_with_veil_tone1", emojiToUnicodeString(0x001f470, 0x001f3fb));
    emojiShortcodeToUnicode.put("bride_with_veil_tone2", emojiToUnicodeString(0x001f470, 0x001f3fc));
    emojiShortcodeToUnicode.put("bride_with_veil_tone3", emojiToUnicodeString(0x001f470, 0x001f3fd));
    emojiShortcodeToUnicode.put("bride_with_veil_tone4", emojiToUnicodeString(0x001f470, 0x001f3fe));
    emojiShortcodeToUnicode.put("bride_with_veil_tone5", emojiToUnicodeString(0x001f470, 0x001f3ff));
    emojiShortcodeToUnicode.put("call_me_tone1", emojiToUnicodeString(0x001f919, 0x001f3fb));
    emojiShortcodeToUnicode.put("call_me_tone2", emojiToUnicodeString(0x001f919, 0x001f3fc));
    emojiShortcodeToUnicode.put("call_me_tone3", emojiToUnicodeString(0x001f919, 0x001f3fd));
    emojiShortcodeToUnicode.put("call_me_tone4", emojiToUnicodeString(0x001f919, 0x001f3fe));
    emojiShortcodeToUnicode.put("call_me_tone5", emojiToUnicodeString(0x001f919, 0x001f3ff));
    emojiShortcodeToUnicode.put("cartwheel_tone1", emojiToUnicodeString(0x001f938, 0x001f3fb));
    emojiShortcodeToUnicode.put("cartwheel_tone2", emojiToUnicodeString(0x001f938, 0x001f3fc));
    emojiShortcodeToUnicode.put("cartwheel_tone3", emojiToUnicodeString(0x001f938, 0x001f3fd));
    emojiShortcodeToUnicode.put("cartwheel_tone4", emojiToUnicodeString(0x001f938, 0x001f3fe));
    emojiShortcodeToUnicode.put("cartwheel_tone5", emojiToUnicodeString(0x001f938, 0x001f3ff));
    emojiShortcodeToUnicode.put("clap_tone1", emojiToUnicodeString(0x001f44f, 0x001f3fb));
    emojiShortcodeToUnicode.put("clap_tone2", emojiToUnicodeString(0x001f44f, 0x001f3fc));
    emojiShortcodeToUnicode.put("clap_tone3", emojiToUnicodeString(0x001f44f, 0x001f3fd));
    emojiShortcodeToUnicode.put("clap_tone4", emojiToUnicodeString(0x001f44f, 0x001f3fe));
    emojiShortcodeToUnicode.put("clap_tone5", emojiToUnicodeString(0x001f44f, 0x001f3ff));
    emojiShortcodeToUnicode.put("cn", emojiToUnicodeString(0x001f1e8, 0x001f1f3));
    emojiShortcodeToUnicode.put("construction_worker_tone1", emojiToUnicodeString(0x001f477, 0x001f3fb));
    emojiShortcodeToUnicode.put("construction_worker_tone2", emojiToUnicodeString(0x001f477, 0x001f3fc));
    emojiShortcodeToUnicode.put("construction_worker_tone3", emojiToUnicodeString(0x001f477, 0x001f3fd));
    emojiShortcodeToUnicode.put("construction_worker_tone4", emojiToUnicodeString(0x001f477, 0x001f3fe));
    emojiShortcodeToUnicode.put("construction_worker_tone5", emojiToUnicodeString(0x001f477, 0x001f3ff));
    emojiShortcodeToUnicode.put("cop_tone1", emojiToUnicodeString(0x001f46e, 0x001f3fb));
    emojiShortcodeToUnicode.put("cop_tone2", emojiToUnicodeString(0x001f46e, 0x001f3fc));
    emojiShortcodeToUnicode.put("cop_tone3", emojiToUnicodeString(0x001f46e, 0x001f3fd));
    emojiShortcodeToUnicode.put("cop_tone4", emojiToUnicodeString(0x001f46e, 0x001f3fe));
    emojiShortcodeToUnicode.put("cop_tone5", emojiToUnicodeString(0x001f46e, 0x001f3ff));
    emojiShortcodeToUnicode.put("couple_mm", emojiToUnicodeString(0x001f468, 0x002764, 0x001f468));
    emojiShortcodeToUnicode.put("couple_ww", emojiToUnicodeString(0x001f469, 0x002764, 0x001f469));
    emojiShortcodeToUnicode.put("dancer_tone1", emojiToUnicodeString(0x001f483, 0x001f3fb));
    emojiShortcodeToUnicode.put("dancer_tone2", emojiToUnicodeString(0x001f483, 0x001f3fc));
    emojiShortcodeToUnicode.put("dancer_tone3", emojiToUnicodeString(0x001f483, 0x001f3fd));
    emojiShortcodeToUnicode.put("dancer_tone4", emojiToUnicodeString(0x001f483, 0x001f3fe));
    emojiShortcodeToUnicode.put("dancer_tone5", emojiToUnicodeString(0x001f483, 0x001f3ff));
    emojiShortcodeToUnicode.put("de", emojiToUnicodeString(0x001f1e9, 0x001f1ea));
    emojiShortcodeToUnicode.put("e,0x00mail", emojiToUnicodeString(0x001f4e7));
    emojiShortcodeToUnicode.put("ear_tone1", emojiToUnicodeString(0x001f442, 0x001f3fb));
    emojiShortcodeToUnicode.put("ear_tone2", emojiToUnicodeString(0x001f442, 0x001f3fc));
    emojiShortcodeToUnicode.put("ear_tone3", emojiToUnicodeString(0x001f442, 0x001f3fd));
    emojiShortcodeToUnicode.put("ear_tone4", emojiToUnicodeString(0x001f442, 0x001f3fe));
    emojiShortcodeToUnicode.put("ear_tone5", emojiToUnicodeString(0x001f442, 0x001f3ff));
    emojiShortcodeToUnicode.put("eight", emojiToUnicodeString(0x000038, 0x0020e3));
    emojiShortcodeToUnicode.put("es", emojiToUnicodeString(0x001f1ea, 0x001f1f8));
    emojiShortcodeToUnicode.put("eye_in_speech_bubble", emojiToUnicodeString(0x001f441, 0x001f5e8));
    emojiShortcodeToUnicode.put("face_palm_tone1", emojiToUnicodeString(0x001f926, 0x001f3fb));
    emojiShortcodeToUnicode.put("face_palm_tone2", emojiToUnicodeString(0x001f926, 0x001f3fc));
    emojiShortcodeToUnicode.put("face_palm_tone3", emojiToUnicodeString(0x001f926, 0x001f3fd));
    emojiShortcodeToUnicode.put("face_palm_tone4", emojiToUnicodeString(0x001f926, 0x001f3fe));
    emojiShortcodeToUnicode.put("face_palm_tone5", emojiToUnicodeString(0x001f926, 0x001f3ff));
    emojiShortcodeToUnicode.put("family_mmb", emojiToUnicodeString(0x001f468, 0x001f468, 0x001f466));
    emojiShortcodeToUnicode.put("family_mmbb", emojiToUnicodeString(0x001f468, 0x001f468, 0x001f466, 0x001f466));
    emojiShortcodeToUnicode.put("family_mmg", emojiToUnicodeString(0x001f468, 0x001f468, 0x001f467));
    emojiShortcodeToUnicode.put("family_mmgb", emojiToUnicodeString(0x001f468, 0x001f468, 0x001f467, 0x001f466));
    emojiShortcodeToUnicode.put("family_mmgg", emojiToUnicodeString(0x001f468, 0x001f468, 0x001f467, 0x001f467));
    emojiShortcodeToUnicode.put("family_mwbb", emojiToUnicodeString(0x001f468, 0x001f469, 0x001f466, 0x001f466));
    emojiShortcodeToUnicode.put("family_mwg", emojiToUnicodeString(0x001f468, 0x001f469, 0x001f467));
    emojiShortcodeToUnicode.put("family_mwgb", emojiToUnicodeString(0x001f468, 0x001f469, 0x001f467, 0x001f466));
    emojiShortcodeToUnicode.put("family_mwgg", emojiToUnicodeString(0x001f468, 0x001f469, 0x001f467, 0x001f467));
    emojiShortcodeToUnicode.put("family_wwb", emojiToUnicodeString(0x001f469, 0x001f469, 0x001f466));
    emojiShortcodeToUnicode.put("family_wwbb", emojiToUnicodeString(0x001f469, 0x001f469, 0x001f466, 0x001f466));
    emojiShortcodeToUnicode.put("family_wwg", emojiToUnicodeString(0x001f469, 0x001f469, 0x001f467));
    emojiShortcodeToUnicode.put("family_wwgb", emojiToUnicodeString(0x001f469, 0x001f469, 0x001f467, 0x001f466));
    emojiShortcodeToUnicode.put("family_wwgg", emojiToUnicodeString(0x001f469, 0x001f469, 0x001f467, 0x001f467));
    emojiShortcodeToUnicode.put("fingers_crossed_tone1", emojiToUnicodeString(0x001f91e, 0x001f3fb));
    emojiShortcodeToUnicode.put("fingers_crossed_tone2", emojiToUnicodeString(0x001f91e, 0x001f3fc));
    emojiShortcodeToUnicode.put("fingers_crossed_tone3", emojiToUnicodeString(0x001f91e, 0x001f3fd));
    emojiShortcodeToUnicode.put("fingers_crossed_tone4", emojiToUnicodeString(0x001f91e, 0x001f3fe));
    emojiShortcodeToUnicode.put("fingers_crossed_tone5", emojiToUnicodeString(0x001f91e, 0x001f3ff));
    emojiShortcodeToUnicode.put("fist_tone1", emojiToUnicodeString(0x00270a, 0x001f3fb));
    emojiShortcodeToUnicode.put("fist_tone2", emojiToUnicodeString(0x00270a, 0x001f3fc));
    emojiShortcodeToUnicode.put("fist_tone3", emojiToUnicodeString(0x00270a, 0x001f3fd));
    emojiShortcodeToUnicode.put("fist_tone4", emojiToUnicodeString(0x00270a, 0x001f3fe));
    emojiShortcodeToUnicode.put("fist_tone5", emojiToUnicodeString(0x00270a, 0x001f3ff));
    emojiShortcodeToUnicode.put("five", emojiToUnicodeString(0x000035, 0x0020e3));
    emojiShortcodeToUnicode.put("flag_ac", emojiToUnicodeString(0x001f1e6, 0x001f1e8));
    emojiShortcodeToUnicode.put("flag_ad", emojiToUnicodeString(0x001f1e6, 0x001f1e9));
    emojiShortcodeToUnicode.put("flag_ae", emojiToUnicodeString(0x001f1e6, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_af", emojiToUnicodeString(0x001f1e6, 0x001f1eb));
    emojiShortcodeToUnicode.put("flag_ag", emojiToUnicodeString(0x001f1e6, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_ai", emojiToUnicodeString(0x001f1e6, 0x001f1ee));
    emojiShortcodeToUnicode.put("flag_al", emojiToUnicodeString(0x001f1e6, 0x001f1f1));
    emojiShortcodeToUnicode.put("flag_am", emojiToUnicodeString(0x001f1e6, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_ao", emojiToUnicodeString(0x001f1e6, 0x001f1f4));
    emojiShortcodeToUnicode.put("flag_aq", emojiToUnicodeString(0x001f1e6, 0x001f1f6));
    emojiShortcodeToUnicode.put("flag_ar", emojiToUnicodeString(0x001f1e6, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_as", emojiToUnicodeString(0x001f1e6, 0x001f1f8));
    emojiShortcodeToUnicode.put("flag_at", emojiToUnicodeString(0x001f1e6, 0x001f1f9));
    emojiShortcodeToUnicode.put("flag_au", emojiToUnicodeString(0x001f1e6, 0x001f1fa));
    emojiShortcodeToUnicode.put("flag_aw", emojiToUnicodeString(0x001f1e6, 0x001f1fc));
    emojiShortcodeToUnicode.put("flag_ax", emojiToUnicodeString(0x001f1e6, 0x001f1fd));
    emojiShortcodeToUnicode.put("flag_az", emojiToUnicodeString(0x001f1e6, 0x001f1ff));
    emojiShortcodeToUnicode.put("flag_ba", emojiToUnicodeString(0x001f1e7, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_bb", emojiToUnicodeString(0x001f1e7, 0x001f1e7));
    emojiShortcodeToUnicode.put("flag_bd", emojiToUnicodeString(0x001f1e7, 0x001f1e9));
    emojiShortcodeToUnicode.put("flag_be", emojiToUnicodeString(0x001f1e7, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_bf", emojiToUnicodeString(0x001f1e7, 0x001f1eb));
    emojiShortcodeToUnicode.put("flag_bg", emojiToUnicodeString(0x001f1e7, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_bh", emojiToUnicodeString(0x001f1e7, 0x001f1ed));
    emojiShortcodeToUnicode.put("flag_bi", emojiToUnicodeString(0x001f1e7, 0x001f1ee));
    emojiShortcodeToUnicode.put("flag_bj", emojiToUnicodeString(0x001f1e7, 0x001f1ef));
    emojiShortcodeToUnicode.put("flag_bl", emojiToUnicodeString(0x001f1e7, 0x001f1f1));
    emojiShortcodeToUnicode.put("flag_bm", emojiToUnicodeString(0x001f1e7, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_bn", emojiToUnicodeString(0x001f1e7, 0x001f1f3));
    emojiShortcodeToUnicode.put("flag_bo", emojiToUnicodeString(0x001f1e7, 0x001f1f4));
    emojiShortcodeToUnicode.put("flag_bq", emojiToUnicodeString(0x001f1e7, 0x001f1f6));
    emojiShortcodeToUnicode.put("flag_br", emojiToUnicodeString(0x001f1e7, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_bs", emojiToUnicodeString(0x001f1e7, 0x001f1f8));
    emojiShortcodeToUnicode.put("flag_bt", emojiToUnicodeString(0x001f1e7, 0x001f1f9));
    emojiShortcodeToUnicode.put("flag_bv", emojiToUnicodeString(0x001f1e7, 0x001f1fb));
    emojiShortcodeToUnicode.put("flag_bw", emojiToUnicodeString(0x001f1e7, 0x001f1fc));
    emojiShortcodeToUnicode.put("flag_by", emojiToUnicodeString(0x001f1e7, 0x001f1fe));
    emojiShortcodeToUnicode.put("flag_bz", emojiToUnicodeString(0x001f1e7, 0x001f1ff));
    emojiShortcodeToUnicode.put("flag_ca", emojiToUnicodeString(0x001f1e8, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_cc", emojiToUnicodeString(0x001f1e8, 0x001f1e8));
    emojiShortcodeToUnicode.put("flag_cd", emojiToUnicodeString(0x001f1e8, 0x001f1e9));
    emojiShortcodeToUnicode.put("flag_cf", emojiToUnicodeString(0x001f1e8, 0x001f1eb));
    emojiShortcodeToUnicode.put("flag_cg", emojiToUnicodeString(0x001f1e8, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_ch", emojiToUnicodeString(0x001f1e8, 0x001f1ed));
    emojiShortcodeToUnicode.put("flag_ci", emojiToUnicodeString(0x001f1e8, 0x001f1ee));
    emojiShortcodeToUnicode.put("flag_ck", emojiToUnicodeString(0x001f1e8, 0x001f1f0));
    emojiShortcodeToUnicode.put("flag_cl", emojiToUnicodeString(0x001f1e8, 0x001f1f1));
    emojiShortcodeToUnicode.put("flag_cm", emojiToUnicodeString(0x001f1e8, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_cn", emojiToUnicodeString(0x001f1e8, 0x001f1f3));
    emojiShortcodeToUnicode.put("flag_co", emojiToUnicodeString(0x001f1e8, 0x001f1f4));
    emojiShortcodeToUnicode.put("flag_cp", emojiToUnicodeString(0x001f1e8, 0x001f1f5));
    emojiShortcodeToUnicode.put("flag_cr", emojiToUnicodeString(0x001f1e8, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_cu", emojiToUnicodeString(0x001f1e8, 0x001f1fa));
    emojiShortcodeToUnicode.put("flag_cv", emojiToUnicodeString(0x001f1e8, 0x001f1fb));
    emojiShortcodeToUnicode.put("flag_cw", emojiToUnicodeString(0x001f1e8, 0x001f1fc));
    emojiShortcodeToUnicode.put("flag_cx", emojiToUnicodeString(0x001f1e8, 0x001f1fd));
    emojiShortcodeToUnicode.put("flag_cy", emojiToUnicodeString(0x001f1e8, 0x001f1fe));
    emojiShortcodeToUnicode.put("flag_cz", emojiToUnicodeString(0x001f1e8, 0x001f1ff));
    emojiShortcodeToUnicode.put("flag_de", emojiToUnicodeString(0x001f1e9, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_dg", emojiToUnicodeString(0x001f1e9, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_dj", emojiToUnicodeString(0x001f1e9, 0x001f1ef));
    emojiShortcodeToUnicode.put("flag_dk", emojiToUnicodeString(0x001f1e9, 0x001f1f0));
    emojiShortcodeToUnicode.put("flag_dm", emojiToUnicodeString(0x001f1e9, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_do", emojiToUnicodeString(0x001f1e9, 0x001f1f4));
    emojiShortcodeToUnicode.put("flag_dz", emojiToUnicodeString(0x001f1e9, 0x001f1ff));
    emojiShortcodeToUnicode.put("flag_ea", emojiToUnicodeString(0x001f1ea, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_ec", emojiToUnicodeString(0x001f1ea, 0x001f1e8));
    emojiShortcodeToUnicode.put("flag_ee", emojiToUnicodeString(0x001f1ea, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_eg", emojiToUnicodeString(0x001f1ea, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_eh", emojiToUnicodeString(0x001f1ea, 0x001f1ed));
    emojiShortcodeToUnicode.put("flag_er", emojiToUnicodeString(0x001f1ea, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_es", emojiToUnicodeString(0x001f1ea, 0x001f1f8));
    emojiShortcodeToUnicode.put("flag_et", emojiToUnicodeString(0x001f1ea, 0x001f1f9));
    emojiShortcodeToUnicode.put("flag_eu", emojiToUnicodeString(0x001f1ea, 0x001f1fa));
    emojiShortcodeToUnicode.put("flag_fi", emojiToUnicodeString(0x001f1eb, 0x001f1ee));
    emojiShortcodeToUnicode.put("flag_fj", emojiToUnicodeString(0x001f1eb, 0x001f1ef));
    emojiShortcodeToUnicode.put("flag_fk", emojiToUnicodeString(0x001f1eb, 0x001f1f0));
    emojiShortcodeToUnicode.put("flag_fm", emojiToUnicodeString(0x001f1eb, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_fo", emojiToUnicodeString(0x001f1eb, 0x001f1f4));
    emojiShortcodeToUnicode.put("flag_fr", emojiToUnicodeString(0x001f1eb, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_ga", emojiToUnicodeString(0x001f1ec, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_gb", emojiToUnicodeString(0x001f1ec, 0x001f1e7));
    emojiShortcodeToUnicode.put("flag_gd", emojiToUnicodeString(0x001f1ec, 0x001f1e9));
    emojiShortcodeToUnicode.put("flag_ge", emojiToUnicodeString(0x001f1ec, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_gf", emojiToUnicodeString(0x001f1ec, 0x001f1eb));
    emojiShortcodeToUnicode.put("flag_gg", emojiToUnicodeString(0x001f1ec, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_gh", emojiToUnicodeString(0x001f1ec, 0x001f1ed));
    emojiShortcodeToUnicode.put("flag_gi", emojiToUnicodeString(0x001f1ec, 0x001f1ee));
    emojiShortcodeToUnicode.put("flag_gl", emojiToUnicodeString(0x001f1ec, 0x001f1f1));
    emojiShortcodeToUnicode.put("flag_gm", emojiToUnicodeString(0x001f1ec, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_gn", emojiToUnicodeString(0x001f1ec, 0x001f1f3));
    emojiShortcodeToUnicode.put("flag_gp", emojiToUnicodeString(0x001f1ec, 0x001f1f5));
    emojiShortcodeToUnicode.put("flag_gq", emojiToUnicodeString(0x001f1ec, 0x001f1f6));
    emojiShortcodeToUnicode.put("flag_gr", emojiToUnicodeString(0x001f1ec, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_gs", emojiToUnicodeString(0x001f1ec, 0x001f1f8));
    emojiShortcodeToUnicode.put("flag_gt", emojiToUnicodeString(0x001f1ec, 0x001f1f9));
    emojiShortcodeToUnicode.put("flag_gu", emojiToUnicodeString(0x001f1ec, 0x001f1fa));
    emojiShortcodeToUnicode.put("flag_gw", emojiToUnicodeString(0x001f1ec, 0x001f1fc));
    emojiShortcodeToUnicode.put("flag_gy", emojiToUnicodeString(0x001f1ec, 0x001f1fe));
    emojiShortcodeToUnicode.put("flag_hk", emojiToUnicodeString(0x001f1ed, 0x001f1f0));
    emojiShortcodeToUnicode.put("flag_hm", emojiToUnicodeString(0x001f1ed, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_hn", emojiToUnicodeString(0x001f1ed, 0x001f1f3));
    emojiShortcodeToUnicode.put("flag_hr", emojiToUnicodeString(0x001f1ed, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_ht", emojiToUnicodeString(0x001f1ed, 0x001f1f9));
    emojiShortcodeToUnicode.put("flag_hu", emojiToUnicodeString(0x001f1ed, 0x001f1fa));
    emojiShortcodeToUnicode.put("flag_ic", emojiToUnicodeString(0x001f1ee, 0x001f1e8));
    emojiShortcodeToUnicode.put("flag_id", emojiToUnicodeString(0x001f1ee, 0x001f1e9));
    emojiShortcodeToUnicode.put("flag_ie", emojiToUnicodeString(0x001f1ee, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_il", emojiToUnicodeString(0x001f1ee, 0x001f1f1));
    emojiShortcodeToUnicode.put("flag_im", emojiToUnicodeString(0x001f1ee, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_in", emojiToUnicodeString(0x001f1ee, 0x001f1f3));
    emojiShortcodeToUnicode.put("flag_io", emojiToUnicodeString(0x001f1ee, 0x001f1f4));
    emojiShortcodeToUnicode.put("flag_iq", emojiToUnicodeString(0x001f1ee, 0x001f1f6));
    emojiShortcodeToUnicode.put("flag_ir", emojiToUnicodeString(0x001f1ee, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_is", emojiToUnicodeString(0x001f1ee, 0x001f1f8));
    emojiShortcodeToUnicode.put("flag_it", emojiToUnicodeString(0x001f1ee, 0x001f1f9));
    emojiShortcodeToUnicode.put("flag_je", emojiToUnicodeString(0x001f1ef, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_jm", emojiToUnicodeString(0x001f1ef, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_jo", emojiToUnicodeString(0x001f1ef, 0x001f1f4));
    emojiShortcodeToUnicode.put("flag_jp", emojiToUnicodeString(0x001f1ef, 0x001f1f5));
    emojiShortcodeToUnicode.put("flag_ke", emojiToUnicodeString(0x001f1f0, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_kg", emojiToUnicodeString(0x001f1f0, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_kh", emojiToUnicodeString(0x001f1f0, 0x001f1ed));
    emojiShortcodeToUnicode.put("flag_ki", emojiToUnicodeString(0x001f1f0, 0x001f1ee));
    emojiShortcodeToUnicode.put("flag_km", emojiToUnicodeString(0x001f1f0, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_kn", emojiToUnicodeString(0x001f1f0, 0x001f1f3));
    emojiShortcodeToUnicode.put("flag_kp", emojiToUnicodeString(0x001f1f0, 0x001f1f5));
    emojiShortcodeToUnicode.put("flag_kr", emojiToUnicodeString(0x001f1f0, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_kw", emojiToUnicodeString(0x001f1f0, 0x001f1fc));
    emojiShortcodeToUnicode.put("flag_ky", emojiToUnicodeString(0x001f1f0, 0x001f1fe));
    emojiShortcodeToUnicode.put("flag_kz", emojiToUnicodeString(0x001f1f0, 0x001f1ff));
    emojiShortcodeToUnicode.put("flag_la", emojiToUnicodeString(0x001f1f1, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_lb", emojiToUnicodeString(0x001f1f1, 0x001f1e7));
    emojiShortcodeToUnicode.put("flag_lc", emojiToUnicodeString(0x001f1f1, 0x001f1e8));
    emojiShortcodeToUnicode.put("flag_li", emojiToUnicodeString(0x001f1f1, 0x001f1ee));
    emojiShortcodeToUnicode.put("flag_lk", emojiToUnicodeString(0x001f1f1, 0x001f1f0));
    emojiShortcodeToUnicode.put("flag_lr", emojiToUnicodeString(0x001f1f1, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_ls", emojiToUnicodeString(0x001f1f1, 0x001f1f8));
    emojiShortcodeToUnicode.put("flag_lt", emojiToUnicodeString(0x001f1f1, 0x001f1f9));
    emojiShortcodeToUnicode.put("flag_lu", emojiToUnicodeString(0x001f1f1, 0x001f1fa));
    emojiShortcodeToUnicode.put("flag_lv", emojiToUnicodeString(0x001f1f1, 0x001f1fb));
    emojiShortcodeToUnicode.put("flag_ly", emojiToUnicodeString(0x001f1f1, 0x001f1fe));
    emojiShortcodeToUnicode.put("flag_ma", emojiToUnicodeString(0x001f1f2, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_mc", emojiToUnicodeString(0x001f1f2, 0x001f1e8));
    emojiShortcodeToUnicode.put("flag_md", emojiToUnicodeString(0x001f1f2, 0x001f1e9));
    emojiShortcodeToUnicode.put("flag_me", emojiToUnicodeString(0x001f1f2, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_mf", emojiToUnicodeString(0x001f1f2, 0x001f1eb));
    emojiShortcodeToUnicode.put("flag_mg", emojiToUnicodeString(0x001f1f2, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_mh", emojiToUnicodeString(0x001f1f2, 0x001f1ed));
    emojiShortcodeToUnicode.put("flag_mk", emojiToUnicodeString(0x001f1f2, 0x001f1f0));
    emojiShortcodeToUnicode.put("flag_ml", emojiToUnicodeString(0x001f1f2, 0x001f1f1));
    emojiShortcodeToUnicode.put("flag_mm", emojiToUnicodeString(0x001f1f2, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_mn", emojiToUnicodeString(0x001f1f2, 0x001f1f3));
    emojiShortcodeToUnicode.put("flag_mo", emojiToUnicodeString(0x001f1f2, 0x001f1f4));
    emojiShortcodeToUnicode.put("flag_mp", emojiToUnicodeString(0x001f1f2, 0x001f1f5));
    emojiShortcodeToUnicode.put("flag_mq", emojiToUnicodeString(0x001f1f2, 0x001f1f6));
    emojiShortcodeToUnicode.put("flag_mr", emojiToUnicodeString(0x001f1f2, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_ms", emojiToUnicodeString(0x001f1f2, 0x001f1f8));
    emojiShortcodeToUnicode.put("flag_mt", emojiToUnicodeString(0x001f1f2, 0x001f1f9));
    emojiShortcodeToUnicode.put("flag_mu", emojiToUnicodeString(0x001f1f2, 0x001f1fa));
    emojiShortcodeToUnicode.put("flag_mv", emojiToUnicodeString(0x001f1f2, 0x001f1fb));
    emojiShortcodeToUnicode.put("flag_mw", emojiToUnicodeString(0x001f1f2, 0x001f1fc));
    emojiShortcodeToUnicode.put("flag_mx", emojiToUnicodeString(0x001f1f2, 0x001f1fd));
    emojiShortcodeToUnicode.put("flag_my", emojiToUnicodeString(0x001f1f2, 0x001f1fe));
    emojiShortcodeToUnicode.put("flag_mz", emojiToUnicodeString(0x001f1f2, 0x001f1ff));
    emojiShortcodeToUnicode.put("flag_na", emojiToUnicodeString(0x001f1f3, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_nc", emojiToUnicodeString(0x001f1f3, 0x001f1e8));
    emojiShortcodeToUnicode.put("flag_ne", emojiToUnicodeString(0x001f1f3, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_nf", emojiToUnicodeString(0x001f1f3, 0x001f1eb));
    emojiShortcodeToUnicode.put("flag_ng", emojiToUnicodeString(0x001f1f3, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_ni", emojiToUnicodeString(0x001f1f3, 0x001f1ee));
    emojiShortcodeToUnicode.put("flag_nl", emojiToUnicodeString(0x001f1f3, 0x001f1f1));
    emojiShortcodeToUnicode.put("flag_no", emojiToUnicodeString(0x001f1f3, 0x001f1f4));
    emojiShortcodeToUnicode.put("flag_np", emojiToUnicodeString(0x001f1f3, 0x001f1f5));
    emojiShortcodeToUnicode.put("flag_nr", emojiToUnicodeString(0x001f1f3, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_nu", emojiToUnicodeString(0x001f1f3, 0x001f1fa));
    emojiShortcodeToUnicode.put("flag_nz", emojiToUnicodeString(0x001f1f3, 0x001f1ff));
    emojiShortcodeToUnicode.put("flag_om", emojiToUnicodeString(0x001f1f4, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_pa", emojiToUnicodeString(0x001f1f5, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_pe", emojiToUnicodeString(0x001f1f5, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_pf", emojiToUnicodeString(0x001f1f5, 0x001f1eb));
    emojiShortcodeToUnicode.put("flag_pg", emojiToUnicodeString(0x001f1f5, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_ph", emojiToUnicodeString(0x001f1f5, 0x001f1ed));
    emojiShortcodeToUnicode.put("flag_pk", emojiToUnicodeString(0x001f1f5, 0x001f1f0));
    emojiShortcodeToUnicode.put("flag_pl", emojiToUnicodeString(0x001f1f5, 0x001f1f1));
    emojiShortcodeToUnicode.put("flag_pm", emojiToUnicodeString(0x001f1f5, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_pn", emojiToUnicodeString(0x001f1f5, 0x001f1f3));
    emojiShortcodeToUnicode.put("flag_pr", emojiToUnicodeString(0x001f1f5, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_ps", emojiToUnicodeString(0x001f1f5, 0x001f1f8));
    emojiShortcodeToUnicode.put("flag_pt", emojiToUnicodeString(0x001f1f5, 0x001f1f9));
    emojiShortcodeToUnicode.put("flag_pw", emojiToUnicodeString(0x001f1f5, 0x001f1fc));
    emojiShortcodeToUnicode.put("flag_py", emojiToUnicodeString(0x001f1f5, 0x001f1fe));
    emojiShortcodeToUnicode.put("flag_qa", emojiToUnicodeString(0x001f1f6, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_re", emojiToUnicodeString(0x001f1f7, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_ro", emojiToUnicodeString(0x001f1f7, 0x001f1f4));
    emojiShortcodeToUnicode.put("flag_rs", emojiToUnicodeString(0x001f1f7, 0x001f1f8));
    emojiShortcodeToUnicode.put("flag_ru", emojiToUnicodeString(0x001f1f7, 0x001f1fa));
    emojiShortcodeToUnicode.put("flag_rw", emojiToUnicodeString(0x001f1f7, 0x001f1fc));
    emojiShortcodeToUnicode.put("flag_sa", emojiToUnicodeString(0x001f1f8, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_sb", emojiToUnicodeString(0x001f1f8, 0x001f1e7));
    emojiShortcodeToUnicode.put("flag_sc", emojiToUnicodeString(0x001f1f8, 0x001f1e8));
    emojiShortcodeToUnicode.put("flag_sd", emojiToUnicodeString(0x001f1f8, 0x001f1e9));
    emojiShortcodeToUnicode.put("flag_se", emojiToUnicodeString(0x001f1f8, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_sg", emojiToUnicodeString(0x001f1f8, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_sh", emojiToUnicodeString(0x001f1f8, 0x001f1ed));
    emojiShortcodeToUnicode.put("flag_si", emojiToUnicodeString(0x001f1f8, 0x001f1ee));
    emojiShortcodeToUnicode.put("flag_sj", emojiToUnicodeString(0x001f1f8, 0x001f1ef));
    emojiShortcodeToUnicode.put("flag_sk", emojiToUnicodeString(0x001f1f8, 0x001f1f0));
    emojiShortcodeToUnicode.put("flag_sl", emojiToUnicodeString(0x001f1f8, 0x001f1f1));
    emojiShortcodeToUnicode.put("flag_sm", emojiToUnicodeString(0x001f1f8, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_sn", emojiToUnicodeString(0x001f1f8, 0x001f1f3));
    emojiShortcodeToUnicode.put("flag_so", emojiToUnicodeString(0x001f1f8, 0x001f1f4));
    emojiShortcodeToUnicode.put("flag_sr", emojiToUnicodeString(0x001f1f8, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_ss", emojiToUnicodeString(0x001f1f8, 0x001f1f8));
    emojiShortcodeToUnicode.put("flag_st", emojiToUnicodeString(0x001f1f8, 0x001f1f9));
    emojiShortcodeToUnicode.put("flag_sv", emojiToUnicodeString(0x001f1f8, 0x001f1fb));
    emojiShortcodeToUnicode.put("flag_sx", emojiToUnicodeString(0x001f1f8, 0x001f1fd));
    emojiShortcodeToUnicode.put("flag_sy", emojiToUnicodeString(0x001f1f8, 0x001f1fe));
    emojiShortcodeToUnicode.put("flag_sz", emojiToUnicodeString(0x001f1f8, 0x001f1ff));
    emojiShortcodeToUnicode.put("flag_ta", emojiToUnicodeString(0x001f1f9, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_tc", emojiToUnicodeString(0x001f1f9, 0x001f1e8));
    emojiShortcodeToUnicode.put("flag_td", emojiToUnicodeString(0x001f1f9, 0x001f1e9));
    emojiShortcodeToUnicode.put("flag_tf", emojiToUnicodeString(0x001f1f9, 0x001f1eb));
    emojiShortcodeToUnicode.put("flag_tg", emojiToUnicodeString(0x001f1f9, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_th", emojiToUnicodeString(0x001f1f9, 0x001f1ed));
    emojiShortcodeToUnicode.put("flag_tj", emojiToUnicodeString(0x001f1f9, 0x001f1ef));
    emojiShortcodeToUnicode.put("flag_tk", emojiToUnicodeString(0x001f1f9, 0x001f1f0));
    emojiShortcodeToUnicode.put("flag_tl", emojiToUnicodeString(0x001f1f9, 0x001f1f1));
    emojiShortcodeToUnicode.put("flag_tm", emojiToUnicodeString(0x001f1f9, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_tn", emojiToUnicodeString(0x001f1f9, 0x001f1f3));
    emojiShortcodeToUnicode.put("flag_to", emojiToUnicodeString(0x001f1f9, 0x001f1f4));
    emojiShortcodeToUnicode.put("flag_tr", emojiToUnicodeString(0x001f1f9, 0x001f1f7));
    emojiShortcodeToUnicode.put("flag_tt", emojiToUnicodeString(0x001f1f9, 0x001f1f9));
    emojiShortcodeToUnicode.put("flag_tv", emojiToUnicodeString(0x001f1f9, 0x001f1fb));
    emojiShortcodeToUnicode.put("flag_tw", emojiToUnicodeString(0x001f1f9, 0x001f1fc));
    emojiShortcodeToUnicode.put("flag_tz", emojiToUnicodeString(0x001f1f9, 0x001f1ff));
    emojiShortcodeToUnicode.put("flag_ua", emojiToUnicodeString(0x001f1fa, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_ug", emojiToUnicodeString(0x001f1fa, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_um", emojiToUnicodeString(0x001f1fa, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_us", emojiToUnicodeString(0x001f1fa, 0x001f1f8));
    emojiShortcodeToUnicode.put("flag_uy", emojiToUnicodeString(0x001f1fa, 0x001f1fe));
    emojiShortcodeToUnicode.put("flag_uz", emojiToUnicodeString(0x001f1fa, 0x001f1ff));
    emojiShortcodeToUnicode.put("flag_va", emojiToUnicodeString(0x001f1fb, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_vc", emojiToUnicodeString(0x001f1fb, 0x001f1e8));
    emojiShortcodeToUnicode.put("flag_ve", emojiToUnicodeString(0x001f1fb, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_vg", emojiToUnicodeString(0x001f1fb, 0x001f1ec));
    emojiShortcodeToUnicode.put("flag_vi", emojiToUnicodeString(0x001f1fb, 0x001f1ee));
    emojiShortcodeToUnicode.put("flag_vn", emojiToUnicodeString(0x001f1fb, 0x001f1f3));
    emojiShortcodeToUnicode.put("flag_vu", emojiToUnicodeString(0x001f1fb, 0x001f1fa));
    emojiShortcodeToUnicode.put("flag_wf", emojiToUnicodeString(0x001f1fc, 0x001f1eb));
    emojiShortcodeToUnicode.put("flag_ws", emojiToUnicodeString(0x001f1fc, 0x001f1f8));
    emojiShortcodeToUnicode.put("flag_xk", emojiToUnicodeString(0x001f1fd, 0x001f1f0));
    emojiShortcodeToUnicode.put("flag_ye", emojiToUnicodeString(0x001f1fe, 0x001f1ea));
    emojiShortcodeToUnicode.put("flag_yt", emojiToUnicodeString(0x001f1fe, 0x001f1f9));
    emojiShortcodeToUnicode.put("flag_za", emojiToUnicodeString(0x001f1ff, 0x001f1e6));
    emojiShortcodeToUnicode.put("flag_zm", emojiToUnicodeString(0x001f1ff, 0x001f1f2));
    emojiShortcodeToUnicode.put("flag_zw", emojiToUnicodeString(0x001f1ff, 0x001f1fc));
    emojiShortcodeToUnicode.put("fleur,0x00de,0x00lis", emojiToUnicodeString(0x00269c));
    emojiShortcodeToUnicode.put("four", emojiToUnicodeString(0x000034, 0x0020e3));
    emojiShortcodeToUnicode.put("fr", emojiToUnicodeString(0x001f1eb, 0x001f1f7));
    emojiShortcodeToUnicode.put("gb", emojiToUnicodeString(0x001f1ec, 0x001f1e7));
    emojiShortcodeToUnicode.put("girl_tone1", emojiToUnicodeString(0x001f467, 0x001f3fb));
    emojiShortcodeToUnicode.put("girl_tone2", emojiToUnicodeString(0x001f467, 0x001f3fc));
    emojiShortcodeToUnicode.put("girl_tone3", emojiToUnicodeString(0x001f467, 0x001f3fd));
    emojiShortcodeToUnicode.put("girl_tone4", emojiToUnicodeString(0x001f467, 0x001f3fe));
    emojiShortcodeToUnicode.put("girl_tone5", emojiToUnicodeString(0x001f467, 0x001f3ff));
    emojiShortcodeToUnicode.put("guardsman_tone1", emojiToUnicodeString(0x001f482, 0x001f3fb));
    emojiShortcodeToUnicode.put("guardsman_tone2", emojiToUnicodeString(0x001f482, 0x001f3fc));
    emojiShortcodeToUnicode.put("guardsman_tone3", emojiToUnicodeString(0x001f482, 0x001f3fd));
    emojiShortcodeToUnicode.put("guardsman_tone4", emojiToUnicodeString(0x001f482, 0x001f3fe));
    emojiShortcodeToUnicode.put("guardsman_tone5", emojiToUnicodeString(0x001f482, 0x001f3ff));
    emojiShortcodeToUnicode.put("haircut_tone1", emojiToUnicodeString(0x001f487, 0x001f3fb));
    emojiShortcodeToUnicode.put("haircut_tone2", emojiToUnicodeString(0x001f487, 0x001f3fc));
    emojiShortcodeToUnicode.put("haircut_tone3", emojiToUnicodeString(0x001f487, 0x001f3fd));
    emojiShortcodeToUnicode.put("haircut_tone4", emojiToUnicodeString(0x001f487, 0x001f3fe));
    emojiShortcodeToUnicode.put("haircut_tone5", emojiToUnicodeString(0x001f487, 0x001f3ff));
    emojiShortcodeToUnicode.put("hand_splayed_tone1", emojiToUnicodeString(0x001f590, 0x001f3fb));
    emojiShortcodeToUnicode.put("hand_splayed_tone2", emojiToUnicodeString(0x001f590, 0x001f3fc));
    emojiShortcodeToUnicode.put("hand_splayed_tone3", emojiToUnicodeString(0x001f590, 0x001f3fd));
    emojiShortcodeToUnicode.put("hand_splayed_tone4", emojiToUnicodeString(0x001f590, 0x001f3fe));
    emojiShortcodeToUnicode.put("hand_splayed_tone5", emojiToUnicodeString(0x001f590, 0x001f3ff));
    emojiShortcodeToUnicode.put("handball_tone1", emojiToUnicodeString(0x001f93e, 0x001f3fb));
    emojiShortcodeToUnicode.put("handball_tone2", emojiToUnicodeString(0x001f93e, 0x001f3fc));
    emojiShortcodeToUnicode.put("handball_tone3", emojiToUnicodeString(0x001f93e, 0x001f3fd));
    emojiShortcodeToUnicode.put("handball_tone4", emojiToUnicodeString(0x001f93e, 0x001f3fe));
    emojiShortcodeToUnicode.put("handball_tone5", emojiToUnicodeString(0x001f93e, 0x001f3ff));
    emojiShortcodeToUnicode.put("handshake_tone1", emojiToUnicodeString(0x001f91d, 0x001f3fb));
    emojiShortcodeToUnicode.put("handshake_tone2", emojiToUnicodeString(0x001f91d, 0x001f3fc));
    emojiShortcodeToUnicode.put("handshake_tone3", emojiToUnicodeString(0x001f91d, 0x001f3fd));
    emojiShortcodeToUnicode.put("handshake_tone4", emojiToUnicodeString(0x001f91d, 0x001f3fe));
    emojiShortcodeToUnicode.put("handshake_tone5", emojiToUnicodeString(0x001f91d, 0x001f3ff));
    emojiShortcodeToUnicode.put("hash", emojiToUnicodeString(0x000023, 0x0020e3));
    emojiShortcodeToUnicode.put("horse_racing_tone1", emojiToUnicodeString(0x001f3c7, 0x001f3fb));
    emojiShortcodeToUnicode.put("horse_racing_tone2", emojiToUnicodeString(0x001f3c7, 0x001f3fc));
    emojiShortcodeToUnicode.put("horse_racing_tone3", emojiToUnicodeString(0x001f3c7, 0x001f3fd));
    emojiShortcodeToUnicode.put("horse_racing_tone4", emojiToUnicodeString(0x001f3c7, 0x001f3fe));
    emojiShortcodeToUnicode.put("horse_racing_tone5", emojiToUnicodeString(0x001f3c7, 0x001f3ff));
    emojiShortcodeToUnicode.put("information_desk_person_tone1", emojiToUnicodeString(0x001f481, 0x001f3fb));
    emojiShortcodeToUnicode.put("information_desk_person_tone2", emojiToUnicodeString(0x001f481, 0x001f3fc));
    emojiShortcodeToUnicode.put("information_desk_person_tone3", emojiToUnicodeString(0x001f481, 0x001f3fd));
    emojiShortcodeToUnicode.put("information_desk_person_tone4", emojiToUnicodeString(0x001f481, 0x001f3fe));
    emojiShortcodeToUnicode.put("information_desk_person_tone5", emojiToUnicodeString(0x001f481, 0x001f3ff));
    emojiShortcodeToUnicode.put("it", emojiToUnicodeString(0x001f1ee, 0x001f1f9));
    emojiShortcodeToUnicode.put("jp", emojiToUnicodeString(0x001f1ef, 0x001f1f5));
    emojiShortcodeToUnicode.put("juggling_tone1", emojiToUnicodeString(0x001f939, 0x001f3fb));
    emojiShortcodeToUnicode.put("juggling_tone2", emojiToUnicodeString(0x001f939, 0x001f3fc));
    emojiShortcodeToUnicode.put("juggling_tone3", emojiToUnicodeString(0x001f939, 0x001f3fd));
    emojiShortcodeToUnicode.put("juggling_tone4", emojiToUnicodeString(0x001f939, 0x001f3fe));
    emojiShortcodeToUnicode.put("juggling_tone5", emojiToUnicodeString(0x001f939, 0x001f3ff));
    emojiShortcodeToUnicode.put("kiss_mm", emojiToUnicodeString(0x001f468, 0x002764, 0x001f48b, 0x001f468));
    emojiShortcodeToUnicode.put("kiss_ww", emojiToUnicodeString(0x001f469, 0x002764, 0x001f48b, 0x001f469));
    emojiShortcodeToUnicode.put("kr", emojiToUnicodeString(0x001f1f0, 0x001f1f7));
    emojiShortcodeToUnicode.put("left_facing_fist_tone1", emojiToUnicodeString(0x001f91b, 0x001f3fb));
    emojiShortcodeToUnicode.put("left_facing_fist_tone2", emojiToUnicodeString(0x001f91b, 0x001f3fc));
    emojiShortcodeToUnicode.put("left_facing_fist_tone3", emojiToUnicodeString(0x001f91b, 0x001f3fd));
    emojiShortcodeToUnicode.put("left_facing_fist_tone4", emojiToUnicodeString(0x001f91b, 0x001f3fe));
    emojiShortcodeToUnicode.put("left_facing_fist_tone5", emojiToUnicodeString(0x001f91b, 0x001f3ff));
    emojiShortcodeToUnicode.put("lifter_tone1", emojiToUnicodeString(0x001f3cb, 0x001f3fb));
    emojiShortcodeToUnicode.put("lifter_tone2", emojiToUnicodeString(0x001f3cb, 0x001f3fc));
    emojiShortcodeToUnicode.put("lifter_tone3", emojiToUnicodeString(0x001f3cb, 0x001f3fd));
    emojiShortcodeToUnicode.put("lifter_tone4", emojiToUnicodeString(0x001f3cb, 0x001f3fe));
    emojiShortcodeToUnicode.put("lifter_tone5", emojiToUnicodeString(0x001f3cb, 0x001f3ff));
    emojiShortcodeToUnicode.put("man_dancing_tone1", emojiToUnicodeString(0x001f57a, 0x001f3fb));
    emojiShortcodeToUnicode.put("man_dancing_tone2", emojiToUnicodeString(0x001f57a, 0x001f3fc));
    emojiShortcodeToUnicode.put("man_dancing_tone3", emojiToUnicodeString(0x001f57a, 0x001f3fd));
    emojiShortcodeToUnicode.put("man_dancing_tone4", emojiToUnicodeString(0x001f57a, 0x001f3fe));
    emojiShortcodeToUnicode.put("man_dancing_tone5", emojiToUnicodeString(0x001f57a, 0x001f3ff));
    emojiShortcodeToUnicode.put("man_in_tuxedo_tone1", emojiToUnicodeString(0x001f935, 0x001f3fb));
    emojiShortcodeToUnicode.put("man_in_tuxedo_tone2", emojiToUnicodeString(0x001f935, 0x001f3fc));
    emojiShortcodeToUnicode.put("man_in_tuxedo_tone3", emojiToUnicodeString(0x001f935, 0x001f3fd));
    emojiShortcodeToUnicode.put("man_in_tuxedo_tone4", emojiToUnicodeString(0x001f935, 0x001f3fe));
    emojiShortcodeToUnicode.put("man_in_tuxedo_tone5", emojiToUnicodeString(0x001f935, 0x001f3ff));
    emojiShortcodeToUnicode.put("man_tone1", emojiToUnicodeString(0x001f468, 0x001f3fb));
    emojiShortcodeToUnicode.put("man_tone2", emojiToUnicodeString(0x001f468, 0x001f3fc));
    emojiShortcodeToUnicode.put("man_tone3", emojiToUnicodeString(0x001f468, 0x001f3fd));
    emojiShortcodeToUnicode.put("man_tone4", emojiToUnicodeString(0x001f468, 0x001f3fe));
    emojiShortcodeToUnicode.put("man_tone5", emojiToUnicodeString(0x001f468, 0x001f3ff));
    emojiShortcodeToUnicode.put("man_with_gua_pi_mao_tone1", emojiToUnicodeString(0x001f472, 0x001f3fb));
    emojiShortcodeToUnicode.put("man_with_gua_pi_mao_tone2", emojiToUnicodeString(0x001f472, 0x001f3fc));
    emojiShortcodeToUnicode.put("man_with_gua_pi_mao_tone3", emojiToUnicodeString(0x001f472, 0x001f3fd));
    emojiShortcodeToUnicode.put("man_with_gua_pi_mao_tone4", emojiToUnicodeString(0x001f472, 0x001f3fe));
    emojiShortcodeToUnicode.put("man_with_gua_pi_mao_tone5", emojiToUnicodeString(0x001f472, 0x001f3ff));
    emojiShortcodeToUnicode.put("man_with_turban_tone1", emojiToUnicodeString(0x001f473, 0x001f3fb));
    emojiShortcodeToUnicode.put("man_with_turban_tone2", emojiToUnicodeString(0x001f473, 0x001f3fc));
    emojiShortcodeToUnicode.put("man_with_turban_tone3", emojiToUnicodeString(0x001f473, 0x001f3fd));
    emojiShortcodeToUnicode.put("man_with_turban_tone4", emojiToUnicodeString(0x001f473, 0x001f3fe));
    emojiShortcodeToUnicode.put("man_with_turban_tone5", emojiToUnicodeString(0x001f473, 0x001f3ff));
    emojiShortcodeToUnicode.put("massage_tone1", emojiToUnicodeString(0x001f486, 0x001f3fb));
    emojiShortcodeToUnicode.put("massage_tone2", emojiToUnicodeString(0x001f486, 0x001f3fc));
    emojiShortcodeToUnicode.put("massage_tone3", emojiToUnicodeString(0x001f486, 0x001f3fd));
    emojiShortcodeToUnicode.put("massage_tone4", emojiToUnicodeString(0x001f486, 0x001f3fe));
    emojiShortcodeToUnicode.put("massage_tone5", emojiToUnicodeString(0x001f486, 0x001f3ff));
    emojiShortcodeToUnicode.put("metal_tone1", emojiToUnicodeString(0x001f918, 0x001f3fb));
    emojiShortcodeToUnicode.put("metal_tone2", emojiToUnicodeString(0x001f918, 0x001f3fc));
    emojiShortcodeToUnicode.put("metal_tone3", emojiToUnicodeString(0x001f918, 0x001f3fd));
    emojiShortcodeToUnicode.put("metal_tone4", emojiToUnicodeString(0x001f918, 0x001f3fe));
    emojiShortcodeToUnicode.put("metal_tone5", emojiToUnicodeString(0x001f918, 0x001f3ff));
    emojiShortcodeToUnicode.put("middle_finger_tone1", emojiToUnicodeString(0x001f595, 0x001f3fb));
    emojiShortcodeToUnicode.put("middle_finger_tone2", emojiToUnicodeString(0x001f595, 0x001f3fc));
    emojiShortcodeToUnicode.put("middle_finger_tone3", emojiToUnicodeString(0x001f595, 0x001f3fd));
    emojiShortcodeToUnicode.put("middle_finger_tone4", emojiToUnicodeString(0x001f595, 0x001f3fe));
    emojiShortcodeToUnicode.put("middle_finger_tone5", emojiToUnicodeString(0x001f595, 0x001f3ff));
    emojiShortcodeToUnicode.put("mountain_bicyclist_tone1", emojiToUnicodeString(0x001f6b5, 0x001f3fb));
    emojiShortcodeToUnicode.put("mountain_bicyclist_tone2", emojiToUnicodeString(0x001f6b5, 0x001f3fc));
    emojiShortcodeToUnicode.put("mountain_bicyclist_tone3", emojiToUnicodeString(0x001f6b5, 0x001f3fd));
    emojiShortcodeToUnicode.put("mountain_bicyclist_tone4", emojiToUnicodeString(0x001f6b5, 0x001f3fe));
    emojiShortcodeToUnicode.put("mountain_bicyclist_tone5", emojiToUnicodeString(0x001f6b5, 0x001f3ff));
    emojiShortcodeToUnicode.put("mrs_claus_tone1", emojiToUnicodeString(0x001f936, 0x001f3fb));
    emojiShortcodeToUnicode.put("mrs_claus_tone2", emojiToUnicodeString(0x001f936, 0x001f3fc));
    emojiShortcodeToUnicode.put("mrs_claus_tone3", emojiToUnicodeString(0x001f936, 0x001f3fd));
    emojiShortcodeToUnicode.put("mrs_claus_tone4", emojiToUnicodeString(0x001f936, 0x001f3fe));
    emojiShortcodeToUnicode.put("mrs_claus_tone5", emojiToUnicodeString(0x001f936, 0x001f3ff));
    emojiShortcodeToUnicode.put("muscle_tone1", emojiToUnicodeString(0x001f4aa, 0x001f3fb));
    emojiShortcodeToUnicode.put("muscle_tone2", emojiToUnicodeString(0x001f4aa, 0x001f3fc));
    emojiShortcodeToUnicode.put("muscle_tone3", emojiToUnicodeString(0x001f4aa, 0x001f3fd));
    emojiShortcodeToUnicode.put("muscle_tone4", emojiToUnicodeString(0x001f4aa, 0x001f3fe));
    emojiShortcodeToUnicode.put("muscle_tone5", emojiToUnicodeString(0x001f4aa, 0x001f3ff));
    emojiShortcodeToUnicode.put("nail_care_tone1", emojiToUnicodeString(0x001f485, 0x001f3fb));
    emojiShortcodeToUnicode.put("nail_care_tone2", emojiToUnicodeString(0x001f485, 0x001f3fc));
    emojiShortcodeToUnicode.put("nail_care_tone3", emojiToUnicodeString(0x001f485, 0x001f3fd));
    emojiShortcodeToUnicode.put("nail_care_tone4", emojiToUnicodeString(0x001f485, 0x001f3fe));
    emojiShortcodeToUnicode.put("nail_care_tone5", emojiToUnicodeString(0x001f485, 0x001f3ff));
    emojiShortcodeToUnicode.put("nine", emojiToUnicodeString(0x000039, 0x0020e3));
    emojiShortcodeToUnicode.put("no_good_tone1", emojiToUnicodeString(0x001f645, 0x001f3fb));
    emojiShortcodeToUnicode.put("no_good_tone2", emojiToUnicodeString(0x001f645, 0x001f3fc));
    emojiShortcodeToUnicode.put("no_good_tone3", emojiToUnicodeString(0x001f645, 0x001f3fd));
    emojiShortcodeToUnicode.put("no_good_tone4", emojiToUnicodeString(0x001f645, 0x001f3fe));
    emojiShortcodeToUnicode.put("no_good_tone5", emojiToUnicodeString(0x001f645, 0x001f3ff));
    emojiShortcodeToUnicode.put("non,0x00potable_water", emojiToUnicodeString(0x001f6b1));
    emojiShortcodeToUnicode.put("nose_tone1", emojiToUnicodeString(0x001f443, 0x001f3fb));
    emojiShortcodeToUnicode.put("nose_tone2", emojiToUnicodeString(0x001f443, 0x001f3fc));
    emojiShortcodeToUnicode.put("nose_tone3", emojiToUnicodeString(0x001f443, 0x001f3fd));
    emojiShortcodeToUnicode.put("nose_tone4", emojiToUnicodeString(0x001f443, 0x001f3fe));
    emojiShortcodeToUnicode.put("nose_tone5", emojiToUnicodeString(0x001f443, 0x001f3ff));
    emojiShortcodeToUnicode.put("ok_hand_tone1", emojiToUnicodeString(0x001f44c, 0x001f3fb));
    emojiShortcodeToUnicode.put("ok_hand_tone2", emojiToUnicodeString(0x001f44c, 0x001f3fc));
    emojiShortcodeToUnicode.put("ok_hand_tone3", emojiToUnicodeString(0x001f44c, 0x001f3fd));
    emojiShortcodeToUnicode.put("ok_hand_tone4", emojiToUnicodeString(0x001f44c, 0x001f3fe));
    emojiShortcodeToUnicode.put("ok_hand_tone5", emojiToUnicodeString(0x001f44c, 0x001f3ff));
    emojiShortcodeToUnicode.put("ok_woman_tone1", emojiToUnicodeString(0x001f646, 0x001f3fb));
    emojiShortcodeToUnicode.put("ok_woman_tone2", emojiToUnicodeString(0x001f646, 0x001f3fc));
    emojiShortcodeToUnicode.put("ok_woman_tone3", emojiToUnicodeString(0x001f646, 0x001f3fd));
    emojiShortcodeToUnicode.put("ok_woman_tone4", emojiToUnicodeString(0x001f646, 0x001f3fe));
    emojiShortcodeToUnicode.put("ok_woman_tone5", emojiToUnicodeString(0x001f646, 0x001f3ff));
    emojiShortcodeToUnicode.put("older_man_tone1", emojiToUnicodeString(0x001f474, 0x001f3fb));
    emojiShortcodeToUnicode.put("older_man_tone2", emojiToUnicodeString(0x001f474, 0x001f3fc));
    emojiShortcodeToUnicode.put("older_man_tone3", emojiToUnicodeString(0x001f474, 0x001f3fd));
    emojiShortcodeToUnicode.put("older_man_tone4", emojiToUnicodeString(0x001f474, 0x001f3fe));
    emojiShortcodeToUnicode.put("older_man_tone5", emojiToUnicodeString(0x001f474, 0x001f3ff));
    emojiShortcodeToUnicode.put("older_woman_tone1", emojiToUnicodeString(0x001f475, 0x001f3fb));
    emojiShortcodeToUnicode.put("older_woman_tone2", emojiToUnicodeString(0x001f475, 0x001f3fc));
    emojiShortcodeToUnicode.put("older_woman_tone3", emojiToUnicodeString(0x001f475, 0x001f3fd));
    emojiShortcodeToUnicode.put("older_woman_tone4", emojiToUnicodeString(0x001f475, 0x001f3fe));
    emojiShortcodeToUnicode.put("older_woman_tone5", emojiToUnicodeString(0x001f475, 0x001f3ff));
    emojiShortcodeToUnicode.put("one", emojiToUnicodeString(0x000031, 0x0020e3));
    emojiShortcodeToUnicode.put("open_hands_tone1", emojiToUnicodeString(0x001f450, 0x001f3fb));
    emojiShortcodeToUnicode.put("open_hands_tone2", emojiToUnicodeString(0x001f450, 0x001f3fc));
    emojiShortcodeToUnicode.put("open_hands_tone3", emojiToUnicodeString(0x001f450, 0x001f3fd));
    emojiShortcodeToUnicode.put("open_hands_tone4", emojiToUnicodeString(0x001f450, 0x001f3fe));
    emojiShortcodeToUnicode.put("open_hands_tone5", emojiToUnicodeString(0x001f450, 0x001f3ff));
    emojiShortcodeToUnicode.put("person_frowning_tone1", emojiToUnicodeString(0x001f64d, 0x001f3fb));
    emojiShortcodeToUnicode.put("person_frowning_tone2", emojiToUnicodeString(0x001f64d, 0x001f3fc));
    emojiShortcodeToUnicode.put("person_frowning_tone3", emojiToUnicodeString(0x001f64d, 0x001f3fd));
    emojiShortcodeToUnicode.put("person_frowning_tone4", emojiToUnicodeString(0x001f64d, 0x001f3fe));
    emojiShortcodeToUnicode.put("person_frowning_tone5", emojiToUnicodeString(0x001f64d, 0x001f3ff));
    emojiShortcodeToUnicode.put("person_with_blond_hair_tone1", emojiToUnicodeString(0x001f471, 0x001f3fb));
    emojiShortcodeToUnicode.put("person_with_blond_hair_tone2", emojiToUnicodeString(0x001f471, 0x001f3fc));
    emojiShortcodeToUnicode.put("person_with_blond_hair_tone3", emojiToUnicodeString(0x001f471, 0x001f3fd));
    emojiShortcodeToUnicode.put("person_with_blond_hair_tone4", emojiToUnicodeString(0x001f471, 0x001f3fe));
    emojiShortcodeToUnicode.put("person_with_blond_hair_tone5", emojiToUnicodeString(0x001f471, 0x001f3ff));
    emojiShortcodeToUnicode.put("person_with_pouting_face_tone1", emojiToUnicodeString(0x001f64e, 0x001f3fb));
    emojiShortcodeToUnicode.put("person_with_pouting_face_tone2", emojiToUnicodeString(0x001f64e, 0x001f3fc));
    emojiShortcodeToUnicode.put("person_with_pouting_face_tone3", emojiToUnicodeString(0x001f64e, 0x001f3fd));
    emojiShortcodeToUnicode.put("person_with_pouting_face_tone4", emojiToUnicodeString(0x001f64e, 0x001f3fe));
    emojiShortcodeToUnicode.put("person_with_pouting_face_tone5", emojiToUnicodeString(0x001f64e, 0x001f3ff));
    emojiShortcodeToUnicode.put("point_down_tone1", emojiToUnicodeString(0x001f447, 0x001f3fb));
    emojiShortcodeToUnicode.put("point_down_tone2", emojiToUnicodeString(0x001f447, 0x001f3fc));
    emojiShortcodeToUnicode.put("point_down_tone3", emojiToUnicodeString(0x001f447, 0x001f3fd));
    emojiShortcodeToUnicode.put("point_down_tone4", emojiToUnicodeString(0x001f447, 0x001f3fe));
    emojiShortcodeToUnicode.put("point_down_tone5", emojiToUnicodeString(0x001f447, 0x001f3ff));
    emojiShortcodeToUnicode.put("point_left_tone1", emojiToUnicodeString(0x001f448, 0x001f3fb));
    emojiShortcodeToUnicode.put("point_left_tone2", emojiToUnicodeString(0x001f448, 0x001f3fc));
    emojiShortcodeToUnicode.put("point_left_tone3", emojiToUnicodeString(0x001f448, 0x001f3fd));
    emojiShortcodeToUnicode.put("point_left_tone4", emojiToUnicodeString(0x001f448, 0x001f3fe));
    emojiShortcodeToUnicode.put("point_left_tone5", emojiToUnicodeString(0x001f448, 0x001f3ff));
    emojiShortcodeToUnicode.put("point_right_tone1", emojiToUnicodeString(0x001f449, 0x001f3fb));
    emojiShortcodeToUnicode.put("point_right_tone2", emojiToUnicodeString(0x001f449, 0x001f3fc));
    emojiShortcodeToUnicode.put("point_right_tone3", emojiToUnicodeString(0x001f449, 0x001f3fd));
    emojiShortcodeToUnicode.put("point_right_tone4", emojiToUnicodeString(0x001f449, 0x001f3fe));
    emojiShortcodeToUnicode.put("point_right_tone5", emojiToUnicodeString(0x001f449, 0x001f3ff));
    emojiShortcodeToUnicode.put("point_up_2_tone1", emojiToUnicodeString(0x001f446, 0x001f3fb));
    emojiShortcodeToUnicode.put("point_up_2_tone2", emojiToUnicodeString(0x001f446, 0x001f3fc));
    emojiShortcodeToUnicode.put("point_up_2_tone3", emojiToUnicodeString(0x001f446, 0x001f3fd));
    emojiShortcodeToUnicode.put("point_up_2_tone4", emojiToUnicodeString(0x001f446, 0x001f3fe));
    emojiShortcodeToUnicode.put("point_up_2_tone5", emojiToUnicodeString(0x001f446, 0x001f3ff));
    emojiShortcodeToUnicode.put("point_up_tone1", emojiToUnicodeString(0x00261d, 0x001f3fb));
    emojiShortcodeToUnicode.put("point_up_tone2", emojiToUnicodeString(0x00261d, 0x001f3fc));
    emojiShortcodeToUnicode.put("point_up_tone3", emojiToUnicodeString(0x00261d, 0x001f3fd));
    emojiShortcodeToUnicode.put("point_up_tone4", emojiToUnicodeString(0x00261d, 0x001f3fe));
    emojiShortcodeToUnicode.put("point_up_tone5", emojiToUnicodeString(0x00261d, 0x001f3ff));
    emojiShortcodeToUnicode.put("pray_tone1", emojiToUnicodeString(0x001f64f, 0x001f3fb));
    emojiShortcodeToUnicode.put("pray_tone2", emojiToUnicodeString(0x001f64f, 0x001f3fc));
    emojiShortcodeToUnicode.put("pray_tone3", emojiToUnicodeString(0x001f64f, 0x001f3fd));
    emojiShortcodeToUnicode.put("pray_tone4", emojiToUnicodeString(0x001f64f, 0x001f3fe));
    emojiShortcodeToUnicode.put("pray_tone5", emojiToUnicodeString(0x001f64f, 0x001f3ff));
    emojiShortcodeToUnicode.put("pregnant_woman_tone1", emojiToUnicodeString(0x001f930, 0x001f3fb));
    emojiShortcodeToUnicode.put("pregnant_woman_tone2", emojiToUnicodeString(0x001f930, 0x001f3fc));
    emojiShortcodeToUnicode.put("pregnant_woman_tone3", emojiToUnicodeString(0x001f930, 0x001f3fd));
    emojiShortcodeToUnicode.put("pregnant_woman_tone4", emojiToUnicodeString(0x001f930, 0x001f3fe));
    emojiShortcodeToUnicode.put("pregnant_woman_tone5", emojiToUnicodeString(0x001f930, 0x001f3ff));
    emojiShortcodeToUnicode.put("prince_tone1", emojiToUnicodeString(0x001f934, 0x001f3fb));
    emojiShortcodeToUnicode.put("prince_tone2", emojiToUnicodeString(0x001f934, 0x001f3fc));
    emojiShortcodeToUnicode.put("prince_tone3", emojiToUnicodeString(0x001f934, 0x001f3fd));
    emojiShortcodeToUnicode.put("prince_tone4", emojiToUnicodeString(0x001f934, 0x001f3fe));
    emojiShortcodeToUnicode.put("prince_tone5", emojiToUnicodeString(0x001f934, 0x001f3ff));
    emojiShortcodeToUnicode.put("princess_tone1", emojiToUnicodeString(0x001f478, 0x001f3fb));
    emojiShortcodeToUnicode.put("princess_tone2", emojiToUnicodeString(0x001f478, 0x001f3fc));
    emojiShortcodeToUnicode.put("princess_tone3", emojiToUnicodeString(0x001f478, 0x001f3fd));
    emojiShortcodeToUnicode.put("princess_tone4", emojiToUnicodeString(0x001f478, 0x001f3fe));
    emojiShortcodeToUnicode.put("princess_tone5", emojiToUnicodeString(0x001f478, 0x001f3ff));
    emojiShortcodeToUnicode.put("punch_tone1", emojiToUnicodeString(0x001f44a, 0x001f3fb));
    emojiShortcodeToUnicode.put("punch_tone2", emojiToUnicodeString(0x001f44a, 0x001f3fc));
    emojiShortcodeToUnicode.put("punch_tone3", emojiToUnicodeString(0x001f44a, 0x001f3fd));
    emojiShortcodeToUnicode.put("punch_tone4", emojiToUnicodeString(0x001f44a, 0x001f3fe));
    emojiShortcodeToUnicode.put("punch_tone5", emojiToUnicodeString(0x001f44a, 0x001f3ff));
    emojiShortcodeToUnicode.put("rainbow_flag", emojiToUnicodeString(0x001f3f3, 0x001f308));
    emojiShortcodeToUnicode.put("raised_back_of_hand_tone1", emojiToUnicodeString(0x001f91a, 0x001f3fb));
    emojiShortcodeToUnicode.put("raised_back_of_hand_tone2", emojiToUnicodeString(0x001f91a, 0x001f3fc));
    emojiShortcodeToUnicode.put("raised_back_of_hand_tone3", emojiToUnicodeString(0x001f91a, 0x001f3fd));
    emojiShortcodeToUnicode.put("raised_back_of_hand_tone4", emojiToUnicodeString(0x001f91a, 0x001f3fe));
    emojiShortcodeToUnicode.put("raised_back_of_hand_tone5", emojiToUnicodeString(0x001f91a, 0x001f3ff));
    emojiShortcodeToUnicode.put("raised_hand_tone1", emojiToUnicodeString(0x00270b, 0x001f3fb));
    emojiShortcodeToUnicode.put("raised_hand_tone2", emojiToUnicodeString(0x00270b, 0x001f3fc));
    emojiShortcodeToUnicode.put("raised_hand_tone3", emojiToUnicodeString(0x00270b, 0x001f3fd));
    emojiShortcodeToUnicode.put("raised_hand_tone4", emojiToUnicodeString(0x00270b, 0x001f3fe));
    emojiShortcodeToUnicode.put("raised_hand_tone5", emojiToUnicodeString(0x00270b, 0x001f3ff));
    emojiShortcodeToUnicode.put("raised_hands_tone1", emojiToUnicodeString(0x001f64c, 0x001f3fb));
    emojiShortcodeToUnicode.put("raised_hands_tone2", emojiToUnicodeString(0x001f64c, 0x001f3fc));
    emojiShortcodeToUnicode.put("raised_hands_tone3", emojiToUnicodeString(0x001f64c, 0x001f3fd));
    emojiShortcodeToUnicode.put("raised_hands_tone4", emojiToUnicodeString(0x001f64c, 0x001f3fe));
    emojiShortcodeToUnicode.put("raised_hands_tone5", emojiToUnicodeString(0x001f64c, 0x001f3ff));
    emojiShortcodeToUnicode.put("raising_hand_tone1", emojiToUnicodeString(0x001f64b, 0x001f3fb));
    emojiShortcodeToUnicode.put("raising_hand_tone2", emojiToUnicodeString(0x001f64b, 0x001f3fc));
    emojiShortcodeToUnicode.put("raising_hand_tone3", emojiToUnicodeString(0x001f64b, 0x001f3fd));
    emojiShortcodeToUnicode.put("raising_hand_tone4", emojiToUnicodeString(0x001f64b, 0x001f3fe));
    emojiShortcodeToUnicode.put("raising_hand_tone5", emojiToUnicodeString(0x001f64b, 0x001f3ff));
    emojiShortcodeToUnicode.put("right_facing_fist_tone1", emojiToUnicodeString(0x001f91c, 0x001f3fb));
    emojiShortcodeToUnicode.put("right_facing_fist_tone2", emojiToUnicodeString(0x001f91c, 0x001f3fc));
    emojiShortcodeToUnicode.put("right_facing_fist_tone3", emojiToUnicodeString(0x001f91c, 0x001f3fd));
    emojiShortcodeToUnicode.put("right_facing_fist_tone4", emojiToUnicodeString(0x001f91c, 0x001f3fe));
    emojiShortcodeToUnicode.put("right_facing_fist_tone5", emojiToUnicodeString(0x001f91c, 0x001f3ff));
    emojiShortcodeToUnicode.put("rowboat_tone1", emojiToUnicodeString(0x001f6a3, 0x001f3fb));
    emojiShortcodeToUnicode.put("rowboat_tone2", emojiToUnicodeString(0x001f6a3, 0x001f3fc));
    emojiShortcodeToUnicode.put("rowboat_tone3", emojiToUnicodeString(0x001f6a3, 0x001f3fd));
    emojiShortcodeToUnicode.put("rowboat_tone4", emojiToUnicodeString(0x001f6a3, 0x001f3fe));
    emojiShortcodeToUnicode.put("rowboat_tone5", emojiToUnicodeString(0x001f6a3, 0x001f3ff));
    emojiShortcodeToUnicode.put("ru", emojiToUnicodeString(0x001f1f7, 0x001f1fa));
    emojiShortcodeToUnicode.put("runner_tone1", emojiToUnicodeString(0x001f3c3, 0x001f3fb));
    emojiShortcodeToUnicode.put("runner_tone2", emojiToUnicodeString(0x001f3c3, 0x001f3fc));
    emojiShortcodeToUnicode.put("runner_tone3", emojiToUnicodeString(0x001f3c3, 0x001f3fd));
    emojiShortcodeToUnicode.put("runner_tone4", emojiToUnicodeString(0x001f3c3, 0x001f3fe));
    emojiShortcodeToUnicode.put("runner_tone5", emojiToUnicodeString(0x001f3c3, 0x001f3ff));
    emojiShortcodeToUnicode.put("santa_tone1", emojiToUnicodeString(0x001f385, 0x001f3fb));
    emojiShortcodeToUnicode.put("santa_tone2", emojiToUnicodeString(0x001f385, 0x001f3fc));
    emojiShortcodeToUnicode.put("santa_tone3", emojiToUnicodeString(0x001f385, 0x001f3fd));
    emojiShortcodeToUnicode.put("santa_tone4", emojiToUnicodeString(0x001f385, 0x001f3fe));
    emojiShortcodeToUnicode.put("santa_tone5", emojiToUnicodeString(0x001f385, 0x001f3ff));
    emojiShortcodeToUnicode.put("selfie_tone1", emojiToUnicodeString(0x001f933, 0x001f3fb));
    emojiShortcodeToUnicode.put("selfie_tone2", emojiToUnicodeString(0x001f933, 0x001f3fc));
    emojiShortcodeToUnicode.put("selfie_tone3", emojiToUnicodeString(0x001f933, 0x001f3fd));
    emojiShortcodeToUnicode.put("selfie_tone4", emojiToUnicodeString(0x001f933, 0x001f3fe));
    emojiShortcodeToUnicode.put("selfie_tone5", emojiToUnicodeString(0x001f933, 0x001f3ff));
    emojiShortcodeToUnicode.put("seven", emojiToUnicodeString(0x000037, 0x0020e3));
    emojiShortcodeToUnicode.put("shrug_tone1", emojiToUnicodeString(0x001f937, 0x001f3fb));
    emojiShortcodeToUnicode.put("shrug_tone2", emojiToUnicodeString(0x001f937, 0x001f3fc));
    emojiShortcodeToUnicode.put("shrug_tone3", emojiToUnicodeString(0x001f937, 0x001f3fd));
    emojiShortcodeToUnicode.put("shrug_tone4", emojiToUnicodeString(0x001f937, 0x001f3fe));
    emojiShortcodeToUnicode.put("shrug_tone5", emojiToUnicodeString(0x001f937, 0x001f3ff));
    emojiShortcodeToUnicode.put("six", emojiToUnicodeString(0x000036, 0x0020e3));
    emojiShortcodeToUnicode.put("spy_tone1", emojiToUnicodeString(0x001f575, 0x001f3fb));
    emojiShortcodeToUnicode.put("spy_tone2", emojiToUnicodeString(0x001f575, 0x001f3fc));
    emojiShortcodeToUnicode.put("spy_tone3", emojiToUnicodeString(0x001f575, 0x001f3fd));
    emojiShortcodeToUnicode.put("spy_tone4", emojiToUnicodeString(0x001f575, 0x001f3fe));
    emojiShortcodeToUnicode.put("spy_tone5", emojiToUnicodeString(0x001f575, 0x001f3ff));
    emojiShortcodeToUnicode.put("surfer_tone1", emojiToUnicodeString(0x001f3c4, 0x001f3fb));
    emojiShortcodeToUnicode.put("surfer_tone2", emojiToUnicodeString(0x001f3c4, 0x001f3fc));
    emojiShortcodeToUnicode.put("surfer_tone3", emojiToUnicodeString(0x001f3c4, 0x001f3fd));
    emojiShortcodeToUnicode.put("surfer_tone4", emojiToUnicodeString(0x001f3c4, 0x001f3fe));
    emojiShortcodeToUnicode.put("surfer_tone5", emojiToUnicodeString(0x001f3c4, 0x001f3ff));
    emojiShortcodeToUnicode.put("swimmer_tone1", emojiToUnicodeString(0x001f3ca, 0x001f3fb));
    emojiShortcodeToUnicode.put("swimmer_tone2", emojiToUnicodeString(0x001f3ca, 0x001f3fc));
    emojiShortcodeToUnicode.put("swimmer_tone3", emojiToUnicodeString(0x001f3ca, 0x001f3fd));
    emojiShortcodeToUnicode.put("swimmer_tone4", emojiToUnicodeString(0x001f3ca, 0x001f3fe));
    emojiShortcodeToUnicode.put("swimmer_tone5", emojiToUnicodeString(0x001f3ca, 0x001f3ff));
    emojiShortcodeToUnicode.put("three", emojiToUnicodeString(0x000033, 0x0020e3));
    emojiShortcodeToUnicode.put("thumbsdown_tone1", emojiToUnicodeString(0x001f44e, 0x001f3fb));
    emojiShortcodeToUnicode.put("thumbsdown_tone2", emojiToUnicodeString(0x001f44e, 0x001f3fc));
    emojiShortcodeToUnicode.put("thumbsdown_tone3", emojiToUnicodeString(0x001f44e, 0x001f3fd));
    emojiShortcodeToUnicode.put("thumbsdown_tone4", emojiToUnicodeString(0x001f44e, 0x001f3fe));
    emojiShortcodeToUnicode.put("thumbsdown_tone5", emojiToUnicodeString(0x001f44e, 0x001f3ff));
    emojiShortcodeToUnicode.put("thumbsup_tone1", emojiToUnicodeString(0x001f44d, 0x001f3fb));
    emojiShortcodeToUnicode.put("thumbsup_tone2", emojiToUnicodeString(0x001f44d, 0x001f3fc));
    emojiShortcodeToUnicode.put("thumbsup_tone3", emojiToUnicodeString(0x001f44d, 0x001f3fd));
    emojiShortcodeToUnicode.put("thumbsup_tone4", emojiToUnicodeString(0x001f44d, 0x001f3fe));
    emojiShortcodeToUnicode.put("thumbsup_tone5", emojiToUnicodeString(0x001f44d, 0x001f3ff));
    emojiShortcodeToUnicode.put("two", emojiToUnicodeString(0x000032, 0x0020e3));
    emojiShortcodeToUnicode.put("uk", emojiToUnicodeString(0x001f1ec, 0x001f1e7));
    emojiShortcodeToUnicode.put("us", emojiToUnicodeString(0x001f1fa, 0x001f1f8));
    emojiShortcodeToUnicode.put("v_tone1", emojiToUnicodeString(0x00270c, 0x001f3fb));
    emojiShortcodeToUnicode.put("v_tone2", emojiToUnicodeString(0x00270c, 0x001f3fc));
    emojiShortcodeToUnicode.put("v_tone3", emojiToUnicodeString(0x00270c, 0x001f3fd));
    emojiShortcodeToUnicode.put("v_tone4", emojiToUnicodeString(0x00270c, 0x001f3fe));
    emojiShortcodeToUnicode.put("v_tone5", emojiToUnicodeString(0x00270c, 0x001f3ff));
    emojiShortcodeToUnicode.put("vulcan_tone1", emojiToUnicodeString(0x001f596, 0x001f3fb));
    emojiShortcodeToUnicode.put("vulcan_tone2", emojiToUnicodeString(0x001f596, 0x001f3fc));
    emojiShortcodeToUnicode.put("vulcan_tone3", emojiToUnicodeString(0x001f596, 0x001f3fd));
    emojiShortcodeToUnicode.put("vulcan_tone4", emojiToUnicodeString(0x001f596, 0x001f3fe));
    emojiShortcodeToUnicode.put("vulcan_tone5", emojiToUnicodeString(0x001f596, 0x001f3ff));
    emojiShortcodeToUnicode.put("walking_tone1", emojiToUnicodeString(0x001f6b6, 0x001f3fb));
    emojiShortcodeToUnicode.put("walking_tone2", emojiToUnicodeString(0x001f6b6, 0x001f3fc));
    emojiShortcodeToUnicode.put("walking_tone3", emojiToUnicodeString(0x001f6b6, 0x001f3fd));
    emojiShortcodeToUnicode.put("walking_tone4", emojiToUnicodeString(0x001f6b6, 0x001f3fe));
    emojiShortcodeToUnicode.put("walking_tone5", emojiToUnicodeString(0x001f6b6, 0x001f3ff));
    emojiShortcodeToUnicode.put("water_polo_tone1", emojiToUnicodeString(0x001f93d, 0x001f3fb));
    emojiShortcodeToUnicode.put("water_polo_tone2", emojiToUnicodeString(0x001f93d, 0x001f3fc));
    emojiShortcodeToUnicode.put("water_polo_tone3", emojiToUnicodeString(0x001f93d, 0x001f3fd));
    emojiShortcodeToUnicode.put("water_polo_tone4", emojiToUnicodeString(0x001f93d, 0x001f3fe));
    emojiShortcodeToUnicode.put("water_polo_tone5", emojiToUnicodeString(0x001f93d, 0x001f3ff));
    emojiShortcodeToUnicode.put("wave_tone1", emojiToUnicodeString(0x001f44b, 0x001f3fb));
    emojiShortcodeToUnicode.put("wave_tone2", emojiToUnicodeString(0x001f44b, 0x001f3fc));
    emojiShortcodeToUnicode.put("wave_tone3", emojiToUnicodeString(0x001f44b, 0x001f3fd));
    emojiShortcodeToUnicode.put("wave_tone4", emojiToUnicodeString(0x001f44b, 0x001f3fe));
    emojiShortcodeToUnicode.put("wave_tone5", emojiToUnicodeString(0x001f44b, 0x001f3ff));
    emojiShortcodeToUnicode.put("woman_tone1", emojiToUnicodeString(0x001f469, 0x001f3fb));
    emojiShortcodeToUnicode.put("woman_tone2", emojiToUnicodeString(0x001f469, 0x001f3fc));
    emojiShortcodeToUnicode.put("woman_tone3", emojiToUnicodeString(0x001f469, 0x001f3fd));
    emojiShortcodeToUnicode.put("woman_tone4", emojiToUnicodeString(0x001f469, 0x001f3fe));
    emojiShortcodeToUnicode.put("woman_tone5", emojiToUnicodeString(0x001f469, 0x001f3ff));
    emojiShortcodeToUnicode.put("wrestlers_tone1", emojiToUnicodeString(0x001f93c, 0x001f3fb));
    emojiShortcodeToUnicode.put("wrestlers_tone2", emojiToUnicodeString(0x001f93c, 0x001f3fc));
    emojiShortcodeToUnicode.put("wrestlers_tone3", emojiToUnicodeString(0x001f93c, 0x001f3fd));
    emojiShortcodeToUnicode.put("wrestlers_tone4", emojiToUnicodeString(0x001f93c, 0x001f3fe));
    emojiShortcodeToUnicode.put("wrestlers_tone5", emojiToUnicodeString(0x001f93c, 0x001f3ff));
    emojiShortcodeToUnicode.put("writing_hand_tone1", emojiToUnicodeString(0x00270d, 0x001f3fb));
    emojiShortcodeToUnicode.put("writing_hand_tone2", emojiToUnicodeString(0x00270d, 0x001f3fc));
    emojiShortcodeToUnicode.put("writing_hand_tone3", emojiToUnicodeString(0x00270d, 0x001f3fd));
    emojiShortcodeToUnicode.put("writing_hand_tone4", emojiToUnicodeString(0x00270d, 0x001f3fe));
    emojiShortcodeToUnicode.put("writing_hand_tone5", emojiToUnicodeString(0x00270d, 0x001f3ff));
    emojiShortcodeToUnicode.put("zero", emojiToUnicodeString(0x000030, 0x0020e3));
  }
}
