/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.markdown;

import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;
import org.symphonyoss.symphony.messageml.markdown.nodes.EmojiNode;

public class EmojiDelimiterProcessor
implements DelimiterProcessor {
    private final char delimiterChar = (char)58;

    protected EmojiDelimiterProcessor() {
    }

    public char getOpeningCharacter() {
        return this.delimiterChar;
    }

    public char getClosingCharacter() {
        return this.delimiterChar;
    }

    public int getMinLength() {
        return 1;
    }

    public int getDelimiterUse(DelimiterRun opener, DelimiterRun closer) {
        if (opener.length() >= 1 && closer.length() >= 1) {
            return 1;
        }
        return 0;
    }

    public void process(Text opener, Text closer, int delimiterUse) {
        EmojiNode emoji = null;
        Node text = opener.getNext();
        if (text instanceof Text) {
            emoji = new EmojiNode(((Text)text).getLiteral());
            text.unlink();
        }
        opener.insertAfter(emoji);
    }
}

