/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.w3c.dom.Node;

public abstract class Entity
extends Element {
    public static final String PRESENTATIONML_CLASS = "entity";
    public static final String ENTITY_ID_ATTR = "data-entity-id";
    public static final String TYPE_FIELD = "type";
    public static final String VALUE_FIELD = "value";
    public static final String ID_FIELD = "id";
    static final String DEFAULT_PRESENTATIONML_TAG = "span";
    static final String VERSION_FIELD = "version";
    String presentationMLTag = "span";
    String entityId;

    Entity(Element parent, String messageMLTag, String presentationMlTag, FormatEnum format) {
        super(parent, messageMLTag, format);
        this.presentationMLTag = presentationMlTag;
    }

    @Override
    protected void buildAttribute(Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "data-entity-id": {
                this.entityId = item.getTextContent();
                break;
            }
            default: {
                if (this.format == FormatEnum.PRESENTATIONML) {
                    super.buildAttribute(item);
                    break;
                }
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    @Override
    public ObjectNode asEntityJson(ObjectNode parent) {
        JsonNode entityNode = parent.path(this.entityId);
        if (entityNode.isMissingNode()) {
            ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
            node.put(TYPE_FIELD, this.getEntityType());
            node.put(VERSION_FIELD, this.getEntityVersion());
            ArrayNode idArray = new ArrayNode(JsonNodeFactory.instance);
            ObjectNode idNode = new ObjectNode(JsonNodeFactory.instance);
            idNode.put(TYPE_FIELD, this.getEntitySubType());
            idNode.put(VALUE_FIELD, this.getEntityValue());
            idArray.add((JsonNode)idNode);
            node.set(ID_FIELD, (JsonNode)idArray);
            parent.set(this.entityId, (JsonNode)node);
            return node;
        }
        return (ObjectNode)entityNode;
    }

    @Override
    public void validate() throws InvalidInputException {
        if (this.format == FormatEnum.PRESENTATIONML && this.entityId == null) {
            throw new InvalidInputException("The attribute \"data-entity-id\" is required");
        }
    }

    String getEntityId(int index) {
        return String.format("%s%s", this.getEntityIdPrefix(), index);
    }

    protected abstract String getEntityValue();

    protected abstract String getEntitySubType();

    protected abstract String getEntityVersion();

    protected abstract String getEntityType();

    protected abstract String getEntityIdPrefix();
}

