/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.Keyword;
import org.symphonyoss.symphony.messageml.markdown.nodes.KeywordNode;

public class HashTag
extends Keyword {
    public static final String MESSAGEML_TAG = "hash";
    public static final String PREFIX = "#";
    public static final String ENTITY_TYPE = "org.symphonyoss.taxonomy";
    private static final String ENTITY_SUBTYPE = "org.symphonyoss.taxonomy.hashtag";
    private static final String ENTITY_VERSION = "1.0";

    public HashTag(Element parent, int entityIndex) {
        super(parent, MESSAGEML_TAG, "span", FormatEnum.MESSAGEML);
        this.entityId = this.getEntityId(entityIndex);
    }

    public HashTag(Element parent, int entityIndex, String value) {
        super(parent, MESSAGEML_TAG, "span", FormatEnum.MESSAGEML);
        this.entityId = this.getEntityId(entityIndex);
        this.tag = value;
    }

    public HashTag(Element parent, String presentationMlTag, String value) {
        super(parent, MESSAGEML_TAG, presentationMlTag, FormatEnum.PRESENTATIONML);
        this.tag = value;
    }

    @Override
    public String asText() {
        return PREFIX + this.getTag();
    }

    @Override
    public Node asMarkdown() {
        return new KeywordNode(PREFIX, this.getTag());
    }

    @Override
    public String toString() {
        return "HashTag(" + this.getTag() + ")";
    }

    @Override
    protected String getEntitySubType() {
        return ENTITY_SUBTYPE;
    }

    @Override
    protected String getEntityVersion() {
        return ENTITY_VERSION;
    }

    @Override
    protected String getEntityType() {
        return ENTITY_TYPE;
    }
}

