/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.markdown;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BulletList;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Delimited;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Link;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.renderer.text.TextContentWriter;
import org.symphonyoss.symphony.messageml.markdown.nodes.EmojiNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.KeywordNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.MentionNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.PreformattedNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.TableCellNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.TableNode;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class MarkdownRenderer
extends AbstractVisitor {
    private static final String TEXT = "text";
    private static final String ID = "id";
    private static final String EXPANDED_URL = "expandedUrl";
    private static final String INDEX_START = "indexStart";
    private static final String INDEX_END = "indexEnd";
    private static final String TYPE = "type";
    private static final String URLS = "urls";
    private static final String SCREEN_NAME = "screenName";
    private static final String PRETTY_NAME = "prettyName";
    private static final String USER_TYPE = "userType";
    private static final String USER_MENTIONS = "userMentions";
    private static final String HASHTAGS = "hashtags";
    private final TrackingWriter writer = new TrackingWriter(new StringBuilder());
    private final ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
    private boolean removeNewlines = true;
    private Character bulletListMarker;
    private Integer orderedListCounter;
    private Character orderedListDelimiter;

    public MarkdownRenderer(Document document) {
        this.visit(document);
    }

    public void visit(Document document) {
        this.visitChildren((Node)document);
    }

    public void visit(Text text) {
        String content = text.getLiteral();
        if (this.removeNewlines) {
            content = XmlPrintStream.removeNewLines(content);
        }
        this.writer.write(content);
    }

    public void visit(HardLineBreak hardLineBreak) {
        this.writer.line();
    }

    public void visit(Paragraph paragraph) {
        this.writer.line();
        if (paragraph.getFirstChild() != null) {
            this.visitChildren((Node)paragraph);
            this.writer.line();
        }
    }

    public void visit(Emphasis em) {
        this.visitDelimited((Delimited)em);
    }

    public void visit(StrongEmphasis b) {
        this.visitDelimited((Delimited)b);
    }

    public void visit(Link a) {
        String href = a.getDestination();
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put(TEXT, href);
        node.put(ID, href);
        node.put(EXPANDED_URL, href);
        node.put(INDEX_START, this.writer.length());
        node.put(INDEX_END, this.writer.length() + href.length());
        node.put(TYPE, "URL");
        this.putJsonObject(URLS, (JsonNode)node);
        this.writer.write(href);
    }

    public void visit(BulletList ul) {
        this.writer.line();
        this.bulletListMarker = Character.valueOf(ul.getBulletMarker());
        this.visitChildren((Node)ul);
        this.writer.line();
        this.bulletListMarker = null;
        this.writer.line();
    }

    public void visit(OrderedList ol) {
        this.writer.line();
        this.orderedListCounter = ol.getStartNumber();
        this.orderedListDelimiter = Character.valueOf(ol.getDelimiter());
        this.visitChildren((Node)ol);
        this.writer.line();
        this.orderedListCounter = null;
        this.orderedListDelimiter = null;
        this.writer.line();
    }

    public void visit(ListItem li) {
        if (this.orderedListCounter != null) {
            this.writer.write(String.valueOf(this.orderedListCounter) + this.orderedListDelimiter + " ");
            this.visitChildren((Node)li);
            this.writer.line();
            Integer n = this.orderedListCounter;
            Integer n2 = this.orderedListCounter = Integer.valueOf(this.orderedListCounter + 1);
        } else if (this.bulletListMarker != null) {
            this.writer.write(this.bulletListMarker + " ");
            this.visitChildren((Node)li);
            this.writer.line();
        }
    }

    public void visit(CustomNode node) {
        if (node instanceof KeywordNode) {
            this.visit((KeywordNode)node);
        } else if (node instanceof EmojiNode) {
            this.visit((EmojiNode)node);
        } else if (node instanceof MentionNode) {
            this.visit((MentionNode)node);
        }
    }

    public void visit(CustomBlock node) {
        if (node instanceof TableNode) {
            this.visit((TableNode)node);
        } else if (node instanceof TableCellNode) {
            this.visit((TableCellNode)node);
        } else if (node instanceof PreformattedNode) {
            this.visit((PreformattedNode)node);
        }
    }

    private void visit(EmojiNode emoji) {
        this.writer.write(emoji.getOpeningDelimiter());
        this.writer.write(emoji.getAnnotation());
        this.writer.write(emoji.getClosingDelimiter());
    }

    private void visit(KeywordNode keyword) {
        String text = keyword.getPrefix() + keyword.getText();
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put(ID, text);
        node.put(TEXT, text);
        node.put(INDEX_START, this.writer.length());
        node.put(INDEX_END, this.writer.length() + text.length());
        node.put(TYPE, "KEYWORD");
        this.putJsonObject(HASHTAGS, (JsonNode)node);
        this.writer.write(text);
    }

    private void visit(MentionNode mention) {
        String text = mention.getText();
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put(ID, mention.getUid());
        node.put(SCREEN_NAME, mention.getScreenName());
        node.put(PRETTY_NAME, mention.getPrettyName());
        node.put(TEXT, text);
        node.put(INDEX_START, this.writer.length());
        node.put(INDEX_END, this.writer.length() + text.length());
        node.put(USER_TYPE, "lc");
        node.put(TYPE, "USER_FOLLOW");
        this.putJsonObject(USER_MENTIONS, (JsonNode)node);
        this.writer.write(text);
    }

    private void visit(TableNode table) {
        this.writer.write(table.getOpeningDelimiter());
        this.visitChildren((Node)table);
        this.writer.write(table.getClosingDelimiter());
        this.writer.line();
    }

    private void visit(TableCellNode cell) {
        this.visitChildren((Node)cell);
        if (cell.getNext() != null) {
            this.writer.write(cell.getDelimiter());
        }
    }

    private void visit(PreformattedNode pre) {
        this.removeNewlines = false;
        this.writer.write(pre.getOpeningDelimiter());
        this.visitChildren((Node)pre);
        this.writer.write(pre.getClosingDelimiter());
        this.writer.line();
        this.removeNewlines = true;
    }

    private void visitDelimited(Delimited delimited) {
        this.writer.write(delimited.getOpeningDelimiter());
        this.visitChildren((Node)delimited);
        this.writer.write(delimited.getClosingDelimiter());
    }

    private void putJsonObject(String field, JsonNode value) {
        if (!this.json.has(field)) {
            this.json.set(field, (JsonNode)new ArrayNode(JsonNodeFactory.instance));
        }
        ((ArrayNode)this.json.get(field)).add(value);
    }

    public String getText() {
        return this.writer.toString();
    }

    public ObjectNode getJson() {
        return this.json;
    }

    class TrackingWriter
    extends TextContentWriter {
        final StringBuilder out;

        TrackingWriter(StringBuilder out) {
            super((Appendable)out);
            this.out = out;
        }

        int length() {
            return this.out.length();
        }

        public String toString() {
            return this.out.toString();
        }
    }
}

