package org.symphonyoss.symphony.messageml.util;

import java.util.HashMap;
import java.util.Map;

/**
 * Class that contains HashMap which has conversion annotation -> unicode for all supported Emojis.
 *
 *  @author cristiadu
 * @since 10/10/17
 */
public class EmojiAnnotationToUnicode {

  private static final Map<String, String> emojiAnnotationToUnicode = new HashMap<>();
  private static final String DEFAULT_EMOJI = "smiley";

  public static String getUnicode(String annotation) {
    return (emojiAnnotationToUnicode.get(annotation) != null) ? emojiAnnotationToUnicode.get(annotation) : emojiAnnotationToUnicode.get(DEFAULT_EMOJI);
  }

  private static String emojiToUnicodeString(int... unicodes) {
    return new String(unicodes, 0, unicodes.length);
  }

  static {

    emojiAnnotationToUnicode.put("+1", emojiToUnicodeString(0x001F44D));
    emojiAnnotationToUnicode.put("-1", emojiToUnicodeString(0x001F44E));
    emojiAnnotationToUnicode.put("100", emojiToUnicodeString(0x001F4AF));
    emojiAnnotationToUnicode.put("1234", emojiToUnicodeString(0x001F522));
    emojiAnnotationToUnicode.put("8ball", emojiToUnicodeString(0x001F3B1));
    emojiAnnotationToUnicode.put("a", emojiToUnicodeString(0x001F170));
    emojiAnnotationToUnicode.put("ab", emojiToUnicodeString(0x001F18E));
    emojiAnnotationToUnicode.put("abc", emojiToUnicodeString(0x001F524));
    emojiAnnotationToUnicode.put("abcd", emojiToUnicodeString(0x001F521));
    emojiAnnotationToUnicode.put("accept", emojiToUnicodeString(0x001F251));
    emojiAnnotationToUnicode.put("aerial_tramway", emojiToUnicodeString(0x001F6A1));
    emojiAnnotationToUnicode.put("airplane", emojiToUnicodeString(0x0002708));
    emojiAnnotationToUnicode.put("alarm_clock", emojiToUnicodeString(0x00023F0));
    emojiAnnotationToUnicode.put("alien", emojiToUnicodeString(0x001F47D));
    emojiAnnotationToUnicode.put("ambulance", emojiToUnicodeString(0x001F691));
    emojiAnnotationToUnicode.put("anchor", emojiToUnicodeString(0x0002693));
    emojiAnnotationToUnicode.put("angel", emojiToUnicodeString(0x001F47C));
    emojiAnnotationToUnicode.put("anger", emojiToUnicodeString(0x001F4A2));
    emojiAnnotationToUnicode.put("angry", emojiToUnicodeString(0x001F620));
    emojiAnnotationToUnicode.put("anguished", emojiToUnicodeString(0x001F627));
    emojiAnnotationToUnicode.put("ant", emojiToUnicodeString(0x001F41C));
    emojiAnnotationToUnicode.put("apple", emojiToUnicodeString(0x001F34E));
    emojiAnnotationToUnicode.put("aquarius", emojiToUnicodeString(0x0002652));
    emojiAnnotationToUnicode.put("aries", emojiToUnicodeString(0x0002648));
    emojiAnnotationToUnicode.put("arrow_backward", emojiToUnicodeString(0x00025C0));
    emojiAnnotationToUnicode.put("arrow_double_down", emojiToUnicodeString(0x00023EC));
    emojiAnnotationToUnicode.put("arrow_double_up", emojiToUnicodeString(0x00023EB));
    emojiAnnotationToUnicode.put("arrow_down", emojiToUnicodeString(0x0002B07));
    emojiAnnotationToUnicode.put("arrow_down_small", emojiToUnicodeString(0x001F53D));
    emojiAnnotationToUnicode.put("arrow_forward", emojiToUnicodeString(0x00025B6));
    emojiAnnotationToUnicode.put("arrow_heading_down", emojiToUnicodeString(0x0002935));
    emojiAnnotationToUnicode.put("arrow_heading_up", emojiToUnicodeString(0x0002934));
    emojiAnnotationToUnicode.put("arrow_left", emojiToUnicodeString(0x0002B05));
    emojiAnnotationToUnicode.put("arrow_lower_left", emojiToUnicodeString(0x0002199));
    emojiAnnotationToUnicode.put("arrow_lower_right", emojiToUnicodeString(0x0002198));
    emojiAnnotationToUnicode.put("arrow_right", emojiToUnicodeString(0x00027A1));
    emojiAnnotationToUnicode.put("arrow_right_hook", emojiToUnicodeString(0x00021AA));
    emojiAnnotationToUnicode.put("arrow_up", emojiToUnicodeString(0x0002B06));
    emojiAnnotationToUnicode.put("arrow_up_down", emojiToUnicodeString(0x0002195));
    emojiAnnotationToUnicode.put("arrow_up_small", emojiToUnicodeString(0x001F53C));
    emojiAnnotationToUnicode.put("arrow_upper_left", emojiToUnicodeString(0x0002196));
    emojiAnnotationToUnicode.put("arrow_upper_right", emojiToUnicodeString(0x0002197));
    emojiAnnotationToUnicode.put("arrows_clockwise", emojiToUnicodeString(0x001F503));
    emojiAnnotationToUnicode.put("arrows_counterclockwise", emojiToUnicodeString(0x001F504));
    emojiAnnotationToUnicode.put("art", emojiToUnicodeString(0x001F3A8));
    emojiAnnotationToUnicode.put("articulated_lorry", emojiToUnicodeString(0x001F69B));
    emojiAnnotationToUnicode.put("astonished", emojiToUnicodeString(0x001F632));
    emojiAnnotationToUnicode.put("athletic_shoe", emojiToUnicodeString(0x001F45F));
    emojiAnnotationToUnicode.put("atm", emojiToUnicodeString(0x001F3E7));
    emojiAnnotationToUnicode.put("b", emojiToUnicodeString(0x001F171));
    emojiAnnotationToUnicode.put("baby", emojiToUnicodeString(0x001F476));
    emojiAnnotationToUnicode.put("baby_bottle", emojiToUnicodeString(0x001F37C));
    emojiAnnotationToUnicode.put("baby_chick", emojiToUnicodeString(0x001F424));
    emojiAnnotationToUnicode.put("baby_symbol", emojiToUnicodeString(0x001F6BC));
    emojiAnnotationToUnicode.put("back", emojiToUnicodeString(0x001F519));
    emojiAnnotationToUnicode.put("baggage_claim", emojiToUnicodeString(0x001F6C4));
    emojiAnnotationToUnicode.put("balloon", emojiToUnicodeString(0x001F388));
    emojiAnnotationToUnicode.put("ballot_box_with_check", emojiToUnicodeString(0x0002611));
    emojiAnnotationToUnicode.put("bamboo", emojiToUnicodeString(0x001F38D));
    emojiAnnotationToUnicode.put("banana", emojiToUnicodeString(0x001F34C));
    emojiAnnotationToUnicode.put("bangbang", emojiToUnicodeString(0x000203C));
    emojiAnnotationToUnicode.put("bank", emojiToUnicodeString(0x001F3E6));
    emojiAnnotationToUnicode.put("bar_chart", emojiToUnicodeString(0x001F4CA));
    emojiAnnotationToUnicode.put("barber", emojiToUnicodeString(0x001F488));
    emojiAnnotationToUnicode.put("baseball", emojiToUnicodeString(0x00026BE));
    emojiAnnotationToUnicode.put("basketball", emojiToUnicodeString(0x001F3C0));
    emojiAnnotationToUnicode.put("bath", emojiToUnicodeString(0x001F6C0));
    emojiAnnotationToUnicode.put("bathtub", emojiToUnicodeString(0x001F6C1));
    emojiAnnotationToUnicode.put("battery", emojiToUnicodeString(0x001F50B));
    emojiAnnotationToUnicode.put("bear", emojiToUnicodeString(0x001F43B));
    emojiAnnotationToUnicode.put("bee", emojiToUnicodeString(0x001F41D));
    emojiAnnotationToUnicode.put("beer", emojiToUnicodeString(0x001F37A));
    emojiAnnotationToUnicode.put("beers", emojiToUnicodeString(0x001F37B));
    emojiAnnotationToUnicode.put("beetle", emojiToUnicodeString(0x001F41E));
    emojiAnnotationToUnicode.put("beginner", emojiToUnicodeString(0x001F530));
    emojiAnnotationToUnicode.put("bell", emojiToUnicodeString(0x001F514));
    emojiAnnotationToUnicode.put("bento", emojiToUnicodeString(0x001F371));
    emojiAnnotationToUnicode.put("bicyclist", emojiToUnicodeString(0x001F6B4));
    emojiAnnotationToUnicode.put("bike", emojiToUnicodeString(0x001F6B2));
    emojiAnnotationToUnicode.put("bikini", emojiToUnicodeString(0x001F459));
    emojiAnnotationToUnicode.put("bird", emojiToUnicodeString(0x001F426));
    emojiAnnotationToUnicode.put("birthday", emojiToUnicodeString(0x001F382));
    emojiAnnotationToUnicode.put("black_circle", emojiToUnicodeString(0x00026AB));
    emojiAnnotationToUnicode.put("black_joker", emojiToUnicodeString(0x001F0CF));
    emojiAnnotationToUnicode.put("black_large_square", emojiToUnicodeString(0x0002B1B));
    emojiAnnotationToUnicode.put("black_medium_small_square", emojiToUnicodeString(0x00025FE));
    emojiAnnotationToUnicode.put("black_medium_square", emojiToUnicodeString(0x00025FC));
    emojiAnnotationToUnicode.put("black_nib", emojiToUnicodeString(0x0002712));
    emojiAnnotationToUnicode.put("black_small_square", emojiToUnicodeString(0x00025AA));
    emojiAnnotationToUnicode.put("black_square_button", emojiToUnicodeString(0x001F532));
    emojiAnnotationToUnicode.put("blossom", emojiToUnicodeString(0x001F33C));
    emojiAnnotationToUnicode.put("blowfish", emojiToUnicodeString(0x001F421));
    emojiAnnotationToUnicode.put("blue_book", emojiToUnicodeString(0x001F4D8));
    emojiAnnotationToUnicode.put("blue_car", emojiToUnicodeString(0x001F699));
    emojiAnnotationToUnicode.put("blue_heart", emojiToUnicodeString(0x001F499));
    emojiAnnotationToUnicode.put("blush", emojiToUnicodeString(0x001F60A));
    emojiAnnotationToUnicode.put("boar", emojiToUnicodeString(0x001F417));
    emojiAnnotationToUnicode.put("boat", emojiToUnicodeString(0x00026F5));
    emojiAnnotationToUnicode.put("bomb", emojiToUnicodeString(0x001F4A3));
    emojiAnnotationToUnicode.put("book", emojiToUnicodeString(0x001F4D6));
    emojiAnnotationToUnicode.put("bookmark", emojiToUnicodeString(0x001F516));
    emojiAnnotationToUnicode.put("bookmark_tabs", emojiToUnicodeString(0x001F4D1));
    emojiAnnotationToUnicode.put("books", emojiToUnicodeString(0x001F4DA));
    emojiAnnotationToUnicode.put("boom", emojiToUnicodeString(0x001F4A5));
    emojiAnnotationToUnicode.put("boot", emojiToUnicodeString(0x001F462));
    emojiAnnotationToUnicode.put("bouquet", emojiToUnicodeString(0x001F490));
    emojiAnnotationToUnicode.put("bow", emojiToUnicodeString(0x001F647));
    emojiAnnotationToUnicode.put("bowling", emojiToUnicodeString(0x001F3B3));
    emojiAnnotationToUnicode.put("boy", emojiToUnicodeString(0x001F466));
    emojiAnnotationToUnicode.put("bread", emojiToUnicodeString(0x001F35E));
    emojiAnnotationToUnicode.put("bride_with_veil", emojiToUnicodeString(0x001F470));
    emojiAnnotationToUnicode.put("bridge_at_night", emojiToUnicodeString(0x001F309));
    emojiAnnotationToUnicode.put("briefcase", emojiToUnicodeString(0x001F4BC));
    emojiAnnotationToUnicode.put("broken_heart", emojiToUnicodeString(0x001F494));
    emojiAnnotationToUnicode.put("bug", emojiToUnicodeString(0x001F41B));
    emojiAnnotationToUnicode.put("bulb", emojiToUnicodeString(0x001F4A1));
    emojiAnnotationToUnicode.put("bullettrain_front", emojiToUnicodeString(0x001F685));
    emojiAnnotationToUnicode.put("bullettrain_side", emojiToUnicodeString(0x001F684));
    emojiAnnotationToUnicode.put("bus", emojiToUnicodeString(0x001F68C));
    emojiAnnotationToUnicode.put("busstop", emojiToUnicodeString(0x001F68F));
    emojiAnnotationToUnicode.put("bust_in_silhouette", emojiToUnicodeString(0x001F464));
    emojiAnnotationToUnicode.put("busts_in_silhouette", emojiToUnicodeString(0x001F465));
    emojiAnnotationToUnicode.put("cactus", emojiToUnicodeString(0x001F335));
    emojiAnnotationToUnicode.put("cake", emojiToUnicodeString(0x001F370));
    emojiAnnotationToUnicode.put("calendar", emojiToUnicodeString(0x001F4C6));
    emojiAnnotationToUnicode.put("calling", emojiToUnicodeString(0x001F4F2));
    emojiAnnotationToUnicode.put("camel", emojiToUnicodeString(0x001F42B));
    emojiAnnotationToUnicode.put("camera", emojiToUnicodeString(0x001F4F7));
    emojiAnnotationToUnicode.put("cancer", emojiToUnicodeString(0x000264B));
    emojiAnnotationToUnicode.put("candy", emojiToUnicodeString(0x001F36C));
    emojiAnnotationToUnicode.put("capital_abcd", emojiToUnicodeString(0x001F520));
    emojiAnnotationToUnicode.put("capricorn", emojiToUnicodeString(0x0002651));
    emojiAnnotationToUnicode.put("car", emojiToUnicodeString(0x001F697));
    emojiAnnotationToUnicode.put("card_index", emojiToUnicodeString(0x001F4C7));
    emojiAnnotationToUnicode.put("carousel_horse", emojiToUnicodeString(0x001F3A0));
    emojiAnnotationToUnicode.put("cat", emojiToUnicodeString(0x001F431));
    emojiAnnotationToUnicode.put("cat2", emojiToUnicodeString(0x001F408));
    emojiAnnotationToUnicode.put("cd", emojiToUnicodeString(0x001F4BF));
    emojiAnnotationToUnicode.put("chart", emojiToUnicodeString(0x001F4B9));
    emojiAnnotationToUnicode.put("chart_with_downwards_trend", emojiToUnicodeString(0x001F4C9));
    emojiAnnotationToUnicode.put("chart_with_upwards_trend", emojiToUnicodeString(0x001F4C8));
    emojiAnnotationToUnicode.put("checkered_flag", emojiToUnicodeString(0x001F3C1));
    emojiAnnotationToUnicode.put("cherries", emojiToUnicodeString(0x001F352));
    emojiAnnotationToUnicode.put("cherry_blossom", emojiToUnicodeString(0x001F338));
    emojiAnnotationToUnicode.put("chestnut", emojiToUnicodeString(0x001F330));
    emojiAnnotationToUnicode.put("chicken", emojiToUnicodeString(0x001F414));
    emojiAnnotationToUnicode.put("children_crossing", emojiToUnicodeString(0x001F6B8));
    emojiAnnotationToUnicode.put("chocolate_bar", emojiToUnicodeString(0x001F36B));
    emojiAnnotationToUnicode.put("christmas_tree", emojiToUnicodeString(0x001F384));
    emojiAnnotationToUnicode.put("church", emojiToUnicodeString(0x00026EA));
    emojiAnnotationToUnicode.put("cinema", emojiToUnicodeString(0x001F3A6));
    emojiAnnotationToUnicode.put("circus_tent", emojiToUnicodeString(0x001F3AA));
    emojiAnnotationToUnicode.put("city_sunrise", emojiToUnicodeString(0x001F307));
    emojiAnnotationToUnicode.put("city_sunset", emojiToUnicodeString(0x001F306));
    emojiAnnotationToUnicode.put("cl", emojiToUnicodeString(0x001F191));
    emojiAnnotationToUnicode.put("clap", emojiToUnicodeString(0x001F44F));
    emojiAnnotationToUnicode.put("clapper", emojiToUnicodeString(0x001F3AC));
    emojiAnnotationToUnicode.put("clipboard", emojiToUnicodeString(0x001F4CB));
    emojiAnnotationToUnicode.put("clock1", emojiToUnicodeString(0x001F550));
    emojiAnnotationToUnicode.put("clock10", emojiToUnicodeString(0x001F559));
    emojiAnnotationToUnicode.put("clock1030", emojiToUnicodeString(0x001F565));
    emojiAnnotationToUnicode.put("clock11", emojiToUnicodeString(0x001F55A));
    emojiAnnotationToUnicode.put("clock1130", emojiToUnicodeString(0x001F566));
    emojiAnnotationToUnicode.put("clock12", emojiToUnicodeString(0x001F55B));
    emojiAnnotationToUnicode.put("clock1230", emojiToUnicodeString(0x001F567));
    emojiAnnotationToUnicode.put("clock130", emojiToUnicodeString(0x001F55C));
    emojiAnnotationToUnicode.put("clock2", emojiToUnicodeString(0x001F551));
    emojiAnnotationToUnicode.put("clock230", emojiToUnicodeString(0x001F55D));
    emojiAnnotationToUnicode.put("clock3", emojiToUnicodeString(0x001F552));
    emojiAnnotationToUnicode.put("clock330", emojiToUnicodeString(0x001F55E));
    emojiAnnotationToUnicode.put("clock4", emojiToUnicodeString(0x001F553));
    emojiAnnotationToUnicode.put("clock430", emojiToUnicodeString(0x001F55F));
    emojiAnnotationToUnicode.put("clock5", emojiToUnicodeString(0x001F554));
    emojiAnnotationToUnicode.put("clock530", emojiToUnicodeString(0x001F560));
    emojiAnnotationToUnicode.put("clock6", emojiToUnicodeString(0x001F555));
    emojiAnnotationToUnicode.put("clock630", emojiToUnicodeString(0x001F561));
    emojiAnnotationToUnicode.put("clock7", emojiToUnicodeString(0x001F556));
    emojiAnnotationToUnicode.put("clock730", emojiToUnicodeString(0x001F562));
    emojiAnnotationToUnicode.put("clock8", emojiToUnicodeString(0x001F557));
    emojiAnnotationToUnicode.put("clock830", emojiToUnicodeString(0x001F563));
    emojiAnnotationToUnicode.put("clock9", emojiToUnicodeString(0x001F558));
    emojiAnnotationToUnicode.put("clock930", emojiToUnicodeString(0x001F564));
    emojiAnnotationToUnicode.put("closed_book", emojiToUnicodeString(0x001F4D5));
    emojiAnnotationToUnicode.put("closed_lock_with_key", emojiToUnicodeString(0x001F510));
    emojiAnnotationToUnicode.put("closed_umbrella", emojiToUnicodeString(0x001F302));
    emojiAnnotationToUnicode.put("cloud", emojiToUnicodeString(0x0002601));
    emojiAnnotationToUnicode.put("clubs", emojiToUnicodeString(0x0002663));
    emojiAnnotationToUnicode.put("cocktail", emojiToUnicodeString(0x001F378));
    emojiAnnotationToUnicode.put("coffee", emojiToUnicodeString(0x0002615));
    emojiAnnotationToUnicode.put("cold_sweat", emojiToUnicodeString(0x001F630));
    emojiAnnotationToUnicode.put("collision", emojiToUnicodeString(0x001F4A5));
    emojiAnnotationToUnicode.put("computer", emojiToUnicodeString(0x001F4BB));
    emojiAnnotationToUnicode.put("confetti_ball", emojiToUnicodeString(0x001F38A));
    emojiAnnotationToUnicode.put("confounded", emojiToUnicodeString(0x001F616));
    emojiAnnotationToUnicode.put("confused", emojiToUnicodeString(0x001F615));
    emojiAnnotationToUnicode.put("congratulations", emojiToUnicodeString(0x0003297));
    emojiAnnotationToUnicode.put("construction", emojiToUnicodeString(0x001F6A7));
    emojiAnnotationToUnicode.put("construction_worker", emojiToUnicodeString(0x001F477));
    emojiAnnotationToUnicode.put("convenience_store", emojiToUnicodeString(0x001F3EA));
    emojiAnnotationToUnicode.put("cookie", emojiToUnicodeString(0x001F36A));
    emojiAnnotationToUnicode.put("cool", emojiToUnicodeString(0x001F192));
    emojiAnnotationToUnicode.put("cop", emojiToUnicodeString(0x001F46E));
    emojiAnnotationToUnicode.put("copyright", emojiToUnicodeString(0x00000A9));
    emojiAnnotationToUnicode.put("corn", emojiToUnicodeString(0x001F33D));
    emojiAnnotationToUnicode.put("couple", emojiToUnicodeString(0x001F46B));
    emojiAnnotationToUnicode.put("couple_with_heart", emojiToUnicodeString(0x001F491));
    emojiAnnotationToUnicode.put("couplekiss", emojiToUnicodeString(0x001F48F));
    emojiAnnotationToUnicode.put("cow", emojiToUnicodeString(0x001F42E));
    emojiAnnotationToUnicode.put("cow2", emojiToUnicodeString(0x001F404));
    emojiAnnotationToUnicode.put("credit_card", emojiToUnicodeString(0x001F4B3));
    emojiAnnotationToUnicode.put("crescent_moon", emojiToUnicodeString(0x001F319));
    emojiAnnotationToUnicode.put("crocodile", emojiToUnicodeString(0x001F40A));
    emojiAnnotationToUnicode.put("crossed_flags", emojiToUnicodeString(0x001F38C));
    emojiAnnotationToUnicode.put("crown", emojiToUnicodeString(0x001F451));
    emojiAnnotationToUnicode.put("cry", emojiToUnicodeString(0x001F622));
    emojiAnnotationToUnicode.put("crying_cat_face", emojiToUnicodeString(0x001F63F));
    emojiAnnotationToUnicode.put("crystal_ball", emojiToUnicodeString(0x001F52E));
    emojiAnnotationToUnicode.put("cupid", emojiToUnicodeString(0x001F498));
    emojiAnnotationToUnicode.put("curly_loop", emojiToUnicodeString(0x00027B0));
    emojiAnnotationToUnicode.put("currency_exchange", emojiToUnicodeString(0x001F4B1));
    emojiAnnotationToUnicode.put("curry", emojiToUnicodeString(0x001F35B));
    emojiAnnotationToUnicode.put("custard", emojiToUnicodeString(0x001F36E));
    emojiAnnotationToUnicode.put("customs", emojiToUnicodeString(0x001F6C3));
    emojiAnnotationToUnicode.put("cyclone", emojiToUnicodeString(0x001F300));
    emojiAnnotationToUnicode.put("dancer", emojiToUnicodeString(0x001F483));
    emojiAnnotationToUnicode.put("dancers", emojiToUnicodeString(0x001F46F));
    emojiAnnotationToUnicode.put("dango", emojiToUnicodeString(0x001F361));
    emojiAnnotationToUnicode.put("dart", emojiToUnicodeString(0x001F3AF));
    emojiAnnotationToUnicode.put("dash", emojiToUnicodeString(0x001F4A8));
    emojiAnnotationToUnicode.put("date", emojiToUnicodeString(0x001F4C5));
    emojiAnnotationToUnicode.put("deciduous_tree", emojiToUnicodeString(0x001F333));
    emojiAnnotationToUnicode.put("department_store", emojiToUnicodeString(0x001F3EC));
    emojiAnnotationToUnicode.put("diamond_shape_with_a_dot_inside", emojiToUnicodeString(0x001F4A0));
    emojiAnnotationToUnicode.put("diamonds", emojiToUnicodeString(0x0002666));
    emojiAnnotationToUnicode.put("disappointed", emojiToUnicodeString(0x001F61E));
    emojiAnnotationToUnicode.put("disappointed_relieved", emojiToUnicodeString(0x001F625));
    emojiAnnotationToUnicode.put("dizzy", emojiToUnicodeString(0x001F4AB));
    emojiAnnotationToUnicode.put("dizzy_face", emojiToUnicodeString(0x001F635));
    emojiAnnotationToUnicode.put("do_not_litter", emojiToUnicodeString(0x001F6AF));
    emojiAnnotationToUnicode.put("dog", emojiToUnicodeString(0x001F436));
    emojiAnnotationToUnicode.put("dog2", emojiToUnicodeString(0x001F415));
    emojiAnnotationToUnicode.put("dollar", emojiToUnicodeString(0x001F4B5));
    emojiAnnotationToUnicode.put("dolls", emojiToUnicodeString(0x001F38E));
    emojiAnnotationToUnicode.put("dolphin", emojiToUnicodeString(0x001F42C));
    emojiAnnotationToUnicode.put("door", emojiToUnicodeString(0x001F6AA));
    emojiAnnotationToUnicode.put("doughnut", emojiToUnicodeString(0x001F369));
    emojiAnnotationToUnicode.put("dragon", emojiToUnicodeString(0x001F409));
    emojiAnnotationToUnicode.put("dragon_face", emojiToUnicodeString(0x001F432));
    emojiAnnotationToUnicode.put("dress", emojiToUnicodeString(0x001F457));
    emojiAnnotationToUnicode.put("dromedary_camel", emojiToUnicodeString(0x001F42A));
    emojiAnnotationToUnicode.put("droplet", emojiToUnicodeString(0x001F4A7));
    emojiAnnotationToUnicode.put("dvd", emojiToUnicodeString(0x001F4C0));
    emojiAnnotationToUnicode.put("e-mail", emojiToUnicodeString(0x001F4E7));
    emojiAnnotationToUnicode.put("ear", emojiToUnicodeString(0x001F442));
    emojiAnnotationToUnicode.put("ear_of_rice", emojiToUnicodeString(0x001F33E));
    emojiAnnotationToUnicode.put("earth_africa", emojiToUnicodeString(0x001F30D));
    emojiAnnotationToUnicode.put("earth_americas", emojiToUnicodeString(0x001F30E));
    emojiAnnotationToUnicode.put("earth_asia", emojiToUnicodeString(0x001F30F));
    emojiAnnotationToUnicode.put("egg", emojiToUnicodeString(0x001F373));
    emojiAnnotationToUnicode.put("eggplant", emojiToUnicodeString(0x001F346));
    emojiAnnotationToUnicode.put("eight_pointed_black_star", emojiToUnicodeString(0x0002734));
    emojiAnnotationToUnicode.put("eight_spoked_asterisk", emojiToUnicodeString(0x0002733));
    emojiAnnotationToUnicode.put("electric_plug", emojiToUnicodeString(0x001F50C));
    emojiAnnotationToUnicode.put("elephant", emojiToUnicodeString(0x001F418));
    emojiAnnotationToUnicode.put("email", emojiToUnicodeString(0x0002709));
    emojiAnnotationToUnicode.put("end", emojiToUnicodeString(0x001F51A));
    emojiAnnotationToUnicode.put("envelope", emojiToUnicodeString(0x0002709));
    emojiAnnotationToUnicode.put("envelope_with_arrow", emojiToUnicodeString(0x001F4E9));
    emojiAnnotationToUnicode.put("euro", emojiToUnicodeString(0x001F4B6));
    emojiAnnotationToUnicode.put("european_castle", emojiToUnicodeString(0x001F3F0));
    emojiAnnotationToUnicode.put("european_post_office", emojiToUnicodeString(0x001F3E4));
    emojiAnnotationToUnicode.put("evergreen_tree", emojiToUnicodeString(0x001F332));
    emojiAnnotationToUnicode.put("exclamation", emojiToUnicodeString(0x0002757));
    emojiAnnotationToUnicode.put("expressionless", emojiToUnicodeString(0x001F611));
    emojiAnnotationToUnicode.put("eyeglasses", emojiToUnicodeString(0x001F453));
    emojiAnnotationToUnicode.put("eyes", emojiToUnicodeString(0x001F440));
    emojiAnnotationToUnicode.put("facepunch", emojiToUnicodeString(0x001F44A));
    emojiAnnotationToUnicode.put("factory", emojiToUnicodeString(0x001F3ED));
    emojiAnnotationToUnicode.put("fallen_leaf", emojiToUnicodeString(0x001F342));
    emojiAnnotationToUnicode.put("family", emojiToUnicodeString(0x001F46A));
    emojiAnnotationToUnicode.put("fast_forward", emojiToUnicodeString(0x00023E9));
    emojiAnnotationToUnicode.put("fax", emojiToUnicodeString(0x001F4E0));
    emojiAnnotationToUnicode.put("fearful", emojiToUnicodeString(0x001F628));
    emojiAnnotationToUnicode.put("feet", emojiToUnicodeString(0x001F43E));
    emojiAnnotationToUnicode.put("ferris_wheel", emojiToUnicodeString(0x001F3A1));
    emojiAnnotationToUnicode.put("file_folder", emojiToUnicodeString(0x001F4C1));
    emojiAnnotationToUnicode.put("fire", emojiToUnicodeString(0x001F525));
    emojiAnnotationToUnicode.put("fire_engine", emojiToUnicodeString(0x001F692));
    emojiAnnotationToUnicode.put("fireworks", emojiToUnicodeString(0x001F386));
    emojiAnnotationToUnicode.put("first_quarter_moon", emojiToUnicodeString(0x001F313));
    emojiAnnotationToUnicode.put("first_quarter_moon_with_face", emojiToUnicodeString(0x001F31B));
    emojiAnnotationToUnicode.put("fish", emojiToUnicodeString(0x001F41F));
    emojiAnnotationToUnicode.put("fish_cake", emojiToUnicodeString(0x001F365));
    emojiAnnotationToUnicode.put("fishing_pole_and_fish", emojiToUnicodeString(0x001F3A3));
    emojiAnnotationToUnicode.put("fist", emojiToUnicodeString(0x000270A));
    emojiAnnotationToUnicode.put("flags", emojiToUnicodeString(0x001F38F));
    emojiAnnotationToUnicode.put("flashlight", emojiToUnicodeString(0x001F526));
    emojiAnnotationToUnicode.put("flipper", emojiToUnicodeString(0x001F42C));
    emojiAnnotationToUnicode.put("floppy_disk", emojiToUnicodeString(0x001F4BE));
    emojiAnnotationToUnicode.put("flower_playing_cards", emojiToUnicodeString(0x001F3B4));
    emojiAnnotationToUnicode.put("flushed", emojiToUnicodeString(0x001F633));
    emojiAnnotationToUnicode.put("foggy", emojiToUnicodeString(0x001F301));
    emojiAnnotationToUnicode.put("football", emojiToUnicodeString(0x001F3C8));
    emojiAnnotationToUnicode.put("footprints", emojiToUnicodeString(0x001F463));
    emojiAnnotationToUnicode.put("fork_and_knife", emojiToUnicodeString(0x001F374));
    emojiAnnotationToUnicode.put("fountain", emojiToUnicodeString(0x00026F2));
    emojiAnnotationToUnicode.put("four_leaf_clover", emojiToUnicodeString(0x001F340));
    emojiAnnotationToUnicode.put("free", emojiToUnicodeString(0x001F193));
    emojiAnnotationToUnicode.put("fried_shrimp", emojiToUnicodeString(0x001F364));
    emojiAnnotationToUnicode.put("fries", emojiToUnicodeString(0x001F35F));
    emojiAnnotationToUnicode.put("frog", emojiToUnicodeString(0x001F438));
    emojiAnnotationToUnicode.put("frowning", emojiToUnicodeString(0x001F626));
    emojiAnnotationToUnicode.put("fuelpump", emojiToUnicodeString(0x00026FD));
    emojiAnnotationToUnicode.put("full_moon", emojiToUnicodeString(0x001F315));
    emojiAnnotationToUnicode.put("full_moon_with_face", emojiToUnicodeString(0x001F31D));
    emojiAnnotationToUnicode.put("game_die", emojiToUnicodeString(0x001F3B2));
    emojiAnnotationToUnicode.put("gem", emojiToUnicodeString(0x001F48E));
    emojiAnnotationToUnicode.put("gemini", emojiToUnicodeString(0x000264A));
    emojiAnnotationToUnicode.put("ghost", emojiToUnicodeString(0x001F47B));
    emojiAnnotationToUnicode.put("gift", emojiToUnicodeString(0x001F381));
    emojiAnnotationToUnicode.put("gift_heart", emojiToUnicodeString(0x001F49D));
    emojiAnnotationToUnicode.put("girl", emojiToUnicodeString(0x001F467));
    emojiAnnotationToUnicode.put("globe_with_meridians", emojiToUnicodeString(0x001F310));
    emojiAnnotationToUnicode.put("goat", emojiToUnicodeString(0x001F410));
    emojiAnnotationToUnicode.put("golf", emojiToUnicodeString(0x00026F3));
    emojiAnnotationToUnicode.put("grapes", emojiToUnicodeString(0x001F347));
    emojiAnnotationToUnicode.put("green_apple", emojiToUnicodeString(0x001F34F));
    emojiAnnotationToUnicode.put("green_book", emojiToUnicodeString(0x001F4D7));
    emojiAnnotationToUnicode.put("green_heart", emojiToUnicodeString(0x001F49A));
    emojiAnnotationToUnicode.put("grey_exclamation", emojiToUnicodeString(0x0002755));
    emojiAnnotationToUnicode.put("grey_question", emojiToUnicodeString(0x0002754));
    emojiAnnotationToUnicode.put("grimacing", emojiToUnicodeString(0x001F62C));
    emojiAnnotationToUnicode.put("grin", emojiToUnicodeString(0x001F601));
    emojiAnnotationToUnicode.put("grinning", emojiToUnicodeString(0x001F600));
    emojiAnnotationToUnicode.put("guardsman", emojiToUnicodeString(0x001F482));
    emojiAnnotationToUnicode.put("guitar", emojiToUnicodeString(0x001F3B8));
    emojiAnnotationToUnicode.put("gun", emojiToUnicodeString(0x001F52B));
    emojiAnnotationToUnicode.put("haircut", emojiToUnicodeString(0x001F487));
    emojiAnnotationToUnicode.put("hamburger", emojiToUnicodeString(0x001F354));
    emojiAnnotationToUnicode.put("hammer", emojiToUnicodeString(0x001F528));
    emojiAnnotationToUnicode.put("hamster", emojiToUnicodeString(0x001F439));
    emojiAnnotationToUnicode.put("hand", emojiToUnicodeString(0x000270B));
    emojiAnnotationToUnicode.put("handbag", emojiToUnicodeString(0x001F45C));
    emojiAnnotationToUnicode.put("hankey", emojiToUnicodeString(0x001F4A9));
    emojiAnnotationToUnicode.put("hatched_chick", emojiToUnicodeString(0x001F425));
    emojiAnnotationToUnicode.put("hatching_chick", emojiToUnicodeString(0x001F423));
    emojiAnnotationToUnicode.put("headphones", emojiToUnicodeString(0x001F3A7));
    emojiAnnotationToUnicode.put("hear_no_evil", emojiToUnicodeString(0x001F649));
    emojiAnnotationToUnicode.put("heart", emojiToUnicodeString(0x0002764));
    emojiAnnotationToUnicode.put("heart_decoration", emojiToUnicodeString(0x001F49F));
    emojiAnnotationToUnicode.put("heart_eyes", emojiToUnicodeString(0x001F60D));
    emojiAnnotationToUnicode.put("heart_eyes_cat", emojiToUnicodeString(0x001F63B));
    emojiAnnotationToUnicode.put("heartbeat", emojiToUnicodeString(0x001F493));
    emojiAnnotationToUnicode.put("heartpulse", emojiToUnicodeString(0x001F497));
    emojiAnnotationToUnicode.put("hearts", emojiToUnicodeString(0x0002665));
    emojiAnnotationToUnicode.put("heavy_check_mark", emojiToUnicodeString(0x0002714));
    emojiAnnotationToUnicode.put("heavy_division_sign", emojiToUnicodeString(0x0002797));
    emojiAnnotationToUnicode.put("heavy_dollar_sign", emojiToUnicodeString(0x001F4B2));
    emojiAnnotationToUnicode.put("heavy_exclamation_mark", emojiToUnicodeString(0x0002757));
    emojiAnnotationToUnicode.put("heavy_minus_sign", emojiToUnicodeString(0x0002796));
    emojiAnnotationToUnicode.put("heavy_multiplication_x", emojiToUnicodeString(0x0002716));
    emojiAnnotationToUnicode.put("heavy_plus_sign", emojiToUnicodeString(0x0002795));
    emojiAnnotationToUnicode.put("helicopter", emojiToUnicodeString(0x001F681));
    emojiAnnotationToUnicode.put("herb", emojiToUnicodeString(0x001F33F));
    emojiAnnotationToUnicode.put("hibiscus", emojiToUnicodeString(0x001F33A));
    emojiAnnotationToUnicode.put("high_brightness", emojiToUnicodeString(0x001F506));
    emojiAnnotationToUnicode.put("high_heel", emojiToUnicodeString(0x001F460));
    emojiAnnotationToUnicode.put("hocho", emojiToUnicodeString(0x001F52A));
    emojiAnnotationToUnicode.put("honey_pot", emojiToUnicodeString(0x001F36F));
    emojiAnnotationToUnicode.put("honeybee", emojiToUnicodeString(0x001F41D));
    emojiAnnotationToUnicode.put("horse", emojiToUnicodeString(0x001F434));
    emojiAnnotationToUnicode.put("horse_racing", emojiToUnicodeString(0x001F3C7));
    emojiAnnotationToUnicode.put("hospital", emojiToUnicodeString(0x001F3E5));
    emojiAnnotationToUnicode.put("hotel", emojiToUnicodeString(0x001F3E8));
    emojiAnnotationToUnicode.put("hotsprings", emojiToUnicodeString(0x0002668));
    emojiAnnotationToUnicode.put("hourglass", emojiToUnicodeString(0x000231B));
    emojiAnnotationToUnicode.put("hourglass_flowing_sand", emojiToUnicodeString(0x00023F3));
    emojiAnnotationToUnicode.put("house", emojiToUnicodeString(0x001F3E0));
    emojiAnnotationToUnicode.put("house_with_garden", emojiToUnicodeString(0x001F3E1));
    emojiAnnotationToUnicode.put("hushed", emojiToUnicodeString(0x001F62F));
    emojiAnnotationToUnicode.put("ice_cream", emojiToUnicodeString(0x001F368));
    emojiAnnotationToUnicode.put("icecream", emojiToUnicodeString(0x001F366));
    emojiAnnotationToUnicode.put("id", emojiToUnicodeString(0x001F194));
    emojiAnnotationToUnicode.put("ideograph_advantage", emojiToUnicodeString(0x001F250));
    emojiAnnotationToUnicode.put("imp", emojiToUnicodeString(0x001F47F));
    emojiAnnotationToUnicode.put("inbox_tray", emojiToUnicodeString(0x001F4E5));
    emojiAnnotationToUnicode.put("incoming_envelope", emojiToUnicodeString(0x001F4E8));
    emojiAnnotationToUnicode.put("information_desk_person", emojiToUnicodeString(0x001F481));
    emojiAnnotationToUnicode.put("information_source", emojiToUnicodeString(0x0002139));
    emojiAnnotationToUnicode.put("innocent", emojiToUnicodeString(0x001F607));
    emojiAnnotationToUnicode.put("interrobang", emojiToUnicodeString(0x0002049));
    emojiAnnotationToUnicode.put("iphone", emojiToUnicodeString(0x001F4F1));
    emojiAnnotationToUnicode.put("izakaya_lantern", emojiToUnicodeString(0x001F3EE));
    emojiAnnotationToUnicode.put("jack_o_lantern", emojiToUnicodeString(0x001F383));
    emojiAnnotationToUnicode.put("japan", emojiToUnicodeString(0x001F5FE));
    emojiAnnotationToUnicode.put("japanese_castle", emojiToUnicodeString(0x001F3EF));
    emojiAnnotationToUnicode.put("japanese_goblin", emojiToUnicodeString(0x001F47A));
    emojiAnnotationToUnicode.put("japanese_ogre", emojiToUnicodeString(0x001F479));
    emojiAnnotationToUnicode.put("jeans", emojiToUnicodeString(0x001F456));
    emojiAnnotationToUnicode.put("joy", emojiToUnicodeString(0x001F602));
    emojiAnnotationToUnicode.put("joy_cat", emojiToUnicodeString(0x001F639));
    emojiAnnotationToUnicode.put("key", emojiToUnicodeString(0x001F511));
    emojiAnnotationToUnicode.put("keycap_ten", emojiToUnicodeString(0x001F51F));
    emojiAnnotationToUnicode.put("kimono", emojiToUnicodeString(0x001F458));
    emojiAnnotationToUnicode.put("kiss", emojiToUnicodeString(0x001F48B));
    emojiAnnotationToUnicode.put("kissing", emojiToUnicodeString(0x001F617));
    emojiAnnotationToUnicode.put("kissing_cat", emojiToUnicodeString(0x001F63D));
    emojiAnnotationToUnicode.put("kissing_closed_eyes", emojiToUnicodeString(0x001F61A));
    emojiAnnotationToUnicode.put("kissing_heart", emojiToUnicodeString(0x001F618));
    emojiAnnotationToUnicode.put("kissing_smiling_eyes", emojiToUnicodeString(0x001F619));
    emojiAnnotationToUnicode.put("koala", emojiToUnicodeString(0x001F428));
    emojiAnnotationToUnicode.put("koko", emojiToUnicodeString(0x001F201));
    emojiAnnotationToUnicode.put("lantern", emojiToUnicodeString(0x001F3EE));
    emojiAnnotationToUnicode.put("large_blue_circle", emojiToUnicodeString(0x001F535));
    emojiAnnotationToUnicode.put("large_blue_diamond", emojiToUnicodeString(0x001F537));
    emojiAnnotationToUnicode.put("large_orange_diamond", emojiToUnicodeString(0x001F536));
    emojiAnnotationToUnicode.put("last_quarter_moon", emojiToUnicodeString(0x001F317));
    emojiAnnotationToUnicode.put("last_quarter_moon_with_face", emojiToUnicodeString(0x001F31C));
    emojiAnnotationToUnicode.put("laughing", emojiToUnicodeString(0x001F606));
    emojiAnnotationToUnicode.put("leaves", emojiToUnicodeString(0x001F343));
    emojiAnnotationToUnicode.put("ledger", emojiToUnicodeString(0x001F4D2));
    emojiAnnotationToUnicode.put("left_luggage", emojiToUnicodeString(0x001F6C5));
    emojiAnnotationToUnicode.put("left_right_arrow", emojiToUnicodeString(0x0002194));
    emojiAnnotationToUnicode.put("leftwards_arrow_with_hook", emojiToUnicodeString(0x00021A9));
    emojiAnnotationToUnicode.put("lemon", emojiToUnicodeString(0x001F34B));
    emojiAnnotationToUnicode.put("leo", emojiToUnicodeString(0x000264C));
    emojiAnnotationToUnicode.put("leopard", emojiToUnicodeString(0x001F406));
    emojiAnnotationToUnicode.put("libra", emojiToUnicodeString(0x000264E));
    emojiAnnotationToUnicode.put("light_rail", emojiToUnicodeString(0x001F688));
    emojiAnnotationToUnicode.put("link", emojiToUnicodeString(0x001F517));
    emojiAnnotationToUnicode.put("lips", emojiToUnicodeString(0x001F444));
    emojiAnnotationToUnicode.put("lipstick", emojiToUnicodeString(0x001F484));
    emojiAnnotationToUnicode.put("lock", emojiToUnicodeString(0x001F512));
    emojiAnnotationToUnicode.put("lock_with_ink_pen", emojiToUnicodeString(0x001F50F));
    emojiAnnotationToUnicode.put("lollipop", emojiToUnicodeString(0x001F36D));
    emojiAnnotationToUnicode.put("loop", emojiToUnicodeString(0x00027BF));
    emojiAnnotationToUnicode.put("loudspeaker", emojiToUnicodeString(0x001F4E2));
    emojiAnnotationToUnicode.put("love_hotel", emojiToUnicodeString(0x001F3E9));
    emojiAnnotationToUnicode.put("love_letter", emojiToUnicodeString(0x001F48C));
    emojiAnnotationToUnicode.put("low_brightness", emojiToUnicodeString(0x001F505));
    emojiAnnotationToUnicode.put("m", emojiToUnicodeString(0x00024C2));
    emojiAnnotationToUnicode.put("mag", emojiToUnicodeString(0x001F50D));
    emojiAnnotationToUnicode.put("mag_right", emojiToUnicodeString(0x001F50E));
    emojiAnnotationToUnicode.put("mahjong", emojiToUnicodeString(0x001F004));
    emojiAnnotationToUnicode.put("mailbox", emojiToUnicodeString(0x001F4EB));
    emojiAnnotationToUnicode.put("mailbox_closed", emojiToUnicodeString(0x001F4EA));
    emojiAnnotationToUnicode.put("mailbox_with_mail", emojiToUnicodeString(0x001F4EC));
    emojiAnnotationToUnicode.put("mailbox_with_no_mail", emojiToUnicodeString(0x001F4ED));
    emojiAnnotationToUnicode.put("man", emojiToUnicodeString(0x001F468));
    emojiAnnotationToUnicode.put("man_with_gua_pi_mao", emojiToUnicodeString(0x001F472));
    emojiAnnotationToUnicode.put("man_with_turban", emojiToUnicodeString(0x001F473));
    emojiAnnotationToUnicode.put("mans_shoe", emojiToUnicodeString(0x001F45E));
    emojiAnnotationToUnicode.put("maple_leaf", emojiToUnicodeString(0x001F341));
    emojiAnnotationToUnicode.put("mask", emojiToUnicodeString(0x001F637));
    emojiAnnotationToUnicode.put("massage", emojiToUnicodeString(0x001F486));
    emojiAnnotationToUnicode.put("meat_on_bone", emojiToUnicodeString(0x001F356));
    emojiAnnotationToUnicode.put("mega", emojiToUnicodeString(0x001F4E3));
    emojiAnnotationToUnicode.put("melon", emojiToUnicodeString(0x001F348));
    emojiAnnotationToUnicode.put("memo", emojiToUnicodeString(0x001F4DD));
    emojiAnnotationToUnicode.put("mens", emojiToUnicodeString(0x001F6B9));
    emojiAnnotationToUnicode.put("metro", emojiToUnicodeString(0x001F687));
    emojiAnnotationToUnicode.put("microphone", emojiToUnicodeString(0x001F3A4));
    emojiAnnotationToUnicode.put("microscope", emojiToUnicodeString(0x001F52C));
    emojiAnnotationToUnicode.put("milky_way", emojiToUnicodeString(0x001F30C));
    emojiAnnotationToUnicode.put("minibus", emojiToUnicodeString(0x001F690));
    emojiAnnotationToUnicode.put("minidisc", emojiToUnicodeString(0x001F4BD));
    emojiAnnotationToUnicode.put("mobile_phone_off", emojiToUnicodeString(0x001F4F4));
    emojiAnnotationToUnicode.put("money_with_wings", emojiToUnicodeString(0x001F4B8));
    emojiAnnotationToUnicode.put("moneybag", emojiToUnicodeString(0x001F4B0));
    emojiAnnotationToUnicode.put("monkey", emojiToUnicodeString(0x001F412));
    emojiAnnotationToUnicode.put("monkey_face", emojiToUnicodeString(0x001F435));
    emojiAnnotationToUnicode.put("monorail", emojiToUnicodeString(0x001F69D));
    emojiAnnotationToUnicode.put("moon", emojiToUnicodeString(0x001F314));
    emojiAnnotationToUnicode.put("mortar_board", emojiToUnicodeString(0x001F393));
    emojiAnnotationToUnicode.put("mount_fuji", emojiToUnicodeString(0x001F5FB));
    emojiAnnotationToUnicode.put("mountain_bicyclist", emojiToUnicodeString(0x001F6B5));
    emojiAnnotationToUnicode.put("mountain_cableway", emojiToUnicodeString(0x001F6A0));
    emojiAnnotationToUnicode.put("mountain_railway", emojiToUnicodeString(0x001F69E));
    emojiAnnotationToUnicode.put("mouse", emojiToUnicodeString(0x001F42D));
    emojiAnnotationToUnicode.put("mouse2", emojiToUnicodeString(0x001F401));
    emojiAnnotationToUnicode.put("movie_camera", emojiToUnicodeString(0x001F3A5));
    emojiAnnotationToUnicode.put("moyai", emojiToUnicodeString(0x001F5FF));
    emojiAnnotationToUnicode.put("muscle", emojiToUnicodeString(0x001F4AA));
    emojiAnnotationToUnicode.put("mushroom", emojiToUnicodeString(0x001F344));
    emojiAnnotationToUnicode.put("musical_keyboard", emojiToUnicodeString(0x001F3B9));
    emojiAnnotationToUnicode.put("musical_note", emojiToUnicodeString(0x001F3B5));
    emojiAnnotationToUnicode.put("musical_score", emojiToUnicodeString(0x001F3BC));
    emojiAnnotationToUnicode.put("mute", emojiToUnicodeString(0x001F507));
    emojiAnnotationToUnicode.put("nail_care", emojiToUnicodeString(0x001F485));
    emojiAnnotationToUnicode.put("name_badge", emojiToUnicodeString(0x001F4DB));
    emojiAnnotationToUnicode.put("necktie", emojiToUnicodeString(0x001F454));
    emojiAnnotationToUnicode.put("negative_squared_cross_mark", emojiToUnicodeString(0x000274E));
    emojiAnnotationToUnicode.put("neutral_face", emojiToUnicodeString(0x001F610));
    emojiAnnotationToUnicode.put("new", emojiToUnicodeString(0x001F195));
    emojiAnnotationToUnicode.put("new_moon", emojiToUnicodeString(0x001F311));
    emojiAnnotationToUnicode.put("new_moon_with_face", emojiToUnicodeString(0x001F31A));
    emojiAnnotationToUnicode.put("newspaper", emojiToUnicodeString(0x001F4F0));
    emojiAnnotationToUnicode.put("ng", emojiToUnicodeString(0x001F196));
    emojiAnnotationToUnicode.put("no_bell", emojiToUnicodeString(0x001F515));
    emojiAnnotationToUnicode.put("no_bicycles", emojiToUnicodeString(0x001F6B3));
    emojiAnnotationToUnicode.put("no_entry", emojiToUnicodeString(0x00026D4));
    emojiAnnotationToUnicode.put("no_entry_sign", emojiToUnicodeString(0x001F6AB));
    emojiAnnotationToUnicode.put("no_good", emojiToUnicodeString(0x001F645));
    emojiAnnotationToUnicode.put("no_mobile_phones", emojiToUnicodeString(0x001F4F5));
    emojiAnnotationToUnicode.put("no_mouth", emojiToUnicodeString(0x001F636));
    emojiAnnotationToUnicode.put("no_pedestrians", emojiToUnicodeString(0x001F6B7));
    emojiAnnotationToUnicode.put("no_smoking", emojiToUnicodeString(0x001F6AD));
    emojiAnnotationToUnicode.put("non-potable_water", emojiToUnicodeString(0x001F6B1));
    emojiAnnotationToUnicode.put("nose", emojiToUnicodeString(0x001F443));
    emojiAnnotationToUnicode.put("notebook", emojiToUnicodeString(0x001F4D3));
    emojiAnnotationToUnicode.put("notebook_with_decorative_cover", emojiToUnicodeString(0x001F4D4));
    emojiAnnotationToUnicode.put("notes", emojiToUnicodeString(0x001F3B6));
    emojiAnnotationToUnicode.put("nut_and_bolt", emojiToUnicodeString(0x001F529));
    emojiAnnotationToUnicode.put("o", emojiToUnicodeString(0x0002B55));
    emojiAnnotationToUnicode.put("o2", emojiToUnicodeString(0x001F17E));
    emojiAnnotationToUnicode.put("ocean", emojiToUnicodeString(0x001F30A));
    emojiAnnotationToUnicode.put("octopus", emojiToUnicodeString(0x001F419));
    emojiAnnotationToUnicode.put("oden", emojiToUnicodeString(0x001F362));
    emojiAnnotationToUnicode.put("office", emojiToUnicodeString(0x001F3E2));
    emojiAnnotationToUnicode.put("ok", emojiToUnicodeString(0x001F197));
    emojiAnnotationToUnicode.put("ok_hand", emojiToUnicodeString(0x001F44C));
    emojiAnnotationToUnicode.put("ok_woman", emojiToUnicodeString(0x001F646));
    emojiAnnotationToUnicode.put("older_man", emojiToUnicodeString(0x001F474));
    emojiAnnotationToUnicode.put("older_woman", emojiToUnicodeString(0x001F475));
    emojiAnnotationToUnicode.put("on", emojiToUnicodeString(0x001F51B));
    emojiAnnotationToUnicode.put("oncoming_automobile", emojiToUnicodeString(0x001F698));
    emojiAnnotationToUnicode.put("oncoming_bus", emojiToUnicodeString(0x001F68D));
    emojiAnnotationToUnicode.put("oncoming_police_car", emojiToUnicodeString(0x001F694));
    emojiAnnotationToUnicode.put("oncoming_taxi", emojiToUnicodeString(0x001F696));
    emojiAnnotationToUnicode.put("open_book", emojiToUnicodeString(0x001F4D6));
    emojiAnnotationToUnicode.put("open_file_folder", emojiToUnicodeString(0x001F4C2));
    emojiAnnotationToUnicode.put("open_hands", emojiToUnicodeString(0x001F450));
    emojiAnnotationToUnicode.put("open_mouth", emojiToUnicodeString(0x001F62E));
    emojiAnnotationToUnicode.put("ophiuchus", emojiToUnicodeString(0x00026CE));
    emojiAnnotationToUnicode.put("orange_book", emojiToUnicodeString(0x001F4D9));
    emojiAnnotationToUnicode.put("outbox_tray", emojiToUnicodeString(0x001F4E4));
    emojiAnnotationToUnicode.put("ox", emojiToUnicodeString(0x001F402));
    emojiAnnotationToUnicode.put("package", emojiToUnicodeString(0x001F4E6));
    emojiAnnotationToUnicode.put("page_facing_up", emojiToUnicodeString(0x001F4C4));
    emojiAnnotationToUnicode.put("page_with_curl", emojiToUnicodeString(0x001F4C3));
    emojiAnnotationToUnicode.put("pager", emojiToUnicodeString(0x001F4DF));
    emojiAnnotationToUnicode.put("palm_tree", emojiToUnicodeString(0x001F334));
    emojiAnnotationToUnicode.put("panda_face", emojiToUnicodeString(0x001F43C));
    emojiAnnotationToUnicode.put("paperclip", emojiToUnicodeString(0x001F4CE));
    emojiAnnotationToUnicode.put("parking", emojiToUnicodeString(0x001F17F));
    emojiAnnotationToUnicode.put("part_alternation_mark", emojiToUnicodeString(0x000303D));
    emojiAnnotationToUnicode.put("partly_sunny", emojiToUnicodeString(0x00026C5));
    emojiAnnotationToUnicode.put("passport_control", emojiToUnicodeString(0x001F6C2));
    emojiAnnotationToUnicode.put("paw_prints", emojiToUnicodeString(0x001F43E));
    emojiAnnotationToUnicode.put("peach", emojiToUnicodeString(0x001F351));
    emojiAnnotationToUnicode.put("pear", emojiToUnicodeString(0x001F350));
    emojiAnnotationToUnicode.put("pencil", emojiToUnicodeString(0x001F4DD));
    emojiAnnotationToUnicode.put("pencil2", emojiToUnicodeString(0x000270F));
    emojiAnnotationToUnicode.put("penguin", emojiToUnicodeString(0x001F427));
    emojiAnnotationToUnicode.put("pensive", emojiToUnicodeString(0x001F614));
    emojiAnnotationToUnicode.put("performing_arts", emojiToUnicodeString(0x001F3AD));
    emojiAnnotationToUnicode.put("persevere", emojiToUnicodeString(0x001F623));
    emojiAnnotationToUnicode.put("person_frowning", emojiToUnicodeString(0x001F64D));
    emojiAnnotationToUnicode.put("person_with_blond_hair", emojiToUnicodeString(0x001F471));
    emojiAnnotationToUnicode.put("person_with_pouting_face", emojiToUnicodeString(0x001F64E));
    emojiAnnotationToUnicode.put("phone", emojiToUnicodeString(0x000260E));
    emojiAnnotationToUnicode.put("pig", emojiToUnicodeString(0x001F437));
    emojiAnnotationToUnicode.put("pig2", emojiToUnicodeString(0x001F416));
    emojiAnnotationToUnicode.put("pig_nose", emojiToUnicodeString(0x001F43D));
    emojiAnnotationToUnicode.put("pill", emojiToUnicodeString(0x001F48A));
    emojiAnnotationToUnicode.put("pineapple", emojiToUnicodeString(0x001F34D));
    emojiAnnotationToUnicode.put("pisces", emojiToUnicodeString(0x0002653));
    emojiAnnotationToUnicode.put("pizza", emojiToUnicodeString(0x001F355));
    emojiAnnotationToUnicode.put("point_down", emojiToUnicodeString(0x001F447));
    emojiAnnotationToUnicode.put("point_left", emojiToUnicodeString(0x001F448));
    emojiAnnotationToUnicode.put("point_right", emojiToUnicodeString(0x001F449));
    emojiAnnotationToUnicode.put("point_up", emojiToUnicodeString(0x000261D));
    emojiAnnotationToUnicode.put("point_up_2", emojiToUnicodeString(0x001F446));
    emojiAnnotationToUnicode.put("police_car", emojiToUnicodeString(0x001F693));
    emojiAnnotationToUnicode.put("poodle", emojiToUnicodeString(0x001F429));
    emojiAnnotationToUnicode.put("poop", emojiToUnicodeString(0x001F4A9));
    emojiAnnotationToUnicode.put("post_office", emojiToUnicodeString(0x001F3E3));
    emojiAnnotationToUnicode.put("postal_horn", emojiToUnicodeString(0x001F4EF));
    emojiAnnotationToUnicode.put("postbox", emojiToUnicodeString(0x001F4EE));
    emojiAnnotationToUnicode.put("potable_water", emojiToUnicodeString(0x001F6B0));
    emojiAnnotationToUnicode.put("pouch", emojiToUnicodeString(0x001F45D));
    emojiAnnotationToUnicode.put("poultry_leg", emojiToUnicodeString(0x001F357));
    emojiAnnotationToUnicode.put("pound", emojiToUnicodeString(0x001F4B7));
    emojiAnnotationToUnicode.put("pouting_cat", emojiToUnicodeString(0x001F63E));
    emojiAnnotationToUnicode.put("pray", emojiToUnicodeString(0x001F64F));
    emojiAnnotationToUnicode.put("princess", emojiToUnicodeString(0x001F478));
    emojiAnnotationToUnicode.put("punch", emojiToUnicodeString(0x001F44A));
    emojiAnnotationToUnicode.put("purple_heart", emojiToUnicodeString(0x001F49C));
    emojiAnnotationToUnicode.put("purse", emojiToUnicodeString(0x001F45B));
    emojiAnnotationToUnicode.put("pushpin", emojiToUnicodeString(0x001F4CC));
    emojiAnnotationToUnicode.put("put_litter_in_its_place", emojiToUnicodeString(0x001F6AE));
    emojiAnnotationToUnicode.put("question", emojiToUnicodeString(0x0002753));
    emojiAnnotationToUnicode.put("rabbit", emojiToUnicodeString(0x001F430));
    emojiAnnotationToUnicode.put("rabbit2", emojiToUnicodeString(0x001F407));
    emojiAnnotationToUnicode.put("racehorse", emojiToUnicodeString(0x001F40E));
    emojiAnnotationToUnicode.put("radio", emojiToUnicodeString(0x001F4FB));
    emojiAnnotationToUnicode.put("radio_button", emojiToUnicodeString(0x001F518));
    emojiAnnotationToUnicode.put("rage", emojiToUnicodeString(0x001F621));
    emojiAnnotationToUnicode.put("railway_car", emojiToUnicodeString(0x001F683));
    emojiAnnotationToUnicode.put("rainbow", emojiToUnicodeString(0x001F308));
    emojiAnnotationToUnicode.put("raised_hand", emojiToUnicodeString(0x000270B));
    emojiAnnotationToUnicode.put("raised_hands", emojiToUnicodeString(0x001F64C));
    emojiAnnotationToUnicode.put("raising_hand", emojiToUnicodeString(0x001F64B));
    emojiAnnotationToUnicode.put("ram", emojiToUnicodeString(0x001F40F));
    emojiAnnotationToUnicode.put("ramen", emojiToUnicodeString(0x001F35C));
    emojiAnnotationToUnicode.put("rat", emojiToUnicodeString(0x001F400));
    emojiAnnotationToUnicode.put("recycle", emojiToUnicodeString(0x000267B));
    emojiAnnotationToUnicode.put("red_car", emojiToUnicodeString(0x001F697));
    emojiAnnotationToUnicode.put("red_circle", emojiToUnicodeString(0x001F534));
    emojiAnnotationToUnicode.put("registered", emojiToUnicodeString(0x00000AE));
    emojiAnnotationToUnicode.put("relaxed", emojiToUnicodeString(0x000263A));
    emojiAnnotationToUnicode.put("relieved", emojiToUnicodeString(0x001F60C));
    emojiAnnotationToUnicode.put("repeat", emojiToUnicodeString(0x001F501));
    emojiAnnotationToUnicode.put("repeat_one", emojiToUnicodeString(0x001F502));
    emojiAnnotationToUnicode.put("restroom", emojiToUnicodeString(0x001F6BB));
    emojiAnnotationToUnicode.put("revolving_hearts", emojiToUnicodeString(0x001F49E));
    emojiAnnotationToUnicode.put("rewind", emojiToUnicodeString(0x00023EA));
    emojiAnnotationToUnicode.put("ribbon", emojiToUnicodeString(0x001F380));
    emojiAnnotationToUnicode.put("rice", emojiToUnicodeString(0x001F35A));
    emojiAnnotationToUnicode.put("rice_ball", emojiToUnicodeString(0x001F359));
    emojiAnnotationToUnicode.put("rice_cracker", emojiToUnicodeString(0x001F358));
    emojiAnnotationToUnicode.put("rice_scene", emojiToUnicodeString(0x001F391));
    emojiAnnotationToUnicode.put("ring", emojiToUnicodeString(0x001F48D));
    emojiAnnotationToUnicode.put("rocket", emojiToUnicodeString(0x001F680));
    emojiAnnotationToUnicode.put("roller_coaster", emojiToUnicodeString(0x001F3A2));
    emojiAnnotationToUnicode.put("rooster", emojiToUnicodeString(0x001F413));
    emojiAnnotationToUnicode.put("rose", emojiToUnicodeString(0x001F339));
    emojiAnnotationToUnicode.put("rotating_light", emojiToUnicodeString(0x001F6A8));
    emojiAnnotationToUnicode.put("round_pushpin", emojiToUnicodeString(0x001F4CD));
    emojiAnnotationToUnicode.put("rowboat", emojiToUnicodeString(0x001F6A3));
    emojiAnnotationToUnicode.put("rugby_football", emojiToUnicodeString(0x001F3C9));
    emojiAnnotationToUnicode.put("runner", emojiToUnicodeString(0x001F3C3));
    emojiAnnotationToUnicode.put("running", emojiToUnicodeString(0x001F3C3));
    emojiAnnotationToUnicode.put("running_shirt_with_sash", emojiToUnicodeString(0x001F3BD));
    emojiAnnotationToUnicode.put("sa", emojiToUnicodeString(0x001F202));
    emojiAnnotationToUnicode.put("sagittarius", emojiToUnicodeString(0x0002650));
    emojiAnnotationToUnicode.put("sailboat", emojiToUnicodeString(0x00026F5));
    emojiAnnotationToUnicode.put("sake", emojiToUnicodeString(0x001F376));
    emojiAnnotationToUnicode.put("sandal", emojiToUnicodeString(0x001F461));
    emojiAnnotationToUnicode.put("santa", emojiToUnicodeString(0x001F385));
    emojiAnnotationToUnicode.put("satellite", emojiToUnicodeString(0x001F4E1));
    emojiAnnotationToUnicode.put("satisfied", emojiToUnicodeString(0x001F606));
    emojiAnnotationToUnicode.put("saxophone", emojiToUnicodeString(0x001F3B7));
    emojiAnnotationToUnicode.put("school", emojiToUnicodeString(0x001F3EB));
    emojiAnnotationToUnicode.put("school_satchel", emojiToUnicodeString(0x001F392));
    emojiAnnotationToUnicode.put("scissors", emojiToUnicodeString(0x0002702));
    emojiAnnotationToUnicode.put("scorpius", emojiToUnicodeString(0x000264F));
    emojiAnnotationToUnicode.put("scream", emojiToUnicodeString(0x001F631));
    emojiAnnotationToUnicode.put("scream_cat", emojiToUnicodeString(0x001F640));
    emojiAnnotationToUnicode.put("scroll", emojiToUnicodeString(0x001F4DC));
    emojiAnnotationToUnicode.put("seat", emojiToUnicodeString(0x001F4BA));
    emojiAnnotationToUnicode.put("secret", emojiToUnicodeString(0x0003299));
    emojiAnnotationToUnicode.put("see_no_evil", emojiToUnicodeString(0x001F648));
    emojiAnnotationToUnicode.put("seedling", emojiToUnicodeString(0x001F331));
    emojiAnnotationToUnicode.put("shaved_ice", emojiToUnicodeString(0x001F367));
    emojiAnnotationToUnicode.put("sheep", emojiToUnicodeString(0x001F411));
    emojiAnnotationToUnicode.put("shell", emojiToUnicodeString(0x001F41A));
    emojiAnnotationToUnicode.put("ship", emojiToUnicodeString(0x001F6A2));
    emojiAnnotationToUnicode.put("shirt", emojiToUnicodeString(0x001F455));
    emojiAnnotationToUnicode.put("shit", emojiToUnicodeString(0x001F4A9));
    emojiAnnotationToUnicode.put("shoe", emojiToUnicodeString(0x001F45E));
    emojiAnnotationToUnicode.put("shower", emojiToUnicodeString(0x001F6BF));
    emojiAnnotationToUnicode.put("signal_strength", emojiToUnicodeString(0x001F4F6));
    emojiAnnotationToUnicode.put("six_pointed_star", emojiToUnicodeString(0x001F52F));
    emojiAnnotationToUnicode.put("ski", emojiToUnicodeString(0x001F3BF));
    emojiAnnotationToUnicode.put("skull", emojiToUnicodeString(0x001F480));
    emojiAnnotationToUnicode.put("sleeping", emojiToUnicodeString(0x001F634));
    emojiAnnotationToUnicode.put("sleepy", emojiToUnicodeString(0x001F62A));
    emojiAnnotationToUnicode.put("slot_machine", emojiToUnicodeString(0x001F3B0));
    emojiAnnotationToUnicode.put("small_blue_diamond", emojiToUnicodeString(0x001F539));
    emojiAnnotationToUnicode.put("small_orange_diamond", emojiToUnicodeString(0x001F538));
    emojiAnnotationToUnicode.put("small_red_triangle", emojiToUnicodeString(0x001F53A));
    emojiAnnotationToUnicode.put("small_red_triangle_down", emojiToUnicodeString(0x001F53B));
    emojiAnnotationToUnicode.put("smile", emojiToUnicodeString(0x001F604));
    emojiAnnotationToUnicode.put("smile_cat", emojiToUnicodeString(0x001F638));
    emojiAnnotationToUnicode.put("smiley", emojiToUnicodeString(0x001F603));
    emojiAnnotationToUnicode.put("smiley_cat", emojiToUnicodeString(0x001F63A));
    emojiAnnotationToUnicode.put("smiling_imp", emojiToUnicodeString(0x001F608));
    emojiAnnotationToUnicode.put("smirk", emojiToUnicodeString(0x001F60F));
    emojiAnnotationToUnicode.put("smirk_cat", emojiToUnicodeString(0x001F63C));
    emojiAnnotationToUnicode.put("smoking", emojiToUnicodeString(0x001F6AC));
    emojiAnnotationToUnicode.put("snail", emojiToUnicodeString(0x001F40C));
    emojiAnnotationToUnicode.put("snake", emojiToUnicodeString(0x001F40D));
    emojiAnnotationToUnicode.put("snowboarder", emojiToUnicodeString(0x001F3C2));
    emojiAnnotationToUnicode.put("snowflake", emojiToUnicodeString(0x0002744));
    emojiAnnotationToUnicode.put("snowman", emojiToUnicodeString(0x00026C4));
    emojiAnnotationToUnicode.put("sob", emojiToUnicodeString(0x001F62D));
    emojiAnnotationToUnicode.put("soccer", emojiToUnicodeString(0x00026BD));
    emojiAnnotationToUnicode.put("soon", emojiToUnicodeString(0x001F51C));
    emojiAnnotationToUnicode.put("sos", emojiToUnicodeString(0x001F198));
    emojiAnnotationToUnicode.put("sound", emojiToUnicodeString(0x001F509));
    emojiAnnotationToUnicode.put("space_invader", emojiToUnicodeString(0x001F47E));
    emojiAnnotationToUnicode.put("spades", emojiToUnicodeString(0x0002660));
    emojiAnnotationToUnicode.put("spaghetti", emojiToUnicodeString(0x001F35D));
    emojiAnnotationToUnicode.put("sparkle", emojiToUnicodeString(0x0002747));
    emojiAnnotationToUnicode.put("sparkler", emojiToUnicodeString(0x001F387));
    emojiAnnotationToUnicode.put("sparkles", emojiToUnicodeString(0x0002728));
    emojiAnnotationToUnicode.put("sparkling_heart", emojiToUnicodeString(0x001F496));
    emojiAnnotationToUnicode.put("speak_no_evil", emojiToUnicodeString(0x001F64A));
    emojiAnnotationToUnicode.put("speaker", emojiToUnicodeString(0x001F50A));
    emojiAnnotationToUnicode.put("speech_balloon", emojiToUnicodeString(0x001F4AC));
    emojiAnnotationToUnicode.put("speedboat", emojiToUnicodeString(0x001F6A4));
    emojiAnnotationToUnicode.put("star", emojiToUnicodeString(0x0002B50));
    emojiAnnotationToUnicode.put("star2", emojiToUnicodeString(0x001F31F));
    emojiAnnotationToUnicode.put("stars", emojiToUnicodeString(0x001F303));
    emojiAnnotationToUnicode.put("station", emojiToUnicodeString(0x001F689));
    emojiAnnotationToUnicode.put("statue_of_liberty", emojiToUnicodeString(0x001F5FD));
    emojiAnnotationToUnicode.put("steam_locomotive", emojiToUnicodeString(0x001F682));
    emojiAnnotationToUnicode.put("stew", emojiToUnicodeString(0x001F372));
    emojiAnnotationToUnicode.put("straight_ruler", emojiToUnicodeString(0x001F4CF));
    emojiAnnotationToUnicode.put("strawberry", emojiToUnicodeString(0x001F353));
    emojiAnnotationToUnicode.put("stuck_out_tongue", emojiToUnicodeString(0x001F61B));
    emojiAnnotationToUnicode.put("stuck_out_tongue_closed_eyes", emojiToUnicodeString(0x001F61D));
    emojiAnnotationToUnicode.put("stuck_out_tongue_winking_eye", emojiToUnicodeString(0x001F61C));
    emojiAnnotationToUnicode.put("sun_with_face", emojiToUnicodeString(0x001F31E));
    emojiAnnotationToUnicode.put("sunflower", emojiToUnicodeString(0x001F33B));
    emojiAnnotationToUnicode.put("sunglasses", emojiToUnicodeString(0x001F60E));
    emojiAnnotationToUnicode.put("sunny", emojiToUnicodeString(0x0002600));
    emojiAnnotationToUnicode.put("sunrise", emojiToUnicodeString(0x001F305));
    emojiAnnotationToUnicode.put("sunrise_over_mountains", emojiToUnicodeString(0x001F304));
    emojiAnnotationToUnicode.put("surfer", emojiToUnicodeString(0x001F3C4));
    emojiAnnotationToUnicode.put("sushi", emojiToUnicodeString(0x001F363));
    emojiAnnotationToUnicode.put("suspension_railway", emojiToUnicodeString(0x001F69F));
    emojiAnnotationToUnicode.put("sweat", emojiToUnicodeString(0x001F613));
    emojiAnnotationToUnicode.put("sweat_drops", emojiToUnicodeString(0x001F4A6));
    emojiAnnotationToUnicode.put("sweat_smile", emojiToUnicodeString(0x001F605));
    emojiAnnotationToUnicode.put("sweet_potato", emojiToUnicodeString(0x001F360));
    emojiAnnotationToUnicode.put("swimmer", emojiToUnicodeString(0x001F3CA));
    emojiAnnotationToUnicode.put("symbols", emojiToUnicodeString(0x001F523));
    emojiAnnotationToUnicode.put("syringe", emojiToUnicodeString(0x001F489));
    emojiAnnotationToUnicode.put("tada", emojiToUnicodeString(0x001F389));
    emojiAnnotationToUnicode.put("tanabata_tree", emojiToUnicodeString(0x001F38B));
    emojiAnnotationToUnicode.put("tangerine", emojiToUnicodeString(0x001F34A));
    emojiAnnotationToUnicode.put("taurus", emojiToUnicodeString(0x0002649));
    emojiAnnotationToUnicode.put("taxi", emojiToUnicodeString(0x001F695));
    emojiAnnotationToUnicode.put("tea", emojiToUnicodeString(0x001F375));
    emojiAnnotationToUnicode.put("telephone", emojiToUnicodeString(0x000260E));
    emojiAnnotationToUnicode.put("telephone_receiver", emojiToUnicodeString(0x001F4DE));
    emojiAnnotationToUnicode.put("telescope", emojiToUnicodeString(0x001F52D));
    emojiAnnotationToUnicode.put("tennis", emojiToUnicodeString(0x001F3BE));
    emojiAnnotationToUnicode.put("tent", emojiToUnicodeString(0x00026FA));
    emojiAnnotationToUnicode.put("thought_balloon", emojiToUnicodeString(0x001F4AD));
    emojiAnnotationToUnicode.put("thumbsdown", emojiToUnicodeString(0x001F44E));
    emojiAnnotationToUnicode.put("thumbsup", emojiToUnicodeString(0x001F44D));
    emojiAnnotationToUnicode.put("ticket", emojiToUnicodeString(0x001F3AB));
    emojiAnnotationToUnicode.put("tiger", emojiToUnicodeString(0x001F42F));
    emojiAnnotationToUnicode.put("tiger2", emojiToUnicodeString(0x001F405));
    emojiAnnotationToUnicode.put("tired_face", emojiToUnicodeString(0x001F62B));
    emojiAnnotationToUnicode.put("tm", emojiToUnicodeString(0x0002122));
    emojiAnnotationToUnicode.put("toilet", emojiToUnicodeString(0x001F6BD));
    emojiAnnotationToUnicode.put("tokyo_tower", emojiToUnicodeString(0x001F5FC));
    emojiAnnotationToUnicode.put("tomato", emojiToUnicodeString(0x001F345));
    emojiAnnotationToUnicode.put("tongue", emojiToUnicodeString(0x001F445));
    emojiAnnotationToUnicode.put("top", emojiToUnicodeString(0x001F51D));
    emojiAnnotationToUnicode.put("tophat", emojiToUnicodeString(0x001F3A9));
    emojiAnnotationToUnicode.put("tractor", emojiToUnicodeString(0x001F69C));
    emojiAnnotationToUnicode.put("traffic_light", emojiToUnicodeString(0x001F6A5));
    emojiAnnotationToUnicode.put("train", emojiToUnicodeString(0x001F683));
    emojiAnnotationToUnicode.put("train2", emojiToUnicodeString(0x001F686));
    emojiAnnotationToUnicode.put("tram", emojiToUnicodeString(0x001F68A));
    emojiAnnotationToUnicode.put("triangular_flag_on_post", emojiToUnicodeString(0x001F6A9));
    emojiAnnotationToUnicode.put("triangular_ruler", emojiToUnicodeString(0x001F4D0));
    emojiAnnotationToUnicode.put("trident", emojiToUnicodeString(0x001F531));
    emojiAnnotationToUnicode.put("triumph", emojiToUnicodeString(0x001F624));
    emojiAnnotationToUnicode.put("trolleybus", emojiToUnicodeString(0x001F68E));
    emojiAnnotationToUnicode.put("trophy", emojiToUnicodeString(0x001F3C6));
    emojiAnnotationToUnicode.put("tropical_drink", emojiToUnicodeString(0x001F379));
    emojiAnnotationToUnicode.put("tropical_fish", emojiToUnicodeString(0x001F420));
    emojiAnnotationToUnicode.put("truck", emojiToUnicodeString(0x001F69A));
    emojiAnnotationToUnicode.put("trumpet", emojiToUnicodeString(0x001F3BA));
    emojiAnnotationToUnicode.put("tshirt", emojiToUnicodeString(0x001F455));
    emojiAnnotationToUnicode.put("tulip", emojiToUnicodeString(0x001F337));
    emojiAnnotationToUnicode.put("turtle", emojiToUnicodeString(0x001F422));
    emojiAnnotationToUnicode.put("tv", emojiToUnicodeString(0x001F4FA));
    emojiAnnotationToUnicode.put("twisted_rightwards_arrows", emojiToUnicodeString(0x001F500));
    emojiAnnotationToUnicode.put("two_hearts", emojiToUnicodeString(0x001F495));
    emojiAnnotationToUnicode.put("two_men_holding_hands", emojiToUnicodeString(0x001F46C));
    emojiAnnotationToUnicode.put("two_women_holding_hands", emojiToUnicodeString(0x001F46D));
    emojiAnnotationToUnicode.put("u5272", emojiToUnicodeString(0x001F239));
    emojiAnnotationToUnicode.put("u5408", emojiToUnicodeString(0x001F234));
    emojiAnnotationToUnicode.put("u55b6", emojiToUnicodeString(0x001F23A));
    emojiAnnotationToUnicode.put("u6307", emojiToUnicodeString(0x001F22F));
    emojiAnnotationToUnicode.put("u6708", emojiToUnicodeString(0x001F237));
    emojiAnnotationToUnicode.put("u6709", emojiToUnicodeString(0x001F236));
    emojiAnnotationToUnicode.put("u6e80", emojiToUnicodeString(0x001F235));
    emojiAnnotationToUnicode.put("u7121", emojiToUnicodeString(0x001F21A));
    emojiAnnotationToUnicode.put("u7533", emojiToUnicodeString(0x001F238));
    emojiAnnotationToUnicode.put("u7981", emojiToUnicodeString(0x001F232));
    emojiAnnotationToUnicode.put("u7a7a", emojiToUnicodeString(0x001F233));
    emojiAnnotationToUnicode.put("umbrella", emojiToUnicodeString(0x0002614));
    emojiAnnotationToUnicode.put("unamused", emojiToUnicodeString(0x001F612));
    emojiAnnotationToUnicode.put("underage", emojiToUnicodeString(0x001F51E));
    emojiAnnotationToUnicode.put("unlock", emojiToUnicodeString(0x001F513));
    emojiAnnotationToUnicode.put("up", emojiToUnicodeString(0x001F199));
    emojiAnnotationToUnicode.put("v", emojiToUnicodeString(0x000270C));
    emojiAnnotationToUnicode.put("vertical_traffic_light", emojiToUnicodeString(0x001F6A6));
    emojiAnnotationToUnicode.put("vhs", emojiToUnicodeString(0x001F4FC));
    emojiAnnotationToUnicode.put("vibration_mode", emojiToUnicodeString(0x001F4F3));
    emojiAnnotationToUnicode.put("video_camera", emojiToUnicodeString(0x001F4F9));
    emojiAnnotationToUnicode.put("video_game", emojiToUnicodeString(0x001F3AE));
    emojiAnnotationToUnicode.put("violin", emojiToUnicodeString(0x001F3BB));
    emojiAnnotationToUnicode.put("virgo", emojiToUnicodeString(0x000264D));
    emojiAnnotationToUnicode.put("volcano", emojiToUnicodeString(0x001F30B));
    emojiAnnotationToUnicode.put("vs", emojiToUnicodeString(0x001F19A));
    emojiAnnotationToUnicode.put("walking", emojiToUnicodeString(0x001F6B6));
    emojiAnnotationToUnicode.put("waning_crescent_moon", emojiToUnicodeString(0x001F318));
    emojiAnnotationToUnicode.put("waning_gibbous_moon", emojiToUnicodeString(0x001F316));
    emojiAnnotationToUnicode.put("warning", emojiToUnicodeString(0x00026A0));
    emojiAnnotationToUnicode.put("watch", emojiToUnicodeString(0x000231A));
    emojiAnnotationToUnicode.put("water_buffalo", emojiToUnicodeString(0x001F403));
    emojiAnnotationToUnicode.put("watermelon", emojiToUnicodeString(0x001F349));
    emojiAnnotationToUnicode.put("wave", emojiToUnicodeString(0x001F44B));
    emojiAnnotationToUnicode.put("wavy_dash", emojiToUnicodeString(0x0003030));
    emojiAnnotationToUnicode.put("waxing_crescent_moon", emojiToUnicodeString(0x001F312));
    emojiAnnotationToUnicode.put("waxing_gibbous_moon", emojiToUnicodeString(0x001F314));
    emojiAnnotationToUnicode.put("wc", emojiToUnicodeString(0x001F6BE));
    emojiAnnotationToUnicode.put("weary", emojiToUnicodeString(0x001F629));
    emojiAnnotationToUnicode.put("wedding", emojiToUnicodeString(0x001F492));
    emojiAnnotationToUnicode.put("whale", emojiToUnicodeString(0x001F433));
    emojiAnnotationToUnicode.put("whale2", emojiToUnicodeString(0x001F40B));
    emojiAnnotationToUnicode.put("wheelchair", emojiToUnicodeString(0x000267F));
    emojiAnnotationToUnicode.put("white_check_mark", emojiToUnicodeString(0x0002705));
    emojiAnnotationToUnicode.put("white_circle", emojiToUnicodeString(0x00026AA));
    emojiAnnotationToUnicode.put("white_flower", emojiToUnicodeString(0x001F4AE));
    emojiAnnotationToUnicode.put("white_large_square", emojiToUnicodeString(0x0002B1C));
    emojiAnnotationToUnicode.put("white_medium_small_square", emojiToUnicodeString(0x00025FD));
    emojiAnnotationToUnicode.put("white_medium_square", emojiToUnicodeString(0x00025FB));
    emojiAnnotationToUnicode.put("white_small_square", emojiToUnicodeString(0x00025AB));
    emojiAnnotationToUnicode.put("white_square_button", emojiToUnicodeString(0x001F533));
    emojiAnnotationToUnicode.put("wind_chime", emojiToUnicodeString(0x001F390));
    emojiAnnotationToUnicode.put("wine_glass", emojiToUnicodeString(0x001F377));
    emojiAnnotationToUnicode.put("wink", emojiToUnicodeString(0x001F609));
    emojiAnnotationToUnicode.put("wolf", emojiToUnicodeString(0x001F43A));
    emojiAnnotationToUnicode.put("woman", emojiToUnicodeString(0x001F469));
    emojiAnnotationToUnicode.put("womans_clothes", emojiToUnicodeString(0x001F45A));
    emojiAnnotationToUnicode.put("womans_hat", emojiToUnicodeString(0x001F452));
    emojiAnnotationToUnicode.put("womens", emojiToUnicodeString(0x001F6BA));
    emojiAnnotationToUnicode.put("worried", emojiToUnicodeString(0x001F61F));
    emojiAnnotationToUnicode.put("wrench", emojiToUnicodeString(0x001F527));
    emojiAnnotationToUnicode.put("x", emojiToUnicodeString(0x000274C));
    emojiAnnotationToUnicode.put("yellow_heart", emojiToUnicodeString(0x001F49B));
    emojiAnnotationToUnicode.put("yen", emojiToUnicodeString(0x001F4B4));
    emojiAnnotationToUnicode.put("yum", emojiToUnicodeString(0x001F60B));
    emojiAnnotationToUnicode.put("zap", emojiToUnicodeString(0x00026A1));
    emojiAnnotationToUnicode.put("zzz", emojiToUnicodeString(0x001F4A4));
    emojiAnnotationToUnicode.put("angel_tone1", emojiToUnicodeString(0x001f47c, 0x001f3fb));
    emojiAnnotationToUnicode.put("angel_tone2", emojiToUnicodeString(0x001f47c, 0x001f3fc));
    emojiAnnotationToUnicode.put("angel_tone3", emojiToUnicodeString(0x001f47c, 0x001f3fd));
    emojiAnnotationToUnicode.put("angel_tone4", emojiToUnicodeString(0x001f47c, 0x001f3fe));
    emojiAnnotationToUnicode.put("angel_tone5", emojiToUnicodeString(0x001f47c, 0x001f3ff));
    emojiAnnotationToUnicode.put("asterisk", emojiToUnicodeString(0x00002a, 0x0020e3));
    emojiAnnotationToUnicode.put("baby_tone1", emojiToUnicodeString(0x001f476, 0x001f3fb));
    emojiAnnotationToUnicode.put("baby_tone2", emojiToUnicodeString(0x001f476, 0x001f3fc));
    emojiAnnotationToUnicode.put("baby_tone3", emojiToUnicodeString(0x001f476, 0x001f3fd));
    emojiAnnotationToUnicode.put("baby_tone4", emojiToUnicodeString(0x001f476, 0x001f3fe));
    emojiAnnotationToUnicode.put("baby_tone5", emojiToUnicodeString(0x001f476, 0x001f3ff));
    emojiAnnotationToUnicode.put("basketball_player_tone1", emojiToUnicodeString(0x0026f9, 0x001f3fb));
    emojiAnnotationToUnicode.put("basketball_player_tone2", emojiToUnicodeString(0x0026f9, 0x001f3fc));
    emojiAnnotationToUnicode.put("basketball_player_tone3", emojiToUnicodeString(0x0026f9, 0x001f3fd));
    emojiAnnotationToUnicode.put("basketball_player_tone4", emojiToUnicodeString(0x0026f9, 0x001f3fe));
    emojiAnnotationToUnicode.put("basketball_player_tone5", emojiToUnicodeString(0x0026f9, 0x001f3ff));
    emojiAnnotationToUnicode.put("bath_tone1", emojiToUnicodeString(0x001f6c0, 0x001f3fb));
    emojiAnnotationToUnicode.put("bath_tone2", emojiToUnicodeString(0x001f6c0, 0x001f3fc));
    emojiAnnotationToUnicode.put("bath_tone3", emojiToUnicodeString(0x001f6c0, 0x001f3fd));
    emojiAnnotationToUnicode.put("bath_tone4", emojiToUnicodeString(0x001f6c0, 0x001f3fe));
    emojiAnnotationToUnicode.put("bath_tone5", emojiToUnicodeString(0x001f6c0, 0x001f3ff));
    emojiAnnotationToUnicode.put("bicyclist_tone1", emojiToUnicodeString(0x001f6b4, 0x001f3fb));
    emojiAnnotationToUnicode.put("bicyclist_tone2", emojiToUnicodeString(0x001f6b4, 0x001f3fc));
    emojiAnnotationToUnicode.put("bicyclist_tone3", emojiToUnicodeString(0x001f6b4, 0x001f3fd));
    emojiAnnotationToUnicode.put("bicyclist_tone4", emojiToUnicodeString(0x001f6b4, 0x001f3fe));
    emojiAnnotationToUnicode.put("bicyclist_tone5", emojiToUnicodeString(0x001f6b4, 0x001f3ff));
    emojiAnnotationToUnicode.put("bow_tone1", emojiToUnicodeString(0x001f647, 0x001f3fb));
    emojiAnnotationToUnicode.put("bow_tone2", emojiToUnicodeString(0x001f647, 0x001f3fc));
    emojiAnnotationToUnicode.put("bow_tone3", emojiToUnicodeString(0x001f647, 0x001f3fd));
    emojiAnnotationToUnicode.put("bow_tone4", emojiToUnicodeString(0x001f647, 0x001f3fe));
    emojiAnnotationToUnicode.put("bow_tone5", emojiToUnicodeString(0x001f647, 0x001f3ff));
    emojiAnnotationToUnicode.put("boy_tone1", emojiToUnicodeString(0x001f466, 0x001f3fb));
    emojiAnnotationToUnicode.put("boy_tone2", emojiToUnicodeString(0x001f466, 0x001f3fc));
    emojiAnnotationToUnicode.put("boy_tone3", emojiToUnicodeString(0x001f466, 0x001f3fd));
    emojiAnnotationToUnicode.put("boy_tone4", emojiToUnicodeString(0x001f466, 0x001f3fe));
    emojiAnnotationToUnicode.put("boy_tone5", emojiToUnicodeString(0x001f466, 0x001f3ff));
    emojiAnnotationToUnicode.put("bride_with_veil_tone1", emojiToUnicodeString(0x001f470, 0x001f3fb));
    emojiAnnotationToUnicode.put("bride_with_veil_tone2", emojiToUnicodeString(0x001f470, 0x001f3fc));
    emojiAnnotationToUnicode.put("bride_with_veil_tone3", emojiToUnicodeString(0x001f470, 0x001f3fd));
    emojiAnnotationToUnicode.put("bride_with_veil_tone4", emojiToUnicodeString(0x001f470, 0x001f3fe));
    emojiAnnotationToUnicode.put("bride_with_veil_tone5", emojiToUnicodeString(0x001f470, 0x001f3ff));
    emojiAnnotationToUnicode.put("call_me_tone1", emojiToUnicodeString(0x001f919, 0x001f3fb));
    emojiAnnotationToUnicode.put("call_me_tone2", emojiToUnicodeString(0x001f919, 0x001f3fc));
    emojiAnnotationToUnicode.put("call_me_tone3", emojiToUnicodeString(0x001f919, 0x001f3fd));
    emojiAnnotationToUnicode.put("call_me_tone4", emojiToUnicodeString(0x001f919, 0x001f3fe));
    emojiAnnotationToUnicode.put("call_me_tone5", emojiToUnicodeString(0x001f919, 0x001f3ff));
    emojiAnnotationToUnicode.put("cartwheel_tone1", emojiToUnicodeString(0x001f938, 0x001f3fb));
    emojiAnnotationToUnicode.put("cartwheel_tone2", emojiToUnicodeString(0x001f938, 0x001f3fc));
    emojiAnnotationToUnicode.put("cartwheel_tone3", emojiToUnicodeString(0x001f938, 0x001f3fd));
    emojiAnnotationToUnicode.put("cartwheel_tone4", emojiToUnicodeString(0x001f938, 0x001f3fe));
    emojiAnnotationToUnicode.put("cartwheel_tone5", emojiToUnicodeString(0x001f938, 0x001f3ff));
    emojiAnnotationToUnicode.put("clap_tone1", emojiToUnicodeString(0x001f44f, 0x001f3fb));
    emojiAnnotationToUnicode.put("clap_tone2", emojiToUnicodeString(0x001f44f, 0x001f3fc));
    emojiAnnotationToUnicode.put("clap_tone3", emojiToUnicodeString(0x001f44f, 0x001f3fd));
    emojiAnnotationToUnicode.put("clap_tone4", emojiToUnicodeString(0x001f44f, 0x001f3fe));
    emojiAnnotationToUnicode.put("clap_tone5", emojiToUnicodeString(0x001f44f, 0x001f3ff));
    emojiAnnotationToUnicode.put("cn", emojiToUnicodeString(0x001f1e8, 0x001f1f3));
    emojiAnnotationToUnicode.put("construction_worker_tone1", emojiToUnicodeString(0x001f477, 0x001f3fb));
    emojiAnnotationToUnicode.put("construction_worker_tone2", emojiToUnicodeString(0x001f477, 0x001f3fc));
    emojiAnnotationToUnicode.put("construction_worker_tone3", emojiToUnicodeString(0x001f477, 0x001f3fd));
    emojiAnnotationToUnicode.put("construction_worker_tone4", emojiToUnicodeString(0x001f477, 0x001f3fe));
    emojiAnnotationToUnicode.put("construction_worker_tone5", emojiToUnicodeString(0x001f477, 0x001f3ff));
    emojiAnnotationToUnicode.put("cop_tone1", emojiToUnicodeString(0x001f46e, 0x001f3fb));
    emojiAnnotationToUnicode.put("cop_tone2", emojiToUnicodeString(0x001f46e, 0x001f3fc));
    emojiAnnotationToUnicode.put("cop_tone3", emojiToUnicodeString(0x001f46e, 0x001f3fd));
    emojiAnnotationToUnicode.put("cop_tone4", emojiToUnicodeString(0x001f46e, 0x001f3fe));
    emojiAnnotationToUnicode.put("cop_tone5", emojiToUnicodeString(0x001f46e, 0x001f3ff));
    emojiAnnotationToUnicode.put("couple_mm", emojiToUnicodeString(0x001f468, 0x002764, 0x001f468));
    emojiAnnotationToUnicode.put("couple_ww", emojiToUnicodeString(0x001f469, 0x002764, 0x001f469));
    emojiAnnotationToUnicode.put("dancer_tone1", emojiToUnicodeString(0x001f483, 0x001f3fb));
    emojiAnnotationToUnicode.put("dancer_tone2", emojiToUnicodeString(0x001f483, 0x001f3fc));
    emojiAnnotationToUnicode.put("dancer_tone3", emojiToUnicodeString(0x001f483, 0x001f3fd));
    emojiAnnotationToUnicode.put("dancer_tone4", emojiToUnicodeString(0x001f483, 0x001f3fe));
    emojiAnnotationToUnicode.put("dancer_tone5", emojiToUnicodeString(0x001f483, 0x001f3ff));
    emojiAnnotationToUnicode.put("de", emojiToUnicodeString(0x001f1e9, 0x001f1ea));
    emojiAnnotationToUnicode.put("e,0x00mail", emojiToUnicodeString(0x001f4e7));
    emojiAnnotationToUnicode.put("ear_tone1", emojiToUnicodeString(0x001f442, 0x001f3fb));
    emojiAnnotationToUnicode.put("ear_tone2", emojiToUnicodeString(0x001f442, 0x001f3fc));
    emojiAnnotationToUnicode.put("ear_tone3", emojiToUnicodeString(0x001f442, 0x001f3fd));
    emojiAnnotationToUnicode.put("ear_tone4", emojiToUnicodeString(0x001f442, 0x001f3fe));
    emojiAnnotationToUnicode.put("ear_tone5", emojiToUnicodeString(0x001f442, 0x001f3ff));
    emojiAnnotationToUnicode.put("eight", emojiToUnicodeString(0x000038, 0x0020e3));
    emojiAnnotationToUnicode.put("es", emojiToUnicodeString(0x001f1ea, 0x001f1f8));
    emojiAnnotationToUnicode.put("eye_in_speech_bubble", emojiToUnicodeString(0x001f441, 0x001f5e8));
    emojiAnnotationToUnicode.put("face_palm_tone1", emojiToUnicodeString(0x001f926, 0x001f3fb));
    emojiAnnotationToUnicode.put("face_palm_tone2", emojiToUnicodeString(0x001f926, 0x001f3fc));
    emojiAnnotationToUnicode.put("face_palm_tone3", emojiToUnicodeString(0x001f926, 0x001f3fd));
    emojiAnnotationToUnicode.put("face_palm_tone4", emojiToUnicodeString(0x001f926, 0x001f3fe));
    emojiAnnotationToUnicode.put("face_palm_tone5", emojiToUnicodeString(0x001f926, 0x001f3ff));
    emojiAnnotationToUnicode.put("family_mmb", emojiToUnicodeString(0x001f468, 0x001f468, 0x001f466));
    emojiAnnotationToUnicode.put("family_mmbb", emojiToUnicodeString(0x001f468, 0x001f468, 0x001f466, 0x001f466));
    emojiAnnotationToUnicode.put("family_mmg", emojiToUnicodeString(0x001f468, 0x001f468, 0x001f467));
    emojiAnnotationToUnicode.put("family_mmgb", emojiToUnicodeString(0x001f468, 0x001f468, 0x001f467, 0x001f466));
    emojiAnnotationToUnicode.put("family_mmgg", emojiToUnicodeString(0x001f468, 0x001f468, 0x001f467, 0x001f467));
    emojiAnnotationToUnicode.put("family_mwbb", emojiToUnicodeString(0x001f468, 0x001f469, 0x001f466, 0x001f466));
    emojiAnnotationToUnicode.put("family_mwg", emojiToUnicodeString(0x001f468, 0x001f469, 0x001f467));
    emojiAnnotationToUnicode.put("family_mwgb", emojiToUnicodeString(0x001f468, 0x001f469, 0x001f467, 0x001f466));
    emojiAnnotationToUnicode.put("family_mwgg", emojiToUnicodeString(0x001f468, 0x001f469, 0x001f467, 0x001f467));
    emojiAnnotationToUnicode.put("family_wwb", emojiToUnicodeString(0x001f469, 0x001f469, 0x001f466));
    emojiAnnotationToUnicode.put("family_wwbb", emojiToUnicodeString(0x001f469, 0x001f469, 0x001f466, 0x001f466));
    emojiAnnotationToUnicode.put("family_wwg", emojiToUnicodeString(0x001f469, 0x001f469, 0x001f467));
    emojiAnnotationToUnicode.put("family_wwgb", emojiToUnicodeString(0x001f469, 0x001f469, 0x001f467, 0x001f466));
    emojiAnnotationToUnicode.put("family_wwgg", emojiToUnicodeString(0x001f469, 0x001f469, 0x001f467, 0x001f467));
    emojiAnnotationToUnicode.put("fingers_crossed_tone1", emojiToUnicodeString(0x001f91e, 0x001f3fb));
    emojiAnnotationToUnicode.put("fingers_crossed_tone2", emojiToUnicodeString(0x001f91e, 0x001f3fc));
    emojiAnnotationToUnicode.put("fingers_crossed_tone3", emojiToUnicodeString(0x001f91e, 0x001f3fd));
    emojiAnnotationToUnicode.put("fingers_crossed_tone4", emojiToUnicodeString(0x001f91e, 0x001f3fe));
    emojiAnnotationToUnicode.put("fingers_crossed_tone5", emojiToUnicodeString(0x001f91e, 0x001f3ff));
    emojiAnnotationToUnicode.put("fist_tone1", emojiToUnicodeString(0x00270a, 0x001f3fb));
    emojiAnnotationToUnicode.put("fist_tone2", emojiToUnicodeString(0x00270a, 0x001f3fc));
    emojiAnnotationToUnicode.put("fist_tone3", emojiToUnicodeString(0x00270a, 0x001f3fd));
    emojiAnnotationToUnicode.put("fist_tone4", emojiToUnicodeString(0x00270a, 0x001f3fe));
    emojiAnnotationToUnicode.put("fist_tone5", emojiToUnicodeString(0x00270a, 0x001f3ff));
    emojiAnnotationToUnicode.put("five", emojiToUnicodeString(0x000035, 0x0020e3));
    emojiAnnotationToUnicode.put("flag_ac", emojiToUnicodeString(0x001f1e6, 0x001f1e8));
    emojiAnnotationToUnicode.put("flag_ad", emojiToUnicodeString(0x001f1e6, 0x001f1e9));
    emojiAnnotationToUnicode.put("flag_ae", emojiToUnicodeString(0x001f1e6, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_af", emojiToUnicodeString(0x001f1e6, 0x001f1eb));
    emojiAnnotationToUnicode.put("flag_ag", emojiToUnicodeString(0x001f1e6, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_ai", emojiToUnicodeString(0x001f1e6, 0x001f1ee));
    emojiAnnotationToUnicode.put("flag_al", emojiToUnicodeString(0x001f1e6, 0x001f1f1));
    emojiAnnotationToUnicode.put("flag_am", emojiToUnicodeString(0x001f1e6, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_ao", emojiToUnicodeString(0x001f1e6, 0x001f1f4));
    emojiAnnotationToUnicode.put("flag_aq", emojiToUnicodeString(0x001f1e6, 0x001f1f6));
    emojiAnnotationToUnicode.put("flag_ar", emojiToUnicodeString(0x001f1e6, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_as", emojiToUnicodeString(0x001f1e6, 0x001f1f8));
    emojiAnnotationToUnicode.put("flag_at", emojiToUnicodeString(0x001f1e6, 0x001f1f9));
    emojiAnnotationToUnicode.put("flag_au", emojiToUnicodeString(0x001f1e6, 0x001f1fa));
    emojiAnnotationToUnicode.put("flag_aw", emojiToUnicodeString(0x001f1e6, 0x001f1fc));
    emojiAnnotationToUnicode.put("flag_ax", emojiToUnicodeString(0x001f1e6, 0x001f1fd));
    emojiAnnotationToUnicode.put("flag_az", emojiToUnicodeString(0x001f1e6, 0x001f1ff));
    emojiAnnotationToUnicode.put("flag_ba", emojiToUnicodeString(0x001f1e7, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_bb", emojiToUnicodeString(0x001f1e7, 0x001f1e7));
    emojiAnnotationToUnicode.put("flag_bd", emojiToUnicodeString(0x001f1e7, 0x001f1e9));
    emojiAnnotationToUnicode.put("flag_be", emojiToUnicodeString(0x001f1e7, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_bf", emojiToUnicodeString(0x001f1e7, 0x001f1eb));
    emojiAnnotationToUnicode.put("flag_bg", emojiToUnicodeString(0x001f1e7, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_bh", emojiToUnicodeString(0x001f1e7, 0x001f1ed));
    emojiAnnotationToUnicode.put("flag_bi", emojiToUnicodeString(0x001f1e7, 0x001f1ee));
    emojiAnnotationToUnicode.put("flag_bj", emojiToUnicodeString(0x001f1e7, 0x001f1ef));
    emojiAnnotationToUnicode.put("flag_bl", emojiToUnicodeString(0x001f1e7, 0x001f1f1));
    emojiAnnotationToUnicode.put("flag_bm", emojiToUnicodeString(0x001f1e7, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_bn", emojiToUnicodeString(0x001f1e7, 0x001f1f3));
    emojiAnnotationToUnicode.put("flag_bo", emojiToUnicodeString(0x001f1e7, 0x001f1f4));
    emojiAnnotationToUnicode.put("flag_bq", emojiToUnicodeString(0x001f1e7, 0x001f1f6));
    emojiAnnotationToUnicode.put("flag_br", emojiToUnicodeString(0x001f1e7, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_bs", emojiToUnicodeString(0x001f1e7, 0x001f1f8));
    emojiAnnotationToUnicode.put("flag_bt", emojiToUnicodeString(0x001f1e7, 0x001f1f9));
    emojiAnnotationToUnicode.put("flag_bv", emojiToUnicodeString(0x001f1e7, 0x001f1fb));
    emojiAnnotationToUnicode.put("flag_bw", emojiToUnicodeString(0x001f1e7, 0x001f1fc));
    emojiAnnotationToUnicode.put("flag_by", emojiToUnicodeString(0x001f1e7, 0x001f1fe));
    emojiAnnotationToUnicode.put("flag_bz", emojiToUnicodeString(0x001f1e7, 0x001f1ff));
    emojiAnnotationToUnicode.put("flag_ca", emojiToUnicodeString(0x001f1e8, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_cc", emojiToUnicodeString(0x001f1e8, 0x001f1e8));
    emojiAnnotationToUnicode.put("flag_cd", emojiToUnicodeString(0x001f1e8, 0x001f1e9));
    emojiAnnotationToUnicode.put("flag_cf", emojiToUnicodeString(0x001f1e8, 0x001f1eb));
    emojiAnnotationToUnicode.put("flag_cg", emojiToUnicodeString(0x001f1e8, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_ch", emojiToUnicodeString(0x001f1e8, 0x001f1ed));
    emojiAnnotationToUnicode.put("flag_ci", emojiToUnicodeString(0x001f1e8, 0x001f1ee));
    emojiAnnotationToUnicode.put("flag_ck", emojiToUnicodeString(0x001f1e8, 0x001f1f0));
    emojiAnnotationToUnicode.put("flag_cl", emojiToUnicodeString(0x001f1e8, 0x001f1f1));
    emojiAnnotationToUnicode.put("flag_cm", emojiToUnicodeString(0x001f1e8, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_cn", emojiToUnicodeString(0x001f1e8, 0x001f1f3));
    emojiAnnotationToUnicode.put("flag_co", emojiToUnicodeString(0x001f1e8, 0x001f1f4));
    emojiAnnotationToUnicode.put("flag_cp", emojiToUnicodeString(0x001f1e8, 0x001f1f5));
    emojiAnnotationToUnicode.put("flag_cr", emojiToUnicodeString(0x001f1e8, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_cu", emojiToUnicodeString(0x001f1e8, 0x001f1fa));
    emojiAnnotationToUnicode.put("flag_cv", emojiToUnicodeString(0x001f1e8, 0x001f1fb));
    emojiAnnotationToUnicode.put("flag_cw", emojiToUnicodeString(0x001f1e8, 0x001f1fc));
    emojiAnnotationToUnicode.put("flag_cx", emojiToUnicodeString(0x001f1e8, 0x001f1fd));
    emojiAnnotationToUnicode.put("flag_cy", emojiToUnicodeString(0x001f1e8, 0x001f1fe));
    emojiAnnotationToUnicode.put("flag_cz", emojiToUnicodeString(0x001f1e8, 0x001f1ff));
    emojiAnnotationToUnicode.put("flag_de", emojiToUnicodeString(0x001f1e9, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_dg", emojiToUnicodeString(0x001f1e9, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_dj", emojiToUnicodeString(0x001f1e9, 0x001f1ef));
    emojiAnnotationToUnicode.put("flag_dk", emojiToUnicodeString(0x001f1e9, 0x001f1f0));
    emojiAnnotationToUnicode.put("flag_dm", emojiToUnicodeString(0x001f1e9, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_do", emojiToUnicodeString(0x001f1e9, 0x001f1f4));
    emojiAnnotationToUnicode.put("flag_dz", emojiToUnicodeString(0x001f1e9, 0x001f1ff));
    emojiAnnotationToUnicode.put("flag_ea", emojiToUnicodeString(0x001f1ea, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_ec", emojiToUnicodeString(0x001f1ea, 0x001f1e8));
    emojiAnnotationToUnicode.put("flag_ee", emojiToUnicodeString(0x001f1ea, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_eg", emojiToUnicodeString(0x001f1ea, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_eh", emojiToUnicodeString(0x001f1ea, 0x001f1ed));
    emojiAnnotationToUnicode.put("flag_er", emojiToUnicodeString(0x001f1ea, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_es", emojiToUnicodeString(0x001f1ea, 0x001f1f8));
    emojiAnnotationToUnicode.put("flag_et", emojiToUnicodeString(0x001f1ea, 0x001f1f9));
    emojiAnnotationToUnicode.put("flag_eu", emojiToUnicodeString(0x001f1ea, 0x001f1fa));
    emojiAnnotationToUnicode.put("flag_fi", emojiToUnicodeString(0x001f1eb, 0x001f1ee));
    emojiAnnotationToUnicode.put("flag_fj", emojiToUnicodeString(0x001f1eb, 0x001f1ef));
    emojiAnnotationToUnicode.put("flag_fk", emojiToUnicodeString(0x001f1eb, 0x001f1f0));
    emojiAnnotationToUnicode.put("flag_fm", emojiToUnicodeString(0x001f1eb, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_fo", emojiToUnicodeString(0x001f1eb, 0x001f1f4));
    emojiAnnotationToUnicode.put("flag_fr", emojiToUnicodeString(0x001f1eb, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_ga", emojiToUnicodeString(0x001f1ec, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_gb", emojiToUnicodeString(0x001f1ec, 0x001f1e7));
    emojiAnnotationToUnicode.put("flag_gd", emojiToUnicodeString(0x001f1ec, 0x001f1e9));
    emojiAnnotationToUnicode.put("flag_ge", emojiToUnicodeString(0x001f1ec, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_gf", emojiToUnicodeString(0x001f1ec, 0x001f1eb));
    emojiAnnotationToUnicode.put("flag_gg", emojiToUnicodeString(0x001f1ec, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_gh", emojiToUnicodeString(0x001f1ec, 0x001f1ed));
    emojiAnnotationToUnicode.put("flag_gi", emojiToUnicodeString(0x001f1ec, 0x001f1ee));
    emojiAnnotationToUnicode.put("flag_gl", emojiToUnicodeString(0x001f1ec, 0x001f1f1));
    emojiAnnotationToUnicode.put("flag_gm", emojiToUnicodeString(0x001f1ec, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_gn", emojiToUnicodeString(0x001f1ec, 0x001f1f3));
    emojiAnnotationToUnicode.put("flag_gp", emojiToUnicodeString(0x001f1ec, 0x001f1f5));
    emojiAnnotationToUnicode.put("flag_gq", emojiToUnicodeString(0x001f1ec, 0x001f1f6));
    emojiAnnotationToUnicode.put("flag_gr", emojiToUnicodeString(0x001f1ec, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_gs", emojiToUnicodeString(0x001f1ec, 0x001f1f8));
    emojiAnnotationToUnicode.put("flag_gt", emojiToUnicodeString(0x001f1ec, 0x001f1f9));
    emojiAnnotationToUnicode.put("flag_gu", emojiToUnicodeString(0x001f1ec, 0x001f1fa));
    emojiAnnotationToUnicode.put("flag_gw", emojiToUnicodeString(0x001f1ec, 0x001f1fc));
    emojiAnnotationToUnicode.put("flag_gy", emojiToUnicodeString(0x001f1ec, 0x001f1fe));
    emojiAnnotationToUnicode.put("flag_hk", emojiToUnicodeString(0x001f1ed, 0x001f1f0));
    emojiAnnotationToUnicode.put("flag_hm", emojiToUnicodeString(0x001f1ed, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_hn", emojiToUnicodeString(0x001f1ed, 0x001f1f3));
    emojiAnnotationToUnicode.put("flag_hr", emojiToUnicodeString(0x001f1ed, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_ht", emojiToUnicodeString(0x001f1ed, 0x001f1f9));
    emojiAnnotationToUnicode.put("flag_hu", emojiToUnicodeString(0x001f1ed, 0x001f1fa));
    emojiAnnotationToUnicode.put("flag_ic", emojiToUnicodeString(0x001f1ee, 0x001f1e8));
    emojiAnnotationToUnicode.put("flag_id", emojiToUnicodeString(0x001f1ee, 0x001f1e9));
    emojiAnnotationToUnicode.put("flag_ie", emojiToUnicodeString(0x001f1ee, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_il", emojiToUnicodeString(0x001f1ee, 0x001f1f1));
    emojiAnnotationToUnicode.put("flag_im", emojiToUnicodeString(0x001f1ee, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_in", emojiToUnicodeString(0x001f1ee, 0x001f1f3));
    emojiAnnotationToUnicode.put("flag_io", emojiToUnicodeString(0x001f1ee, 0x001f1f4));
    emojiAnnotationToUnicode.put("flag_iq", emojiToUnicodeString(0x001f1ee, 0x001f1f6));
    emojiAnnotationToUnicode.put("flag_ir", emojiToUnicodeString(0x001f1ee, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_is", emojiToUnicodeString(0x001f1ee, 0x001f1f8));
    emojiAnnotationToUnicode.put("flag_it", emojiToUnicodeString(0x001f1ee, 0x001f1f9));
    emojiAnnotationToUnicode.put("flag_je", emojiToUnicodeString(0x001f1ef, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_jm", emojiToUnicodeString(0x001f1ef, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_jo", emojiToUnicodeString(0x001f1ef, 0x001f1f4));
    emojiAnnotationToUnicode.put("flag_jp", emojiToUnicodeString(0x001f1ef, 0x001f1f5));
    emojiAnnotationToUnicode.put("flag_ke", emojiToUnicodeString(0x001f1f0, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_kg", emojiToUnicodeString(0x001f1f0, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_kh", emojiToUnicodeString(0x001f1f0, 0x001f1ed));
    emojiAnnotationToUnicode.put("flag_ki", emojiToUnicodeString(0x001f1f0, 0x001f1ee));
    emojiAnnotationToUnicode.put("flag_km", emojiToUnicodeString(0x001f1f0, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_kn", emojiToUnicodeString(0x001f1f0, 0x001f1f3));
    emojiAnnotationToUnicode.put("flag_kp", emojiToUnicodeString(0x001f1f0, 0x001f1f5));
    emojiAnnotationToUnicode.put("flag_kr", emojiToUnicodeString(0x001f1f0, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_kw", emojiToUnicodeString(0x001f1f0, 0x001f1fc));
    emojiAnnotationToUnicode.put("flag_ky", emojiToUnicodeString(0x001f1f0, 0x001f1fe));
    emojiAnnotationToUnicode.put("flag_kz", emojiToUnicodeString(0x001f1f0, 0x001f1ff));
    emojiAnnotationToUnicode.put("flag_la", emojiToUnicodeString(0x001f1f1, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_lb", emojiToUnicodeString(0x001f1f1, 0x001f1e7));
    emojiAnnotationToUnicode.put("flag_lc", emojiToUnicodeString(0x001f1f1, 0x001f1e8));
    emojiAnnotationToUnicode.put("flag_li", emojiToUnicodeString(0x001f1f1, 0x001f1ee));
    emojiAnnotationToUnicode.put("flag_lk", emojiToUnicodeString(0x001f1f1, 0x001f1f0));
    emojiAnnotationToUnicode.put("flag_lr", emojiToUnicodeString(0x001f1f1, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_ls", emojiToUnicodeString(0x001f1f1, 0x001f1f8));
    emojiAnnotationToUnicode.put("flag_lt", emojiToUnicodeString(0x001f1f1, 0x001f1f9));
    emojiAnnotationToUnicode.put("flag_lu", emojiToUnicodeString(0x001f1f1, 0x001f1fa));
    emojiAnnotationToUnicode.put("flag_lv", emojiToUnicodeString(0x001f1f1, 0x001f1fb));
    emojiAnnotationToUnicode.put("flag_ly", emojiToUnicodeString(0x001f1f1, 0x001f1fe));
    emojiAnnotationToUnicode.put("flag_ma", emojiToUnicodeString(0x001f1f2, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_mc", emojiToUnicodeString(0x001f1f2, 0x001f1e8));
    emojiAnnotationToUnicode.put("flag_md", emojiToUnicodeString(0x001f1f2, 0x001f1e9));
    emojiAnnotationToUnicode.put("flag_me", emojiToUnicodeString(0x001f1f2, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_mf", emojiToUnicodeString(0x001f1f2, 0x001f1eb));
    emojiAnnotationToUnicode.put("flag_mg", emojiToUnicodeString(0x001f1f2, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_mh", emojiToUnicodeString(0x001f1f2, 0x001f1ed));
    emojiAnnotationToUnicode.put("flag_mk", emojiToUnicodeString(0x001f1f2, 0x001f1f0));
    emojiAnnotationToUnicode.put("flag_ml", emojiToUnicodeString(0x001f1f2, 0x001f1f1));
    emojiAnnotationToUnicode.put("flag_mm", emojiToUnicodeString(0x001f1f2, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_mn", emojiToUnicodeString(0x001f1f2, 0x001f1f3));
    emojiAnnotationToUnicode.put("flag_mo", emojiToUnicodeString(0x001f1f2, 0x001f1f4));
    emojiAnnotationToUnicode.put("flag_mp", emojiToUnicodeString(0x001f1f2, 0x001f1f5));
    emojiAnnotationToUnicode.put("flag_mq", emojiToUnicodeString(0x001f1f2, 0x001f1f6));
    emojiAnnotationToUnicode.put("flag_mr", emojiToUnicodeString(0x001f1f2, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_ms", emojiToUnicodeString(0x001f1f2, 0x001f1f8));
    emojiAnnotationToUnicode.put("flag_mt", emojiToUnicodeString(0x001f1f2, 0x001f1f9));
    emojiAnnotationToUnicode.put("flag_mu", emojiToUnicodeString(0x001f1f2, 0x001f1fa));
    emojiAnnotationToUnicode.put("flag_mv", emojiToUnicodeString(0x001f1f2, 0x001f1fb));
    emojiAnnotationToUnicode.put("flag_mw", emojiToUnicodeString(0x001f1f2, 0x001f1fc));
    emojiAnnotationToUnicode.put("flag_mx", emojiToUnicodeString(0x001f1f2, 0x001f1fd));
    emojiAnnotationToUnicode.put("flag_my", emojiToUnicodeString(0x001f1f2, 0x001f1fe));
    emojiAnnotationToUnicode.put("flag_mz", emojiToUnicodeString(0x001f1f2, 0x001f1ff));
    emojiAnnotationToUnicode.put("flag_na", emojiToUnicodeString(0x001f1f3, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_nc", emojiToUnicodeString(0x001f1f3, 0x001f1e8));
    emojiAnnotationToUnicode.put("flag_ne", emojiToUnicodeString(0x001f1f3, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_nf", emojiToUnicodeString(0x001f1f3, 0x001f1eb));
    emojiAnnotationToUnicode.put("flag_ng", emojiToUnicodeString(0x001f1f3, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_ni", emojiToUnicodeString(0x001f1f3, 0x001f1ee));
    emojiAnnotationToUnicode.put("flag_nl", emojiToUnicodeString(0x001f1f3, 0x001f1f1));
    emojiAnnotationToUnicode.put("flag_no", emojiToUnicodeString(0x001f1f3, 0x001f1f4));
    emojiAnnotationToUnicode.put("flag_np", emojiToUnicodeString(0x001f1f3, 0x001f1f5));
    emojiAnnotationToUnicode.put("flag_nr", emojiToUnicodeString(0x001f1f3, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_nu", emojiToUnicodeString(0x001f1f3, 0x001f1fa));
    emojiAnnotationToUnicode.put("flag_nz", emojiToUnicodeString(0x001f1f3, 0x001f1ff));
    emojiAnnotationToUnicode.put("flag_om", emojiToUnicodeString(0x001f1f4, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_pa", emojiToUnicodeString(0x001f1f5, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_pe", emojiToUnicodeString(0x001f1f5, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_pf", emojiToUnicodeString(0x001f1f5, 0x001f1eb));
    emojiAnnotationToUnicode.put("flag_pg", emojiToUnicodeString(0x001f1f5, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_ph", emojiToUnicodeString(0x001f1f5, 0x001f1ed));
    emojiAnnotationToUnicode.put("flag_pk", emojiToUnicodeString(0x001f1f5, 0x001f1f0));
    emojiAnnotationToUnicode.put("flag_pl", emojiToUnicodeString(0x001f1f5, 0x001f1f1));
    emojiAnnotationToUnicode.put("flag_pm", emojiToUnicodeString(0x001f1f5, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_pn", emojiToUnicodeString(0x001f1f5, 0x001f1f3));
    emojiAnnotationToUnicode.put("flag_pr", emojiToUnicodeString(0x001f1f5, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_ps", emojiToUnicodeString(0x001f1f5, 0x001f1f8));
    emojiAnnotationToUnicode.put("flag_pt", emojiToUnicodeString(0x001f1f5, 0x001f1f9));
    emojiAnnotationToUnicode.put("flag_pw", emojiToUnicodeString(0x001f1f5, 0x001f1fc));
    emojiAnnotationToUnicode.put("flag_py", emojiToUnicodeString(0x001f1f5, 0x001f1fe));
    emojiAnnotationToUnicode.put("flag_qa", emojiToUnicodeString(0x001f1f6, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_re", emojiToUnicodeString(0x001f1f7, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_ro", emojiToUnicodeString(0x001f1f7, 0x001f1f4));
    emojiAnnotationToUnicode.put("flag_rs", emojiToUnicodeString(0x001f1f7, 0x001f1f8));
    emojiAnnotationToUnicode.put("flag_ru", emojiToUnicodeString(0x001f1f7, 0x001f1fa));
    emojiAnnotationToUnicode.put("flag_rw", emojiToUnicodeString(0x001f1f7, 0x001f1fc));
    emojiAnnotationToUnicode.put("flag_sa", emojiToUnicodeString(0x001f1f8, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_sb", emojiToUnicodeString(0x001f1f8, 0x001f1e7));
    emojiAnnotationToUnicode.put("flag_sc", emojiToUnicodeString(0x001f1f8, 0x001f1e8));
    emojiAnnotationToUnicode.put("flag_sd", emojiToUnicodeString(0x001f1f8, 0x001f1e9));
    emojiAnnotationToUnicode.put("flag_se", emojiToUnicodeString(0x001f1f8, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_sg", emojiToUnicodeString(0x001f1f8, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_sh", emojiToUnicodeString(0x001f1f8, 0x001f1ed));
    emojiAnnotationToUnicode.put("flag_si", emojiToUnicodeString(0x001f1f8, 0x001f1ee));
    emojiAnnotationToUnicode.put("flag_sj", emojiToUnicodeString(0x001f1f8, 0x001f1ef));
    emojiAnnotationToUnicode.put("flag_sk", emojiToUnicodeString(0x001f1f8, 0x001f1f0));
    emojiAnnotationToUnicode.put("flag_sl", emojiToUnicodeString(0x001f1f8, 0x001f1f1));
    emojiAnnotationToUnicode.put("flag_sm", emojiToUnicodeString(0x001f1f8, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_sn", emojiToUnicodeString(0x001f1f8, 0x001f1f3));
    emojiAnnotationToUnicode.put("flag_so", emojiToUnicodeString(0x001f1f8, 0x001f1f4));
    emojiAnnotationToUnicode.put("flag_sr", emojiToUnicodeString(0x001f1f8, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_ss", emojiToUnicodeString(0x001f1f8, 0x001f1f8));
    emojiAnnotationToUnicode.put("flag_st", emojiToUnicodeString(0x001f1f8, 0x001f1f9));
    emojiAnnotationToUnicode.put("flag_sv", emojiToUnicodeString(0x001f1f8, 0x001f1fb));
    emojiAnnotationToUnicode.put("flag_sx", emojiToUnicodeString(0x001f1f8, 0x001f1fd));
    emojiAnnotationToUnicode.put("flag_sy", emojiToUnicodeString(0x001f1f8, 0x001f1fe));
    emojiAnnotationToUnicode.put("flag_sz", emojiToUnicodeString(0x001f1f8, 0x001f1ff));
    emojiAnnotationToUnicode.put("flag_ta", emojiToUnicodeString(0x001f1f9, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_tc", emojiToUnicodeString(0x001f1f9, 0x001f1e8));
    emojiAnnotationToUnicode.put("flag_td", emojiToUnicodeString(0x001f1f9, 0x001f1e9));
    emojiAnnotationToUnicode.put("flag_tf", emojiToUnicodeString(0x001f1f9, 0x001f1eb));
    emojiAnnotationToUnicode.put("flag_tg", emojiToUnicodeString(0x001f1f9, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_th", emojiToUnicodeString(0x001f1f9, 0x001f1ed));
    emojiAnnotationToUnicode.put("flag_tj", emojiToUnicodeString(0x001f1f9, 0x001f1ef));
    emojiAnnotationToUnicode.put("flag_tk", emojiToUnicodeString(0x001f1f9, 0x001f1f0));
    emojiAnnotationToUnicode.put("flag_tl", emojiToUnicodeString(0x001f1f9, 0x001f1f1));
    emojiAnnotationToUnicode.put("flag_tm", emojiToUnicodeString(0x001f1f9, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_tn", emojiToUnicodeString(0x001f1f9, 0x001f1f3));
    emojiAnnotationToUnicode.put("flag_to", emojiToUnicodeString(0x001f1f9, 0x001f1f4));
    emojiAnnotationToUnicode.put("flag_tr", emojiToUnicodeString(0x001f1f9, 0x001f1f7));
    emojiAnnotationToUnicode.put("flag_tt", emojiToUnicodeString(0x001f1f9, 0x001f1f9));
    emojiAnnotationToUnicode.put("flag_tv", emojiToUnicodeString(0x001f1f9, 0x001f1fb));
    emojiAnnotationToUnicode.put("flag_tw", emojiToUnicodeString(0x001f1f9, 0x001f1fc));
    emojiAnnotationToUnicode.put("flag_tz", emojiToUnicodeString(0x001f1f9, 0x001f1ff));
    emojiAnnotationToUnicode.put("flag_ua", emojiToUnicodeString(0x001f1fa, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_ug", emojiToUnicodeString(0x001f1fa, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_um", emojiToUnicodeString(0x001f1fa, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_us", emojiToUnicodeString(0x001f1fa, 0x001f1f8));
    emojiAnnotationToUnicode.put("flag_uy", emojiToUnicodeString(0x001f1fa, 0x001f1fe));
    emojiAnnotationToUnicode.put("flag_uz", emojiToUnicodeString(0x001f1fa, 0x001f1ff));
    emojiAnnotationToUnicode.put("flag_va", emojiToUnicodeString(0x001f1fb, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_vc", emojiToUnicodeString(0x001f1fb, 0x001f1e8));
    emojiAnnotationToUnicode.put("flag_ve", emojiToUnicodeString(0x001f1fb, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_vg", emojiToUnicodeString(0x001f1fb, 0x001f1ec));
    emojiAnnotationToUnicode.put("flag_vi", emojiToUnicodeString(0x001f1fb, 0x001f1ee));
    emojiAnnotationToUnicode.put("flag_vn", emojiToUnicodeString(0x001f1fb, 0x001f1f3));
    emojiAnnotationToUnicode.put("flag_vu", emojiToUnicodeString(0x001f1fb, 0x001f1fa));
    emojiAnnotationToUnicode.put("flag_wf", emojiToUnicodeString(0x001f1fc, 0x001f1eb));
    emojiAnnotationToUnicode.put("flag_ws", emojiToUnicodeString(0x001f1fc, 0x001f1f8));
    emojiAnnotationToUnicode.put("flag_xk", emojiToUnicodeString(0x001f1fd, 0x001f1f0));
    emojiAnnotationToUnicode.put("flag_ye", emojiToUnicodeString(0x001f1fe, 0x001f1ea));
    emojiAnnotationToUnicode.put("flag_yt", emojiToUnicodeString(0x001f1fe, 0x001f1f9));
    emojiAnnotationToUnicode.put("flag_za", emojiToUnicodeString(0x001f1ff, 0x001f1e6));
    emojiAnnotationToUnicode.put("flag_zm", emojiToUnicodeString(0x001f1ff, 0x001f1f2));
    emojiAnnotationToUnicode.put("flag_zw", emojiToUnicodeString(0x001f1ff, 0x001f1fc));
    emojiAnnotationToUnicode.put("fleur,0x00de,0x00lis", emojiToUnicodeString(0x00269c));
    emojiAnnotationToUnicode.put("four", emojiToUnicodeString(0x000034, 0x0020e3));
    emojiAnnotationToUnicode.put("fr", emojiToUnicodeString(0x001f1eb, 0x001f1f7));
    emojiAnnotationToUnicode.put("gb", emojiToUnicodeString(0x001f1ec, 0x001f1e7));
    emojiAnnotationToUnicode.put("girl_tone1", emojiToUnicodeString(0x001f467, 0x001f3fb));
    emojiAnnotationToUnicode.put("girl_tone2", emojiToUnicodeString(0x001f467, 0x001f3fc));
    emojiAnnotationToUnicode.put("girl_tone3", emojiToUnicodeString(0x001f467, 0x001f3fd));
    emojiAnnotationToUnicode.put("girl_tone4", emojiToUnicodeString(0x001f467, 0x001f3fe));
    emojiAnnotationToUnicode.put("girl_tone5", emojiToUnicodeString(0x001f467, 0x001f3ff));
    emojiAnnotationToUnicode.put("guardsman_tone1", emojiToUnicodeString(0x001f482, 0x001f3fb));
    emojiAnnotationToUnicode.put("guardsman_tone2", emojiToUnicodeString(0x001f482, 0x001f3fc));
    emojiAnnotationToUnicode.put("guardsman_tone3", emojiToUnicodeString(0x001f482, 0x001f3fd));
    emojiAnnotationToUnicode.put("guardsman_tone4", emojiToUnicodeString(0x001f482, 0x001f3fe));
    emojiAnnotationToUnicode.put("guardsman_tone5", emojiToUnicodeString(0x001f482, 0x001f3ff));
    emojiAnnotationToUnicode.put("haircut_tone1", emojiToUnicodeString(0x001f487, 0x001f3fb));
    emojiAnnotationToUnicode.put("haircut_tone2", emojiToUnicodeString(0x001f487, 0x001f3fc));
    emojiAnnotationToUnicode.put("haircut_tone3", emojiToUnicodeString(0x001f487, 0x001f3fd));
    emojiAnnotationToUnicode.put("haircut_tone4", emojiToUnicodeString(0x001f487, 0x001f3fe));
    emojiAnnotationToUnicode.put("haircut_tone5", emojiToUnicodeString(0x001f487, 0x001f3ff));
    emojiAnnotationToUnicode.put("hand_splayed_tone1", emojiToUnicodeString(0x001f590, 0x001f3fb));
    emojiAnnotationToUnicode.put("hand_splayed_tone2", emojiToUnicodeString(0x001f590, 0x001f3fc));
    emojiAnnotationToUnicode.put("hand_splayed_tone3", emojiToUnicodeString(0x001f590, 0x001f3fd));
    emojiAnnotationToUnicode.put("hand_splayed_tone4", emojiToUnicodeString(0x001f590, 0x001f3fe));
    emojiAnnotationToUnicode.put("hand_splayed_tone5", emojiToUnicodeString(0x001f590, 0x001f3ff));
    emojiAnnotationToUnicode.put("handball_tone1", emojiToUnicodeString(0x001f93e, 0x001f3fb));
    emojiAnnotationToUnicode.put("handball_tone2", emojiToUnicodeString(0x001f93e, 0x001f3fc));
    emojiAnnotationToUnicode.put("handball_tone3", emojiToUnicodeString(0x001f93e, 0x001f3fd));
    emojiAnnotationToUnicode.put("handball_tone4", emojiToUnicodeString(0x001f93e, 0x001f3fe));
    emojiAnnotationToUnicode.put("handball_tone5", emojiToUnicodeString(0x001f93e, 0x001f3ff));
    emojiAnnotationToUnicode.put("handshake_tone1", emojiToUnicodeString(0x001f91d, 0x001f3fb));
    emojiAnnotationToUnicode.put("handshake_tone2", emojiToUnicodeString(0x001f91d, 0x001f3fc));
    emojiAnnotationToUnicode.put("handshake_tone3", emojiToUnicodeString(0x001f91d, 0x001f3fd));
    emojiAnnotationToUnicode.put("handshake_tone4", emojiToUnicodeString(0x001f91d, 0x001f3fe));
    emojiAnnotationToUnicode.put("handshake_tone5", emojiToUnicodeString(0x001f91d, 0x001f3ff));
    emojiAnnotationToUnicode.put("hash", emojiToUnicodeString(0x000023, 0x0020e3));
    emojiAnnotationToUnicode.put("horse_racing_tone1", emojiToUnicodeString(0x001f3c7, 0x001f3fb));
    emojiAnnotationToUnicode.put("horse_racing_tone2", emojiToUnicodeString(0x001f3c7, 0x001f3fc));
    emojiAnnotationToUnicode.put("horse_racing_tone3", emojiToUnicodeString(0x001f3c7, 0x001f3fd));
    emojiAnnotationToUnicode.put("horse_racing_tone4", emojiToUnicodeString(0x001f3c7, 0x001f3fe));
    emojiAnnotationToUnicode.put("horse_racing_tone5", emojiToUnicodeString(0x001f3c7, 0x001f3ff));
    emojiAnnotationToUnicode.put("information_desk_person_tone1", emojiToUnicodeString(0x001f481, 0x001f3fb));
    emojiAnnotationToUnicode.put("information_desk_person_tone2", emojiToUnicodeString(0x001f481, 0x001f3fc));
    emojiAnnotationToUnicode.put("information_desk_person_tone3", emojiToUnicodeString(0x001f481, 0x001f3fd));
    emojiAnnotationToUnicode.put("information_desk_person_tone4", emojiToUnicodeString(0x001f481, 0x001f3fe));
    emojiAnnotationToUnicode.put("information_desk_person_tone5", emojiToUnicodeString(0x001f481, 0x001f3ff));
    emojiAnnotationToUnicode.put("it", emojiToUnicodeString(0x001f1ee, 0x001f1f9));
    emojiAnnotationToUnicode.put("jp", emojiToUnicodeString(0x001f1ef, 0x001f1f5));
    emojiAnnotationToUnicode.put("juggling_tone1", emojiToUnicodeString(0x001f939, 0x001f3fb));
    emojiAnnotationToUnicode.put("juggling_tone2", emojiToUnicodeString(0x001f939, 0x001f3fc));
    emojiAnnotationToUnicode.put("juggling_tone3", emojiToUnicodeString(0x001f939, 0x001f3fd));
    emojiAnnotationToUnicode.put("juggling_tone4", emojiToUnicodeString(0x001f939, 0x001f3fe));
    emojiAnnotationToUnicode.put("juggling_tone5", emojiToUnicodeString(0x001f939, 0x001f3ff));
    emojiAnnotationToUnicode.put("kiss_mm", emojiToUnicodeString(0x001f468, 0x002764, 0x001f48b, 0x001f468));
    emojiAnnotationToUnicode.put("kiss_ww", emojiToUnicodeString(0x001f469, 0x002764, 0x001f48b, 0x001f469));
    emojiAnnotationToUnicode.put("kr", emojiToUnicodeString(0x001f1f0, 0x001f1f7));
    emojiAnnotationToUnicode.put("left_facing_fist_tone1", emojiToUnicodeString(0x001f91b, 0x001f3fb));
    emojiAnnotationToUnicode.put("left_facing_fist_tone2", emojiToUnicodeString(0x001f91b, 0x001f3fc));
    emojiAnnotationToUnicode.put("left_facing_fist_tone3", emojiToUnicodeString(0x001f91b, 0x001f3fd));
    emojiAnnotationToUnicode.put("left_facing_fist_tone4", emojiToUnicodeString(0x001f91b, 0x001f3fe));
    emojiAnnotationToUnicode.put("left_facing_fist_tone5", emojiToUnicodeString(0x001f91b, 0x001f3ff));
    emojiAnnotationToUnicode.put("lifter_tone1", emojiToUnicodeString(0x001f3cb, 0x001f3fb));
    emojiAnnotationToUnicode.put("lifter_tone2", emojiToUnicodeString(0x001f3cb, 0x001f3fc));
    emojiAnnotationToUnicode.put("lifter_tone3", emojiToUnicodeString(0x001f3cb, 0x001f3fd));
    emojiAnnotationToUnicode.put("lifter_tone4", emojiToUnicodeString(0x001f3cb, 0x001f3fe));
    emojiAnnotationToUnicode.put("lifter_tone5", emojiToUnicodeString(0x001f3cb, 0x001f3ff));
    emojiAnnotationToUnicode.put("man_dancing_tone1", emojiToUnicodeString(0x001f57a, 0x001f3fb));
    emojiAnnotationToUnicode.put("man_dancing_tone2", emojiToUnicodeString(0x001f57a, 0x001f3fc));
    emojiAnnotationToUnicode.put("man_dancing_tone3", emojiToUnicodeString(0x001f57a, 0x001f3fd));
    emojiAnnotationToUnicode.put("man_dancing_tone4", emojiToUnicodeString(0x001f57a, 0x001f3fe));
    emojiAnnotationToUnicode.put("man_dancing_tone5", emojiToUnicodeString(0x001f57a, 0x001f3ff));
    emojiAnnotationToUnicode.put("man_in_tuxedo_tone1", emojiToUnicodeString(0x001f935, 0x001f3fb));
    emojiAnnotationToUnicode.put("man_in_tuxedo_tone2", emojiToUnicodeString(0x001f935, 0x001f3fc));
    emojiAnnotationToUnicode.put("man_in_tuxedo_tone3", emojiToUnicodeString(0x001f935, 0x001f3fd));
    emojiAnnotationToUnicode.put("man_in_tuxedo_tone4", emojiToUnicodeString(0x001f935, 0x001f3fe));
    emojiAnnotationToUnicode.put("man_in_tuxedo_tone5", emojiToUnicodeString(0x001f935, 0x001f3ff));
    emojiAnnotationToUnicode.put("man_tone1", emojiToUnicodeString(0x001f468, 0x001f3fb));
    emojiAnnotationToUnicode.put("man_tone2", emojiToUnicodeString(0x001f468, 0x001f3fc));
    emojiAnnotationToUnicode.put("man_tone3", emojiToUnicodeString(0x001f468, 0x001f3fd));
    emojiAnnotationToUnicode.put("man_tone4", emojiToUnicodeString(0x001f468, 0x001f3fe));
    emojiAnnotationToUnicode.put("man_tone5", emojiToUnicodeString(0x001f468, 0x001f3ff));
    emojiAnnotationToUnicode.put("man_with_gua_pi_mao_tone1", emojiToUnicodeString(0x001f472, 0x001f3fb));
    emojiAnnotationToUnicode.put("man_with_gua_pi_mao_tone2", emojiToUnicodeString(0x001f472, 0x001f3fc));
    emojiAnnotationToUnicode.put("man_with_gua_pi_mao_tone3", emojiToUnicodeString(0x001f472, 0x001f3fd));
    emojiAnnotationToUnicode.put("man_with_gua_pi_mao_tone4", emojiToUnicodeString(0x001f472, 0x001f3fe));
    emojiAnnotationToUnicode.put("man_with_gua_pi_mao_tone5", emojiToUnicodeString(0x001f472, 0x001f3ff));
    emojiAnnotationToUnicode.put("man_with_turban_tone1", emojiToUnicodeString(0x001f473, 0x001f3fb));
    emojiAnnotationToUnicode.put("man_with_turban_tone2", emojiToUnicodeString(0x001f473, 0x001f3fc));
    emojiAnnotationToUnicode.put("man_with_turban_tone3", emojiToUnicodeString(0x001f473, 0x001f3fd));
    emojiAnnotationToUnicode.put("man_with_turban_tone4", emojiToUnicodeString(0x001f473, 0x001f3fe));
    emojiAnnotationToUnicode.put("man_with_turban_tone5", emojiToUnicodeString(0x001f473, 0x001f3ff));
    emojiAnnotationToUnicode.put("massage_tone1", emojiToUnicodeString(0x001f486, 0x001f3fb));
    emojiAnnotationToUnicode.put("massage_tone2", emojiToUnicodeString(0x001f486, 0x001f3fc));
    emojiAnnotationToUnicode.put("massage_tone3", emojiToUnicodeString(0x001f486, 0x001f3fd));
    emojiAnnotationToUnicode.put("massage_tone4", emojiToUnicodeString(0x001f486, 0x001f3fe));
    emojiAnnotationToUnicode.put("massage_tone5", emojiToUnicodeString(0x001f486, 0x001f3ff));
    emojiAnnotationToUnicode.put("metal_tone1", emojiToUnicodeString(0x001f918, 0x001f3fb));
    emojiAnnotationToUnicode.put("metal_tone2", emojiToUnicodeString(0x001f918, 0x001f3fc));
    emojiAnnotationToUnicode.put("metal_tone3", emojiToUnicodeString(0x001f918, 0x001f3fd));
    emojiAnnotationToUnicode.put("metal_tone4", emojiToUnicodeString(0x001f918, 0x001f3fe));
    emojiAnnotationToUnicode.put("metal_tone5", emojiToUnicodeString(0x001f918, 0x001f3ff));
    emojiAnnotationToUnicode.put("middle_finger_tone1", emojiToUnicodeString(0x001f595, 0x001f3fb));
    emojiAnnotationToUnicode.put("middle_finger_tone2", emojiToUnicodeString(0x001f595, 0x001f3fc));
    emojiAnnotationToUnicode.put("middle_finger_tone3", emojiToUnicodeString(0x001f595, 0x001f3fd));
    emojiAnnotationToUnicode.put("middle_finger_tone4", emojiToUnicodeString(0x001f595, 0x001f3fe));
    emojiAnnotationToUnicode.put("middle_finger_tone5", emojiToUnicodeString(0x001f595, 0x001f3ff));
    emojiAnnotationToUnicode.put("mountain_bicyclist_tone1", emojiToUnicodeString(0x001f6b5, 0x001f3fb));
    emojiAnnotationToUnicode.put("mountain_bicyclist_tone2", emojiToUnicodeString(0x001f6b5, 0x001f3fc));
    emojiAnnotationToUnicode.put("mountain_bicyclist_tone3", emojiToUnicodeString(0x001f6b5, 0x001f3fd));
    emojiAnnotationToUnicode.put("mountain_bicyclist_tone4", emojiToUnicodeString(0x001f6b5, 0x001f3fe));
    emojiAnnotationToUnicode.put("mountain_bicyclist_tone5", emojiToUnicodeString(0x001f6b5, 0x001f3ff));
    emojiAnnotationToUnicode.put("mrs_claus_tone1", emojiToUnicodeString(0x001f936, 0x001f3fb));
    emojiAnnotationToUnicode.put("mrs_claus_tone2", emojiToUnicodeString(0x001f936, 0x001f3fc));
    emojiAnnotationToUnicode.put("mrs_claus_tone3", emojiToUnicodeString(0x001f936, 0x001f3fd));
    emojiAnnotationToUnicode.put("mrs_claus_tone4", emojiToUnicodeString(0x001f936, 0x001f3fe));
    emojiAnnotationToUnicode.put("mrs_claus_tone5", emojiToUnicodeString(0x001f936, 0x001f3ff));
    emojiAnnotationToUnicode.put("muscle_tone1", emojiToUnicodeString(0x001f4aa, 0x001f3fb));
    emojiAnnotationToUnicode.put("muscle_tone2", emojiToUnicodeString(0x001f4aa, 0x001f3fc));
    emojiAnnotationToUnicode.put("muscle_tone3", emojiToUnicodeString(0x001f4aa, 0x001f3fd));
    emojiAnnotationToUnicode.put("muscle_tone4", emojiToUnicodeString(0x001f4aa, 0x001f3fe));
    emojiAnnotationToUnicode.put("muscle_tone5", emojiToUnicodeString(0x001f4aa, 0x001f3ff));
    emojiAnnotationToUnicode.put("nail_care_tone1", emojiToUnicodeString(0x001f485, 0x001f3fb));
    emojiAnnotationToUnicode.put("nail_care_tone2", emojiToUnicodeString(0x001f485, 0x001f3fc));
    emojiAnnotationToUnicode.put("nail_care_tone3", emojiToUnicodeString(0x001f485, 0x001f3fd));
    emojiAnnotationToUnicode.put("nail_care_tone4", emojiToUnicodeString(0x001f485, 0x001f3fe));
    emojiAnnotationToUnicode.put("nail_care_tone5", emojiToUnicodeString(0x001f485, 0x001f3ff));
    emojiAnnotationToUnicode.put("nine", emojiToUnicodeString(0x000039, 0x0020e3));
    emojiAnnotationToUnicode.put("no_good_tone1", emojiToUnicodeString(0x001f645, 0x001f3fb));
    emojiAnnotationToUnicode.put("no_good_tone2", emojiToUnicodeString(0x001f645, 0x001f3fc));
    emojiAnnotationToUnicode.put("no_good_tone3", emojiToUnicodeString(0x001f645, 0x001f3fd));
    emojiAnnotationToUnicode.put("no_good_tone4", emojiToUnicodeString(0x001f645, 0x001f3fe));
    emojiAnnotationToUnicode.put("no_good_tone5", emojiToUnicodeString(0x001f645, 0x001f3ff));
    emojiAnnotationToUnicode.put("non,0x00potable_water", emojiToUnicodeString(0x001f6b1));
    emojiAnnotationToUnicode.put("nose_tone1", emojiToUnicodeString(0x001f443, 0x001f3fb));
    emojiAnnotationToUnicode.put("nose_tone2", emojiToUnicodeString(0x001f443, 0x001f3fc));
    emojiAnnotationToUnicode.put("nose_tone3", emojiToUnicodeString(0x001f443, 0x001f3fd));
    emojiAnnotationToUnicode.put("nose_tone4", emojiToUnicodeString(0x001f443, 0x001f3fe));
    emojiAnnotationToUnicode.put("nose_tone5", emojiToUnicodeString(0x001f443, 0x001f3ff));
    emojiAnnotationToUnicode.put("ok_hand_tone1", emojiToUnicodeString(0x001f44c, 0x001f3fb));
    emojiAnnotationToUnicode.put("ok_hand_tone2", emojiToUnicodeString(0x001f44c, 0x001f3fc));
    emojiAnnotationToUnicode.put("ok_hand_tone3", emojiToUnicodeString(0x001f44c, 0x001f3fd));
    emojiAnnotationToUnicode.put("ok_hand_tone4", emojiToUnicodeString(0x001f44c, 0x001f3fe));
    emojiAnnotationToUnicode.put("ok_hand_tone5", emojiToUnicodeString(0x001f44c, 0x001f3ff));
    emojiAnnotationToUnicode.put("ok_woman_tone1", emojiToUnicodeString(0x001f646, 0x001f3fb));
    emojiAnnotationToUnicode.put("ok_woman_tone2", emojiToUnicodeString(0x001f646, 0x001f3fc));
    emojiAnnotationToUnicode.put("ok_woman_tone3", emojiToUnicodeString(0x001f646, 0x001f3fd));
    emojiAnnotationToUnicode.put("ok_woman_tone4", emojiToUnicodeString(0x001f646, 0x001f3fe));
    emojiAnnotationToUnicode.put("ok_woman_tone5", emojiToUnicodeString(0x001f646, 0x001f3ff));
    emojiAnnotationToUnicode.put("older_man_tone1", emojiToUnicodeString(0x001f474, 0x001f3fb));
    emojiAnnotationToUnicode.put("older_man_tone2", emojiToUnicodeString(0x001f474, 0x001f3fc));
    emojiAnnotationToUnicode.put("older_man_tone3", emojiToUnicodeString(0x001f474, 0x001f3fd));
    emojiAnnotationToUnicode.put("older_man_tone4", emojiToUnicodeString(0x001f474, 0x001f3fe));
    emojiAnnotationToUnicode.put("older_man_tone5", emojiToUnicodeString(0x001f474, 0x001f3ff));
    emojiAnnotationToUnicode.put("older_woman_tone1", emojiToUnicodeString(0x001f475, 0x001f3fb));
    emojiAnnotationToUnicode.put("older_woman_tone2", emojiToUnicodeString(0x001f475, 0x001f3fc));
    emojiAnnotationToUnicode.put("older_woman_tone3", emojiToUnicodeString(0x001f475, 0x001f3fd));
    emojiAnnotationToUnicode.put("older_woman_tone4", emojiToUnicodeString(0x001f475, 0x001f3fe));
    emojiAnnotationToUnicode.put("older_woman_tone5", emojiToUnicodeString(0x001f475, 0x001f3ff));
    emojiAnnotationToUnicode.put("one", emojiToUnicodeString(0x000031, 0x0020e3));
    emojiAnnotationToUnicode.put("open_hands_tone1", emojiToUnicodeString(0x001f450, 0x001f3fb));
    emojiAnnotationToUnicode.put("open_hands_tone2", emojiToUnicodeString(0x001f450, 0x001f3fc));
    emojiAnnotationToUnicode.put("open_hands_tone3", emojiToUnicodeString(0x001f450, 0x001f3fd));
    emojiAnnotationToUnicode.put("open_hands_tone4", emojiToUnicodeString(0x001f450, 0x001f3fe));
    emojiAnnotationToUnicode.put("open_hands_tone5", emojiToUnicodeString(0x001f450, 0x001f3ff));
    emojiAnnotationToUnicode.put("person_frowning_tone1", emojiToUnicodeString(0x001f64d, 0x001f3fb));
    emojiAnnotationToUnicode.put("person_frowning_tone2", emojiToUnicodeString(0x001f64d, 0x001f3fc));
    emojiAnnotationToUnicode.put("person_frowning_tone3", emojiToUnicodeString(0x001f64d, 0x001f3fd));
    emojiAnnotationToUnicode.put("person_frowning_tone4", emojiToUnicodeString(0x001f64d, 0x001f3fe));
    emojiAnnotationToUnicode.put("person_frowning_tone5", emojiToUnicodeString(0x001f64d, 0x001f3ff));
    emojiAnnotationToUnicode.put("person_with_blond_hair_tone1", emojiToUnicodeString(0x001f471, 0x001f3fb));
    emojiAnnotationToUnicode.put("person_with_blond_hair_tone2", emojiToUnicodeString(0x001f471, 0x001f3fc));
    emojiAnnotationToUnicode.put("person_with_blond_hair_tone3", emojiToUnicodeString(0x001f471, 0x001f3fd));
    emojiAnnotationToUnicode.put("person_with_blond_hair_tone4", emojiToUnicodeString(0x001f471, 0x001f3fe));
    emojiAnnotationToUnicode.put("person_with_blond_hair_tone5", emojiToUnicodeString(0x001f471, 0x001f3ff));
    emojiAnnotationToUnicode.put("person_with_pouting_face_tone1", emojiToUnicodeString(0x001f64e, 0x001f3fb));
    emojiAnnotationToUnicode.put("person_with_pouting_face_tone2", emojiToUnicodeString(0x001f64e, 0x001f3fc));
    emojiAnnotationToUnicode.put("person_with_pouting_face_tone3", emojiToUnicodeString(0x001f64e, 0x001f3fd));
    emojiAnnotationToUnicode.put("person_with_pouting_face_tone4", emojiToUnicodeString(0x001f64e, 0x001f3fe));
    emojiAnnotationToUnicode.put("person_with_pouting_face_tone5", emojiToUnicodeString(0x001f64e, 0x001f3ff));
    emojiAnnotationToUnicode.put("point_down_tone1", emojiToUnicodeString(0x001f447, 0x001f3fb));
    emojiAnnotationToUnicode.put("point_down_tone2", emojiToUnicodeString(0x001f447, 0x001f3fc));
    emojiAnnotationToUnicode.put("point_down_tone3", emojiToUnicodeString(0x001f447, 0x001f3fd));
    emojiAnnotationToUnicode.put("point_down_tone4", emojiToUnicodeString(0x001f447, 0x001f3fe));
    emojiAnnotationToUnicode.put("point_down_tone5", emojiToUnicodeString(0x001f447, 0x001f3ff));
    emojiAnnotationToUnicode.put("point_left_tone1", emojiToUnicodeString(0x001f448, 0x001f3fb));
    emojiAnnotationToUnicode.put("point_left_tone2", emojiToUnicodeString(0x001f448, 0x001f3fc));
    emojiAnnotationToUnicode.put("point_left_tone3", emojiToUnicodeString(0x001f448, 0x001f3fd));
    emojiAnnotationToUnicode.put("point_left_tone4", emojiToUnicodeString(0x001f448, 0x001f3fe));
    emojiAnnotationToUnicode.put("point_left_tone5", emojiToUnicodeString(0x001f448, 0x001f3ff));
    emojiAnnotationToUnicode.put("point_right_tone1", emojiToUnicodeString(0x001f449, 0x001f3fb));
    emojiAnnotationToUnicode.put("point_right_tone2", emojiToUnicodeString(0x001f449, 0x001f3fc));
    emojiAnnotationToUnicode.put("point_right_tone3", emojiToUnicodeString(0x001f449, 0x001f3fd));
    emojiAnnotationToUnicode.put("point_right_tone4", emojiToUnicodeString(0x001f449, 0x001f3fe));
    emojiAnnotationToUnicode.put("point_right_tone5", emojiToUnicodeString(0x001f449, 0x001f3ff));
    emojiAnnotationToUnicode.put("point_up_2_tone1", emojiToUnicodeString(0x001f446, 0x001f3fb));
    emojiAnnotationToUnicode.put("point_up_2_tone2", emojiToUnicodeString(0x001f446, 0x001f3fc));
    emojiAnnotationToUnicode.put("point_up_2_tone3", emojiToUnicodeString(0x001f446, 0x001f3fd));
    emojiAnnotationToUnicode.put("point_up_2_tone4", emojiToUnicodeString(0x001f446, 0x001f3fe));
    emojiAnnotationToUnicode.put("point_up_2_tone5", emojiToUnicodeString(0x001f446, 0x001f3ff));
    emojiAnnotationToUnicode.put("point_up_tone1", emojiToUnicodeString(0x00261d, 0x001f3fb));
    emojiAnnotationToUnicode.put("point_up_tone2", emojiToUnicodeString(0x00261d, 0x001f3fc));
    emojiAnnotationToUnicode.put("point_up_tone3", emojiToUnicodeString(0x00261d, 0x001f3fd));
    emojiAnnotationToUnicode.put("point_up_tone4", emojiToUnicodeString(0x00261d, 0x001f3fe));
    emojiAnnotationToUnicode.put("point_up_tone5", emojiToUnicodeString(0x00261d, 0x001f3ff));
    emojiAnnotationToUnicode.put("pray_tone1", emojiToUnicodeString(0x001f64f, 0x001f3fb));
    emojiAnnotationToUnicode.put("pray_tone2", emojiToUnicodeString(0x001f64f, 0x001f3fc));
    emojiAnnotationToUnicode.put("pray_tone3", emojiToUnicodeString(0x001f64f, 0x001f3fd));
    emojiAnnotationToUnicode.put("pray_tone4", emojiToUnicodeString(0x001f64f, 0x001f3fe));
    emojiAnnotationToUnicode.put("pray_tone5", emojiToUnicodeString(0x001f64f, 0x001f3ff));
    emojiAnnotationToUnicode.put("pregnant_woman_tone1", emojiToUnicodeString(0x001f930, 0x001f3fb));
    emojiAnnotationToUnicode.put("pregnant_woman_tone2", emojiToUnicodeString(0x001f930, 0x001f3fc));
    emojiAnnotationToUnicode.put("pregnant_woman_tone3", emojiToUnicodeString(0x001f930, 0x001f3fd));
    emojiAnnotationToUnicode.put("pregnant_woman_tone4", emojiToUnicodeString(0x001f930, 0x001f3fe));
    emojiAnnotationToUnicode.put("pregnant_woman_tone5", emojiToUnicodeString(0x001f930, 0x001f3ff));
    emojiAnnotationToUnicode.put("prince_tone1", emojiToUnicodeString(0x001f934, 0x001f3fb));
    emojiAnnotationToUnicode.put("prince_tone2", emojiToUnicodeString(0x001f934, 0x001f3fc));
    emojiAnnotationToUnicode.put("prince_tone3", emojiToUnicodeString(0x001f934, 0x001f3fd));
    emojiAnnotationToUnicode.put("prince_tone4", emojiToUnicodeString(0x001f934, 0x001f3fe));
    emojiAnnotationToUnicode.put("prince_tone5", emojiToUnicodeString(0x001f934, 0x001f3ff));
    emojiAnnotationToUnicode.put("princess_tone1", emojiToUnicodeString(0x001f478, 0x001f3fb));
    emojiAnnotationToUnicode.put("princess_tone2", emojiToUnicodeString(0x001f478, 0x001f3fc));
    emojiAnnotationToUnicode.put("princess_tone3", emojiToUnicodeString(0x001f478, 0x001f3fd));
    emojiAnnotationToUnicode.put("princess_tone4", emojiToUnicodeString(0x001f478, 0x001f3fe));
    emojiAnnotationToUnicode.put("princess_tone5", emojiToUnicodeString(0x001f478, 0x001f3ff));
    emojiAnnotationToUnicode.put("punch_tone1", emojiToUnicodeString(0x001f44a, 0x001f3fb));
    emojiAnnotationToUnicode.put("punch_tone2", emojiToUnicodeString(0x001f44a, 0x001f3fc));
    emojiAnnotationToUnicode.put("punch_tone3", emojiToUnicodeString(0x001f44a, 0x001f3fd));
    emojiAnnotationToUnicode.put("punch_tone4", emojiToUnicodeString(0x001f44a, 0x001f3fe));
    emojiAnnotationToUnicode.put("punch_tone5", emojiToUnicodeString(0x001f44a, 0x001f3ff));
    emojiAnnotationToUnicode.put("rainbow_flag", emojiToUnicodeString(0x001f3f3, 0x001f308));
    emojiAnnotationToUnicode.put("raised_back_of_hand_tone1", emojiToUnicodeString(0x001f91a, 0x001f3fb));
    emojiAnnotationToUnicode.put("raised_back_of_hand_tone2", emojiToUnicodeString(0x001f91a, 0x001f3fc));
    emojiAnnotationToUnicode.put("raised_back_of_hand_tone3", emojiToUnicodeString(0x001f91a, 0x001f3fd));
    emojiAnnotationToUnicode.put("raised_back_of_hand_tone4", emojiToUnicodeString(0x001f91a, 0x001f3fe));
    emojiAnnotationToUnicode.put("raised_back_of_hand_tone5", emojiToUnicodeString(0x001f91a, 0x001f3ff));
    emojiAnnotationToUnicode.put("raised_hand_tone1", emojiToUnicodeString(0x00270b, 0x001f3fb));
    emojiAnnotationToUnicode.put("raised_hand_tone2", emojiToUnicodeString(0x00270b, 0x001f3fc));
    emojiAnnotationToUnicode.put("raised_hand_tone3", emojiToUnicodeString(0x00270b, 0x001f3fd));
    emojiAnnotationToUnicode.put("raised_hand_tone4", emojiToUnicodeString(0x00270b, 0x001f3fe));
    emojiAnnotationToUnicode.put("raised_hand_tone5", emojiToUnicodeString(0x00270b, 0x001f3ff));
    emojiAnnotationToUnicode.put("raised_hands_tone1", emojiToUnicodeString(0x001f64c, 0x001f3fb));
    emojiAnnotationToUnicode.put("raised_hands_tone2", emojiToUnicodeString(0x001f64c, 0x001f3fc));
    emojiAnnotationToUnicode.put("raised_hands_tone3", emojiToUnicodeString(0x001f64c, 0x001f3fd));
    emojiAnnotationToUnicode.put("raised_hands_tone4", emojiToUnicodeString(0x001f64c, 0x001f3fe));
    emojiAnnotationToUnicode.put("raised_hands_tone5", emojiToUnicodeString(0x001f64c, 0x001f3ff));
    emojiAnnotationToUnicode.put("raising_hand_tone1", emojiToUnicodeString(0x001f64b, 0x001f3fb));
    emojiAnnotationToUnicode.put("raising_hand_tone2", emojiToUnicodeString(0x001f64b, 0x001f3fc));
    emojiAnnotationToUnicode.put("raising_hand_tone3", emojiToUnicodeString(0x001f64b, 0x001f3fd));
    emojiAnnotationToUnicode.put("raising_hand_tone4", emojiToUnicodeString(0x001f64b, 0x001f3fe));
    emojiAnnotationToUnicode.put("raising_hand_tone5", emojiToUnicodeString(0x001f64b, 0x001f3ff));
    emojiAnnotationToUnicode.put("right_facing_fist_tone1", emojiToUnicodeString(0x001f91c, 0x001f3fb));
    emojiAnnotationToUnicode.put("right_facing_fist_tone2", emojiToUnicodeString(0x001f91c, 0x001f3fc));
    emojiAnnotationToUnicode.put("right_facing_fist_tone3", emojiToUnicodeString(0x001f91c, 0x001f3fd));
    emojiAnnotationToUnicode.put("right_facing_fist_tone4", emojiToUnicodeString(0x001f91c, 0x001f3fe));
    emojiAnnotationToUnicode.put("right_facing_fist_tone5", emojiToUnicodeString(0x001f91c, 0x001f3ff));
    emojiAnnotationToUnicode.put("rowboat_tone1", emojiToUnicodeString(0x001f6a3, 0x001f3fb));
    emojiAnnotationToUnicode.put("rowboat_tone2", emojiToUnicodeString(0x001f6a3, 0x001f3fc));
    emojiAnnotationToUnicode.put("rowboat_tone3", emojiToUnicodeString(0x001f6a3, 0x001f3fd));
    emojiAnnotationToUnicode.put("rowboat_tone4", emojiToUnicodeString(0x001f6a3, 0x001f3fe));
    emojiAnnotationToUnicode.put("rowboat_tone5", emojiToUnicodeString(0x001f6a3, 0x001f3ff));
    emojiAnnotationToUnicode.put("ru", emojiToUnicodeString(0x001f1f7, 0x001f1fa));
    emojiAnnotationToUnicode.put("runner_tone1", emojiToUnicodeString(0x001f3c3, 0x001f3fb));
    emojiAnnotationToUnicode.put("runner_tone2", emojiToUnicodeString(0x001f3c3, 0x001f3fc));
    emojiAnnotationToUnicode.put("runner_tone3", emojiToUnicodeString(0x001f3c3, 0x001f3fd));
    emojiAnnotationToUnicode.put("runner_tone4", emojiToUnicodeString(0x001f3c3, 0x001f3fe));
    emojiAnnotationToUnicode.put("runner_tone5", emojiToUnicodeString(0x001f3c3, 0x001f3ff));
    emojiAnnotationToUnicode.put("santa_tone1", emojiToUnicodeString(0x001f385, 0x001f3fb));
    emojiAnnotationToUnicode.put("santa_tone2", emojiToUnicodeString(0x001f385, 0x001f3fc));
    emojiAnnotationToUnicode.put("santa_tone3", emojiToUnicodeString(0x001f385, 0x001f3fd));
    emojiAnnotationToUnicode.put("santa_tone4", emojiToUnicodeString(0x001f385, 0x001f3fe));
    emojiAnnotationToUnicode.put("santa_tone5", emojiToUnicodeString(0x001f385, 0x001f3ff));
    emojiAnnotationToUnicode.put("selfie_tone1", emojiToUnicodeString(0x001f933, 0x001f3fb));
    emojiAnnotationToUnicode.put("selfie_tone2", emojiToUnicodeString(0x001f933, 0x001f3fc));
    emojiAnnotationToUnicode.put("selfie_tone3", emojiToUnicodeString(0x001f933, 0x001f3fd));
    emojiAnnotationToUnicode.put("selfie_tone4", emojiToUnicodeString(0x001f933, 0x001f3fe));
    emojiAnnotationToUnicode.put("selfie_tone5", emojiToUnicodeString(0x001f933, 0x001f3ff));
    emojiAnnotationToUnicode.put("seven", emojiToUnicodeString(0x000037, 0x0020e3));
    emojiAnnotationToUnicode.put("shrug_tone1", emojiToUnicodeString(0x001f937, 0x001f3fb));
    emojiAnnotationToUnicode.put("shrug_tone2", emojiToUnicodeString(0x001f937, 0x001f3fc));
    emojiAnnotationToUnicode.put("shrug_tone3", emojiToUnicodeString(0x001f937, 0x001f3fd));
    emojiAnnotationToUnicode.put("shrug_tone4", emojiToUnicodeString(0x001f937, 0x001f3fe));
    emojiAnnotationToUnicode.put("shrug_tone5", emojiToUnicodeString(0x001f937, 0x001f3ff));
    emojiAnnotationToUnicode.put("six", emojiToUnicodeString(0x000036, 0x0020e3));
    emojiAnnotationToUnicode.put("spy_tone1", emojiToUnicodeString(0x001f575, 0x001f3fb));
    emojiAnnotationToUnicode.put("spy_tone2", emojiToUnicodeString(0x001f575, 0x001f3fc));
    emojiAnnotationToUnicode.put("spy_tone3", emojiToUnicodeString(0x001f575, 0x001f3fd));
    emojiAnnotationToUnicode.put("spy_tone4", emojiToUnicodeString(0x001f575, 0x001f3fe));
    emojiAnnotationToUnicode.put("spy_tone5", emojiToUnicodeString(0x001f575, 0x001f3ff));
    emojiAnnotationToUnicode.put("surfer_tone1", emojiToUnicodeString(0x001f3c4, 0x001f3fb));
    emojiAnnotationToUnicode.put("surfer_tone2", emojiToUnicodeString(0x001f3c4, 0x001f3fc));
    emojiAnnotationToUnicode.put("surfer_tone3", emojiToUnicodeString(0x001f3c4, 0x001f3fd));
    emojiAnnotationToUnicode.put("surfer_tone4", emojiToUnicodeString(0x001f3c4, 0x001f3fe));
    emojiAnnotationToUnicode.put("surfer_tone5", emojiToUnicodeString(0x001f3c4, 0x001f3ff));
    emojiAnnotationToUnicode.put("swimmer_tone1", emojiToUnicodeString(0x001f3ca, 0x001f3fb));
    emojiAnnotationToUnicode.put("swimmer_tone2", emojiToUnicodeString(0x001f3ca, 0x001f3fc));
    emojiAnnotationToUnicode.put("swimmer_tone3", emojiToUnicodeString(0x001f3ca, 0x001f3fd));
    emojiAnnotationToUnicode.put("swimmer_tone4", emojiToUnicodeString(0x001f3ca, 0x001f3fe));
    emojiAnnotationToUnicode.put("swimmer_tone5", emojiToUnicodeString(0x001f3ca, 0x001f3ff));
    emojiAnnotationToUnicode.put("three", emojiToUnicodeString(0x000033, 0x0020e3));
    emojiAnnotationToUnicode.put("thumbsdown_tone1", emojiToUnicodeString(0x001f44e, 0x001f3fb));
    emojiAnnotationToUnicode.put("thumbsdown_tone2", emojiToUnicodeString(0x001f44e, 0x001f3fc));
    emojiAnnotationToUnicode.put("thumbsdown_tone3", emojiToUnicodeString(0x001f44e, 0x001f3fd));
    emojiAnnotationToUnicode.put("thumbsdown_tone4", emojiToUnicodeString(0x001f44e, 0x001f3fe));
    emojiAnnotationToUnicode.put("thumbsdown_tone5", emojiToUnicodeString(0x001f44e, 0x001f3ff));
    emojiAnnotationToUnicode.put("thumbsup_tone1", emojiToUnicodeString(0x001f44d, 0x001f3fb));
    emojiAnnotationToUnicode.put("thumbsup_tone2", emojiToUnicodeString(0x001f44d, 0x001f3fc));
    emojiAnnotationToUnicode.put("thumbsup_tone3", emojiToUnicodeString(0x001f44d, 0x001f3fd));
    emojiAnnotationToUnicode.put("thumbsup_tone4", emojiToUnicodeString(0x001f44d, 0x001f3fe));
    emojiAnnotationToUnicode.put("thumbsup_tone5", emojiToUnicodeString(0x001f44d, 0x001f3ff));
    emojiAnnotationToUnicode.put("two", emojiToUnicodeString(0x000032, 0x0020e3));
    emojiAnnotationToUnicode.put("uk", emojiToUnicodeString(0x001f1ec, 0x001f1e7));
    emojiAnnotationToUnicode.put("us", emojiToUnicodeString(0x001f1fa, 0x001f1f8));
    emojiAnnotationToUnicode.put("v_tone1", emojiToUnicodeString(0x00270c, 0x001f3fb));
    emojiAnnotationToUnicode.put("v_tone2", emojiToUnicodeString(0x00270c, 0x001f3fc));
    emojiAnnotationToUnicode.put("v_tone3", emojiToUnicodeString(0x00270c, 0x001f3fd));
    emojiAnnotationToUnicode.put("v_tone4", emojiToUnicodeString(0x00270c, 0x001f3fe));
    emojiAnnotationToUnicode.put("v_tone5", emojiToUnicodeString(0x00270c, 0x001f3ff));
    emojiAnnotationToUnicode.put("vulcan_tone1", emojiToUnicodeString(0x001f596, 0x001f3fb));
    emojiAnnotationToUnicode.put("vulcan_tone2", emojiToUnicodeString(0x001f596, 0x001f3fc));
    emojiAnnotationToUnicode.put("vulcan_tone3", emojiToUnicodeString(0x001f596, 0x001f3fd));
    emojiAnnotationToUnicode.put("vulcan_tone4", emojiToUnicodeString(0x001f596, 0x001f3fe));
    emojiAnnotationToUnicode.put("vulcan_tone5", emojiToUnicodeString(0x001f596, 0x001f3ff));
    emojiAnnotationToUnicode.put("walking_tone1", emojiToUnicodeString(0x001f6b6, 0x001f3fb));
    emojiAnnotationToUnicode.put("walking_tone2", emojiToUnicodeString(0x001f6b6, 0x001f3fc));
    emojiAnnotationToUnicode.put("walking_tone3", emojiToUnicodeString(0x001f6b6, 0x001f3fd));
    emojiAnnotationToUnicode.put("walking_tone4", emojiToUnicodeString(0x001f6b6, 0x001f3fe));
    emojiAnnotationToUnicode.put("walking_tone5", emojiToUnicodeString(0x001f6b6, 0x001f3ff));
    emojiAnnotationToUnicode.put("water_polo_tone1", emojiToUnicodeString(0x001f93d, 0x001f3fb));
    emojiAnnotationToUnicode.put("water_polo_tone2", emojiToUnicodeString(0x001f93d, 0x001f3fc));
    emojiAnnotationToUnicode.put("water_polo_tone3", emojiToUnicodeString(0x001f93d, 0x001f3fd));
    emojiAnnotationToUnicode.put("water_polo_tone4", emojiToUnicodeString(0x001f93d, 0x001f3fe));
    emojiAnnotationToUnicode.put("water_polo_tone5", emojiToUnicodeString(0x001f93d, 0x001f3ff));
    emojiAnnotationToUnicode.put("wave_tone1", emojiToUnicodeString(0x001f44b, 0x001f3fb));
    emojiAnnotationToUnicode.put("wave_tone2", emojiToUnicodeString(0x001f44b, 0x001f3fc));
    emojiAnnotationToUnicode.put("wave_tone3", emojiToUnicodeString(0x001f44b, 0x001f3fd));
    emojiAnnotationToUnicode.put("wave_tone4", emojiToUnicodeString(0x001f44b, 0x001f3fe));
    emojiAnnotationToUnicode.put("wave_tone5", emojiToUnicodeString(0x001f44b, 0x001f3ff));
    emojiAnnotationToUnicode.put("woman_tone1", emojiToUnicodeString(0x001f469, 0x001f3fb));
    emojiAnnotationToUnicode.put("woman_tone2", emojiToUnicodeString(0x001f469, 0x001f3fc));
    emojiAnnotationToUnicode.put("woman_tone3", emojiToUnicodeString(0x001f469, 0x001f3fd));
    emojiAnnotationToUnicode.put("woman_tone4", emojiToUnicodeString(0x001f469, 0x001f3fe));
    emojiAnnotationToUnicode.put("woman_tone5", emojiToUnicodeString(0x001f469, 0x001f3ff));
    emojiAnnotationToUnicode.put("wrestlers_tone1", emojiToUnicodeString(0x001f93c, 0x001f3fb));
    emojiAnnotationToUnicode.put("wrestlers_tone2", emojiToUnicodeString(0x001f93c, 0x001f3fc));
    emojiAnnotationToUnicode.put("wrestlers_tone3", emojiToUnicodeString(0x001f93c, 0x001f3fd));
    emojiAnnotationToUnicode.put("wrestlers_tone4", emojiToUnicodeString(0x001f93c, 0x001f3fe));
    emojiAnnotationToUnicode.put("wrestlers_tone5", emojiToUnicodeString(0x001f93c, 0x001f3ff));
    emojiAnnotationToUnicode.put("writing_hand_tone1", emojiToUnicodeString(0x00270d, 0x001f3fb));
    emojiAnnotationToUnicode.put("writing_hand_tone2", emojiToUnicodeString(0x00270d, 0x001f3fc));
    emojiAnnotationToUnicode.put("writing_hand_tone3", emojiToUnicodeString(0x00270d, 0x001f3fd));
    emojiAnnotationToUnicode.put("writing_hand_tone4", emojiToUnicodeString(0x00270d, 0x001f3fe));
    emojiAnnotationToUnicode.put("writing_hand_tone5", emojiToUnicodeString(0x00270d, 0x001f3ff));
    emojiAnnotationToUnicode.put("zero", emojiToUnicodeString(0x000030, 0x0020e3));
  }
}
