/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.Entity;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.EmojiNode;
import org.symphonyoss.symphony.messageml.util.EmojiAnnotationToUnicode;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class Emoji
extends Entity {
    public static final String MESSAGEML_TAG = "emoji";
    private static final String ATTR_ANNOTATION = "annotation";
    private static final String ATTR_FAMILY = "family";
    private static final String ATTR_SIZE = "size";
    private static final String ENTITY_TYPE = "com.symphony.emoji";
    private static final String ENTITY_VERSION = "1.0";
    private static final String ENTITY_ID_PREFIX = "emoji";
    private static final String DATA_FIELD = "data";
    private static final String UNICODE_FIELD = "unicode";
    private static final String DEFAULT_EMOJI_SIZE = "normal";
    private String annotation;
    private String family;
    private String size;

    public Emoji(Element parent, String annotation, int entityIndex) {
        this(parent, entityIndex);
        this.annotation = annotation;
    }

    public Emoji(Element parent, int entityIndex) {
        super(parent, "emoji", "span", FormatEnum.MESSAGEML);
        this.entityId = this.getEntityId(entityIndex);
        this.size = DEFAULT_EMOJI_SIZE;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getFamily() {
        return this.family;
    }

    public String getSize() {
        return this.size;
    }

    @Override
    public void asPresentationML(XmlPrintStream out) {
        out.openElement(this.presentationMLTag, "class", "entity", "data-entity-id", this.entityId);
        for (Element child : this.getChildren()) {
            child.asPresentationML(out);
        }
        out.closeElement();
    }

    @Override
    public Node asMarkdown() throws InvalidInputException {
        return new EmojiNode(this.annotation);
    }

    @Override
    public ObjectNode asEntityJson(ObjectNode parent) {
        JsonNode entityNode = parent.path(this.entityId);
        if (entityNode.isMissingNode()) {
            ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
            node.put("type", this.getEntityType());
            node.put("version", this.getEntityVersion());
            ObjectNode idNode = new ObjectNode(JsonNodeFactory.instance);
            idNode.put(ATTR_ANNOTATION, this.getAnnotation());
            idNode.put(ATTR_SIZE, this.getSize());
            idNode.put(UNICODE_FIELD, EmojiAnnotationToUnicode.getUnicode(this.annotation));
            if (this.getFamily() != null) {
                idNode.put(ATTR_FAMILY, this.getFamily());
            }
            node.set(DATA_FIELD, (JsonNode)idNode);
            parent.set(this.entityId, (JsonNode)node);
            return node;
        }
        return (ObjectNode)entityNode;
    }

    @Override
    public void validate() throws InvalidInputException {
        if (this.annotation == null) {
            throw new InvalidInputException("The attribute \"annotation\" is required");
        }
        this.assertPhrasingContent();
    }

    public String toString() {
        return "Emoji(" + this.getAnnotation() + ")";
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "annotation": {
                this.annotation = this.getStringAttribute(item);
                break;
            }
            case "family": {
                this.family = this.getStringAttribute(item);
                break;
            }
            case "size": {
                this.size = this.getStringAttribute(item);
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    @Override
    protected String getEntityValue() {
        return this.annotation;
    }

    @Override
    protected String getEntitySubType() {
        return null;
    }

    @Override
    protected String getEntityVersion() {
        return ENTITY_VERSION;
    }

    @Override
    protected String getEntityType() {
        return ENTITY_TYPE;
    }

    @Override
    protected String getEntityIdPrefix() {
        return "emoji";
    }
}

