/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Bold;
import org.symphonyoss.symphony.messageml.elements.Chime;
import org.symphonyoss.symphony.messageml.elements.Emoji;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.Image;
import org.symphonyoss.symphony.messageml.elements.Italic;
import org.symphonyoss.symphony.messageml.elements.LineBreak;
import org.symphonyoss.symphony.messageml.elements.Link;
import org.symphonyoss.symphony.messageml.elements.Span;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class Element {
    public static final String CLASS_ATTR = "class";
    protected FormatEnum format = FormatEnum.PRESENTATIONML;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final List<Element> children = new ArrayList<Element>();
    private final Element parent;
    private String messageMLTag;

    Element(Element parent) {
        this(parent, null);
    }

    Element(Element parent, String messageMLTag) {
        this(parent, messageMLTag, FormatEnum.PRESENTATIONML);
    }

    Element(Element parent, String messageMLTag, FormatEnum format) {
        this.messageMLTag = messageMLTag;
        this.parent = parent;
        this.format = format;
    }

    public void buildAll(MessageMLParser context, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        NamedNodeMap attr = element.getAttributes();
        for (int i = 0; i < attr.getLength(); ++i) {
            this.buildAttribute(attr.item(i));
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.buildNode(context, children.item(i));
        }
    }

    void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "class": {
                this.attributes.put(CLASS_ATTR, this.getStringAttribute(item));
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    private void buildNode(MessageMLParser context, org.w3c.dom.Node node) throws InvalidInputException, ProcessingException {
        switch (node.getNodeType()) {
            case 3: {
                this.buildText((Text)node);
                break;
            }
            case 1: {
                this.buildElement(context, (org.w3c.dom.Element)node);
                break;
            }
            default: {
                throw new InvalidInputException("Invalid element \"" + node.getNodeName() + "\"");
            }
        }
    }

    private void buildElement(MessageMLParser context, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        Element child = context.createElement(element, this);
        child.buildAll(context, element);
        child.validate();
        this.addChild(child);
    }

    void buildText(Text text) {
        this.addChild(new TextNode(this, text));
    }

    void buildMarkdown(Node parent) throws InvalidInputException {
        for (Element child : this.children) {
            Node node = child.asMarkdown();
            if (node != null) {
                parent.appendChild(node);
            } else {
                node = parent;
            }
            child.buildMarkdown(node);
        }
    }

    void buildEntityJson(ObjectNode parent) {
        for (Element child : this.children) {
            ObjectNode node = child.asEntityJson(parent);
            if (node != null) {
                child.buildEntityJson(node);
                continue;
            }
            child.buildEntityJson(parent);
        }
    }

    Node asMarkdown() throws InvalidInputException {
        return null;
    }

    void asPresentationML(XmlPrintStream out) {
        out.openElement(this.getMessageMLTag(), this.getAttributes());
        for (Element child : this.getChildren()) {
            child.asPresentationML(out);
        }
        out.closeElement();
    }

    public String asText() {
        StringBuilder b = new StringBuilder();
        for (Element child : this.children) {
            b.append(child.asText());
        }
        return b.toString();
    }

    ObjectNode asEntityJson(ObjectNode parent) {
        return null;
    }

    void validate() throws InvalidInputException {
    }

    String getStringAttribute(org.w3c.dom.Node attribute) {
        return attribute.getTextContent();
    }

    Long getLongAttribute(org.w3c.dom.Node attribute) throws InvalidInputException {
        String s = this.getStringAttribute(attribute);
        if (s == null) {
            return null;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new InvalidInputException("Invalid input: " + attribute.getLocalName() + " must be a int64 value not \"" + s + "\"");
        }
    }

    Boolean getBooleanAttribute(org.w3c.dom.Node attribute) {
        String s = this.getStringAttribute(attribute);
        if (s == null) {
            return null;
        }
        return Boolean.parseBoolean(s);
    }

    URI getUrlAttribute(org.w3c.dom.Node attribute) throws InvalidInputException {
        String s = this.getStringAttribute(attribute);
        if (s == null) {
            return null;
        }
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            throw new InvalidInputException("Invalid input: " + attribute.getLocalName() + " must be a URI value not \"" + s + "\"");
        }
    }

    void assertNoContent() throws InvalidInputException {
        if (!this.getChildren().isEmpty()) {
            throw new InvalidInputException("Element \"" + this.getMessageMLTag() + "\" may not have child elements or text content");
        }
    }

    void assertNoAttributes() throws InvalidInputException {
        if (!this.getAttributes().isEmpty()) {
            throw new InvalidInputException("Element \"" + this.getMessageMLTag() + "\" may not have attributes");
        }
    }

    void assertNoText() throws InvalidInputException {
        for (Element child : this.getChildren()) {
            if (!(child instanceof TextNode) || !StringUtils.isNotBlank((CharSequence)((TextNode)child).getText())) continue;
            throw new InvalidInputException("Element \"" + this.getMessageMLTag() + "\" may not have text content");
        }
    }

    void assertPhrasingContent() throws InvalidInputException {
        this.assertContentModel(Arrays.asList(TextNode.class, Link.class, Chime.class, Bold.class, Italic.class, Image.class, LineBreak.class, Span.class, Emoji.class));
    }

    void assertContentModel(Collection<Class<? extends Element>> permittedChildren) throws InvalidInputException {
        for (Element child : this.getChildren()) {
            if (permittedChildren.contains(child.getClass()) || child instanceof TextNode && StringUtils.isBlank((CharSequence)((TextNode)child).getText())) continue;
            throw new InvalidInputException("Element \"" + child.getMessageMLTag() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
        }
    }

    public String getMessageMLTag() {
        return this.messageMLTag;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String attr) {
        return this.attributes.get(attr);
    }

    void setAttribute(String attr, String value) {
        this.attributes.put(attr, value);
    }

    public List<Element> getChildren() {
        return this.children;
    }

    public Element getChild(int n) {
        return this.children.get(n);
    }

    public void addChild(Element child) {
        this.children.add(child);
    }

    public int size() {
        return this.children.size();
    }

    public Element getParent() {
        return this.parent;
    }

    public FormatEnum getFormat() {
        return this.format;
    }

    public List<Element> findElements(Class type) {
        ArrayList<Element> result = new ArrayList<Element>();
        LinkedList<Element> stack = new LinkedList<Element>(this.getChildren());
        if (this.getClass() == type) {
            result.add(this);
        }
        while (!stack.isEmpty()) {
            Element child = stack.pop();
            stack.addAll(0, child.getChildren());
            if (child.getClass() != type) continue;
            result.add(child);
        }
        return result;
    }

    public List<Element> findElements(String tag) {
        ArrayList<Element> result = new ArrayList<Element>();
        LinkedList<Element> stack = new LinkedList<Element>(this.getChildren());
        if (tag.equalsIgnoreCase(this.getMessageMLTag())) {
            result.add(this);
        }
        while (!stack.isEmpty()) {
            Element child = stack.pop();
            stack.addAll(0, child.getChildren());
            if (!tag.equalsIgnoreCase(child.getMessageMLTag())) continue;
            result.add(child);
        }
        return result;
    }

    public List<Element> findElements(String attribute, String value) {
        ArrayList<Element> result = new ArrayList<Element>();
        LinkedList<Element> stack = new LinkedList<Element>(this.getChildren());
        if (value.equals(this.getAttribute(attribute))) {
            result.add(this);
        }
        while (!stack.isEmpty()) {
            Element child = stack.pop();
            stack.addAll(0, child.getChildren());
            if (!value.equals(child.getAttribute(attribute))) continue;
            result.add(child);
        }
        return result;
    }
}

