/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;

public class Div
extends Element {
    public static final String MESSAGEML_TAG = "div";
    private static final String ATTR_ENTITY_ID = "data-entity-id";
    private static final String ATTR_ICON_SRC = "data-icon-src";

    public Div(Element parent) {
        super(parent, MESSAGEML_TAG);
    }

    @Override
    protected void buildAttribute(org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "data-entity-id": {
                this.setAttribute(ATTR_ENTITY_ID, this.getStringAttribute(item));
                break;
            }
            case "data-icon-src": {
                this.setAttribute(ATTR_ICON_SRC, this.getStringAttribute(item));
                break;
            }
            default: {
                super.buildAttribute(item);
            }
        }
    }

    @Override
    public Node asMarkdown() {
        return new Paragraph();
    }

    @Override
    public ObjectNode asEntityJson(ObjectNode parent) {
        String entityId = this.getAttribute(ATTR_ENTITY_ID);
        if (entityId != null) {
            return (ObjectNode)parent.path(entityId);
        }
        return null;
    }

    @Override
    public void validate() throws InvalidInputException {
        String[] classes;
        if (this.getAttribute(ATTR_ENTITY_ID) != null && !"entity".equals(this.getAttribute("class"))) {
            throw new InvalidInputException("The attribute \"data-entity-id\" is only allowed if the element class is \"entity\".");
        }
        if ("entity".equals(this.getAttribute("class")) && this.getAttribute(ATTR_ENTITY_ID) == null) {
            throw new InvalidInputException("The attribute \"data-entity-id\" is required if the element class is \"entity\".");
        }
        if (!(this.getAttribute(ATTR_ICON_SRC) == null || (classes = this.getAttribute("class").split(" ")).length != 0 && "card".equals(classes[0]))) {
            throw new InvalidInputException("The attribute \"data-icon-src\" is only allowed if the element class is \"card\".");
        }
    }
}

