/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.MessageML;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.Node;

public class Chime
extends Element {
    public static final String MESSAGEML_TAG = "chime";
    public static final String PRESENTATIONML_TAG = "audio";
    private static final String ATTR_SRC = "src";
    private static final String SRC = "https://asset.symphony.com/symphony/audio/chime.mp3";
    private static final String ATTR_AUTOPLAY = "autoplay";

    public Chime(Element parent, FormatEnum format) throws InvalidInputException {
        super(parent, MESSAGEML_TAG, format);
        if (!(parent instanceof MessageML)) {
            throw new InvalidInputException("Element \"chime\" has to be the only element in the message.");
        }
        ((MessageML)parent).setChime(true);
    }

    @Override
    protected void buildAttribute(Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "src": {
                if (this.getStringAttribute(item).equalsIgnoreCase(SRC)) break;
                throw new InvalidInputException("Attribute \"src\" value needs to be \"https://asset.symphony.com/symphony/audio/chime.mp3\"");
            }
            case "autoplay": {
                break;
            }
            default: {
                throw new InvalidInputException("Attribute \"" + item.getNodeName() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out) {
        out.printElement(PRESENTATIONML_TAG, null, ATTR_SRC, SRC, ATTR_AUTOPLAY, "true");
    }

    @Override
    public String asText() {
        return "";
    }

    @Override
    public void validate() throws InvalidInputException {
        this.assertNoContent();
    }
}

