/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.util;

import java.util.ArrayList;
import org.symphonyoss.symphony.messageml.util.IndentedPrintStream;

public class AlignedBlock {
    private static final int TAB_SIZE = 8;
    private final IndentedPrintStream out;
    private final ArrayList<Integer> maxColumnLength = new ArrayList();
    private final ArrayList<String[]> rows = new ArrayList();

    public AlignedBlock(IndentedPrintStream out) {
        this.out = out;
    }

    public void align(Object ... o) {
        int i = 0;
        String[] s = new String[o.length];
        for (int ii = 0; ii < o.length; ++ii) {
            if (o[ii] == null) continue;
            s[ii] = o[ii].toString();
        }
        while (i < s.length && i < this.maxColumnLength.size()) {
            int l;
            int n = l = s[i] == null ? 0 : s[i].length();
            if (this.maxColumnLength.get(i) < l) {
                this.maxColumnLength.set(i, l);
            }
            ++i;
        }
        while (i < s.length) {
            this.maxColumnLength.add(s[i] == null ? 0 : s[i].length());
            ++i;
        }
        this.rows.add(s);
    }

    public void print(String separator, String terminator) {
        for (int i = 0; i < this.maxColumnLength.size(); ++i) {
            this.maxColumnLength.set(i, (this.maxColumnLength.get(i) / 8 + 1) * 8);
        }
        for (int r = 0; r < this.rows.size(); ++r) {
            String[] s = this.rows.get(r);
            for (int i = 0; i < s.length; ++i) {
                int l;
                this.out.print(s[i]);
                if (i >= s.length - 1) continue;
                int n = l = s[i] == null ? 0 : s[i].length();
                while (l < this.maxColumnLength.get(i)) {
                    this.out.print(' ');
                    ++l;
                }
            }
            if (separator != null && r < this.rows.size() - 1) {
                this.out.println(separator);
                continue;
            }
            if (terminator != null && r == this.rows.size() - 1) {
                this.out.println(terminator);
                continue;
            }
            this.out.println();
        }
    }

    public void print() {
        this.print(null, null);
    }
}

