/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.markdown;

import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;
import org.symphonyoss.symphony.messageml.markdown.nodes.KeywordNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.MentionNode;

public class EntityDelimiterProcessor
implements DelimiterProcessor {
    public static final char ENTITY_DELIMITER = '\u0091';
    public static final char FIELD_DELIMITER = '\u0092';

    public char getOpeningCharacter() {
        return '\u0091';
    }

    public char getClosingCharacter() {
        return '\u0091';
    }

    public int getMinLength() {
        return 0;
    }

    public int getDelimiterUse(DelimiterRun opener, DelimiterRun closer) {
        if (opener.length() >= 1 && closer.length() >= 1) {
            return 1;
        }
        return 0;
    }

    private Node createNode(Text node) {
        String[] text = node.getLiteral().split(String.valueOf('\u0092'));
        if (text.length >= 2) {
            switch (text[0]) {
                case "KEYWORD": {
                    String prefix = text[1].substring(0, 1);
                    String value = text[1].substring(1);
                    return new KeywordNode(prefix, value);
                }
                case "URL": {
                    return new Link(text[1], text[1]);
                }
                case "USER_FOLLOW": {
                    try {
                        Long uid = Long.valueOf(text[1]);
                        return new MentionNode(uid);
                    }
                    catch (NumberFormatException e) {
                        return new Text(text[1]);
                    }
                }
            }
            return null;
        }
        return node;
    }

    public void process(Text opener, Text closer, int delimiterUse) {
        Node result;
        Node node = opener.getNext();
        if (node instanceof Text && (result = this.createNode((Text)node)) != null) {
            opener.insertAfter(result);
            node.unlink();
        }
    }
}

