/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import org.symphonyoss.symphony.messageml.util.AlignedBlock;
import org.symphonyoss.symphony.messageml.util.CountedOutputStream;

public class IndentedPrintStream
extends PrintStream {
    private boolean startOfLine = true;
    private int indent = 0;
    private AlignedBlock alignedBlock = null;
    private boolean printOffsets = false;
    private boolean oNlCr = false;
    private boolean noIndent = false;
    private boolean noNl = false;
    private String linePrefix;
    private int linePrefixIndent = 9999;

    public IndentedPrintStream(OutputStream outputStream) {
        super(outputStream instanceof CountedOutputStream ? outputStream : new CountedOutputStream(outputStream));
    }

    public void setPrintOffsets(boolean printOffsets) {
        this.printOffsets = printOffsets;
    }

    public boolean getPrintOffsets() {
        return this.printOffsets;
    }

    public void setLinePrefix(String linePrefix) {
        this.linePrefix = linePrefix;
        this.linePrefixIndent = linePrefix == null ? 9999 : this.indent;
    }

    public String getLinePrefix() {
        return this.linePrefix;
    }

    public void align(Object ... s) {
        if (this.alignedBlock == null) {
            this.alignedBlock = new AlignedBlock(this);
        }
        this.alignedBlock.align(s);
    }

    private void printAlignedBlock(String separator, String terminator) {
        if (this.alignedBlock != null) {
            this.alignedBlock.print(separator, terminator);
            this.alignedBlock = null;
        }
    }

    public void printAlignedBlock() {
        this.printAlignedBlock(null, null);
    }

    public void openBlock() {
        this.println("{");
        this.indent();
    }

    public void closeBlock() {
        this.outdent();
        this.println("}");
    }

    public void openBlock(String s) {
        this.println(s);
        this.println("{");
        this.indent();
    }

    public void closeBlock(String s) {
        this.outdent();
        this.println("}" + s);
    }

    public void continueBlock(String s) {
        this.outdent();
        this.println("}");
        this.println(s);
        this.println("{");
        this.indent();
    }

    public void indent() {
        ++this.indent;
    }

    public void outdent() {
        --this.indent;
    }

    private void doIndent(int tempIndent) {
        if (this.printOffsets) {
            ((CountedOutputStream)this.out).beginUncounted();
            super.print(String.format("%10d ", this.getOffset()));
            ((CountedOutputStream)this.out).endUncounted();
        }
        if (!this.noIndent) {
            int i;
            tempIndent += this.indent;
            for (i = 0; i < tempIndent && i < this.linePrefixIndent; ++i) {
                super.print('\t');
            }
            if (this.linePrefix != null) {
                super.print(this.linePrefix);
            }
            while (i++ < tempIndent) {
                super.print('\t');
            }
        }
        this.startOfLine = false;
    }

    public void print(int tempIndent, boolean b) {
        this.print(tempIndent, "" + b);
    }

    public void print(int tempIndent, char c) {
        if (this.startOfLine) {
            this.doIndent(tempIndent);
        }
        super.print(c);
    }

    public void print(int tempIndent, char[] s) {
        if (this.startOfLine) {
            this.doIndent(tempIndent);
        }
        super.print(s);
    }

    public void print(int tempIndent, double d) {
        this.print(tempIndent, "" + d);
    }

    public void print(int tempIndent, float f) {
        this.print(tempIndent, "" + f);
    }

    public void print(int tempIndent, int i) {
        this.print(tempIndent, "" + i);
    }

    public void print(int tempIndent, Object obj) {
        this.print(tempIndent, "" + obj);
    }

    public void print(int tempIndent, String s) {
        if (this.startOfLine) {
            this.doIndent(tempIndent);
        }
        super.print(s);
    }

    public void print(int tempIndent, long l) {
        this.print(tempIndent, "" + l);
    }

    @Override
    public void println() {
        super.println();
        this.startOfLine = true;
    }

    public void forceNewLine() {
        if (!this.startOfLine) {
            this.println();
        }
    }

    public void println(int tempIndent, boolean x) {
        this.println(tempIndent, "" + x);
    }

    public void println(int tempIndent, char x) {
        if (this.startOfLine) {
            this.doIndent(tempIndent);
        }
        super.println(x);
        this.startOfLine = true;
    }

    public void println(int tempIndent, char[] x) {
        if (this.startOfLine) {
            this.doIndent(tempIndent);
        }
        super.println(x);
        this.startOfLine = true;
    }

    public void println(int tempIndent, double x) {
        this.println(tempIndent, "" + x);
    }

    public void println(int tempIndent, float x) {
        this.println(tempIndent, "" + x);
    }

    public void println(int tempIndent, int x) {
        this.println(tempIndent, "" + x);
    }

    public void println(int tempIndent, Object x) {
        this.println(tempIndent, "" + x);
    }

    public void println(int tempIndent, String x) {
        if (this.startOfLine) {
            this.doIndent(tempIndent);
        }
        if (this.noNl) {
            super.print(x);
        } else {
            super.println(x);
            if (this.oNlCr) {
                super.write(13);
            }
        }
        this.startOfLine = true;
    }

    public void println(int tempIndent, long x) {
        this.println(tempIndent, "" + x);
    }

    @Override
    public void print(boolean b) {
        this.print(0, b);
    }

    @Override
    public void print(char c) {
        this.print(0, c);
    }

    @Override
    public void print(char[] s) {
        this.print(0, s);
    }

    @Override
    public void print(double d) {
        this.print(0, d);
    }

    @Override
    public void print(float f) {
        this.print(0, f);
    }

    @Override
    public void print(int i) {
        this.print(0, i);
    }

    @Override
    public void print(Object obj) {
        this.print(0, obj);
    }

    @Override
    public void print(String s) {
        this.print(0, s);
    }

    @Override
    public void print(long l) {
        this.print(0, l);
    }

    @Override
    public void println(boolean x) {
        this.println(0, x);
    }

    @Override
    public void println(char x) {
        this.println(0, x);
    }

    @Override
    public void println(char[] x) {
        this.println(0, x);
    }

    @Override
    public void println(double x) {
        this.println(0, x);
    }

    @Override
    public void println(float x) {
        this.println(0, x);
    }

    @Override
    public void println(int x) {
        this.println(0, x);
    }

    @Override
    public void println(Object x) {
        this.println(0, x);
    }

    @Override
    public void println(String x) {
        this.println(0, x);
    }

    public void printlines(String ... strings) {
        for (String s : strings) {
            this.println(s);
        }
    }

    @Override
    public void println(long x) {
        this.println(0, x);
    }

    public void println(Collection<String> str) {
        for (String s : str) {
            this.println(0, s);
        }
    }

    public void print(String pattern, Object ... arguments) {
        this.print(String.format(pattern, arguments));
    }

    public void println(String pattern, Object ... arguments) {
        this.println(String.format(pattern, arguments));
    }

    public void print(int indent, String pattern, Object ... arguments) {
        this.print(indent, String.format(pattern, arguments));
    }

    public void println(int indent, String pattern, Object ... arguments) {
        this.println(indent, String.format(pattern, arguments));
    }

    public long getOffset() {
        return ((CountedOutputStream)this.out).getOffset();
    }

    public boolean isoNlCr() {
        return this.oNlCr;
    }

    public void setoNlCr(boolean oNlCr) {
        this.oNlCr = oNlCr;
    }

    public boolean isNoIndent() {
        return this.noIndent;
    }

    public void setNoIndent(boolean noIndent) {
        this.noIndent = noIndent;
    }

    public boolean isNoNl() {
        return this.noNl;
    }

    public void setNoNl(boolean noNl) {
        this.noNl = noNl;
    }
}

