/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.util;

import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class ShortID {
    public static final String DEFAULT_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-";
    private static final long DEFAULT_REDUCE_TIME = 1403265799803L;
    private static final int DEFAULT_VERSION = 6;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final Random random;
    private final long reduceTime;
    private final int version;
    private final int clusterWorkerId;
    private char[] shuffled;
    private final AtomicInteger counter;
    private volatile long previousSeconds;

    private ShortID(Random random, long reduceTime, int version, int clusterWorkerId) {
        this.random = random;
        this.counter = new AtomicInteger();
        this.reduceTime = reduceTime;
        this.version = version;
        this.clusterWorkerId = clusterWorkerId;
    }

    public ShortID() {
        this(SECURE_RANDOM, 1403265799803L, 6, 0);
    }

    public String generate() {
        int counterValue;
        if (this.shuffled == null) {
            this.shuffled = this.shuffle(DEFAULT_ALPHABET);
        }
        String str = "";
        long seconds = (long)Math.floor((double)(System.currentTimeMillis() - this.reduceTime) * 0.001);
        if (seconds == this.previousSeconds) {
            counterValue = this.counter.incrementAndGet();
        } else {
            this.counter.set(0);
            counterValue = 0;
            this.previousSeconds = seconds;
        }
        str = str + this.encode(this.version);
        str = str + this.encode(this.clusterWorkerId);
        if (counterValue > 0) {
            str = str + this.encode(counterValue);
        }
        str = str + this.encode((int)seconds);
        return str;
    }

    private String encode(int number) {
        int loopCounter = 0;
        boolean done = false;
        StringBuilder str = new StringBuilder();
        while (!done) {
            int index = number >> 4 * loopCounter & 0xF | this.randomByte();
            str.append(this.shuffled[index]);
            done = (double)number < Math.pow(16.0, (double)loopCounter + 1.0);
            ++loopCounter;
        }
        return str.toString();
    }

    private int randomByte() {
        byte[] bytes = new byte[1];
        this.random.nextBytes(bytes);
        return bytes[0] & 0x30;
    }

    private char[] shuffle(String alphabet) {
        StringBuilder source = new StringBuilder(alphabet);
        StringBuilder target = new StringBuilder(source.length());
        while (source.length() > 0) {
            double r = this.random.nextDouble();
            int charIndex = (int)Math.floor(r * (double)source.length());
            target.append(source.charAt(charIndex));
            source.deleteCharAt(charIndex);
        }
        return target.toString().toCharArray();
    }
}

