/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.bi.BiItem;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.LabelableElement;
import org.symphonyoss.symphony.messageml.elements.MinMaxLengthElement;
import org.symphonyoss.symphony.messageml.elements.RegexElement;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.elements.TooltipableElement;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.TextAreaNode;

public class TextArea
extends FormElement
implements RegexElement,
LabelableElement,
TooltipableElement,
MinMaxLengthElement {
    public static final String MESSAGEML_TAG = "textarea";
    private Integer MIN_ALLOWED_LENGTH = 0;
    private Integer MAX_ALLOWED_LENGTH = 10000;
    private static final String PLACEHOLDER_ATTR = "placeholder";
    private static final String REQUIRED_ATTR = "required";
    private static final List<String> VALID_VALUES_FOR_REQUIRED_ATTR = Arrays.asList("true", "false");

    public TextArea(Element parent, FormatEnum format) {
        super(parent, MESSAGEML_TAG, format);
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, VALID_VALUES_FOR_REQUIRED_ATTR);
        }
        this.assertAttributeNotBlank("name");
        this.assertContentModel(Collections.singleton(TextNode.class));
        this.validateMinAndMaxLengths();
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "required": 
            case "placeholder": 
            case "minlength": 
            case "maxlength": 
            case "pattern": 
            case "label": 
            case "title": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "pattern-error-message": {
                if (this.format != FormatEnum.MESSAGEML) {
                    this.throwInvalidInputException(item);
                }
                this.setAttribute("pattern-error-message", this.getStringAttribute(item));
                break;
            }
            case "data-pattern-error-message": {
                if (this.format != FormatEnum.PRESENTATIONML) {
                    this.throwInvalidInputException(item);
                }
                this.setAttribute("data-pattern-error-message", this.getStringAttribute(item));
                break;
            }
            case "id": {
                if (this.format != FormatEnum.PRESENTATIONML) {
                    this.throwInvalidInputException(item);
                }
                this.fillAttributes(parser, item);
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public Node asMarkdown() {
        return new TextAreaNode(this.getAttribute(PLACEHOLDER_ATTR), this.hasExactNumberOfChildren(1) ? this.getChild(0).asText() : null, this.getAttribute("label"), this.getAttribute("title"));
    }

    @Override
    public String getElementId() {
        return MESSAGEML_TAG;
    }

    @Override
    public String getElementType() {
        return MESSAGEML_TAG;
    }

    @Override
    public boolean hasElementInitialValue() {
        return this.getChildren() != null && this.getChildren().size() == 1 && this.getChild(0) instanceof TextNode;
    }

    @Override
    public String getElementInitialValue() {
        return ((TextNode)this.getChild(0)).getText();
    }

    @Override
    public String getAttributeValue(String attributeName) {
        return this.getAttribute(attributeName);
    }

    @Override
    public Integer getMinValueAllowed() {
        return this.MIN_ALLOWED_LENGTH;
    }

    @Override
    public Integer getMaxValueAllowed() {
        return this.MAX_ALLOWED_LENGTH;
    }

    @Override
    public void updateBiContext(BiContext context) {
        HashMap<String, Object> attributesMapBi = new HashMap<String, Object>();
        this.putOneIfPresent(attributesMapBi, BiFields.PLACEHOLDER.getValue(), PLACEHOLDER_ATTR);
        this.putOneIfPresent(attributesMapBi, BiFields.TITLE.getValue(), "title");
        this.putOneIfPresent(attributesMapBi, BiFields.LABEL.getValue(), "label");
        this.putOneIfPresent(attributesMapBi, BiFields.REQUIRED.getValue(), REQUIRED_ATTR);
        this.computeAndPutValidationProperties(attributesMapBi);
        if (this.hasElementInitialValue()) {
            attributesMapBi.put(BiFields.DEFAULT.getValue(), 1);
        }
        context.addItem(new BiItem(BiFields.TEXT_AREA.getValue(), attributesMapBi));
    }

    private void computeAndPutValidationProperties(Map<String, Object> attributesMapBi) {
        boolean validationPattern;
        boolean bl = validationPattern = this.getAttribute("pattern") != null;
        if (validationPattern) {
            attributesMapBi.put(BiFields.VALIDATION_PATTERN.getValue(), 1);
            attributesMapBi.put(BiFields.VALIDATION.getValue(), 1);
        }
    }
}

