/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.ExpandableCard;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class ExpandableCardBody
extends Element {
    public static final String MESSAGEML_TAG = "body";
    public static final String PRESENTATIONML_CLASS = "expandableCardBody";
    public static final String PRESENTATIONML_VARIANT_ATTR = "data-variant";
    private static final String PRESENTATIONML_TAG = "div";
    private static final String ATTR_VARIANT = "variant";
    private static final List<String> allowedVariants = Arrays.asList("default", "error");

    public ExpandableCardBody(Element parent, FormatEnum format) {
        super(parent, MESSAGEML_TAG, format);
    }

    @Override
    void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "data-variant": 
            case "variant": {
                this.setAttribute(ATTR_VARIANT, this.getStringAttribute(item));
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        presentationAttrs.put("class", PRESENTATIONML_CLASS);
        if (this.getAttribute(ATTR_VARIANT) != null) {
            presentationAttrs.put(PRESENTATIONML_VARIANT_ATTR, this.getAttribute(ATTR_VARIANT));
        }
        out.openElement(PRESENTATIONML_TAG, presentationAttrs);
        for (Element child : this.getChildren()) {
            child.asPresentationML(out, context);
        }
        out.closeElement();
    }

    @Override
    public Node asMarkdown() {
        return new Paragraph();
    }

    @Override
    void validate() throws InvalidInputException {
        super.validate();
        this.assertParent(Collections.singleton(ExpandableCard.class));
        if (this.getAttribute(ATTR_VARIANT) != null) {
            this.assertAttributeValue(ATTR_VARIANT, allowedVariants);
        }
    }

    @Override
    public String getPresentationMLTag() {
        return PRESENTATIONML_TAG;
    }
}

